#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <error.h>
#include <string.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <errno.h>
#include <log/log.h>
#include <liblog/lynq_deflog.h>
#include "include/libat/lynq_at_factory.h"

#define FACTORY_STRING "AT+LYNQFACTORY="
#define USER_LOG_TAG "AT_FACTORY"

#undef LOG_TAG
#define LOG_TAG "AT_FACTORY"

static const char *usb3_speed = "super-speed";
static const char *usb2_speed = "high-speed";

lynq_atsvc_outcb handle_output;

typedef struct
{
    char *cmd;
    void (*func)(char *input);
}Command;

enum
{
    Response = 0,
    Urc
};

void lynq_response_ok()
{
    char *str = "OK";
    handle_output(str, strlen(str), Response);
}

void lynq_response_error(int error_code)
{
    char str[32] = {0};
    sprintf(str, "+CME ERROR: %d", error_code);
    handle_output(str, strlen(str), Response);
}

void lynq_handle_adc(char *input)
{
    FILE *fp;
    char lynq_adc_dev[126] = {0};
    char lynq_adc_buf[32] = {0};
    int lynq_adc_num = atoi(input+4);
    char flag[64] = {0};
    if(lynq_adc_num == 0)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage0_input  2>&1");
    }
    else if(lynq_adc_num == 1)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage1_input  2>&1");
    }
    else if(lynq_adc_num == 2)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage2_input  2>&1");
    }
    else if(lynq_adc_num == 3)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage3_input  2>&1");
    }
    fp=popen(lynq_adc_dev, "r");
    fgets(lynq_adc_buf,sizeof(lynq_adc_buf),fp);
    sprintf(flag,"%s %s", "ADC:", lynq_adc_buf);
    if(handle_output != NULL)
    {
        handle_output(flag, strlen(flag), Response);
    }
    lynq_response_ok();
    pclose(fp);
}

int set_campare(char dev_buf[][40],char *buf_str[3])
{
    FILE *fp;
    int k = 15;
    int j;
    char lynq_usb_buf[256] = {0};
    char buf[256] = {0};
    for(j=0;j++;j<3)
    {
        sprintf(lynq_usb_buf,"cat /sys/class/leds/led95%d:%s",k++, dev_buf[j]);
        fp=popen(lynq_usb_buf, "r");
        fgets(buf, sizeof(buf), fp);
        if(strcmp(buf,buf_str[j]))
        {
            pclose(fp);
            return -1;
        }
        pclose(fp);
    }
    return 0;
}
void lynq_handle_sink(char *input)
{
    FILE *fp;
    time_t start,end;
    char lynq_usb_dev[256] = {0};
    char lynq[256] = {0};
    char char_buf[16] = {0};
    char flag_buf[64] = {0};
    int sink[3][3] = {{255,0,0},{0,255,0},{0,0,255}};
    char dev_buf[][40] = {{"green:cellular-radio/brightness"},{"green:cellular-quality/brightness"},{"red:system/brightness"}};
    char *str_buf[3] = {"0","0","0"};
    int i,j,ret;
    int state = 0;
    int k = 15;

    for(i = 0;i < 3;i++)
    {
        bzero(flag_buf, 64);
        k = 15;

        switch(i)
        {
        case 0:
        {
            str_buf[0]="255";
            str_buf[1]="0";
            str_buf[2]="0";
            break;
        }

        case 1:
        {
            str_buf[0]="0";
            str_buf[1]="255";
            str_buf[2]="0";
            break;
        }

        case 2:
        {
            str_buf[0]="0";
            str_buf[1]="0";
            str_buf[2]="255";
            break;
        }
        }
        for(int h=0;h<20;h++)
        {
            for(j = 0;j < 3;j++)
            {
                bzero(lynq_usb_dev, 256);
                sprintf(lynq_usb_dev,"echo %d >  /sys/class/leds/led95%d:%s  2>&1", sink[i][j], k++, dev_buf[j]);
                fp=popen(lynq_usb_dev, "r");
                pclose(fp);
            }
            bzero(char_buf,16);
            if(set_campare(dev_buf,str_buf))
            {
                RLOGD("pre_campare fail %s line %d input %s\n", __FUNCTION__, __LINE__, input);
                continue;
            }
            sprintf(lynq,"cat /sys/bus/iio/devices/iio:device1/in_voltage4_input  2>&1");
            fp=popen(lynq, "r");
            fgets(char_buf, sizeof(char_buf), fp);

            if(set_campare(dev_buf,str_buf))
            {
                RLOGD("behand_campare fail %s line %d input %s\n", __FUNCTION__, __LINE__, input);
                continue;
            }
            sprintf(flag_buf, "%s%d%s%s%s", "SINK[", i+1, "]: ", char_buf, "\n");
            handle_output(flag_buf, strlen(flag_buf), Response);
            state =1;
            break;
        }
        if(state == 0)
        {
            sprintf(flag_buf, "%s%d%s%s%s", "SINK[", i+1, "]: ", char_buf, "\n");
            handle_output(flag_buf, strlen(flag_buf), Response);
        }
    }
    pclose(fp);
    lynq_response_ok();
    return;
}

void lynq_handle_emmc(char *input)
{
    FILE *fp;
    char emmc_buf[100] = {0};
    char buf[100] = {0};
    sprintf(emmc_buf, "ls /dev | grep mmcblk0  2>&1");
    fp=popen(emmc_buf, "r");
    if(!fp){
        lynq_response_error(100);
        return;
    }
    while(fgets(buf, sizeof(buf), fp) != NULL){
        lynq_response_ok();
        pclose(fp);
        return;
    }
    lynq_response_error(100);
    pclose(fp);
}

static int set_all_gpio_status_and_check(int lynq_gpio_arr[], char status)
{
    int m =0;
    FILE *fp;
    char lynq_set_gpio_arr[256] = {0};
    char lynq_get_gpio_state[512] = {0};
    for(m = 0; m < 85; m++)
    {
        bzero(lynq_set_gpio_arr, 256);
        sprintf(lynq_set_gpio_arr,"echo mode %d 0 > /sys/devices/platform/10005000.pinctrl/mt_gpio",(char*)lynq_gpio_arr[m]);
        system(lynq_set_gpio_arr);
        bzero(lynq_set_gpio_arr, 256);
        sprintf(lynq_set_gpio_arr,"echo out %d %c > /sys/devices/platform/10005000.pinctrl/mt_gpio",(char*)lynq_gpio_arr[m], status);
        system(lynq_set_gpio_arr);
    }

    bzero(lynq_set_gpio_arr, 256);
    sprintf(lynq_set_gpio_arr,"cat /sys/devices/platform/10005000.pinctrl/mt_gpio | grep 006");
    fp=popen(lynq_set_gpio_arr, "r");
    bzero(lynq_get_gpio_state, 512);
    fgets(lynq_get_gpio_state,sizeof(lynq_get_gpio_state),fp);
    pclose(fp);
    
    if(lynq_get_gpio_state[7] != status)
    {
        return 1;
    }
    //usleep(10000);
    return 0;
}

void lynq_handle_gpio(char *input)
{
    FILE *fp;
    int lynq_gpio_arr[85] = {230,231,232,233,234,102,104,103,101,186 ,188 ,187 ,185 ,194 ,196 ,195 ,193 ,205 ,204 ,203 ,202, 201 ,190 ,192 ,191 ,189 ,173 ,174 ,175 ,176 ,170 ,169 ,184 ,183 ,182 ,181 ,24 ,25 ,157 ,158 ,155 ,156 ,143 ,144 ,140 ,141 ,153 ,154 ,180 ,179 ,29 ,30 ,178, 177, 7 ,5 ,4 ,113 ,112, 116 ,115 ,114, 107, 108, 105, 106, 100 ,99 ,98, 97, 94, 93, 92, 91, 1 ,130 ,41 ,67 ,69, 68, 63, 22, 23, 199, 200};
    char lynq_set_gpio_arr[256] = {0};
    char lynq_get_gpio_state[512] = {0};
    char lynq_show_gpio_state[64] = {0};
    int lynq_gpio_low = 0;
    int lynq_gpio_hig = 0;
    int lynq_gpio_test_env_error = 1;
    int i = 0,m = 0,j = 0;
    int need_int = 1;
    int lynq_gpio_beta_state = 1;
    RLOGD("start function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
    
    for(i=0; i < 85; i++)
    {

        for(j=0;j<3;j++)
        {
            if  (j > 0) // reset gpio when retry
            {
                need_int = 1;
            }

            if (need_int == 1)
            {
                if (set_all_gpio_status_and_check(lynq_gpio_arr, '0') != 0)
                {
                    continue;
                }
                else
                {
                    need_int = 0;
                }
                RLOGD("finsh peizhi function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
            }

            lynq_gpio_low = 0;
            lynq_gpio_hig = 0;

            for(int n=0;n<3;n++)
            {
                bzero(lynq_set_gpio_arr, 256);
                sprintf(lynq_set_gpio_arr,"echo mode %d 0 > /sys/devices/platform/10005000.pinctrl/mt_gpio",(char*)lynq_gpio_arr[i]);
                system(lynq_set_gpio_arr);

                bzero(lynq_set_gpio_arr, 256);
                sprintf(lynq_set_gpio_arr,"echo out %d 1 > /sys/devices/platform/10005000.pinctrl/mt_gpio",(char*)lynq_gpio_arr[i]);
                system(lynq_set_gpio_arr);


                bzero(lynq_set_gpio_arr, 256);
                sprintf(lynq_set_gpio_arr,"cat /sys/devices/platform/10005000.pinctrl/mt_gpio | grep 006");
                fp=popen(lynq_set_gpio_arr, "r");
                bzero(lynq_get_gpio_state, 512);
                fgets(lynq_get_gpio_state,sizeof(lynq_get_gpio_state),fp);
                pclose(fp);
                if(lynq_get_gpio_state[7] == '1')
                {
                    RLOGD("high function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
                    lynq_gpio_hig = 1;
                    lynq_gpio_test_env_error = 0;
                    break;
                }
                else
                {
                    RLOGD("high function %s line %d input %s num %d\n", __FUNCTION__, __LINE__, input,lynq_gpio_arr[i]);
                    if(i == 0 && j == 0)
                    {

                        lynq_gpio_test_env_error = set_all_gpio_status_and_check(lynq_gpio_arr, '1') == 0 ? 0 : 1;
                    }

                }
            }
            if (lynq_gpio_test_env_error == 1)
                break;
            bzero(lynq_set_gpio_arr, 256);
            sprintf(lynq_set_gpio_arr,"echo out %d 0 > /sys/devices/platform/10005000.pinctrl/mt_gpio",(char*)lynq_gpio_arr[i]);
            system(lynq_set_gpio_arr);
            
            bzero(lynq_set_gpio_arr, 256);
            sprintf(lynq_set_gpio_arr,"cat /sys/devices/platform/10005000.pinctrl/mt_gpio | grep 006");
            fp=popen(lynq_set_gpio_arr, "r");
            bzero(lynq_get_gpio_state, 512);
            fgets(lynq_get_gpio_state,sizeof(lynq_get_gpio_state),fp);
            pclose(fp);
            if(lynq_get_gpio_state[7] == '0')
            {
                RLOGI("*low function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
                lynq_gpio_low = 1;
            }
            else
            {
                RLOGD("low function fail %s line %d input %s num %d\n", __FUNCTION__, __LINE__, input,lynq_gpio_arr[i]);
            }
            bzero(lynq_show_gpio_state, 64);
            if((lynq_gpio_low != 1) || (lynq_gpio_hig != 1))
            {
                RLOGD("fail function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
            }
            else
            {
                RLOGD("success function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
                sprintf(lynq_show_gpio_state,"gpio%d\n",(char *)lynq_gpio_arr[i]);
                handle_output(lynq_show_gpio_state, strlen(lynq_show_gpio_state), Response);
                break; // do not retry when pass
            }
        } // for(j=0;j<3;j++)
        if (lynq_gpio_test_env_error == 1)
        {
            lynq_gpio_beta_state = 0;
            break;
        }
        if (j >= 3 )
        {
            lynq_gpio_beta_state = 0;
            sprintf(lynq_show_gpio_state,"[gpio%d][result]:FAIL \n",(char *)lynq_gpio_arr[i]);
            handle_output(lynq_show_gpio_state, strlen(lynq_show_gpio_state), Response);
        }

    } // for(i=0; i < 85; i++)

    if(lynq_gpio_test_env_error == 1)
    {
        handle_output("tool error", strlen("tool error"), Response);
    }

    if(lynq_gpio_beta_state == 1)
    {
        RLOGD("total success function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
        lynq_response_ok();
    }
    else
    {
        RLOGD("total fail function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
        lynq_response_error(100);
    }
}

void lynq_handle_pcie(char *input)
{
    FILE *fp;
    char lynq_usb_dev[128] = {0};
    char lynq_get_gpio_state[512] = {0};
    sprintf(lynq_usb_dev,"cat sys/devices/platform/10005000.pinctrl/mt_gpio |grep 097  2>&1");
    fp=popen(lynq_usb_dev, "r");
    fgets(lynq_get_gpio_state,sizeof(lynq_get_gpio_state),fp);
    pclose(fp);
    if(lynq_get_gpio_state[6] == '1')
    {
        lynq_response_ok();
    }
    else
    {
        lynq_response_error(100);
    }
}

int receive_data(int fd,char *buf_send,char *buf_recv, int send_len)
{
    time_t time_start;
    time_t time_end;
    int ret = 0;
    time_start=time(NULL);
    for(int recv =0;recv <50;recv++)
    {
        bzero(buf_recv, send_len);
        ret = recvfrom(fd,buf_recv,1024,0,NULL,NULL);
        if(ret<0)
        {
            handle_output("time_out", strlen("time_out"), Response);
            return -1;
        }
        else if (ret != send_len)
        {
            continue;
        }

        if(memcmp(buf_send,buf_recv, send_len))
        {
            time_end=time(NULL);
            if(difftime(time_end,time_start)>2)
            {
                handle_output("time_out", strlen("time_out"), Response);
                break;
            }
        }
        else
        {
            return 0;
        }
    }
    handle_output("can't receive correct data", strlen("can't receive correct data"), Response);
    return -1;
}

int rsgmii_init()
{
    char lynq_set_rgmii_arr[256] = {0};

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth1 | grep \"RUNNING\"");
    if(system(lynq_set_rgmii_arr))
    {
        handle_output("Please checkout network_line", strlen("Please checkout network_line"), Response);
        return -1;
    }
    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth2 | grep \"RUNNING\"");
    if(system(lynq_set_rgmii_arr))
    {
        handle_output("Please checkout network_line", strlen("Please checkout network_line"), Response);
        return -1;
    }

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth1 192.168.11.1");
    system(lynq_set_rgmii_arr);

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth2 192.168.22.2");
    system(lynq_set_rgmii_arr);

    
    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth1 | grep HWaddr | awk '{print \"ip n add 192.168.11.1 lladdr \"$5\" dev eth2\"}' | sh");
    system(lynq_set_rgmii_arr);

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth2 | grep HWaddr | awk '{print \"ip n add 192.168.22.2 lladdr \"$5\" dev eth1\"}' | sh");
    system(lynq_set_rgmii_arr);

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"iptables -t nat -A POSTROUTING -s 192.168.22.2 -d 192.168.11.1 -j SNAT --to-source 192.168.22.44");
    system(lynq_set_rgmii_arr);

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"iptables -t nat -A POSTROUTING -s 192.168.11.1 -d 192.168.22.2 -j SNAT --to-source 192.168.11.33");
    system(lynq_set_rgmii_arr);

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth1 | grep \"inet addr\" | grep \"192.168.11.1\"");
    if(system(lynq_set_rgmii_arr))
    {
        return -1;
    }

    bzero(lynq_set_rgmii_arr, 256);
    sprintf(lynq_set_rgmii_arr,"ifconfig eth2 | grep \"inet addr\" | grep \"192.168.22.2\"");
    if(system(lynq_set_rgmii_arr))
    {
        return -1;
    }
    return 0;
}


int rsgmii_socket_init(struct sockaddr_in* server_addr, const char * eth_name, const char * ip_addr)
{
    int ser_socket = -1;
    struct ifreq ser;
    memset(&ser,0x00,sizeof(ser));
    strncpy(ser.ifr_name,eth_name,strlen(eth_name));

    server_addr->sin_family=AF_INET;
    server_addr->sin_port = htons(100);
    server_addr->sin_addr.s_addr = inet_addr(ip_addr);


    ser_socket = socket(AF_INET,SOCK_DGRAM,0);
    if (ser_socket<0)
    {
        return -1;
    }
    
    struct timeval timeout={1,0};
    int ret;
    ret = bind(ser_socket,(struct sockaddr*)server_addr,sizeof(*server_addr));
    if(ret< 0)
    {
        close(ser_socket);
        return -1;
    }
    
    ret = setsockopt(ser_socket,SOL_SOCKET,SO_BINDTODEVICE,(char *)&ser,sizeof(ser));
    if(ret< 0)
    {
        close(ser_socket);
        return -1;
    }
    ret = setsockopt(ser_socket,SOL_SOCKET,SO_RCVTIMEO,&timeout,sizeof(timeout));
    if(ret< 0)
    {
        close(ser_socket);
        return -1;
    }

    return ser_socket;
}

void lynq_handle_rsgmii()
{
    
    int ret;
    int check_count = 0;
    int check_ok_count = 0;
    int ser_socket = -1;
    int cli_socket = -1;
    char buf_init[1024];
    char buf_tran[1024];
    char buf_recv[1024];
    char flag[256]={0};
    struct sockaddr_in ser_addr;
    struct sockaddr_in cli_addr;
    time_t start,end;
    bzero(buf_init,sizeof(buf_init));
    bzero(buf_tran,sizeof(buf_tran));
    bzero(buf_recv,sizeof(buf_recv));
    
    const char *ser_ip = "192.168.22.2";
    const char *cli_ip = "192.168.11.1";
    const char * ser_name = "eth2";
    const char * cli_name = "eth1";
    int count = 0;
    ret = rsgmii_init();
    if(ret<0)
    {
        lynq_response_error(1);
        return;
    }

    ser_socket =rsgmii_socket_init(&ser_addr, ser_name, ser_ip);
    if(ser_socket < 0)
    {
        handle_output("init_failed", strlen("init_failed"), Response);
        lynq_response_error(2);
        return;
    }

    cli_socket =rsgmii_socket_init(&cli_addr, cli_name, cli_ip);
    if(cli_socket < 0)
    {
        close(ser_socket);
        handle_output("init_failed", strlen("init_failed"), Response);
        lynq_response_error(3);
        return;
    }
    //data content
    for(int j =0;j<4;j++)
    {
        for(int i =0;i<255;i++)
        {
            count += sprintf(buf_init + count,"%c",i);
            if (count >= 1024)
            {
                buf_init[1023] = '\0';
                break;
            }
        }
        
        if (count >= 1024)
        {
            break;
        }
    }

    start = time(NULL);
    for(int i=0;i<128;i++)
    {
        check_count++;
        end = time(NULL);
        if(difftime(end,start)>10)
        {
            break;
        }
        ret = sendto(cli_socket,buf_init,sizeof(buf_init),0,(struct sockaddr*)&ser_addr,sizeof(ser_addr));
        if(ret < 0 )
        {
            continue;
        }

        ret = receive_data(ser_socket,buf_init,buf_tran, sizeof(buf_init));
        if(ret < 0)
        {
            continue;
        }

        //ser receive data and send back the same of data to cli
        ret = sendto(ser_socket,buf_tran,sizeof(buf_init),0,(struct sockaddr*)&cli_addr,sizeof(cli_addr));
        if(ret <0)
        {
            continue;
        }

        ret = receive_data(cli_socket,buf_init,buf_recv, sizeof(buf_init));
        if(ret < 0)
        {
            continue;
        }

        check_ok_count ++;
    }

    if(check_ok_count >= 120)
    {
        lynq_response_ok();
    }
    else
    {
        sprintf(flag,"sent %d, success %d\n", check_count, check_ok_count);
        handle_output(flag, strlen(flag), Response);
        lynq_response_error(100);
    }

    close(ser_socket);
    close(cli_socket);
    return;
}

void lynq_handle_rgmii(char *input)
{
    char *ipv4 = input+6;
    char cmd[128] = {0};
    FILE *fp;
    sprintf(cmd, "%s %s %s %s", "ping -I eth2", ipv4, "-c4", "2>&1");
    fp=popen(cmd, "r");
    if(NULL == fp){
        char *str = "popen errorn\n";
        handle_output(str, strlen(str), Response);
    }
    char lynq_factory_buf[1024] = {0};
    while (NULL != fgets(lynq_factory_buf,sizeof(lynq_factory_buf),fp))
    {
        if(strstr(lynq_factory_buf, "Usage"))
        {
            char *str  = "RGMII cannot recognize IP addresses\nERROR\n";
            handle_output(str, strlen(str), Response);
            pclose(fp);
        }
        handle_output(lynq_factory_buf, strlen(lynq_factory_buf), Response);
    }
    lynq_response_ok();
    pclose(fp);
}

void lynq_handle_sgmii(char *input)
{
    char *ipv4 = input+6;
    char cmd[128] = {0};
    FILE *fp;
    sprintf(cmd, "%s %s %s %s", "ping -I eth1", ipv4, "-c4", "2>&1");
    fp=popen(cmd, "r");
    if(NULL == fp){
        char *str = "popen errorn\n";
        handle_output(str, strlen(str), Response);
    }
    char lynq_factory_buf[1024] = {0};
    while (NULL != fgets(lynq_factory_buf,sizeof(lynq_factory_buf),fp))
    {
        if(strstr(lynq_factory_buf, "Usage"))
        {
            char *str  = "RGMII cannot recognize IP addresses\nERROR\n";
            handle_output(str, strlen(str), Response);
            pclose(fp);
        }
        handle_output(lynq_factory_buf, strlen(lynq_factory_buf), Response);
    }
    lynq_response_ok();
    pclose(fp);
}

void lynq_handle_inside_version(char *input)
{
    FILE *fp;
    char buf[64] = {0};
    fp=popen("uci get lynq_uci_ro.lynq_version.LYNQ_SW_INSIDE_VERSION 2>&1", "r");
    if(NULL == fp){
        char *str = "popen errorn\n";
        handle_output(str, strlen(str), Response);
    }
    fgets(buf, sizeof(buf), fp);
    handle_output(buf, strlen(buf), Response);
    lynq_response_ok();
    pclose(fp);
}

void lynq_handle_usb(char *input)
{
    FILE *fp;
    char lynq_usb_dev[512] = {0};
    char lynq_usb_buf[512];
    bzero(lynq_usb_buf, 512);
    bzero(lynq_usb_dev,512);
    sprintf(lynq_usb_dev,"cat /sys/devices/platform/11201000.usb/udc/11201000.usb/current_speed  2>&1");
    fp=popen(lynq_usb_dev, "r");
    fgets(lynq_usb_buf,sizeof(lynq_usb_buf),fp);
    if(!strncmp(lynq_usb_buf,usb3_speed,strlen(usb3_speed)))
    {
        char *res = "[usb][result],3.0";
        handle_output(res, strlen(res), Response);
        lynq_response_ok();
    }
    else if(!strncmp(lynq_usb_buf,usb2_speed,strlen(usb2_speed)))
    {
        char *res = "[usb][result],2.0";
        handle_output(res, strlen(res), Response);
        lynq_response_ok();
    }
    pclose(fp);
    return 1;
}


static Command commands[] = 
{
    {"adc",lynq_handle_adc},
    {"sink",lynq_handle_sink},
    {"emmc",lynq_handle_emmc},
    {"gpio",lynq_handle_gpio},
    {"pcie",lynq_handle_pcie},
    {"rsgmii",lynq_handle_rsgmii},
    {"rgmii",lynq_handle_rgmii},
    {"sgmii",lynq_handle_sgmii},
    {"usb",lynq_handle_usb},
    {NULL, NULL}
};

Command* find_command (char *input)
{
    RLOGD("function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
    int i;
    int ret = -1;
    for (i = 0; commands[i].cmd; i++)
    {
        ret = strncmp(input, commands[i].cmd, strlen(commands[i].cmd));
        if(ret == 0)
        {
            RLOGD("function %s line %d find input %s commands[i].cmd %s  strlen %d ret %d\n", __FUNCTION__, __LINE__, input, commands[i].cmd, strlen(commands[i].cmd), ret);
            return (&commands[i]);
        }
    }
    RLOGD("function %s line %d not find ret %d \n", __FUNCTION__, __LINE__, ret);
    return ((Command *)NULL);
}

void lynq_at_factory_cb(char *input, int input_max_size)
{
    if(handle_output != NULL)
    {
        RLOGD("function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
        if(input != NULL)
        {
            char *handle_string = input + strlen(FACTORY_STRING);
            if(!strlen(handle_string))
            {
                RLOGD("function %s line %d strlen %d\n", __FUNCTION__, __LINE__, strlen(handle_string));
                return;
            }
            RLOGD("function %s line %d  handle_string %s\n", __FUNCTION__, __LINE__, handle_string);
            Command *cmd = find_command(handle_string);
            if(cmd != NULL)
            {
                RLOGD("function %s line %d\n", __FUNCTION__, __LINE__);
                (*(cmd->func))(handle_string);
                return;
            }
        }
    }
}

lynq_atsvc_incb lynq_register_at_factory(lynq_atsvc_outcb out_cb)
{
    if(out_cb != NULL)
    {
        handle_output = out_cb;
        RLOGD("function %s line %d\n", __FUNCTION__, __LINE__);
        return lynq_at_factory_cb;
    }
}
