#include <stdio.h>
#include <stdlib.h>
#include "lynq_modem_voice.h"
#include <syslog.h>
#include <log/log.h>
#define LOG_TAG "MEDIA_API"
#include <dtmf.h>
#include "mixer_ctrl.h"

const char g_card_name[] = "mtk_phonecall";
/*for speech on*/
const char g_mixer_name[] = "Speech_on";
const char g_mixer_name_volume[] = "DL Call Playback Volume";
const char g_DL_mute_name[] = "Speech_DL_mute";
const char g_UL_mute_name[] = "Speech_UL_mute";
GstElement *pipeline_element;
static int inCallRecordMode = 0;
static int gst_status = 0;

 int lynq_audio_init() //mixer_init
{
    int ret;

    // only need to set card name once
    ret = set_card_name(g_card_name);
    if (ret)
        RLOGE("set_card_name err: %d", ret);
    return ret;
}

 int lynq_audio_set(int value )//mixer_set
{
    int ret;

     //set mixer ctl to om:1 or off:0
    ret = set_mixer_ctrl_value_int(g_mixer_name, value);
    if (ret)
        RLOGE("set_mixer_ctrl_value_int g_mixer_name err: %d", ret);
    return ret;
}
/*
int mixer_reset_set(int value )
{
    int ret;

    // set mixer  to reset:1
    ret = set_mixer_ctrl_value_int(g_mixer_reset_name, value);
    if (ret)
        RLOGE("set_mixer_ctrl_value_int g_mixer_reset_name err: %d", ret);
    return ret;
}*/





int lynq_set_spk_modem_volume(int value)//mixer_set_volume
{
    int ret;
  //  if (get_audio_path() == 0) {
        ret = set_mixer_ctrl_volume_value(g_mixer_name_volume, value);
   // } else {
   //     ret = set_mixer_ctrl_volume_value(g_mixer_name_volume_bt, value);
   // }
    if (ret)
        RLOGE("set_mixer_ctrl_volume_value_int err: %d", ret);
    return ret;
}


 int lynq_get_spk_modem_volume()//mixer_get_volume
{
    long int vol_value;
  //  if (get_audio_path() == 0) {
        vol_value = get_mixer_ctrl_volume_value(g_mixer_name_volume);
   // } else {
   //     vol_value = get_mixer_ctrl_volume_value(g_mixer_name_volume_bt);
   // }
    RLOGD("The ctrl \"%s\" is set to %d", g_mixer_name_volume, vol_value);
    return vol_value;
}

static int GSM_Init(char* filepath){
    GstElement *pipeline, *source, *mux, *encoder, *sink;
    RLOGD("[GSM]GSM Init Start!");
    /* Initialisation */
    gst_init (NULL, NULL);

    pipeline = gst_pipeline_new ("3gppmux-test");
    source   = gst_element_factory_make ("pulsesrc",       "file-source");
    encoder  = gst_element_factory_make ("faac",           "encoder");
    mux      = gst_element_factory_make ("3gppmux",        "muxer");
    sink     = gst_element_factory_make ("filesink",       "output");

    g_object_set(mux, "fragment-duration", 100, NULL);
    g_object_set(sink, "location", filepath, NULL);

    if (!pipeline || !source || !encoder || !mux || !sink) {
        if(pipeline) {
            gst_object_unref (GST_OBJECT (pipeline));
            pipeline = NULL;
        }
        if(source) {
            gst_object_unref (GST_OBJECT (source));
            source = NULL;
        }
        if(encoder) {
            gst_object_unref (GST_OBJECT (encoder));
            encoder = NULL;
        }
        if(mux) {
            gst_object_unref (GST_OBJECT (mux));
            mux = NULL;
        }
        if(sink) {
            gst_object_unref (GST_OBJECT (sink));
            sink = NULL;
        }
        RLOGE ("[GSM]One element could not be created. Exiting");
        return -1;
    }

    gst_bin_add_many (GST_BIN (pipeline), source, encoder, mux, sink, NULL);
    gst_element_link_many (source, encoder, mux, sink, NULL);

    pipeline_element = pipeline;
    gst_status = 1; //initial done
    RLOGD("[GSM]GSM Init Done!");
    return 0;
}
static int GSM_Start(void)
{
    RLOGD("[GSM]GSM Start start!");
    if(gst_status == 2)
        return 0;

    if(gst_status == 1 || gst_status ==3) {
        GstStateChangeReturn ret = gst_element_set_state (pipeline_element, GST_STATE_PLAYING);

        RLOGD("[GSM]Running... return: %d", ret);
        //g_main_loop_run (gst_loop);
        gst_status = 2; //start done
    } else {
        return -1;
    }
    RLOGD("[GSM]GSM Start End!");
    return 0;
}

static int GSM_Stop()
{
    RLOGD("[GSM]GSM Stop Start!");
    if (gst_status == 4)
        return 0;

    if(gst_status == 2 || gst_status == 3) {
    /* Out of the main loop, clean up nicely */
        gboolean isSend = gst_element_send_event (pipeline_element, gst_event_new_eos ());
        GstStateChangeReturn ret = gst_element_set_state (pipeline_element, GST_STATE_NULL);
        RLOGD("[GSM]Returned, stopping playback. ret: %d, isSend: %d", ret, isSend);
        gst_status = 4;
    } else {
        return -1;
    }
    RLOGD("[GSM]GSM Stop End!");
    return 0;
}
static int GSM_Close()
{
    RLOGD("[GSM]Deleting pipeline");
    gst_object_unref (GST_OBJECT (pipeline_element));
    gst_deinit ();
    gst_status = 0;
    RLOGD("[GSM]GSM Close Done!");
    return 0;
}
int lynq_incall_record(char* file_path)
{
	RLOGD("start GSM!");
	if(-1 != GSM_Init(file_path) && -1 != GSM_Start()) {
		inCallRecordMode = 1;
		RLOGW("inCallRecord Start OK!");
	}else{
		inCallRecordMode = 0;
		return 1;
		RLOGW("[error],inCallRecord Start fail!");
	}

    return 0;
}
int lynq_stop_record()
{
    RLOGD("After Handup, stop record! Before Record is %s",inCallRecordMode ? "Enable" : "Disable");
    if (inCallRecordMode == 1) {
         if(!(-1 != GSM_Stop() && -1 != GSM_Close()))
            RLOGW("[error],inCallRecord fail!");

         inCallRecordMode = 0;
        /*From GSM report stop_record to PulseAudio send record_off  need 15ms. so after stop record delay 30ms*/
         usleep(30*1000);
         return 1;
    }
    return 0;
}

static int mixer_set_mute(int path, int value)
{
    RLOGD("mixer_set_mute path: %d , value: %d", path, value);
    int ret;
    /* DL:0 UL:1 */
    if (path == 0) {
        ret = set_mixer_ctrl_value_int(g_DL_mute_name, value);
    } else {
        ret = set_mixer_ctrl_value_int(g_UL_mute_name, value);
    }
    if (ret) {
        RLOGE("set_mixer_ctrl_volume_value_int err: %d", ret);
    }
    return ret;
}

static long int mixer_get_mute(int path)
{
    long int is_mute;

    /* DL:0 UL:1 */
    if (path == 0) {
        is_mute = get_mixer_ctrl_value_int(g_DL_mute_name);
        RLOGD("The ctrl \"%s\" is set to %d", g_DL_mute_name, is_mute);
    } else {
        is_mute = get_mixer_ctrl_value_int(g_UL_mute_name);
        RLOGD("The ctrl \"%s\" is set to %d", g_UL_mute_name, is_mute);
    }

    return is_mute;
}
 int lynq_set_call_mute(int mute) {
    RLOGD("setCallMute: %d", mute);
    return mixer_set_mute(1, (mute ? 1: 0));
}

int lynq_get_call_mute() {
    long int cc_mute = mixer_get_mute(1);
    RLOGD("getCallMute: %d", cc_mute);
    return cc_mute;
}


void lynq_reset_mute() {
    if (lynq_get_call_mute() > 0) {
        lynq_set_call_mute(0);
    }
}


