#ifndef _LYNQ_HTTP_H_
#define _LYNQ_HTTP_H_

#define HTTP_API


#include "lynq_http_parser.h"
#include "lynq_msgq.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <pthread.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/select.h>
#include <time.h> 
#include <ctype.h>
#include <netdb.h>
#include <strings.h>
#include <openssl/ssl.h>
#include <openssl/err.h>

#ifdef _cplusplus
extern "C" {
#endif

#define HTTP_INVALID_SOCKET -1
#define HTTP_EINTR EINTR
#define HTTP_EINPROGRESS EINPROGRESS
#define HTTP_EWOULDBLOCK EWOULDBLOCK
#define HTTP_EALREADY EALREADY

#define free_member(member) if((member)) { free(member); (member) = NULL; }
#define close_socket(fd) if(fd != HTTP_INVALID_SOCKET) { socket_close(fd); fd = HTTP_INVALID_SOCKET; }
#define close_file(pf) if(pf != NULL) { fclose(pf); pf = NULL; }

#define RECV_BUF_SIZE 4 * 1024

#define socket_close close


enum parser_statue_e { PARSERD_NONE = 0, PARSERD_FIELD, PARSERD_VALUE, PARSERD_BODY };

enum proto_type_e { PROTO_HTTP = 0, PROTO_HTTPS };
	typedef enum http_request_method_e 
	{ 
		M_GET = 0, 
		M_POST, 
		M_HEAD 
	} http_request_method_e;

	typedef enum http_connent_method_e 
	{ 
		M_CLOSE = 0, 
		M_KEEP,
	} http_connent_method_e;

	enum http_error_e
	{
		ERR_OK = 0,

		ERR_INVALID_PARAM,
		ERR_OUT_MEMORY,
		ERR_OPEN_FILE,
		ERR_PARSE_REP,
		ERR_URL_INVALID,
		ERR_URL_INVALID_PROTO,
		ERR_URL_INVALID_HOST,
		ERR_URL_INVALID_IP,
		ERR_URL_RESOLVED_HOST,
		ERR_SOCKET_CREATE = 10,
		ERR_SOCKET_SET_OPT,
		ERR_SOCKET_NOBLOCKING,
		ERR_SOCKET_CONNECT,
		ERR_SOCKET_CONNECT_TIMEOUT,
		ERR_SOCKET_SELECT,
		ERR_SOCKET_WRITE,
		ERR_SOCKET_READ,
		ERR_SOCKET_TIMEOUT,
		ERR_SOCKET_CLOSED,
		ERR_SOCKET_GET_OPT = 20,
		ERR_SSL_CREATE_CTX,
		ERR_SSL_CREATE_SSL,
		ERR_SSL_SET_FD,
		ERR_SSL_CONNECT,
		ERR_SSL_WRITE,
		ERR_SSL_READ,
		ERR_NOCERT,
		ERR_MSG
	};

	struct lynq_http_client_t;
	typedef struct lynq_http_client_t lynq_http_client_t;
	typedef int (*data_recv_cb_t)( lynq_http_client_t* http, const char* data, int size, int total, void* user);

 typedef int socket_t;

 
 struct lynq_http_client_t
 {
	int index;
	char protocol[10];
	int  session;
	char action[10];
	char *data;
	char *section;
	int request_method;
	int connent_method;
	int sockfd;
	int modify_thread;
	int add_thread;

	FILE* pf;
	char* filename;
	char* body;
	char* redirect_url;
	char* header_field;
	char* header_value;

	char* post_data;
	char* url;
	int post_data_len;
	struct http_parser_url u;
	char* user_header;
	int user_header_len;
	
	http_parser_settings parser_setting;
	struct http_parser parser;


	char* user;
	data_recv_cb_t recv_cb;
	
	unsigned long body_len;
	unsigned long content_length;

	enum http_request_method_e method;
	enum http_connent_method_e conn_method;
	enum proto_type_e proto_type;

	unsigned short field_size;
	unsigned short value_size;
	unsigned short cur_field_size;
	unsigned short cur_value_size;
	SSL_CTX *ctx;
	SSL *ssl;

	socket_t fd; 
	int timeout;
	
	short status_code;
	char parser_statue;
	char error_code;
	unsigned cancel   : 1;
	unsigned exit	  : 1;
	unsigned download : 1;
	unsigned redirect : 1;
};


int lynq_http_init(void);
lynq_http_client_t* lynq_http_new();
void lynq_http_destroy(lynq_http_client_t* http);
int lynq_http_get_error_code(lynq_http_client_t* http);
const char* lynq_http_sync_request(lynq_http_client_t* http, const char* url, http_request_method_e m, http_connent_method_e c_m);
const char* lynq_http_sync_post_request(lynq_http_client_t* http, char* url, char* post_data, http_request_method_e m, http_connent_method_e c_m);
int lynq_http_sync_download_file(lynq_http_client_t* http, char* url, char* filepath, http_request_method_e m, http_connent_method_e c_m);
int lynq_http_set_data_recv_cb(lynq_http_client_t* http, data_recv_cb_t cb, void* user);
int lynq_http_exit(lynq_http_client_t* http);
int lynq_http_data_send(char *data);
void *lynq_http_write_head_data(lynq_http_client_t* http);
#ifdef _cplusplus
}
#endif
#endif

