#ifndef LYNQ_RTP_H
#define LYNQ_RTP_H

#ifdef __cplusplus
extern "C" {
#endif

#define  MAX_IP_LENGTH 128
#define  MAX_EN_CODING_NAME_LENGTH 32
#define  MAX_CMD_SIZE 512

typedef enum{
    RTP_CLIENT = 0,     
    RTP_SERVER =1,
}LYNQ_Rtp_Mode;

int lynq_set_rtp_mode_media_play(const LYNQ_Rtp_Mode rtp_mode);
int lynq_set_rtp_ip_media_play(LYNQ_Rtp_Mode rtp_mode,const char* ip,const int ip_length);
int lynq_set_rtp_port_media_play(LYNQ_Rtp_Mode rtp_mode,const int port);
int lynq_set_rtp_param_media_play(LYNQ_Rtp_Mode rtp_mode,char *file_address,const int clock_rate,const int channels,const int latency);

int lynq_get_rtp_ip_media_play(const LYNQ_Rtp_Mode rtp_mode, char* ip, const int ip_length);
int lynq_get_rtp_port_media_play(LYNQ_Rtp_Mode rtp_mode,int* port);
int lynq_get_rtp_param_media_play(LYNQ_Rtp_Mode rtp_mode,char *file_address,int* clock_rate,int* channels,int* latency);

int lynq_start_rtp_server_media_play();
int lynq_stop_rtp_server_media_play();


#ifdef __cplusplus
}
#endif

#endif