/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef SSLP_SSLPMANAGER_H_
#define SSLP_SSLPMANAGER_H_

#include <cstdint>
#include <string>
#include <vector>
#include <memory>

#include "IndividualRecord.h"

class SslpManager {
public:
    SslpManager();
    virtual ~SslpManager();
    int decodeAllRecords(const char* sfrd , std::uint16_t len);
    bool isIncludedCmdCode(std::uint16_t cmd);
    bool isNeedNewSms();
    int getEcallReqPara();
    //sst ,rst service_support_layer_protocol::EGTS_ECALL_SERVICE, service_support_layer_protocol::EGTS_ECALL_SERVICE
    std::string encodeAllRecords(std::uint8_t sst, std::uint8_t rst,std::uint8_t srt, std::string msd); //srt: EcallUtils::EGTS_SR_RAW_MSD_DATA
    std::vector<std::shared_ptr<IndividualRecord> >& getDeRecords();
    //sst, rst service_support_layer_protocol::EGTS_COMMANDS_SERVICE, service_support_layer_protocol::EGTS_COMMANDS_SERVICE,
    //CmdUtils::EGTS_SR_COMMAND_DATA,
    //cmd: EcallUtils: 1.EGTS_ECALL_DEREGISTRATION 2. EGTS_ECALL_MSD_REQ.3 EGTS_ECALL_REQ
    std::string encodeAck(std::uint8_t sst_value, std::uint8_t rst_value, std::uint8_t subType, std::uint16_t cmd, bool ack);

private:
    std::vector<std::shared_ptr<IndividualRecord>> deRecords;
    std::shared_ptr<IndividualRecord> enRecords;
};

#endif /* SSLP_SSLPMANAGER_H_ */
