/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  This software is protected by Copyright and the information contained
*  herein is confidential. The software may not be copied and the information
*  contained herein may not be used or disclosed except with the written
*  permission of MediaTek Inc. (C) 2005
*
*  BY OPENING THIS FILE, BUYER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
*  THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
*  RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO BUYER ON
*  AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
*  NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
*  SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
*  SUPPLIED WITH THE MEDIATEK SOFTWARE, AND BUYER AGREES TO LOOK ONLY TO SUCH
*  THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. MEDIATEK SHALL ALSO
*  NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO BUYER'S
*  SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN FORUM.
*
*  BUYER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND CUMULATIVE
*  LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
*  AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
*  OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY BUYER TO
*  MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
*  THE TRANSACTION CONTEMPLATED HEREUNDER SHALL BE CONSTRUED IN ACCORDANCE
*  WITH THE LAWS OF THE STATE OF CALIFORNIA, USA, EXCLUDING ITS CONFLICT OF
*  LAWS PRINCIPLES.  ANY DISPUTES, CONTROVERSIES OR CLAIMS ARISING THEREOF AND
*  RELATED THERETO SHALL BE SETTLED BY ARBITRATION IN SAN FRANCISCO, CA, UNDER
*  THE RULES OF THE INTERNATIONAL CHAMBER OF COMMERCE (ICC).
*
*****************************************************************************/

#ifndef _EM_EL1_PUBLIC_STRUCT_H
#define _EM_EL1_PUBLIC_STRUCT_H

/* portable 8-bit unsigned integer */
typedef unsigned char           kal_uint8;
/* portable 8-bit signed integer */
typedef signed char             kal_int8;
/* portable 16-bit unsigned integer */
typedef unsigned short int      kal_uint16;
/* portable 16-bit signed integer */
typedef signed short int        kal_int16;
/* portable 32-bit unsigned integer */
typedef unsigned int            kal_uint32;
typedef signed int              kal_int32;
typedef unsigned long long kal_uint64;
typedef signed long long kal_int64;
typedef unsigned char kal_bool;
typedef kal_uint32 EARFCN;

/* EL1 */
#define RPT_LTE_RX_CC_MAX   4
#define RPT_LTE_TX_CC_MAX   2
#define LTE_MAX_DATA_BUF   30   // EL1 MDMI

#define AGC_RX_ANT_NUM 2
#define EM_OTDOA_MAX_NBR_CELL_LIST_NUM_TOTAL  3

#define LOCAL_PARA_HDR \
   kal_uint8 ref_count; \
   kal_uint8 lp_reserved; \
   kal_uint16 msg_len;

typedef enum
{
    EM_RNTI_NONE                = 0,
    EM_C_RNTI                   = 1,
    EM_SPSC_RNTI                = 2,
    EM_P_RNTI                   = 3,
    EM_RA_RNTI                  = 4,
    EM_TC_RNTI                  = 5,
    EM_SI_RNTI                  = 6,
    EM_TPC_PUSCH_RNTI           = 7,
    EM_TPC_PUCCH_RNTI           = 8,
    EM_M_RNTI                   = 9,
    EM_RNTI_INVALID             = 255
} em_dl_rnti_enum;

typedef enum
{
   /*
    * MP branches: please add "EM type id" in em_info_enum.h.
    * Please remember to modify MD_COMMON\EM\em_info_enum.h for main TRUNK ex: LR11/LR12/UMOLY/UMOLYA
    */
          /* RR */
          /* Begin of RR EM INFO Request enum */
          RR_EM_CELL_SELECT_PARA_INFO = 0, RR_EM_INFO_BEGIN = RR_EM_CELL_SELECT_PARA_INFO,
          RR_EM_CHANNEL_DESCR_INFO = 1,
          RR_EM_CTRL_CHANNEL_DESCR_INFO = 2,
          RR_EM_RACH_CTRL_PARA_INFO = 3,
          RR_EM_LAI_INFO = 4,
          RR_EM_RADIO_LINK_COUNTER_INFO = 5,
          RR_EM_MEASUREMENT_REPORT_INFO = 6,
          /* ZY : Temp solution : Cell allocation list*/
          RR_EM_CA_LIST_INFO = 7,
          /* RR new structure */
          RR_EM_CONTROL_MSG_INFO = 8,
          RR_EM_SI2Q_INFO_STRUCT_INFO = 9,
          RR_EM_MI_INFO_STRUCT_INFO = 10,
          RR_EM_BLK_INFO = 11,
          RR_EM_TBF_INFO = 12,
          RR_EM_GPRS_GENERAL_INFO = 13,
          /* GAS MM EM INFO */
          RRM_EM_FDD_IR_PARAMETER_STATUS_IND_STRUCT_INFO = 14,
          RRM_EM_IR_RESELECT_STATUS_IND_STRUCT_INFO = 15,
          RRM_EM_IR_3G_NEIGHBOR_MEAS_STATUS_IND_STRUCT_INFO = 16,
          RRM_EM_IR_3G_NEIGHBOR_MEAS_INFO_IND_STRUCT_INFO = 17,
          RRM_EM_IR_4G_NEIGHBOR_MEAS_STATUS_IND_STRUCT_INFO = 18,
          RRM_EM_IR_4G_NEIGHBOR_MEAS_INFO_IND_STRUCT_INFO = 19,
          RRM_EM_SERV_CELL_POWER_STATUS_IND_STRUCT_INFO = 20,
          RRM_EM_IR_3G_NEIGHBOR_CELL_STATUS_IND_STRUCT_INFO = 21,
          RRM_EM_IR_4G_NEIGHBOR_CELL_STATUS_IND_STRUCT_INFO = 22,
          RRM_EM_TDD_IR_PARAMETER_STATUS_IND_STRUCT_INFO = 23,
          RRM_EM_SUCCESS_RATE_KPI_INFO = 24,
          RRM_EM_MT_T3126_TIMEOUT_INFO = 25,
          RRM_EM_CS_RLF_INFO = 26,
          RRM_EM_RR_STATE_INFO = 27,
          RRM_EM_GAS_SEARCH_INFO = 28,
          RRM_EM_DOWNLINK_SIGNALLING_COUNTER_INFO = 29,
          RRM_EM_RACH_FAIL = 30,
          RRM_EM_N200_EXP = 31,
          RRM_EM_HO_FAIL = 32,
          RRM_EM_OOS_IND = 33,
          RR_EM_INFO_END = RR_EM_INFO_BEGIN + 49,

          /*End of RR EM INFO Request enum*/

          /* CC */
          CC_EM_CHANNEL_INFO = 50,
          CC_EM_CALL_INFO = 51,

          /* SS */
          SS_EM_INFO = 52,

          /* MM */
          MM_EM_INFO = 53,
          /*EM ehancement for RR new structure*/
          MMRR_EM_PLMN_INFO_STRUCT_INFO = 54,

          /* UEM */
          UEM_EM_BATTERY_INFO = 55,

          /* gprs em begins */
          GMM_EM_INFO = 56,
       //   TCM_EM_EXT_PDP_INFO,
       //   TCM_EM_INT_PDP_INFO,
       //   TCM_EM_CONTEXT_INFO, //new
       //   SNDCP_EM_INFO,
          LLC_EM_INFO = 57,
          /* PPP , removed because of no use*/
          //PPP_EM_INFO,
          SM_EM_INFO = 58,
          EM_TCM_INFO_IND = 59,

          MMRR_EM_PLMN_LIST_REQ_STRUCT_INFO = 60,
          MMRR_EM_PLMN_LIST_CNF_STRUCT_INFO = 61,
          MMRR_EM_PLMN_SEARCH_REQ_STRUCT_INFO = 62,
          MMRR_EM_PLMN_SEARCH_CNF_STRUCT_INFO = 63,
          MMRR_EM_HPLMN_LIST_INFO = 64,
          MMRR_EM_OPLMN_LIST_INFO = 65,
          MMRR_EM_STATIC_APPLMN_LIST_INFO = 66,
          MMRR_EM_DYNAMIC_APPLMN_LIST_INFO = 67,

           /* VT EM Display, 2007/11/30 */
           /* VT owner comments VT EM enum is not needed in WR8 */
           //VT_EM_CALL_STATE_INFO = 50, VT_EM_BEGIN = VT_EM_CALL_STATE_INFO,/* vt_em_call_state_choice */
           //VT_EM_MASTER_SLAVE_STATUS_INFO,     /* vt_em_master_slave_status_choice */
           //VT_EM_RETRANSMISSION_PROTOCOL_INFO, /* vt_em_retransmission_protocol_choice */
           //VT_EM_INCOMING_AUDIO_CHANNEL_INFO,  /* vt_em_audio_channel_info_struct */
           //VT_EM_OUTGOING_AUDIO_CHANNEL_INFO,  /* vt_em_audio_channel_info_struct */
           //VT_EM_INCOMING_VIDEO_CHANNEL_INFO,  /* vt_em_video_channel_info_struct */
           //VT_EM_OUTGOING_VIDEO_CHANNEL_INFO,  /* vt_em_video_channel_info_struct */
           //VT_EM_ADM_MEM_MAX_USED_INFO,        /* kal_uint32 */
           //VT_EM_STATISTIC_INFO,               /* vt_em_statistic_info_struct */
           //VT_EM_ROUND_TRIP_DELAY_INFO,        /* kal_uint32 */
           //VT_EM_INCOMING_XSRP_INFO,           /* vt_em_incoming_xSRP */
           //VT_EM_OUTGOING_XSRP_INFO,           /* vt_em_outgoing_xSRP */
           //VT_EM_END = VT_EM_OUTGOING_XSRP_INFO,

          /**
           * Gibran 20061228
           * UAS MEME/CSCE measuremnt and cell status structure
           */
          MMRR_EM_PLMN_LOSS_INFO_STRUCT_INFO = 68,
          MMRR_EM_PLMN_SEARCH_CNF_INFO_STRUCT_INFO = 69,
          /* URR common Range 1, from enum 70 to 169.
             it's used for both FDD and TDD */
          FDD_EM_URR_3G_GENERAL_STATUS_IND = 70, URR_EM_INFO_BEGIN = FDD_EM_URR_3G_GENERAL_STATUS_IND,
          /* Put 1st XXX_STATUS_IND_STRUCT_INFO in front of XXX_EM_INFO_BEGIN
             in order to show enum_name in XXX_STATUS_IND_STRUCT_INFO not in XXX_EM_INFO_BEGIN. */

          EM_SIBE_3G_SIB_IND_STRUCT_INFO = 71,
          TDD_EM_URR_3G_GENERAL_STATUS_IND = 72,
          FDD_EM_CSCE_SERV_CELL_IND_STRUCT_INFO = 75,
          FDD_EM_CSCE_NEIGH_CELL_IND_STRUCT_INFO = 76,
          FDD_EM_CSCE_R_STATUS_IND_STRUCT_INFO = 77,
          FDD_EM_CSCE_H_STATUS_IND_STRUCT_INFO = 78,
          FDD_EM_CSCE_APBCR_STATUS_IND_STRUCT_INFO = 79,
          FDD_EM_CSCE_MEAS_RULE_STATUS_IND_STRUCT_INFO = 80,
          FDD_EM_CSCE_MULTIPLE_PLMN_IND_STRUCT_INFO = 81,
          TDD_EM_CSCE_SERV_CELL_IND_STRUCT_INFO = 82,
          TDD_EM_CSCE_NEIGH_CELL_IND_STRUCT_INFO = 83,
          TDD_EM_CSCE_R_STATUS_IND_STRUCT_INFO = 84,
          TDD_EM_CSCE_H_STATUS_IND_STRUCT_INFO = 85,
          TDD_EM_CSCE_APBCR_STATUS_IND_STRUCT_INFO = 86,
          TDD_EM_CSCE_MEAS_RULE_STATUS_IND_STRUCT_INFO = 87,
          TDD_EM_CSCE_MULTIPLE_PLMN_IND_STRUCT_INFO = 88,

           /*SIM*/
          EM_SIM_MONITOR_EVENT_INFO = 89,

          EM_TDD_MEME_INFO_DCH_UMTS_CELL_INFO = 90, TDD_MEME_EM_INFO_BEGIN = EM_TDD_MEME_INFO_DCH_UMTS_CELL_INFO,
          EM_TDD_MEME_INFO_DCH_GSM_CELL_INFO = 91,
          EM_TDD_MEME_INFO_DCH_LTE_CELL_INFO = 92,
          EM_TDD_MEME_INFO_EVENT_TYPE_1_PARAMETER_STRUCT_INFO = 93,
          EM_TDD_MEME_INFO_EVENT_TYPE_2_PARAMETER_STRUCT_INFO = 94,
          EM_TDD_MEME_INFO_EVENT_TYPE_3_PARAMETER_STRUCT_INFO =95,
       //   EM_MEME_INFO_EVENT_TYPE_4_PARAMETER_STRUCT_INFO,
       //   EM_MEME_INFO_EVENT_TYPE_5_PARAMETER_STRUCT_INFO,
       //   EM_MEME_INFO_EVENT_TYPE_6_PARAMETER_STRUCT_INFO,
       //   EM_MEME_INFO_DCH_H_SERVING_CELL_INFO,
       //   EM_TDD_MEME_INFO_DCH_3G_BLER_INFO = 96,
          EM_TDD_MEME_INFO_GSM_CELL_INFO =97, //for CMCC FT Tool
          EM_TDD_MEME_INFO_LTE_CELL_INFO =98, //for CMCC FT Tool
       //   EM_MEME_INFO_FACH_LTE_CELL_INFO = 100,
          EM_TDD_MEME_INFO_REPORT_INFO = 99,
          TDD_MEME_EM_INFO_END = TDD_MEME_EM_INFO_BEGIN + 15,

          /* Call Information */
          EM_CALL_INFO_IND = 106,

          /* SIP Information */
          EM_IMC_SIP_INFO_IND = 107,

          MMRF_EM_MIPI_HW_INFO = 108,

          EM_RRCE_TGPS_STATUS_IND= 110,
          EM_SLCE_SRNCID_STATUS_IND= 111,

          /* WO: 112 ~ 129 */
          EM_WO_INFO_BEGIN = 112,
          EM_WO_IKE_SRCPORT_INFO = EM_WO_INFO_BEGIN,
          EM_WO_IKE_NATT_SRCPORT_INFO = 113,
          EM_WO_IKE_DECRYPT_INFO_ADD = 114,
          EM_WO_IKE_DECRYPT_INFO_DEL = 115,
          EM_WO_ESP_DECRYPT_INFO_ADD = 116,
          EM_WO_ESP_DECRYPT_INFO_DEL = 117,
          EM_WO_DPD_INTERVAL_INFO = 118,
          EM_WO_INFO_END = EM_WO_INFO_BEGIN + 17,

          EM_UAS_3G_TDD128_HANDOVER_SEQUENCE_IND = 130,

          EM_RRCE_3G4_REDIR_EVENT = 131,
          EM_RRCE_KPI_STATUS_IND = 132,
          TDD_EM_RRCE_CONN_STATUS_IND = 133,

          /* SIM */
          EM_SIM_APDU_INFO = 135,

          EM_SLCE_PS_DATA_RATE_STATUS_IND = 140,
          EM_RRCE_NW_PEER_MSG_INFO = 150,
          EM_RRCE_RACH_FAIL_IND = 151,
          EM_RRCE_MO_RLF_IND = 152,
          EM_RRCE_3G3_HO_FAIL_IND = 153,
          EM_RRCE_3G2_HO_FAIL_IND = 154,
          EM_RRCE_DCH_STATE_CONFIGURATION_STATUS_IND = 155,
          EM_RRCE_FACH_STATE_CONFIGURATION_STATUS_IND = 156,
          EM_RRCE_CS_OVER_HSPA_STATUS_IND = 157,
          EM_RRCE_3G_SECURITY_CONFIGURATION_INFO_IND = 158,
          EM_RRCE_FD_CONFIGURATION_STATUS_IND = 159,
          EM_RRCE_HSPA_CONFIG_IND = 160,   /* MOLY00100048, Jack Chu,  EM_RRCE_HSPA_CONFIG_IND == 160 */
          EM_RRCE_RLF_IND = 161,  /* __ALPS02506878_SUPPORT__ */
          EM_RRCE_3G_CELL_UARFCN_DL_UL_INFO_IND = 162,
          URR_EM_INFO_END = EM_RRCE_3G_CELL_UARFCN_DL_UL_INFO_IND,

          /* LBS: 163 ~ 169 */
          EM_LBS_BEGIN = 163,
          EM_LBS_GPS_OPEN_STATISTIC = EM_LBS_BEGIN,
          EM_LBS_LR_STATISTIC = 164,
          EM_LBS_AP_SETTING = 165,
          EM_LBS_END = 169,

          /* __UL1_EM_MODE__ */
          UL1_EM_HS_DSCH_CONFIGURATION_INFO = 170, UL1_EM_INFO_BEGIN = UL1_EM_HS_DSCH_CONFIGURATION_INFO,
          UL1_EM_EDCH_CONFIGURATION_INFO = 171,
          UL1_EM_CPC_CONFIGURATION_INFO = 172,
          UL1_EM_SECONDARY_HS_CONFIGURATION_STATUS_INFO = 173,
          UL1_EM_PRIMARY_HS_DSCH_BLER_INFO = 174,
          UL1_EM_SECONDARY_HS_DSCH_BLER_INFO = 175,
          UL1_EM_EDCH_ACK_RATE_INFO = 176,   UL1_EM_INFO_END = UL1_EM_EDCH_ACK_RATE_INFO,  /* for backward compatibility */
          UL1_EM_PRX_DRX_MEASUREMENT_INFO = 177,
          /* HSDSCH info group  */
          UL1_EM_HSPA_INFO_GROUP = 178,
          UL1_EM_TAS_INFO = 179,
          UL1_EM_RADIO_LINK_SYNC_STATUS = 180,
          UL1_EM_UL1_RXD_STATUS = 181, /* already ported */
          UL1_EM_UL1_RAS_INFO = 182,
          UL1_EM_FS_UARFCN_INFO = 184,


          /* __UL2_EM_MODE__ */
          UL2_EM_ADM_POOL_STATUS_IND_STRUCT_INFO = 185, UL2_EM_INFO_BEGIN = UL2_EM_ADM_POOL_STATUS_IND_STRUCT_INFO,
          UL2_EM_PS_DATA_RATE_STATUS_IND_STRUCT_INFO = 186,
          UL2_EM_HSDSCH_RECONFIG_STATUS_IND_STRUCT_INFO = 187,
          UL2_EM_URLC_EVENT_STATUS_IND_STRUCT_INFO = 188,
          UL2_EM_3G_BLER_IND_STRUCT_INFO = 189,
          UL2_EM_WCDMA_RLC_STATS_STRUCT_INFO = 190,
          UL2_EM_URLC_LAYER_TPUT_INFO = 191,
          /* UMAC new EM Arch */
          /***HSUPA SI***/
          UL2_EM_HSUPA_SI_IND_STRUCT_INFO = 192,
          /***HSUPA SI***/

          /* UMAC EM 2015 */
          UL2_EM_UMAC_DCH_INFO = 193,
          UL2_EM_UMAC_EDCH_INFO = 194,
          UL2_EM_UMAC_HSDSCH_INFO = 195,
          UL2_EM_URLC_ATT_RLC_STATISTICS_INFO = 196,
          UL2_EM_URLC_ATT_RLC_RESET_INFO = 197,
          UL2_EM_UMAC_PCH_CRC_ERR_INFO = 198,
          UL2_EM_UMAC_PCH_INFO = 199,
          UL2_EM_UMAC_LCHID_TRCH_MAPPING_INFO = 200,
          UL2_EM_INFO_END = UL2_EM_UMAC_LCHID_TRCH_MAPPING_INFO,

          /*ERRC_EM_MODE, here is the start of errc em info definition*/
          ERRC_EM_MOB_MEAS_INTRARAT_INFO = 210, ERRC_EM_INFO_BEGIN = ERRC_EM_MOB_MEAS_INTRARAT_INFO,
          ERRC_EM_MOB_MEAS_INTERRAT_UTRAN_INFO = 211,
          ERRC_EM_MOB_MEAS_INTERRAT_GERAN_INFO = 212,
          ERRC_EM_AUTOS_CSG_INFO = 213,
          ERRC_EM_CARRS_EVENT_IND = 214,
          ERRC_EM_SIB_EVENT_IND = 215,
          ERRC_EM_MOB_EVENT_IND = 216,
          ERRC_EM_SEC_PARAM = 217,
          ERRC_EM_REEST_INFO = 218,
          ERRC_EM_RECONF_INFO = 219,
          ERRC_EM_RCM_SIM_STS_INFO = 220,
          ERRC_EM_SYS_SIB_RX_STS_INFO = 221,
          ERRC_EM_ERRC_STATE_IND = 222,
          ERRC_EM_OVER_PROC_DELAY_WARNING = 223,
          ERRC_EM_LTE_SUPPORTED_BAND_INFO = 224,
          ERRC_EM_ERRC_KPI_INFO = 225,
          ERRC_EM_ERRC_CONFIG_INFO = 226,

          ERRC_EM_CONN_INFO = 227,

          ERRC_EM_INFO_END = ERRC_EM_CONN_INFO,

          /* __ESM_EM_MODE__ */
          ESM_ESM_INFO = 228,
          ESM_L4C_ESM_INFO = 229,

          /* __EMM_EM_MODE__*/
          EMM_EM_SEC_INFO = 230, EMM_EM_INFO_BEGIN = EMM_EM_SEC_INFO,
          EMM_EM_PLMNSEL_INFO = 231,
          EMM_EM_CONN_INFO = 232,
          EMM_EM_NASMSG_INFO = 233,
          EMM_EM_CALL_INFO = 234,
          EMM_EM_REG_ATTACH_INFO = 235,
          EMM_EM_REG_DETACH_INFO = 236,
          EMM_EM_REG_TAU_INFO = 237,
          EMM_EM_REG_COMMON_INFO = 238,
          EMM_EM_SV_INFO = 239,
          EMM_EM_RATBAND_INFO = 240,
          EMM_EM_TIMERSRV_INFO = 241,
          EMM_EM_USIMSRV_INFO = 242,
          EMM_EM_NVMSRV_INFO = 243,
          EMM_EM_INFO_END = EMM_EM_NVMSRV_INFO,

          EMM_L4C_EMM_INFO = 244,

          EM_EL2_OV_STATUS = 245,
          EM_EL1_OV_STATUS = 246,
          EM_QBM_STATUS = 247,
          EM_UPCM_STATUS = 248,

          /* EL1 */
          EM_EL1_INFO = 249,

          EM_CSR_STATUS_IND = 250,

          RAC_EM_INFO = 251,

          /* EL2 public status */
          EM_EL2_PUB_STATUS = 252,

          EMM_L4C_LAI_CHANGE_INFO = 253,

          /*RATCM*/
          RATCM_EM_23G_RAT_CHANGE_IND = 254, RATCM_EM_INFO_BEGIN = RATCM_EM_23G_RAT_CHANGE_IND,

          EM_EL1_B3B39_INFO = 255,

          RATCM_EM_INFO_END = RATCM_EM_INFO_BEGIN + 20,

          /* L4C */
          EM_L4C_RAT_CHANGE_IND = 275,

          /* EMAC RACH */
          EM_EMAC_RACH_TRIGGER = 276,
          EM_EMAC_RACH_FINISH = 277,
          EM_EMAC_MSG2_REPORT = 278,
          EM_EMAC_MSG4_REPORT = 279,

          /* EMAC 500MS */
          EM_EMAC_OV_STATUS_500 = 280,

          /* EMAC TIMER EXPIRE */
          EM_EMAC_TIMER_EXPIRE = 281,

          EM_L4C_MDMI_RAT_INFO_IND = 282,

          /* EMAC CONFIG REPORT */
          EM_EMAC_CONFIG_REPORT = 283,

          /* MD EVENT INFO */
          EM_L4C_MD_EVENT_INFO = 284,

         /*EMAC RACH for Innowireless EM*/
          EM_EMAC_RACH_SUCCESS = 285,
          EM_EMAC_RACH_FAILURE = 286,

          /* EMAC EMBMS */
          EM_EMAC_EMBMS_REPORT = 287,

          /* EMAC DL TBS REPORT */
          EM_EMAC_DL_TBS_REPORT = 288,

          /* EMM CSFB status */
          EMM_L4C_CSFB_INFO = 289,

          /* EL1 CIQ for ATT*/
          EM_EL1_CIQ_RLF_STATUS_INFO        = 290, EM_EL1_CIQ_INFO_BEGIN = EM_EL1_CIQ_RLF_STATUS_INFO,
          EM_EL1_CIQ_PUSCH_INFO             = 291,
          EM_EL1_CIQ_INFO_END               = EM_EL1_CIQ_INFO_BEGIN + 10,

          /* L4C EM to report ECSQ params */
          EM_L4C_ECSQ_IND = 301,

          /* IPCORE */
          IPC_EM_UL_THROTTLE_STATUS = 326,

          /*ERRC_EM_MODE, here is the start of errc em info definition of Range 2*/
          ERRC_EM_SERV_IR_NEIGHBOR_INFO = 327, ERRC_EM_INFO_BEGIN_R2 = ERRC_EM_SERV_IR_NEIGHBOR_INFO,
          ERRC_EM_IR_REDIR_EVENT = 328,
          ERRC_EM_IRAT_MEAS_CFG = 329,
          ERRC_EM_MOB_MEAS_CONFIG_INFO_IND = 330,
          ERRC_EM_MOB_MEAS_REPORT_INFO_IND = 331,
          ERRC_EM_MOB_MEAS_INTERRAT_C2K_INFO = 332,
          ERRC_EM_LTE_RRC_STATE_IND = 333,
          ERRC_EM_SERVING_INFO = 334,
          ERRC_EM_PAGING_FAIL = 335,
          ERRC_EM_RLF_EVENT = 336,
          ERRC_EM_TIMER_EXPIRY_EVENT = 337,
          ERRC_EM_HO_EVENT = 338,
          ERRC_EM_ERRC_SYS_MIB_SIB_READEVENT_INFO = 339,
          ERRC_EM_SRVCC_BSIC_INFO = 340,
          ERRC_EM_MFROM_INFO = 341,
          ERRC_EM_FEATURE_DETECTION = 342,
          ERRC_EM_SEARCHING_STATE = 343,
          ERRC_EM_CA_INFO = 344,
          ERRC_EM_EUTRA_RRC_MESSAGE_S = 345,
          ERRC_EM_EUTRA_RRC_MESSAGE_M = 346,
          ERRC_EM_EUTRA_RRC_MESSAGE_L = 347,
          ERRC_EM_LTE_BAND_TIME = 348,
          ERRC_EM_REEST_BY_L2 = 349,
          ERRC_EM_EL1_CONFIG_INFO = 350,
          ERRC_EM_SRVCC_CELL_INFO = 351,
          ERRC_EM_SRVCC_HO_FAIL_EVENT =352,
          ERRC_EM_OOS_EVENT = 353,
          ERRC_EM_CELL_BLACK_LIST_EVENT = 354,
          ERRC_EM_INFO_END_R2 = ERRC_EM_CELL_BLACK_LIST_EVENT,
          ERRC_EM_INFO_END_RESERVED = ERRC_EM_INFO_BEGIN_R2 + 30,

          /* UPCM */
          EM_UPCM_PS_TPUT_INFO = 358,

          MM_EM_MTC_TIMER_INFO = 359,
          MM_EM_LU_INFO = 360,
          MM_EM_RAU_INFO = 361,

          /* USIME capability */
          USIME_EM_INFO_CAPABILITY = 362, USIME_EM_INFO_BEGIN = USIME_EM_INFO_CAPABILITY,
          USIME_EM_INFO_END = USIME_EM_INFO_BEGIN + 30,

          MM_EM_MT_CSFB_INFO = 393,
          MM_EM_REG_REJ_INFO = 394,        // LU, Attach, RAU reject info
          MM_EM_AUTH_REJ_INFO = 395,       // Auth reject info for MM/GMM
          MM_EM_AS_FAIL_INFO = 396,        // AS fail info during REG proc

          /* EL2 feature detection */
          EM_EL2_FEATURE_DETECTION = 397,

          MM_EM_CSFB_STATUS = 398,         // CSFB START /SUCCESSFUL /FAIL
          MM_EM_MTCS_MTCSFB_STATUS = 399,  //MTCS MT CSFB FAILURES

          /* FDD URR common Range 2, the range should be 400 ~ 599 */
          /* FDD CSCE Range 2 */
          FDD_CSCE_EM_INFO_BEGIN_R2 = 400, FDD_URR_EM_INFO_BEGIN_R2 = FDD_CSCE_EM_INFO_BEGIN_R2,
          FDD_CSCE_EM_INFO_END_R2 = 449,
          /* FDD RRCE Range 2 */
          FDD_RRCE_EM_INFO_BEGIN_R2 = 450,
          FDD_RRCE_EM_INFO_END_R2 = 499,
          /* FDD MEME Range 2 */
          EM_FDD_MEME_INFO_DCH_UMTS_CELL_INFO = 500, FDD_MEME_EM_INFO_BEGIN_R2 = EM_FDD_MEME_INFO_DCH_UMTS_CELL_INFO,
          EM_FDD_MEME_INFO_DCH_GSM_CELL_INFO = 501,
          EM_FDD_MEME_INFO_DCH_LTE_CELL_INFO = 502,
          EM_FDD_MEME_INFO_DCH_H_SERVING_CELL_INFO = 503,
          EM_FDD_MEME_INFO_DCH_3G_BLER_INFO = 504,
          EM_FDD_MEME_INFO_FACH_LTE_CELL_INFO = 505,
          EM_FDD_MEME_INFO_EVENT_TYPE_3_PARAMETER_INFO = 506,        // For NVIOT EM MeasCtrl E3x
          EM_FDD_MEME_INFO_REPORT_INFO = 507,                        // For NVIOT EM MEasRpt E3x
          FDD_MEME_EM_INFO_END_R2 = 549,

          /* FDD SLCE Range 2 */
          FDD_SLCE_EM_INFO_BEGIN_R2 = 550,
          FDD_SLCE_EM_INFO_END_R2 = 559,

          /* FDD SIBE Range 2 */
          FDD_SIBE_EM_INFO_BEGIN_R2 = 560,
          FDD_SIBE_EM_INFO_END_R2 = 569,

          /* for other FDD URR modules, 569 ~ 599 */

          FDD_URR_EM_INFO_END_R2 = 599,


          /* VDM */
          EM_VDM_CALL_INFO_IND = 601,

          /* IMC */
          IMC_EM_IPSEC_INFO_IND = 602, IMC_EM_INFO_BEGIN = IMC_EM_IPSEC_INFO_IND,
          IMC_EM_IMC_INFO_IND = 603,
          IMC_EM_BEARER_INFO_IND = 604,
          IMC_EM_REG_INFO_IND = 605,
          IMC_EM_SMS_INFO_IND = 606,
          IMC_EM_CALL_INFO_IND = 607,
          IMC_EM_CONF_INFO_IND = 608,
          IMC_EM_SRVCC_INFO_IND = 609,
          IMC_EM_PCSCF_INFO_IND = 610,
          IMC_EM_MEDIA_INFO_IND = 611,
          IMC_EM_CALL_DROP_IND = 613,
          IMC_EM_INFO_END = IMC_EM_INFO_BEGIN + 20,

          /* __EMM_EM_MODE__ Range 2, the range should be 625 ~ 629*/
          EMM_EM_REG_EVENT_INFO = 625, EMM_EM_INFO_RANGE_2_BEGIN = EMM_EM_REG_EVENT_INFO,
          EMM_EM_TIMER_EXPIRY_INFO = 626,
          EMM_EM_EMM_STATE_INFO = 627,
          EMM_EM_SEC_EVENT_INFO = 628,
          EMM_EM_TIMERSRV_TIMER_START_INFO = 629,
          EMM_EM_INFO_RANGE_2_END = EMM_EM_TIMERSRV_TIMER_START_INFO,

          EM_SPEECH_INFO_BEGIN = 630,  EM_SPEECH_INFO_SPH_CODEC = EM_SPEECH_INFO_BEGIN,
          EM_SPEECH_INFO_END = 649,

          /* NWSEL */
          NWSEL_EM_TIMER_INFO = 650,
          NWSEL_EM_INFO_BEGIN = NWSEL_EM_TIMER_INFO,
          NWSEL_EM_PLMN_LIST_REQ_INFO = 651,
          NWSEL_EM_PLMN_LIST_CNF_INFO = 652,
          NWSEL_EM_PLMN_SEARCH_REQ_INFO = 653,
          NWSEL_EM_HPLMN_INFO_INFO = 654,
          NWSEL_EM_OPLMN_INFO_INFO = 655,
          NWSEL_EM_STATIC_APPLMN_INFO = 656,
          NWSEL_EM_DYNAMIC_APPLMN_INFO = 657,
          NWSEL_EM_EUTRAN_DISABLE_INFO = 658,
          NWSEL_EM_INFO_END = NWSEL_EM_INFO_BEGIN+30,

          /* Abnormal event for smart logging phase2 */
          /* Naming format: EM_ABNORMAL_EVENT_(MOD)_(NAME) */
          EM_ABNORMAL_EVENT_RAC_NO_SERVICE = 681,

          /* LTECSR */
          LTECSR_EM_RTP_CODEC = 682,
          LTECSR_EM_RTP_PACKET_LOSS = 683,
          LTECSR_EM_RTP_ONE_WAY_DELAY = 684,
          LTECSR_EM_RTP_JITTER = 685,
          LTECSR_EM_RTP_JITTER_BUFFER_DELAY = 686,
          LTECSR_EM_RTP_OTA_MSG = 687,
          LTECSR_EM_SESSION_STAT = 688,
          LTECSR_EM_XMIT_PKT = 689,
          LTECSR_EM_RECV_PKT = 690,
          LTECSR_EM_XMIT_STAT = 691,
          LTECSR_EM_RECV_STAT = 692,
          LTECSR_EM_RTP_INFO = 693,
          LTECSR_EM_RTCP_INFO = 694,
          LTECSR_EM_RTP_EVENT = 695,

          /* LPP 696 ~699 */
          LPP_EM_MSG_STATUS_STATISTICS = 696,
          LPP_EM_MSG_INFO = 697,
          LPP_EM_INFO_END = 699,

          /* TDD URR common Range 2, the range should be 700 ~ 899
             before put TDD URR EM enum below, please make sure relative function already consider the enum range,
             e.g. TDD_RRC_HandleEmUpdateReq() should cover enum 700 ~ 899. */
          TDD_URR_EM_INFO_BEGIN_R2 = 700,
          TDD_URR_EM_INFO_END_R2 = 749,

          /* C2K: 750 ~ 899 */
          EM_C2K_INFO_BEGIN = 750,

          /* C2K EVDO L1 750~769 */
          EM_EVL1_INFO_BEGIN = EM_C2K_INFO_BEGIN,
          EM_EVL1_GENERAL_INFO = EM_EVL1_INFO_BEGIN,
          EM_EVL1_TXAGC_POWER_INFO = 751,
          EM_EVL1_CELL_SWITCH_INFO = 752,
          EM_EVL1_RXAGC_INFO = 753,
          EM_EVL1_AFC_INFO = 754,
          EM_EVL1_MBP_SECTOR_INFO = 755,
          EM_EVL1_FMP_FINGER_INFO = 756,
          EM_EVL1_TIMING_TRACK_STATUS = 757,
          EM_EVL1_SCH_STATUS = 758,
          EM_EVL1_ACC_DATA_RATE_INFO = 759,
          EM_EVL1_TRAFFIC_RRI_VALUE_INFO = 760,
          EM_EVL1_FMP_SECTOR_INFO = 761,
          EM_EVL1_SCH_PILOT_UPDATE_INFO = 762,
          EM_EVL1_SCH_RESULT_INFO = 763,
          EM_EVL1_INFO_END = EM_EVL1_INFO_BEGIN + 19,

          /* XL1: 770 ~ 789 */
          EM_XL1_INFO_BEGIN = 770,
          EM_XL1_STATUS_INFO = EM_XL1_INFO_BEGIN,
          EM_XL1_MEAS_INFO = 771,
          EM_XL1_MAIN_RXAGC_INFO = 772,
          EM_XL1_DIV_RXAGC_INFO = 773,
          EM_XL1_RAKE_INFO = 774,
          EM_XL1_CRC_INFO = 775,
          EM_XL1_TX_PATH_INFO = 776,
          EM_XL1_TX_AGC_INFO = 777,
          EM_XL1_AFC_INFO = 778,
          EM_XL1_MMAFC_INIT_FOE_INFO = 779,
          EM_XL1_TAS_INFO = 780,
          EM_XL1_TIMING_LOOP_INFO = 781,
          EM_XL1_INFO_END = EM_XL1_INFO_BEGIN + 19,

          /* HSC: 790 ~ 809 */
          EM_C2K_HSC_INFO_BEGIN = 790,
          EM_C2K_RTBA_CHANNEL_STATUS_INFO = EM_C2K_HSC_INFO_BEGIN,
          EM_C2K_DO_SPAGE_STATE_INFO = 791,
          EM_C2K_HSC_MPA_STATUS_INFO = 792,
          EM_C2K_LL1A_STATE_MODE_INFO = 793,
          EM_C2K_LL1A_STANDBY_GAP_INFO = 794,
          EM_C2K_LL1A_ACTIVE_GAP_INFO = 795,
          EM_C2K_HSC_INFO_END = EM_C2K_HSC_INFO_BEGIN + 19,

          /* XL3: 810 ~ 824 */
          EM_XL3_INFO_BEGIN = 810,
          EM_XL3_CP_STATUS = EM_XL3_INFO_BEGIN,
          EM_XL3_SLOTTED_MODE_INFO = 811,
          EM_XL3_CP_EVENTS = 812,
          EM_1XRTT_CALL_EVENTS = 813,
          EM_C2K_RSVAS_INFO = 814,
          EM_XL3_PAGING_INFO = 815,
          EM_XL3_SET_INFO = 816,
          EM_XL3_SYSTEM_SEARCH_INFO = 817,
          EM_XL3_CALL_FAIL_REASON = 818,
          EM_XL3_INFO_END = EM_XL3_INFO_BEGIN + 14,

          /* EVL3: 825 ~ 839 */
          EM_EVL3_INFO_BEGIN = 825,
          EM_EVL3_STATE = EM_EVL3_INFO_BEGIN,
          EM_EVL3_SERVING_CELL_INFO = 826,
          EM_EVL3_SLOTTED_MODE_INFO = 827,
          EM_EVL3_ACCESS_PROCEDURE_INFO = 828,
          EM_EVL3_CP_EVENTS = 829,
          EM_EVL3_SYSTEM_SEARCH_INFO = 830,
          EM_EVL3_INFO_END = EM_EVL3_INFO_BEGIN + 14,

          /* EVL2: 840~849 */
          EM_EVL2_INFO_BEGIN = 840,
          EM_EVL2_FWD_CHANNEL_INFO = EM_EVL2_INFO_BEGIN,
          EM_EVL2_REV_TRAFFIC_INFO = 841,
          EM_EVL2_ACCESS_STATE_INFO = 842,
          EM_EVL2_RTM3_T2P_INFO = 843,
          EM_EVL2_INFO_END = EM_EVL2_INFO_BEGIN + 9,

          /* XL2 :850~859*/
          EM_XL2_INFO_BEGIN = 850,
          EM_XL2_REV_STATE  = EM_XL2_INFO_BEGIN,
          EM_XL2_ACH_PROBE_INFO = 851,
          EM_XL2_VOICE_RATE_INFO = 852,
          EM_XL2_RLP_INFO = 853,
          EM_XL2_PS_RATE_INFO = 854,
          EM_XL2_SCH_ASSIGNED_RATE = 855,
          EM_XL2_INFO_END = EM_XL2_INFO_BEGIN + 9,

          /* C2K HLP: 860 ~ 879*/
          EM_C2K_HLP_INFO_BEGIN = 860,
          EM_C2K_HLP_TIMER_STATUS = EM_C2K_HLP_INFO_BEGIN,
          EM_C2K_HLP_CAM_STATE = 861,
          EM_C2K_HLP_NSPE_STATE = 862,
          EM_C2K_HLP_PDN_STATUS = 863,
          EM_C2K_HLP_PPPHA_STATUS = 864,
          EM_C2K_HLP_PPP_STATUS = 865,
          EM_C2K_HLP_RM_BUFQ_INFO = 866,
          EM_C2K_HLP_UM_BUFQ_INFO = 867,
          EM_C2K_HLP_PACKET_INFO = 868,
          EM_C2K_HLP_ABNORMAL_EVENT_INFO = 869,
          EM_C2K_HLP_INFO_END = EM_C2K_HLP_INFO_BEGIN + 19,

          /* C2K_L4(CVAL): 880 ~ 899 */
          EM_C2K_L4_INFO_BEGIN = 880,
          EM_C2K_L4_RTT_RADIO_INFO = EM_C2K_L4_INFO_BEGIN,
          EM_C2K_L4_RTT_INFO = 881,
          EM_C2K_L4_RTT_SCH_INFO = 882,
          EM_C2K_L4_RTT_STAT_INFO = 883,
          EM_C2K_L4_RTT_SERVING_NEIGHBR_SET_INFO = 884,
          EM_C2K_L4_EVDO_SERVING_INFO = 885,
          EM_C2K_L4_EVDO_ACTIVE_SET_INFO = 886,
          EM_C2K_L4_EVDO_CAND_SET_INFO = 887,
          EM_C2K_L4_EVDO_NGHDR_SET_INFO = 888,
          EM_C2K_L4_EVDO_FL_INFO = 889,
          EM_C2K_L4_EVDO_RL_INFO = 890,
          EM_C2K_L4_EVDO_STATE_INFO = 891,
          EM_C2K_L4_SPRINT_XRTT_INFO = 892,
          EM_C2K_L4_SPRINT_EVDO_INFO = 893,
          EM_C2K_L4_INFO_END = 899,
          EM_C2K_INFO_END = EM_C2K_L4_INFO_END,

          /* GMSS: 900 ~ 919 */
          GMSS_EM_INFO_BEGIN = 900,
          GMSS_EM_WORLD_PHONE_INFO = GMSS_EM_INFO_BEGIN,
          GMSS_EM_INFO_END = GMSS_EM_WORLD_PHONE_INFO+19,

          /* EL1 MDMI for VzW*/
          EM_EL1_STATUS_CSR_RPT_INFO        = 921, EM_EL1_MDMI_INFO_BEGIN = EM_EL1_STATUS_CSR_RPT_INFO,
          EM_EL1_STATUS_SRV_MEAS_RPT_INFO   = 922,
          EM_EL1_STATUS_PBCH_RPT_INFO       = 923,
          EM_EL1_STATUS_PCFICH_RPT_INFO     = 924,
          EM_EL1_STATUS_PDCCH_RPT_INFO      = 925,
          EM_EL1_STATUS_PDSCH_RPT_INFO      = 926,
          EM_EL1_STATUS_PHICH_RPT_INFO      = 927,
          EM_EL1_STATUS_PMCH_RPT_INFO       = 928,
          EM_EL1_STATUS_DCI_RPT_INFO        = 929,
          EM_EL1_STATUS_PUCCH_RPT_INFO      = 930,
          EM_EL1_STATUS_PUCCH_CSI_RPT_INFO  = 931,
          EM_EL1_STATUS_PUSCH_RPT_INFO      = 932,
          EM_EL1_STATUS_PUSCH_CSI_RPT_INFO  = 933,
          EM_EL1_STATUS_SRS_RPT_INFO        = 934,
          EM_EL1_STATUS_CELLTIME_RPT_INFO   = 935,
          EM_EL1_STATUS_SR_CFG_INFO         = 936,
          EM_EL1_STATUS_PRACH_INFO          = 937,
          EM_EL1_STATUS_RACH_INFO           = 938,
          EM_EL1_STATUS_PCH_INFO            = 939,
          EM_EL1_STATUS_TA_INFO             = 940,
          EM_EL1_STATUS_PHR_INFO            = 941,
          EM_EL1_STATUS_DL_TPUT_INFO        = 942,
          EM_EL1_STATUS_UL_TPUT_INFO        = 943,
          EM_EL1_STATUS_CSR_INFO            = 944,
          EM_EL1_MDMI_INFO_END              = EM_EL1_MDMI_INFO_BEGIN + 25,

          /* EPDCP */
          EM_EPDCP_DATA_INACTV_IND = 947,

          /* GL1: 950 ~ 959 */
          GL1_EM_TAS_INFO = 950,
          GL1_EM_RXD_INFO = 951,

          /* TDD L1 */
          TDD_EM_L1_TAS_INFO = 960, TDD_EM_L1_INFO_BEGIN = TDD_EM_L1_TAS_INFO,
          TDD_EM_L1_INFO_END = TDD_EM_L1_TAS_INFO + 4,

          EMM_L4C_REJECT_INFO = 965,
          EMM_L4C_TIMER_INFO = 966,
          EMM_L4C_CALL_INFO = 967,

          /*EL1*/
          EM_EL1_STATUS_PDSCH_INFO = 970,

          RAC_EM_NETWORK_TYPE_INFO = 971,

          /* ERLC */
          EM_ERLC_DATA_STALL = 972,

          /* LTECSR Range 2, the range should be 975 ~ 979 */
          LTECSR_EM_RTP_PERIODIC_RPT = 975,

       /*================C2K_XCAL start====================*/
         /* C2K XCAL related EMs, maximum 30 EMs supported. */
         EM_C2K_XCAL_INFO_BEGIN = 980,
         EM_C2K_XCAL_OTA_EVENT_INFO = EM_C2K_XCAL_INFO_BEGIN,
         EM_C2K_XCAL_OTA_FDSCH_INFO = 981,
         EM_C2K_XCAL_OTA_RDSCH_INFO = 982,
         /* New C2K EMs should be added before  EM_C2K_XCAL_INFO_LAST, */
         EM_C2K_XCAL_INFO_LAST = EM_C2K_XCAL_OTA_RDSCH_INFO,
         EM_C2K_XCAL_INFO_END = EM_C2K_XCAL_INFO_BEGIN + 29,
         /*================C2K_XCAL end====================*/

          /* D2/DDM: 1016-1023 */
          EM_DDM_INFO_BEGIN = 1016,
          EM_DDM_W2LHO_EVENT_INFO = EM_DDM_INFO_BEGIN,
          EM_DDM_L2WHO_EVENT_INFO = 1017,
          EM_DDM_IP_INFO = 1020,
          EM_DDM_LAST_ERROR_CODE_INFO = 1021,
          EM_DDM_INFO_END = EM_DDM_INFO_BEGIN + 7, /* 1023 */

   NUM_OF_EM_INFO,
   INVALID_EM_INFO = 0x7fffffff //end tag force this enum 4 bytes, for alignment purpose. Don't remove
   /*
    * MP branches: please add "EM type id" in em_info_enum.h.
    * Please remember to modify MD_COMMON\EM\em_info_enum.h for main TRUNK ex: LR11/LR12/UMOLY/UMOLYA
    */
} em_info_enum;

typedef enum
{
    EM_TX_ANT_L_ANT    = 0, // L_ANT
    EM_TX_ANT_U_ANT    = 1, // U_ANT
    EM_TX_ANT_L_ANT_A  = 2, // L_ANT'
    EM_TX_ANT_INVALID  = 0xFF
} em_tx_ant_enum;


typedef enum
{
    EM_TAS_VERSION_1_0     = 0,
    EM_TAS_VERSION_2_0     = 1,
    EM_TAS_VERSION_INVALID = 0xFF
} em_tas_version_enum;


typedef struct
{
    /* PWR info */
    kal_int16  prach_tx_power_ave;
    kal_int16  pucch_tx_power_ave;
    kal_int16  pusch_tx_power_ave;
    kal_int16  srs_tx_power_ave;

    /* Tx report */
    kal_int16  tm;
    kal_int16  phr;
    kal_int16  ta;

    /* UL info */
    kal_uint32 UL_Tput;
    kal_int16  UL_Imcs;
    kal_int16  UL_rb;
    kal_int16  UL_block;
    kal_int16  UL_bler;
    kal_uint16 UL_retx_rate;

   /* TAS info */
    kal_int16   tx_ant;
    kal_int8   UL_Mod;

    /*RJIL requirement*/
    kal_uint8   srs_bw_ave;
    kal_int16   pucch_tx_power_ave_fmt[9]; //0:FMT1 1:FMT1A 2:FMT1B 3:FMT2 4:FMT2_extCP 5:FMT2A 6:FMT2B 7:FMT3 8:FMT1B_CS
    kal_bool    hop_en;
    kal_int8    puschPrb0;
    kal_int8    puschPrb1;

    /*Power scaling*/
    kal_int16  pucch_tx_pwr;
    kal_int16  pucch_tx_pwr_out;
    kal_int16  pusch_tx_pwr;
    kal_int16  pusch_tx_pwr_out;
    kal_int16  ul_ca_pucch_tx_pwr_out;
    kal_int16  ul_ca_pusch_tx_pwr_out;

    /* TAS Info */
    em_tx_ant_enum  tx_ant_type;
    kal_int16       rsrp_l_ant;      // L_ANT: -255: disable, -140 ~ 18 (dBm)
    kal_int16       rsrp_u_ant;      // U_ANT: -255: disable, -140 ~ 18 (dBm)
    kal_int16       rsrp_l_ant_a;    // L_ANT' -255: disable, -140 ~ 18 (dBm)
    kal_int16       tx_power;        // -50...33
    kal_int16       el1_dat_scenario_index;

    kal_uint16  ul_grant_cnt;
    kal_uint16  cqi_req_cnt;
    kal_int16   total_tx_power_ave;

    /* PUCCH format statistics */
    kal_uint16  pucch_f1_cnt;       // Standalone SR count
    kal_uint16  pucch_f1a_cnt;      // Probable SR + 1 bit HARQ count
    kal_uint16  pucch_f1b_cnt;      // Probable SR + 2 bit HARQ count
    kal_uint16  pucch_f2_cnt;       // Standalone CSI over PUCCH count
    kal_uint16  pucch_f2a_cnt;      // CSI + 1 bit HARQ count
    kal_uint16  pucch_f2b_cnt;      // CSI + 2 bit HARQ count
    kal_uint16  pucch_f2_ecp_cnt;   // CSI with extended CP
    kal_uint16  pucch_f3_cnt;       // Format 3 count
    kal_uint16  pucch_f1b_cs_cnt;   // Format 1b with CS count
    kal_uint16  pucch_sr_cnt;       // Overall SR count

    /* TITAN Info */
    kal_int16   curr_fi;
    kal_int16   curr_gi;
    kal_int16   num_tpc_fi;
    kal_int16   num_tpc_gi;
    kal_int16   avg_ul_retx;

    /* TAS Info */ // This is request by OPPO
    kal_uint8   tas_status;         // TAS status: 0: disable/ 1: enable
    kal_uint8   force_tx_ant;       // TAS force tx ant status: 0: disable/ 1: enable
    kal_uint8   force_tx_idx;       // TAS force tx ann index: 0~7 according to antenna state

    kal_int16   pcmax;
} em_el1_ul_status_struct;

typedef struct
{
    /* DL Qual indicator */
    kal_int16  dl_rssi[2]; // -255: disable, -140 ~ 18 (dBm)
    kal_int16  dl_rsrp[2]; // -255: disable, -140 ~ 18 (dBm)
    kal_int16  dl_rsrq[2]; //
    kal_int16  dl_sinr[2];
    kal_int16  rsrp;
    kal_int16  rsrq;
    kal_int16  sinr;
    kal_int16  rsSNR;

    /* Rx report */
    kal_int16  tm;
    kal_int16  cqi_cw0;
    kal_int16  cqi_cw1;
    kal_int16  ri;

    /* DL info */
    kal_uint32 DL_Tput;
    kal_uint32 DL_Tput_cw0;
    kal_uint32 DL_Tput_cw1;
    kal_int16  DL_Imcs;
    kal_int16  DL_rb;
    kal_int16  DL_block;
    kal_int16  DL_bler;
    kal_int8  DL_Mod0;
    kal_int8  DL_Mod1;

    /* MCH info */
    kal_uint32 MCH_Tput;
    kal_int16  MCH_block;
    kal_int16  MCH_bler;

    // PDSCH info
    kal_uint16 pdsch_tc_rnti;
    kal_uint16 pdsch_c_rnti;
    kal_uint16 pdsch_sps_rnti;
    kal_uint16 pdsch_avg_tbs;
    kal_uint16 dl_grant_cnt;
    kal_int8   dl_carrier_idx;
    kal_int8   dl_mcs0;
    kal_int8   dl_mcs1;
    kal_int8   dl_pmi0;
    kal_int8   dl_pmi1;  // Not used in 90 as well. Can be used to differentiate 1CW and 2CW scenario in future.

    // PDCCH info
    kal_int8   pdcch_dci;
    kal_uint16 pdcch_agg_lv[4];
    kal_uint16 pdcch_sps_rnti;
    kal_uint16 pdcch_ra_rnti;
    kal_uint16 tpc_pucch_rnti;
    kal_uint16 tpc_pusch_rnti;
    kal_uint16 pdcch_p_rnti;
    kal_uint16 pdcch_si_rnti;

    // For 93 KPI
    kal_int16  kpi_DL_bler[2];

    //For 91 Titan request
    kal_int16  avg_dl_grant;
    kal_int16  dl_sm_ratio;

    /* MCH info */
    kal_int16  MCH_sf_skip_cnt;

    /* DL Qual indicator */
    kal_int16  sir;

    /* DL tb Number*/
    kal_uint8   DL_TB;

    /* rxpath_sum for RSRP/RSRQ/SNR as Mohamed' request */
    kal_int16    rsrp_l1_rxpath_sum_dBm;     /*rx0 + rx1  RSRP dBm*/
    kal_int16    rsrq_l1_rxpath_sum_dB;      /*rx0 + rx1  RSRQ dB*/
    kal_int16    snr_l1_rxpath_sum_dB;       /*rx0 + rx1  SNR dB*/

    // For LG
    kal_int16  DL_bler_harq[15];
    kal_int16  DL_rb_tb1;
    kal_int16  DL_rb_tb2;

    kal_uint8  rsrq_decimal;
    // For AT&T
    kal_uint16 DL_Mod_time[4];
} em_el1_dl_status_struct;

typedef struct
{
    /* TPC info */
    kal_uint8 pa_mode[RPT_LTE_TX_CC_MAX];
    kal_uint8 pa_idx[RPT_LTE_TX_CC_MAX];
    kal_int16 pa_gain[RPT_LTE_TX_CC_MAX];
    kal_uint8 temper_idx[RPT_LTE_TX_CC_MAX];  //temperature idx
    kal_int16 temper_comp[RPT_LTE_TX_CC_MAX]; //temperature compensation power for PA
    kal_int16 cmeas_rf[RPT_LTE_TX_CC_MAX];    //close loop compensation
    kal_int16 ppa_dbm[RPT_LTE_TX_CC_MAX];     //DDPC report(antenna power)

    /* RF info */
    kal_int16 rf_gain_absolute[RPT_LTE_RX_CC_MAX][AGC_RX_ANT_NUM];

    /* Power info */
    kal_int16  mpr[RPT_LTE_TX_CC_MAX];
    kal_int16  a_mpr[RPT_LTE_TX_CC_MAX];
    kal_int16  p_cmax[RPT_LTE_TX_CC_MAX];
    kal_int16 main_ant_sar[RPT_LTE_TX_CC_MAX]; // S(9,7)
    kal_int16 div_ant_sar[RPT_LTE_TX_CC_MAX];  // S(9,7)

    kal_int16 bb_gain[RPT_LTE_TX_CC_MAX];
    kal_int16 rf_gain[RPT_LTE_TX_CC_MAX];     //PGA gain
    kal_uint8 dc2dc_lvl[RPT_LTE_TX_CC_MAX];   //VP
} em_el1_tpc_rf_status_struct;

typedef struct
{
    /* DL info */
    kal_int16  DL_block;
    kal_int16  DL_nack_cnt;
    kal_int16  DL_bler;
    kal_uint8  fail_rate_ind;
} em_el1_dl_pdsch_status_struct;

typedef struct
{
    kal_uint16                         phyCellId;
    kal_uint32                         earfcn;        /* [0..262143], 65535 is invalid to indicate ARFCN-ValueEUTRA-v9a0 present */
    kal_int64                          rstd_microsec;
}em_el1_mpc_otdoa_measured_nbr_cell_em_struct;


typedef struct
{
    kal_uint8                           numMeasuredNbrCell;
    em_el1_mpc_otdoa_measured_nbr_cell_em_struct  measuredNbrCell[EM_OTDOA_MAX_NBR_CELL_LIST_NUM_TOTAL];
} em_el1_mpc_otdoa_struct;

typedef struct
{
    /* cell info */
    kal_uint8  band;
    kal_uint8  ant_port;
    kal_uint8  dl_bw;       // 100kHz
    kal_uint8  ul_bw;       // 100kHz
    kal_uint8  tdd_cfg;     // TDD: 0~6, FDD: 0xFF
    kal_uint8  sp_cfg;      // TDD: 0~9, FDD: 0xFF
    kal_uint8  tm;          // 0,1~9
    kal_int8   ul_cc_idx;   //-1,0~(ul_cc_max-1)
    kal_int16  pci;         // 0~503
    EARFCN     earfcn;
    EARFCN     ul_earfcn;
    kal_uint16 dlFreq;      // 100kHz
    kal_uint16 ulFreq;      // 100kHz
    kal_bool   enable_64qam;
    kal_uint8  ue_category;
    kal_uint8  sr_period;   //ms
    kal_uint8  main_ant_swap; // Main Antenna swap information
    kal_uint8  rx_antenna_config;
    kal_uint8  rx_div_status;
    em_el1_mpc_otdoa_struct otdoa_info;
    kal_uint8  dl_bw_rb;
    kal_uint8  ul_bw_rb;
    kal_uint32 dl_max_throughput;
    kal_uint32 ul_max_throughput;
} em_el1_cell_info_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum            em_info;
    kal_uint8               dl_cc_count;
    kal_uint8               ul_cc_count;
    em_el1_cell_info_struct cell_info[RPT_LTE_RX_CC_MAX];
    em_el1_dl_status_struct dl_info[RPT_LTE_RX_CC_MAX];
    em_el1_ul_status_struct ul_info[RPT_LTE_TX_CC_MAX];
    em_tas_version_enum     tas_version;
    em_el1_tpc_rf_status_struct tpc_rf_info;
} em_el1_status_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum            em_info;
    em_el1_dl_pdsch_status_struct dl_info[RPT_LTE_RX_CC_MAX];
} em_el1_status_pdsch_ind_struct;


typedef enum
{
    EM_CRC_FAIL                 = 0,
    EM_CRC_PASS                 = 1
} em_dl_crc_enum;

typedef enum
{
    EM_FDD                      = 0,
    EM_TDD                      = 1
} em_duplex_enum;

typedef enum
{
    EM_COMMON_SPACE             = 0,
    EM_UE_SPECIFIC_SPACE        = 1
} em_dci_srch_space;

typedef enum
{
    EM_PCC                      = 0,
    EM_SCC1                     = 1,
    EM_SCC2                     = 2
} em_carrier_idx_enum;

typedef enum
{
    EM_Bandwidth_1_4            = 1,
    EM_Bandwidth_3              = 2,
    EM_Bandwidth_5              = 3,
    EM_Bandwidth_10             = 4,
    EM_Bandwidth_15             = 5,
    EM_Bandwidth_20             = 6
} em_BandWidth_enum;

typedef enum
{
    EM_CCE_AGG_LV1              = 0,
    EM_CCE_AGG_LV2              = 1,
    EM_CCE_AGG_LV4              = 2,
    EM_CCE_AGG_LV8              = 3
} em_cce_agg_lv_enum;

typedef enum
{
    EM_PDCCH_FMT0               = 0,
    EM_PDCCH_FMT1               = 1,
    EM_PDCCH_FMT1A              = 2,
    EM_PDCCH_FMT1B              = 3,
    EM_PDCCH_FMT1C              = 4,
    EM_PDCCH_FMT1D              = 5,
    EM_PDCCH_FMT2               = 6,
    EM_PDCCH_FMT2A              = 7,
    EM_PDCCH_FMT2B              = 8,
    EM_PDCCH_FMT2C              = 9,
    EM_PDCCH_FMT2D              = 10,
    EM_PDCCH_FMT3               = 11,
    EM_PDCCH_FMT3A              = 12,
    EM_PDCCH_FMT4               = 13,
    EM_PDCCH_INVALID            = 255
} em_pdcch_fmt_enum;

typedef enum
{
    EM_DCI_FMT0                 = 0,
    EM_DCI_FMT1                 = 1,
    EM_DCI_FMT1A                = 2,
    EM_DCI_FMT1B                = 3,
    EM_DCI_FMT1C                = 4,
    EM_DCI_FMT1D                = 5,
    EM_DCI_FMT2                 = 6,
    EM_DCI_FMT2A                = 7,
    EM_DCI_FMT3                 = 8,
    EM_DCI_FMT3A                = 9
} em_dci_fmt_enum;

typedef enum
{
    EM_dciSuc                   = 1,
    EM_dciErr                   = 2
} em_dci_stat_enum;

typedef enum
{
    EM_PHICH_NACK               = 0,
    EM_PHICH_ACK                = 1
} em_phich_val_enum;

typedef enum
{
    EM_PUCCH_FMT1               = 0,
    EM_PUCCH_FMT1A              = 1,
    EM_PUCCH_FMT1B              = 2,
    EM_PUCCH_FMT2               = 3,
    EM_PUCCH_FMT2A              = 4,
    EM_PUCCH_FMT2B              = 5
} em_pucch_fmt_enum;

typedef enum
{
    EM_DL_TM_MODE_DISABLED      = 0,
    EM_DL_TM_MODE_1             = 1,
    EM_DL_TM_MODE_2             = 2,
    EM_DL_TM_MODE_3             = 3,
    EM_DL_TM_MODE_4             = 4,
    EM_DL_TM_MODE_5             = 5,
    EM_DL_TM_MODE_6             = 6,
    EM_DL_TM_MODE_7             = 7,
    EM_DL_TM_MODE_8             = 8,
    EM_DL_TM_MODE_9             = 9,
    EM_DL_TM_MODE_10            = 10,
    EM_DL_TM_MODE_INVALID       = 255
} em_dl_tm_mode_enum;

typedef enum
{
    EM_mode10                   = 0,
    EM_mode11                   = 1,
    EM_mode20                   = 2,
    EM_mode21                   = 3
} em_pucch_rpt_mode_enum;

typedef enum
{
    EM_subBandCqiFeedback       = 0,
    EM_wideBandCqiPmiFeedback   = 1,
    EM_riFeedback               = 2,
    EM_widebandCqiFeedback      = 3
} em_pucch_rpt_type_enum;

typedef enum
{
    EM_UL_BPSK                  = 0,
    EM_UL_QPSK                  = 1,
    EM_UL_QAM16                 = 2,
    EM_UL_QAM64                 = 3
} em_pusch_mcs_enum;

typedef enum
{
    EM_FREQ_HOP_DISABLED        = 0,
    EM_FREQ_HOP_INTER_SF        = 1,
    EM_FREQ_HOP_INTRA_INTER_SF  = 2,
    EM_FREQ_HOP_INVALID         = 255
} em_pusch_freq_hop_enum;

typedef enum
{
    EM_semiPersistent           = 0,
    EM_dynamic                  = 1,
    EM_rachMsg3                 = 2
} em_pusch_type_enum;

typedef enum
{
    EM_modeAperiodicRm12        = 0,
    EM_modeAperiodicRm20        = 1,
    EM_modeAperiodicRm22        = 2,
    EM_modeAperiodicRm30        = 3,
    EM_modeAperiodicRm31        = 4
} em_pusch_rpt_mode_enum;

typedef enum
{
    EM_NoSrs                    = 0,
    EM_UpPtsSymbol0             = 1,
    EM_UpPtsSymbol1             = 2,
    EM_BothUpPtsSymbols         = 3
} em_srs_uppts_enum;

typedef enum
{
    EM_SRS_Type0                = 0,
    EM_SRS_Type1Dci0            = 1,
    EM_SRS_Type1Dci1A2B2C       = 2,
    EM_SRS_Type1Dci4            = 3
} em_srs_trig_enum;

typedef enum
{
    EM_CYCLE_320                = 0,
    EM_CYCLE_640                = 1,
    EM_CYCLE_1280               = 2,
    EM_CYCLE_2560               = 3
} em_paging_cyc_enum;

typedef enum
{
    EM_fourT                    = 0,
    EM_twoT                     = 1,
    EM_oneT                     = 2,
    EM_one2T                    = 3,
    EM_one4T                    = 4,
    EM_one8T                    = 5,
    EM_one16T                   = 6,
    EM_one32T                   = 7
} em_drx_nb_enum;

typedef enum
{
    EM_T310_STOP                = 0,
    EM_T310_START               = 1,
    EM_T310_EXPIRE              = 2,
    EM_T310_INVALID             = 255
} em_t310_status_enum;



typedef enum
{
    EM_DL_QPSK                  = 0,
    EM_DL_QAM16                 = 1,
    EM_DL_QAM64                 = 2,
    EM_DL_QAM256                = 3,
    EM_DL_INVALID               = 255
} em_dl_mod_enum;


typedef struct
{
    kal_bool                        tbEn;
    kal_uint8                       Imcs;
    em_dl_mod_enum                  mcs;
    kal_uint8                       rv;
    kal_uint8                       ndi;
    kal_uint8                       tbIndex;
    kal_uint32                      tbsize;
    kal_uint8                       dupPacket;
    kal_bool                        harqComb;
    //pdsch 3
    em_dl_crc_enum                  tbCrc;
    kal_uint16                      cbCrc;
    kal_uint8                       cw_idx;
    kal_uint8                       reRxNum;                        // 1~8
    kal_uint16                      cbSizePlus;                     // 0~6168
    kal_uint8                       numCbPlus;                      // 0~13
    kal_uint8                       turboDecMaxIterNum;
    kal_uint8                       turboDecIterNum;
    kal_bool                        earlyEndAlgm;
} em_PdschTb_struct;

typedef struct
{
    kal_uint8                       numRBs;      //pdsch 1,2
    kal_uint8                       numLayers;   //pdsch 2
    kal_uint8                       numTBs;      //pdsch 2
    kal_uint8                       harqId;      //pdsch 1,3
    em_dl_rnti_enum                 rntiType;
    kal_uint16                      rntiValue;
    em_PdschTb_struct               PdschTb[2];
} em_PdschRlt_struct;

typedef struct
{
    kal_uint16                      SFN;
    kal_uint8                       subframe;
    kal_uint16                      pci;

    kal_uint8                       cc_idx;//pdsch 3
    kal_uint8                       ueCat;//pdsch 3
    kal_uint8                       tranMode;//pdsch 3
    kal_uint8                       mimoRi;                     // num of tb
    kal_uint8                       pmchId;                     // 0~255
    kal_uint8                       areaId;                     // 0~255
    em_PdschRlt_struct              PdschRlt[5];
} el1_em_PdschRpt_struct;

typedef struct
{
    kal_uint16                      SFN;
    kal_uint8                       subframe;
    kal_uint16                      pci;
    kal_uint8                       cc_idx;
    kal_uint8                       ulDlCfg;                        // 0~6:TDD
    //ltePhyPdcch 1
    em_dl_rnti_enum                 rntiType[9];
    em_cce_agg_lv_enum              cceAggLv[9];
    kal_bool                        newDl[9];
    em_dci_srch_space               srchSpace[9];                   // 0: common, 1: ue-specific
    kal_uint16                      payloadSize[9];                 // pi/si/ra/c,tc,sps
    kal_uint8                       spsType;                        // 1:rel, 2:acv, 3:cfg, 4:retx
    //ltePhyPdcch 2
    kal_uint8                       numDlTbs[9];                    // 0~3, number of DL TBs
    //ltePhyPdcch 3
    em_pdcch_fmt_enum               dciFormat[9];
    kal_uint8                       strtCce[9];                     // 0~86
    kal_bool                        dciStatus[9];
} el1_em_PdcchRpt_struct;

typedef struct
{
    //ltePhyPhich 1, 3
    kal_bool                        phichEn;
    em_phich_val_enum               phichRlt;
    //ltePhyPhich 3
    kal_uint8                       spreadCode;                     // 0~7
    kal_uint8                       groupNum;                       // 0~31
} em_PhichRlt_struct;

typedef struct
{
    kal_uint16                      SFN;
    kal_uint8                       subframe;
    kal_uint16                      pci;
    em_carrier_idx_enum             cc_idx;
    kal_uint8                       ulDlCfg;                        //0~6:TDD
    em_PhichRlt_struct              phichRlt0;
    em_PhichRlt_struct              phichRlt1;
} el1_em_PhichRpt_struct;

typedef struct
{
    kal_uint16                      SFN;
    kal_uint8                       subframe;
    kal_uint16                      pci;
    em_pdcch_fmt_enum               dciFormat[9];
    em_pucch_fmt_enum               txFormat;
    kal_uint8                       numAck;                         //0~2, number of Harq bits
    kal_bool                        csiEn[RPT_LTE_RX_CC_MAX];
    kal_uint8                       numCqi[RPT_LTE_RX_CC_MAX];
    kal_int8                        pucchTpc[9];
    kal_int16                       gi;
    kal_uint8                       digitalGain;                    //0~255, PUCCH digital amplitude gain in dB
    kal_int8                        txPower;
    kal_int8                        ActualTxPower;
    kal_uint8                       pathLoss;
    kal_uint8                       startRbSlot0;                   //0~110
    kal_uint8                       startRbSlot1;                   //0~110
    kal_uint8                       dmrsSeqSlot0;                   //0~29
    kal_uint8                       dmrsSeqSlot1;                   //0~29
} em_el1_PucchRpt_struct;

typedef struct
{
    kal_bool                        csiEn;
    kal_uint8                       cc_idx;
    em_dl_tm_mode_enum              csiTxMode;
    em_pucch_rpt_mode_enum          csiRptMode;
    em_pucch_rpt_type_enum          csiRptType;
    //kal_uint8                       numCqi;
    kal_uint8                       bpSize;                         //0~4
    kal_uint8                       bpIndex;                        //0~4
    kal_uint8                       sbNum;
    kal_uint8                       ri;
    kal_uint8                       cqiCw0;
    kal_uint8                       cqiCw1;
    kal_uint8                       wbPmi;
} em_pucchCsiRpt_struct;

typedef struct
{
    kal_uint16                      SFN;
    kal_uint8                       subframe;

    em_pucchCsiRpt_struct           csiRpt[RPT_LTE_RX_CC_MAX];
} em_el1_PucchCsiRpt_struct;

typedef struct
{
    kal_uint16                      SFN;
    kal_uint8                       subframe;
    kal_uint16                      pci;
    em_pdcch_fmt_enum               dciFormat;                      // DCI format of the decoded PDCCH
    kal_int8                        puschTpc;
    em_pusch_type_enum              puschType;
    kal_int16                       fi;
    kal_uint8                       digitalGain;                    //0~255, PUSCH digital amplitude gain in dB
    kal_int8                        txPower;
    kal_int8                        ActualTxPower;
    kal_uint8                       pathLoss;
    kal_uint8                       rbNum;
    em_pusch_mcs_enum               ModOrd;
    kal_uint8                       harqId;
    kal_uint16                      tbSize;
    kal_uint8                       retxIndex;                      //1~8, HARQ retransmission number
    em_pusch_freq_hop_enum          freqHop;
    //kal_bool                        ackExists;
    kal_uint8                       numAck;                         //0~7, length of ACK NACK bit
    //kal_bool                        cqiExists[RPT_LTE_RX_CC_MAX];
    kal_bool                        csiEn[RPT_LTE_RX_CC_MAX];
    kal_uint8                       numCqi[RPT_LTE_RX_CC_MAX];      //0~66, length of CQI bit
    //kal_bool                        riExists[RPT_LTE_RX_CC_MAX];
    kal_uint8                       numRi[RPT_LTE_RX_CC_MAX];       //0~3, length of RI bit
    kal_uint8                       startRbSlot0;                   //0~110
    kal_uint8                       startRbSlot1;                   //0~110
    kal_uint8                       dmrsSeqSlot0;                   //0~29
    kal_uint8                       dmrsSeqSlot1;                   //0~29
} em_el1_PuschRpt_struct;

typedef struct
{
    kal_bool                        csiEn;
    kal_uint8                       cc_idx;
    em_dl_tm_mode_enum              csiTxMode;
    em_pusch_rpt_mode_enum          csiRptMode;
    kal_uint8                       sbNum;
    kal_uint8                       ri;
    kal_uint8                       wbCqiCw0;
    kal_uint8                       wbCqiCw1;
    kal_uint8                       sizeM;
    kal_uint8                       snglWbPmi;
    kal_uint8                       snglMbPmi;
    kal_uint8                       sbCqiCw0[13];
    kal_uint8                       sbCqiCw1[13];
    kal_uint8                       mSbCqiCw0;
    kal_uint8                       mSbCqiCw1;
    kal_uint8                       sbSize;
} em_puschCsiRpt_struct;

typedef struct
{
    kal_uint16                      SFN;
    kal_uint8                       subframe;

    em_puschCsiRpt_struct           csiRpt[RPT_LTE_RX_CC_MAX];
} em_el1_PuschCsiRpt_struct;

typedef struct
{
    kal_uint16                      SFN;
    kal_uint8                       subframe;
    kal_uint16                      pci;
    em_carrier_idx_enum             cc_idx;
    kal_uint8                       cfi;
} em_el1_PcfichRpt_struct;

typedef struct
{
    kal_uint16                      SFN;
    kal_uint8                       subframe;
    kal_uint16                      pci;
    em_carrier_idx_enum             cc_idx;
    kal_uint8                       pmchId;
    kal_uint8                       areaId;
    //kal_uint8                       numOfRB;
    kal_uint8                       numRBs;
    kal_uint8                       numLayers;
    kal_uint8                       harqId;
    kal_uint8                       rv;
    kal_uint8                       ndi;
    em_dl_crc_enum                  crcRlt;
    em_dl_rnti_enum                 rntiType;
    kal_uint8                       tbIndex;
    kal_uint16                      tbSize;                         // bytes
    kal_uint8                       Imcs;                           // 0~31
    //kal_uint8                       numRBs;                         // 0~255 // TBD
} em_el1_PmchRpt_struct;

typedef struct
{
    kal_uint16                      strtSFN;
    kal_uint8                       strtSubframe;
    kal_uint32                      strtDlFrameTimeOffst;           // 0~307200, Ts units
    kal_uint32                      strtUlFrameTimeOffst;           // 0~307200, Ts units
    kal_uint32                      strtUlTimeAdv;                  // 0~307200, Ts units

    kal_int16                       dlFrameTimeChng;                // -512~511
    kal_int8                        ulFrameTimeChng;                //  -16~15
    kal_int8                        timeAdvChng;                    // -128~127
} em_el1_CellTime_struct;

typedef struct
{
    kal_uint16                      SFN;
    kal_uint8                       subframe;
    kal_uint16                      pci;
    kal_int16                       rsrp;                           // -180~-30
    kal_int16                       rsrp0;
    kal_int16                       rsrp1;
    kal_int16                       rsrq;                           //  -30~ 10
    kal_int16                       rsrq0;
    kal_int16                       rsrq1;
    kal_int16                       rssi;                           // -110~-10
    kal_int16                       rssi0;
    kal_int16                       rssi1;
    kal_int16                       sinr;                           //  -20~ 30
    kal_int16                       sinr0;
    kal_int16                       sinr1;
    EARFCN                          earfcn;
    kal_uint8                       priority;                       // 0~7, The priority of the layer that the cell resides on
    kal_bool                        isIdleMode;
    em_BandWidth_enum               Bandwidth;
    em_carrier_idx_enum             CarrierType;
} em_el1_SrvMeasRpt_struct;

#if 0
typedef struct
{
    kal_uint16                      sysFrameNumber;
    kal_uint8                       subFrameNumber;
    kal_uint8                       TranMode;
} em_el1_TranMode_struct;

typedef struct
{
    kal_uint16                      sysFrameNumber;
    kal_uint8                       subFrameNumber;
    kal_uint8                       mcs;                            // 0~31
} em_el1_McsValue_struct;
#endif


typedef struct
{
    kal_bool                        ueSrsEn;
    kal_bool                        cellSrsEn;
    kal_uint8                       strtRb;
    kal_uint8                       numRb;
    kal_uint16                      zcRoot;                         // 1~1151
    em_srs_uppts_enum               upPtsType;
    //em_srs_trig_enum                srsTrigType;
} em_srsTxParam_struct;

typedef struct
{
    kal_uint16                      SFN;
    kal_uint8                       subframe;
    kal_uint16                      pci;
    em_carrier_idx_enum             carrierType;
    em_duplex_enum                  duplexMode[RPT_LTE_RX_CC_MAX];
    //ltePhyMeasurements 15
    kal_int8                        srsTxPower;
    kal_int16                       fi;
    kal_uint8                       pathLoss;
    kal_uint8                       srsTxBw;
    kal_int8                        srsActualTxPower;
    //ltePhyMeasurements 16
    em_srs_trig_enum                srsTrigType;
    kal_uint8                       cycShift;
    kal_int8                        srsPwrOffst;                 // 0:p-srs,    1:a-srs
    em_srsTxParam_struct            srsTxParam[2];                  // 0:symbol 1, 1:symbol 2
} em_el1_SrsRpt_struct;

typedef struct
{
    kal_uint8                       mcsIndex;
    kal_uint8                       cqiRequest;
    kal_uint8                       startRB[2];
    kal_uint8                       numRB[2];
    kal_uint8                       tbSizeIndex;
    kal_uint8                       modType;
    kal_bool                        freqHop;                        // 0: disable, 1: enable
    kal_uint8                       ndi;
    kal_uint8                       rv;
    kal_int8                        tpcCmd;
    kal_uint8                       dmrsCycShift;
    kal_uint8                       timeToTx;
} ul_grant_struct;

typedef struct
{
    kal_uint16                      pci;
    em_pdcch_fmt_enum               dlAssgnFmt[7];
    kal_uint8                       numAck[7];                      // 0~2
    kal_int8                        tpcCmd[7];
} dl_assgn_struct;

typedef struct
{
    em_duplex_enum                  duplexMode[RPT_LTE_RX_CC_MAX];

    kal_uint16                      SFN;
    kal_uint8                       subframe;

    kal_bool                        pdcchOrderVld[RPT_LTE_TX_CC_MAX];

    kal_bool                        ulGrantVld[RPT_LTE_TX_CC_MAX];
    ul_grant_struct                 ulGrantInfo[RPT_LTE_TX_CC_MAX];

    kal_bool                        tpcVld;
    em_pdcch_fmt_enum               tpcFmt[2];                      // 0: tpc-pucch, 1: tpc-pusch

    kal_bool                        dlAssgnVld[RPT_LTE_RX_CC_MAX];                  // 2cc
    dl_assgn_struct                 dlAssgnInfo[RPT_LTE_RX_CC_MAX];                 // 2/tc/spsc -rnti
} em_el1_DciRpt_struct;

typedef struct
{
    kal_uint16                      SFN;
    kal_uint8                       subframe;
    //PSS result
    kal_int16                       pssQualLev;
    kal_uint16                      pssPeakPos;                     // 0~10000
    kal_uint8                       pssIndex;                       // 0~2
    //SSS result
    kal_uint16                      pci;
    kal_int16                       sssQualLev;
    kal_uint16                      sssFrameBoundary;
    kal_uint16                      sssCp;
} em_el1_CsrRpt_struct;

typedef struct
{
    kal_uint16                      SFN;
    kal_uint8                       subframe;
    kal_uint16                      pci;
    EARFCN                          earfcn;
    kal_uint8                       dlBw;
    kal_uint16                      payloadSize;
    kal_uint16                      decSFN;
    em_dl_crc_enum                  crcRlt;
    kal_uint8                       numAnt;
    kal_uint8                       txAntCfg;
    kal_uint16                      sfnOffst;
    kal_uint16                      freqOffst;                      // TBD
    kal_uint16                      tx0Rx0Cir;                      // TBD
} em_el1_PbchRpt_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    //lteMacKpis 7
    kal_uint16                      SFN;
    kal_uint8                       subframe;
    kal_uint8                       srPeriod;
} em_el1_status_sr_cfg_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    //ltePhyPrach 1
    kal_uint16                      SFN;
    kal_uint8                       subframe;
    kal_int16                       rachTxPwr;
    kal_uint16                      zadOffSeq;                      //0~837, ZadOFF Sequence Number
    kal_uint8                       prachCfg;
    kal_uint8                       preambleFmt;
    em_duplex_enum                  duplexType;
    kal_uint8                       maxTxMsg3;
    kal_uint8                       rarWinSize;
    kal_bool                        rachRlt;
} em_el1_status_prach_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    //ltePhyMeasurements 5
    kal_uint16                      SFN;
    kal_uint8                       subframe;
    kal_uint32                      dlTputVal;
    kal_uint32                      dlTputCw0;
    kal_uint32                      dlTputCw1;
} em_el1_status_dl_tput_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    //ltePhyMeasurements 6
    kal_uint16                      SFN;
    kal_uint8                       subframe;
    kal_uint32                      ulTputVal;
} em_el1_status_ul_tput_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    el1_em_PdcchRpt_struct          PdcchRpt[LTE_MAX_DATA_BUF];
    kal_uint16                      PdcchRpt_num;
    kal_uint16                      Pdcch_num;
} em_el1_status_pdcch_rpt_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    //ltePhyPdsch 1
    el1_em_PdschRpt_struct          PdschRpt[LTE_MAX_DATA_BUF];
    kal_uint16                      PdschRpt_num;
    kal_uint16                      Pdsch_num;
} em_el1_status_pdsch_rpt_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    //ltePhyPhich 1,3
    el1_em_PhichRpt_struct          PhichRpt[LTE_MAX_DATA_BUF];
    kal_uint16                      PhichRpt_num;
} em_el1_status_phich_rpt_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    //ltePhyMeasurements 10, 11
    em_el1_CsrRpt_struct            CsrRlt[LTE_MAX_DATA_BUF];
    kal_uint8                       CsrRlt_num;
} em_el1_status_csr_rpt_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    em_info;

    //Carrier search information
    EARFCN                          csr_earfcn;
    kal_uint8                       csr_band;
} em_el1_status_csr_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    //ltePhyMeasurements 1
    em_el1_SrvMeasRpt_struct        SrvMeasRpt[LTE_MAX_DATA_BUF];
    kal_int8                        SrvMeasRpt_num;
} em_el1_status_srv_meas_rpt_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    //ltePhyPucch 1,3
    em_el1_PucchRpt_struct          PucchRpt[LTE_MAX_DATA_BUF];
    kal_uint8                       PucchRpt_num;
} em_el1_status_pucch_rpt_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    //ltePhyPucch 4
    em_el1_PucchCsiRpt_struct       PucchCsiRpt[LTE_MAX_DATA_BUF];
    kal_uint8                       PucchCsiRpt_num;
} em_el1_status_pucch_csi_rpt_ind_struct;



typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    //ltePhyPusch 1,3
    em_el1_PuschRpt_struct          PuschRpt[LTE_MAX_DATA_BUF];
    kal_uint8                       PuschRpt_num;
} em_el1_status_pusch_rpt_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    //ltePhyPusch 4
    em_el1_PuschCsiRpt_struct       PuschCsiRpt[LTE_MAX_DATA_BUF];
    kal_uint8                       PuschCsiRpt_num;
} em_el1_status_pusch_csi_rpt_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    //ltePhyMeasurements 17
    em_el1_DciRpt_struct            DciRpt[LTE_MAX_DATA_BUF];
    kal_uint8                       DciRpt_num;
} em_el1_status_dci_rpt_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    //ltePhyPmch 3
    em_el1_PmchRpt_struct           PmchRpt[LTE_MAX_DATA_BUF];
    kal_uint8                       PmchRpt_num;
} em_el1_status_pmch_rpt_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    //ltePhyMeasurements 15, 16
    em_el1_SrsRpt_struct            SrsRpt[LTE_MAX_DATA_BUF];
    kal_uint8                       SrsRpt_num;
} em_el1_status_srs_rpt_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    //ltePhyDebug 1
    kal_uint16                      SFN;
    kal_uint8                       subframe;
    kal_uint32                      strtDlFrmeTimeOffst;            // 0~307200, Ts units
    kal_uint32                      strtUlFrameTimeOffst;           // 0~307200, Ts units
    kal_uint32                      strtUlTimeAdv;                  // 0~307200, Ts units
    kal_int16                       dlFrameTimeChng;                // -512~511
    kal_int16                       ulFrameTimeChng;                //  -16~15
    kal_int8                        timeAdvChng;                    // -128~127
} em_el1_status_celltime_rpt_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    //ltePhyPcfich 3
    em_el1_PcfichRpt_struct         PcfichRpt[LTE_MAX_DATA_BUF];
    kal_uint8                       PcfichRpt_num;
} em_el1_status_pcfich_rpt_ind_struct;

typedef struct
{
    kal_uint8                       sequence;                       //    0~63, Preamble sequence index
    kal_int8                        prachTxPower;                   // -112~23, PRACH tx power
    kal_uint8                       duplexMode;
} el1_em_msg1_rpt_struct;

typedef struct
{
    kal_uint8                       mcs;
    kal_uint8                       modType;
    kal_uint8                       startRb;
    kal_uint8                       numRb;
    kal_uint8                       tbSizeIndex;
} el1_em_msg3_rpt_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    kal_uint16                      SFN;
    kal_uint8                       subframe;

    kal_bool                        msg1_valid;
    el1_em_msg1_rpt_struct          msg1_rpt;
    kal_bool                        msg3_valid;
    el1_em_msg3_rpt_struct          msg3_rpt;
} em_el1_status_rach_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    em_el1_PbchRpt_struct           PbchRpt[LTE_MAX_DATA_BUF];
    kal_uint8                       PbchRpt_num;
} em_el1_status_pbch_rpt_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    EARFCN                          earfcn;
    kal_uint16                      pci;
    em_paging_cyc_enum              pagCyc;
    em_drx_nb_enum                  nb;
    kal_uint16                      ueId;                           // IMSI mod 1024
    kal_uint8                       drxFrameNumOffst;
    kal_uint8                       drxSubframeNum;
} em_el1_status_pch_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    //ltePhyMeasurements 7
    kal_uint16                      SFN;
    kal_uint8                       subframe;
    kal_int16                       ta_value;
} em_el1_status_ta_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    mdmi_info;

    //ltePhyMeasurements 8
    kal_uint16                      SFN;
    kal_uint8                       subframe;
    kal_int8                        phr_value;                      // -23~40
} em_el1_status_phr_ind_struct;

// CIQ
typedef struct
{
    kal_bool                        wb_rpt_valid;
    kal_uint8                       sb_rpt_num;
    kal_uint16                      wb_cqi_dist[16];
    kal_uint16                      sb_cqi_dist[4][16];
    kal_uint16                      ri_dist[5];
    kal_uint16                      pmi_dist[16];
} el1_em_csi_rpt_struct;



typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    ciq_info;
    kal_uint32              trig_time;
    //LT13 - E-UTRA Radio Link Sync Status
    em_t310_status_enum             t310_status;
} em_el1_ciq_rlf_status_ind_struct;

typedef struct
{
    LOCAL_PARA_HDR
    em_info_enum                    ciq_info;
    kal_uint32              trig_time;

    //LT12 - E-UTRA PUSCH Transmission Status
    kal_int16                       total_pwr;
    kal_int16                       perRB_pwr;
    kal_uint16                      count_pwr;
    //CSI info
    //TBD
    el1_em_csi_rpt_struct       csi_rpt;
} em_el1_ciq_pusch_ind_struct;




#endif /* _EM_EL1_PUBLIC_STRUCT_H */
