#include "lynq_common.h"
#include <liblog/lynq_deflog.h>
#include <sys/time.h>
#include "Phone_utils.h"
#undef LOG_TAG
#define LOG_TAG "LYNQ_COMMON"
void set_timer(int it_interval_sec, int it_interval_usec,int it_value_sec,int it_value_usec)
{
    struct itimerval itv, oldtv;
    itv.it_interval.tv_sec = it_interval_sec;
    itv.it_interval.tv_usec = it_interval_usec;
    itv.it_value.tv_sec = it_value_sec;
    itv.it_value.tv_usec = it_value_usec;
    setitimer(ITIMER_REAL, &itv, &oldtv);
}
 
int sleep_with_restart(int second) {
    int left = second;
    while (left > 0) 
    { 
       left = sleep(left);
    }
    return 0;
}
int millli_sleep_with_restart(int millisecond)
{
    int left = millisecond*1000;
    while (left > 0) 
    { 
        left = usleep(left);
    }

    return 0;
}
 int lynqNoneParame(const char *requestStr){
    char *argv[MAX_LEN];
    int32_t token;
    char *mRequestStr=new char[MAX_LEN];
    strcpy(mRequestStr, requestStr);
    argv[0] = mRequestStr;
    token=android::getRequestData(argv, 1);
    delete mRequestStr;
    return token;
}

int lynqIntParame(const char *requestStr,int parame){
    char *argv[MAX_LEN];
    char indexStr[MAX_QUEST_LEN] = {0};
    char *mRequestStr=new char[MAX_LEN];
    strcpy(mRequestStr, requestStr);
    sprintf(indexStr, "%d", parame);
    LYINFLOG("lynqIntParame,indexStr:%s,parame:%d\n", indexStr,parame);
    argv[0] = mRequestStr;
    argv[1] = indexStr;
    return  android::getRequestData(argv, 2);
}

int lynqStringParame(const char *requestStr,const char *parameString){
    char *mRequestStr=new char[MAX_LEN];
    char *mParameString=new char[MAX_LEN];
    char *argv[MAX_LEN];
    strcpy(mRequestStr, requestStr);
    strcpy(mParameString, parameString);
    argv[0] = mRequestStr;
    argv[1] = mParameString;
    return  android::getRequestData(argv, 2);

}
int triggerRequest(int request)
{
    int32_t token;
    switch (request)
    {
        case RIL_REQUEST_GET_SIM_STATUS:
        {
            token = lynqNoneParame("RIL_REQUEST_GET_SIM_STATUS");
            break;
        }
    }
    return 0;
}
int advanceCheckError(RIL_Errno err)
{
    RIL_Errno tempe = 0;
    RIL_CardState cardState =0;
    Service_State serviceState= 0;
    RIL_SOCKET_ID soc_id = (RIL_SOCKET_ID)Phone_utils::get_enable_sim_for_dsss();
    switch(err)
    {
        case RIL_E_GENERIC_FAILURE:
        {
            cardState = getSimState(soc_id);
            switch(cardState)
            {
                case 0:
                {
                    tempe = RIL_E_SIM_ABSENT;
                    return tempe;
                    //break;
                }
                case 2:
                {
                    tempe = LYNQ_E_CARDSTATE_ERROR;
                    return tempe;
                    //break;
                }
                default:
                    break;
            }
            serviceState = get_reg_voice_service_state(RIL_REQUEST_VOICE_REGISTRATION_STATE, soc_id);
            switch(serviceState)
            {
                case 1:
                {
                    tempe = LYNQ_E_STATE_OUT_OF_SERVICE;
                    return tempe;
                    //break;
                }
                case 2:
                {
                    tempe = LYNQ_E_STATE_EMERGENCY_ONLY;
                    return tempe;
                    //break;
                }
                case 3:
                {
                    tempe = LYNQ_E_STATE_POWER_OFF;
                    return tempe;
                    //break;
                }
                default:
                    break;
            }
            tempe = err;
            break;
        }
        default:
            tempe = err;
            break;
    }
    LYDBGLOG("[advanceCheckError] temp error is %d\n",tempe);
    return tempe;
}
int strUpper(char * str)
{
    int i=0;
    while(1)
    {
        if(str[i]=='\0')
        {
            break;
        }
        if(str[i]>='a'&&str[i]<='z')
        {
             //printf("str %c\n",str[i]-32);
             str[i]=str[i]-32;
        }
        i++;
    }
    return 0;
}
lynqQueue *commonFindParcelmsg(const int32_t token,const int time,RIL_Errno&e)
{
    int timeCount = time;
    int num=0;
    lynqQueue *node = NULL;
    lynqQueue *temp =NULL;
    while(timeCount--)
    {
         millli_sleep_with_restart(10);
         temp=LynqQueueHead;
         if(temp==NULL)
         {
             LYDBGLOG("Queue head is NULL, maybe malloc fail!\n");
             continue;
         }
         node = searchTokeninQueue(token, temp);
         if(node ==NULL)
         {
             LYDBGLOG("can not find token %x\n",token);
             e=-1;
             return NULL;
         }
         if(node->t_Errno!=RIL_E_SUCCESS)
         {
             LYDBGLOG("get fail, the error code is %d\n",node->t_Errno);
             e = advanceCheckError(node->t_Errno);
             //e=node->t_Errno;
             return NULL;
         }
         else
         {
            node->parcel.setDataPosition(0);
            if (node->parcel.dataAvail() > 0) 
            {
                e=node->t_Errno;
                //pNode=node;
                return node;
             }
             else
             {
               continue;
             }
         }
    }
    //printf("timeCount is %d\n",timeCount);
    if(timeCount<0)
    {
        LYDBGLOG("time out,can not find message!\n");
        e=LYNQ_E_TIME_OUT;
    }
    return NULL;

}
lynqQueue *commonUpdateEstatus(const int32_t token,const int time,RIL_Errno&e)
{
    int timeCount = time;
    int num=0;
    lynqQueue *node = NULL;
    lynqQueue *temp =NULL;
    while(timeCount--)
    {
         millli_sleep_with_restart(10);
         temp=LynqQueueHead;
         if(temp==NULL)
         {
             LYDBGLOG("Queue head is NULL, maybe malloc fail!\n");
             continue;
         }
         node = searchTokeninQueue(token, temp);
         if(node ==NULL)
         {
             RLOGD("can not find token %x\n",token);
             e=-1;
             return NULL;
         }
         if(node->t_Errno!=RIL_E_SUCCESS)
         {
             LYDBGLOG("get fail, the error code is %d\n",node->t_Errno);
             e = advanceCheckError(node->t_Errno);
             //e=node->t_Errno;
             return node;
         }
         else
         {
            if (node->E_status==1) 
            {
                e=node->t_Errno;
                return node;
            }
            else
            {
               continue;
            }
         }
    }
    //printf("timeCount is %d\n",timeCount);
    if(timeCount<0)
    {
        LYDBGLOG("time out,can not find message!\n");
        e=LYNQ_E_TIME_OUT;
    }
    return NULL;
}