#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <strings.h>
#include <unistd.h>
#include "liblog/liblog.h"
#include "liblog/lynq_deflog.h"

#define USER_LOG_TAG "TCPSER"
#define SA struct sockaddr
#define BUF_LEN 128
#define ERR_SOCK  3

int main(int argc, const char *argv[])
{
	int sockfd,confd;
	char buf[BUF_LEN];
	int ret_recv;
	int ret_bind;

	LYLOGEINIT(USER_LOG_TAG);    
	sockfd=socket(AF_INET,SOCK_STREAM,0);

	if(sockfd<0)
	{
		LYDBGLOG("fail to socket\n");
		return ERR_SOCK;
	}
	struct sockaddr_in seraddr;
	seraddr.sin_family=AF_INET;
	seraddr.sin_port=htons(50000);
	seraddr.sin_addr.s_addr=inet_addr("0.0.0.0");

	ret_bind=bind(sockfd,(SA *)&seraddr,sizeof(seraddr));
	if(ret_bind<0)
	{
		LYDBGLOG("fail to bind\n");
		return ERR_SOCK;
	}

	listen(sockfd,5);

	while(1)
	{
		confd=accept(sockfd,NULL,NULL);
		//printf("confd =%d\n",confd);
		if(confd<0)
		{
			LYDBGLOG("fail to accept\n");
			return ERR_SOCK;
		}

		while(1)
		{
			bzero(buf,sizeof(buf));

			ret_recv=recv(confd,buf,sizeof(buf),0);
			
			if(ret_recv<0)
			{
				LYDBGLOG("fail to recv\n");
				return ERR_SOCK;
			}
			if(ret_recv==0)
			{
				close(confd);
				LYDBGLOG("closed,confd =%d\n",confd);
				break;
			}
			
			LYVERBLOG("+[tcpser]: ser_rcv = %s\n",buf);
			send(confd,buf,sizeof(buf),0);
		}
	
	}

	
	return 0;
}
