#include "model_manager.h"
#include <unistd.h>
#include <stdio.h>
#include <string.h>




MAG_LIST_S list_manager[] = {
	{"http", http_list_init, http_param_verification, http_list_locate, http_act_handler, NULL, NULL, NULL, NULL },
	{"ftp", ftp_list_init, ftp_param_verification, ftp_list_locate, ftp_act_handler, NULL, NULL, NULL},
	{"mqtt", mqtt_list_init, mqtt_param_verification, mqtt_list_locate, mqtt_act_handler, NULL, NULL, NULL,NULL},
	//{"ril", ril_list_init,ril_param_verification, ril_list_locate, ril_act_handler, NULL, NULL, NULL,NULL},
};


MAG_LIST_S *list_manager_proc(const char *name)
{
	int type_num = sizeof(list_manager) / sizeof(MAG_LIST_S);
	int i = 0;
	for (i = 0; i < type_num; i++)
	{
		if (0 == strcmp(list_manager[i].name, name))
		{
		    LYDBGLOG("[%s-%d] recognized message type is %s\n", __FUNCTION__, __LINE__, list_manager[i].name);
		    return &list_manager[i];
		}
	}
	LYDBGLOG("[%s-%d] Unrecognized message type %s\n", __FUNCTION__, __LINE__, name);
	
	return NULL;
}


