#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <strings.h>
#include "liblog/liblog.h"
#include "liblog/lynq_deflog.h"

#define USER_LOG_TAG "UDPSER"
#define BUF_LEN 128
#define ERR_SOCK  3
#define SA struct sockaddr

int main(int argc, const char *argv[])
{
	int sockfd;
	char buf[128];

	LYLOGEINIT(USER_LOG_TAG);    
	sockfd=socket(AF_INET,SOCK_DGRAM,0);

	if(sockfd<0)
	{
		LYDBGLOG("fail to sockfd\n");
		return -1;
	}
	
	struct sockaddr_in seraddr,peeraddr;
	seraddr.sin_family=AF_INET;
	seraddr.sin_port=htons(50000);

	seraddr.sin_addr.s_addr=inet_addr("0.0.0.0");

	int ret_bind;
	ret_bind=bind(sockfd,(struct sockaddr *)&seraddr,sizeof(seraddr));

	if(ret_bind<0)
	{
	   LYDBGLOG("fail to bind\n");
	   return -1;
	}

	int len=sizeof(peeraddr);

	while(1)
	{
		bzero(buf,sizeof(buf));

		recvfrom(sockfd,buf,sizeof(buf),0,(struct sockaddr*)&peeraddr,&len);

		LYVERBLOG("+[udpser]: ser_rcv = %s\n", buf);
		sendto(sockfd,buf,sizeof(buf),0,(SA *)&peeraddr,len);
	}
	return 0;
}
