/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <algorithm>
#include <iterator>
#include <stdexcept>

#include "rfdesense/RfDesenseTxTestCdma.h"
#include "rfdesense/RfDesenseTxTestBase.h"
#include "util/log_extra.h"
#include "em.h"

#undef LOG_TAG
#define LOG_TAG "EM_RfDesenseTxTestCdma"

const int RfDesenseTxTestCdma::INDEX_BAND = 0;
const int RfDesenseTxTestCdma::INDEX_CHANNEL = 1;
const int RfDesenseTxTestCdma::INDEX_POWER = 2;
const int RfDesenseTxTestCdma::INDEX_MODULATION = 3;
std::string RfDesenseTxTestCdma::band = "";
std::string RfDesenseTxTestCdma::channel = "";
std::string RfDesenseTxTestCdma::power = "";
std::string RfDesenseTxTestCdma::modulation = "";
std::map<int, std::string> RfDesenseTxTestCdma::evdo_values = {{INDEX_BAND, "0"},{INDEX_CHANNEL, "384"},{INDEX_POWER, "23"}, {INDEX_MODULATION, "1"}};
std::map<int, std::string> RfDesenseTxTestCdma::cdma_1x_values = {{INDEX_BAND, "0"},{INDEX_CHANNEL, "384"},{INDEX_POWER, "23"}, {INDEX_MODULATION, "0"}};

RfDesenseTxTestCdma::RfDesenseTxTestCdma(int type) {
    modem_type = type;
    std::map<int, std::string> tmp;
    switch(modem_type){
        case utils::MODEM_CDMA_EVDO:{
            tmp = evdo_values;
            break;
        }
        case utils::MODEM_CDMA_1X:{
            tmp = cdma_1x_values;
            break;
        }
        default:
            break;
    }
    if(!tmp.empty()) {
        band = tmp[INDEX_BAND];
        channel = tmp[INDEX_CHANNEL];
        power = tmp [INDEX_POWER];
        modulation = tmp[INDEX_MODULATION];
    }

}

void RfDesenseTxTestCdma::show_default() {
    std::string str;
    int index = std::stoi(band);
    std::string modem;
    if(modem_type == utils::MODEM_CDMA_EVDO) {
        modem = "CDMA(EVDO) ";
    } else if(modem_type == utils::MODEM_CDMA_1X){
        modem = "CDMA(1X) ";
    }
    str = modem + "parameters: Band: "
            + std::string(rfdesense_cdma_band[index].name)
            + ", modulation: "
            + (std::stoi(modulation) == 0 ?
                    std::string("1x") : std::string("EVDO"))
            + ", Channel(ARFCN): " + channel + ", Power Level(dBm): " + power;
    emResultNotifyWithDone(str);
}

RfDesenseTxTestCdma::~RfDesenseTxTestCdma() {
    // TODO Auto-generated destructor stub
}
std::string RfDesenseTxTestCdma::modemTypeToString(int type) {
    switch(modem_type){
        case utils::MODEM_CDMA_EVDO:
            return "CDMA(EVD)";
        case utils::MODEM_CDMA_1X:
            return "CDMA(1X)";
        default:
            return "UNKNOWN";
    }
}

std::string RfDesenseTxTestCdma::get_command(){
    int tx_power = 0;
    if (!power.empty()) {
        tx_power = std::stoi(power) + 60;
    }

    if (modem_type == utils::MODEM_CDMA_1X) {
        command = "AT+ECRFTX=1," + channel + "," + band + ","
                + std::to_string(tx_power)
                + ","
                + (modulation == "1" ? "0" : "1");
    } else if(modem_type == utils::MODEM_CDMA_EVDO) {
        command = "AT+ERFTX=13,4," + channel + "," + band + ","
                + std::to_string(tx_power);
    }
    return command;
}

std::string RfDesenseTxTestCdma::get_band(){
    return band;
}

std::string RfDesenseTxTestCdma::get_power(){
    return power;
}

bool RfDesenseTxTestCdma::set_band(int value){
    std::string s;
    if(value < 0 || value > 15) {
        s = utils::format("band(%d) is out of range", value);
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "band(%d) is out of range", value);
        return false;
    }
    band = std::to_string(value);
    if(modem_type == utils::MODEM_CDMA_EVDO) {
        evdo_values[INDEX_BAND] = band;
    } else if(modem_type == utils::MODEM_CDMA_1X) {
        cdma_1x_values[INDEX_BAND] = band;
    } else {
        s = utils::format("modem(%s) is invalid", modemTypeToString(modem_type));
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "modem(%s) is invalid", modemTypeToString(modem_type));
        return false;
    }
    em_result_notify_ok("band: " + std::string(rfdesense_cdma_band[value].name));
    return true;
}

bool RfDesenseTxTestCdma::set_modulation(int value){
    if (value != 0 && value != 1) {
        LOG_D(LOG_TAG, "set_modulation value(%d) is out of range",value);
        return false;
    }
    modulation = std::to_string(value);
    if(modem_type == utils::MODEM_CDMA_EVDO) {
        evdo_values[INDEX_MODULATION] = modulation;
    } else if(modem_type == utils::MODEM_CDMA_1X) {
        cdma_1x_values[INDEX_MODULATION] = modulation;
    } else {
        std::string s;
        s = utils::format("modem(%s) is invalid", modemTypeToString(modem_type));
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "modem(%s) is invalid", modemTypeToString(modem_type));
        return false;
    }
    em_result_notify_ok("modulation: " + (value == 0 ?std::string("1x") : std::string("EVDO")));
    return true;
}

bool RfDesenseTxTestCdma::set_channel(std::string str){
    channel = str;
    if(modem_type == utils::MODEM_CDMA_EVDO) {
        evdo_values[INDEX_CHANNEL] = channel;
    } else if(modem_type == utils::MODEM_CDMA_1X) {
        cdma_1x_values[INDEX_CHANNEL] = channel;
    } else {
        std::string s;
        s = utils::format("modem(%s) is invalid", modemTypeToString(modem_type));
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "modem(%s) is invalid", modemTypeToString(modem_type));
        return false;
    }
    em_result_notify_ok("channel: " + channel);
    return true;
}

bool RfDesenseTxTestCdma::set_power(std::string str){
    power = str;
    if(modem_type == utils::MODEM_CDMA_EVDO) {
        evdo_values[INDEX_POWER] = power;
    } else if(modem_type == utils::MODEM_CDMA_1X) {
        cdma_1x_values[INDEX_POWER] = power;
    } else {
        std::string s;
        s = utils::format("modem(%s) is invalid", modemTypeToString(modem_type));
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "modem(%s) is invalid", modemTypeToString(modem_type));
        return false;
    }
    em_result_notify_ok("power: " + power);
    return true;
}

void RfDesenseTxTestCdma::show_channel(){
    emResultNotifyWithDone("Channel(ARFCN): " + channel);
}

void RfDesenseTxTestCdma::show_power(){
    emResultNotifyWithDone("Power level(dBm): " + power);
}
