inherit pkgconfig externalsrc package
SUMMARY = "RTK Library"
LICENSE = "CLOSED"
#LIC_FILES_CHKSUM = "file://LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"
DEPENDS += "liblynq-log gpshal6635"
inherit workonsrc
WORKONSRC = "${TOPDIR}/../LYNQ_PUBLIC/IC_src/mtk/lib/liblynq-rtk"


TARGET_CC_ARCH += "${LDFLAGS}"
BB_INCLUDE_ADD = "--sysroot=${STAGING_DIR_HOST}"
BB_LDFLAGS_ADD = "--sysroot=${STAGING_DIR_HOST} -Wl,--hash-style=gnu"

FILES_${PN} = "${base_libdir}/*.so \
               ${base_bindir}\
               ${base_sbindir} \"

FILES_${PN} += "${libdir}/libRTKFUN.so"
FILES_${PN} += "${libdir}/libcmcc_sdk.so"

FILES_${PN}-dev = "${includedir} \
                    ${libdir/*.so}"

TOOLCHAIN_HOST_TASK_append = " nativesdk-python-core"

INSANE_SKIP_${PN} += "ldflags"
INSANE_SKIP_${PN}-dev += "ldflags"
INSANE_SKIP_${PN} += "dev-so"
INSANE_SKIP_${PN} += "already-stripped"
INSANE_SKIP_${PN} += "installed-vs-shipped"

do_compile () {
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -Wl,--hash-style=gnu -DTELEPHONYWARE"
}

do_install () {
    oe_runmake install ROOT=${D}
	
    if [ -d "${WORKONSRC}" ] ; then
        install -d ${D}${includedir}/
        cp -af ${S}include/ ${D}${includedir}/
    fi 
    install -d ${D}${base_libdir}
    install -d ${D}${includedir}
    cp -arf ${S}/rtk_fun.h ${D}${includedir}/
    install ${S}/libRTKFUN.so ${D}${base_libdir}/
    install ${S}/libcmcc_sdk.so ${D}${base_libdir}/
}

addtask bachclean
do_bachclean () {
    oe_runmake clean
}