inherit externalsrc package systemd

DESCRIPTION = "USB login port switching"
LICENSE = "CLOSED"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"
inherit workonsrc
WORKONSRC = "${TOPDIR}/../LYNQ_PUBLIC/IC_src/mtk/framework/lynq-ndis-uevent/src"
DEPENDS += "liblynq-uci"

SRC_URI = "file://gsw_switch"

TARGET_CC_ARCH += "${LDFLAGS}"
SYSTEMD_PACKAGES = "${PN}"
SYSTEMD_SERVICE_${PN} = "lynq_ndis_uevent.service"
FILES_${PN} += "${systemd_unitdir}/system/lynq_ndis_uevent.service"

#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
	if test "${PACKAGE_ARCH}" = "cortexa7hf-vfp-vfpv4-neon" || test "${PACKAGE_ARCH}" = "cortexa7hf-neon-vfpv4"; then
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -mhard-float"
	else
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST}"
	fi
}

do_install() {
	install -d ${D}${bindir}/
	install -m 0755 ${S}lynq-ndis-uevent ${D}${bindir}/
        install -m 0755 ${WORKDIR}/gsw_switch ${D}${bindir}/
	install -d ${D}${systemd_unitdir}/system
	install -m 0644 ${B}/lynq_ndis_uevent.service ${D}${systemd_unitdir}/system/
}
