#!/bin/sh
# uart root user set password to login

# Generate a uart login password based on the file 
if [ -f /oemapp/usr/bin/sfscheck ]; then
        /oemapp/usr/bin/sfscheck -g
        raw_passwd=`cat /tmp/uart_password`
elif [ -f oemapp2/usr/bin/sfscheck ]; then
          oemapp2/usr/bin/sfscheck -g
        raw_passwd=`cat /tmp/uart_password`
else
        raw_passwd=lynq
fi

# The root user configures the secret key
password=`openssl passwd -6 -salt lynq $raw_passwd`
sed "s%^root:[^:]*:%root:$password:%" \
       < /etc/shadow_bk \
       > /run/shadow;

rm -rf /tmp/uart_password
