#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <log/log.h>
//xf.li@20230822 add for ab recover start
#include <errno.h>
//xf.li@20230822 add for ab recover end
#include "md5.h"
#include "mtk_device_wrap.h"
#include "liblog/lynq_deflog.h"
#define LOG_TAG "LYNQ_FOTA"

int ota_file_open(char* path, char* flag)
{
#if 1
	if(strcmp(flag, "r") == 0 || strcmp(flag, "rb") == 0)
		return mtk_device_wrap_open(path, O_RDONLY);
	else if(strcmp(flag, "r+") == 0 || strcmp(flag, "rb+") == 0)
		return mtk_device_wrap_open(path, O_RDWR | O_CREAT);
	else if(strcmp(flag, "w+") == 0 ||strcmp(flag, "wb+") == 0 || strcmp(flag, "w") == 0  || strcmp(flag, "wb") == 0 )	
		return mtk_device_wrap_open(path, O_RDWR | O_CREAT | O_TRUNC);
	else if(strcmp(flag, "a+") == 0 ||strcmp(flag, "ab+") == 0 || strcmp(flag, "a") == 0  || strcmp(flag, "ab") == 0 )	
		return mtk_device_wrap_open(path, O_RDWR | O_CREAT | O_APPEND);	
#endif
}


int ota_file_seek(int handle, int offset,  int flag)
{
	return mtk_device_wrap_seek(handle,offset,flag);
}



int ota_file_read(char* buffer, size_t count, int file)
{
	return mtk_device_wrap_read(file,buffer,count);
}



void ota_file_close(int handle)
{
	mtk_device_wrap_close(handle);
}

#define MD5_READ_BUFFER_LEN 4*1024
int lynq_md5_file_verfy(char* filePath, char* file_md5)
{
	int ret = -1;
	int handle;

	LYVERBLOG("[+MD5]:calc file md5: %s\n", filePath);
	handle = open(filePath, O_RDONLY);	
	LYVERBLOG("[+MD5]:handle:%d\n",handle);
	if(handle >= 0){
		{
			int read_len = 0; 
			unsigned char buffer[MD5_READ_BUFFER_LEN] = {0};
			unsigned char decrypt[16];
			int i;
			MD5_CTX md5;  
			MD5Init(&md5);
			//strcpy(buffer,"12345");
			while ((read_len = read(handle,buffer, MD5_READ_BUFFER_LEN)) > 0)
			{   
				//printf("readlen:%d\n",read_len);
				MD5Update(&md5, (unsigned char*)buffer, read_len); 				
				memset(buffer,0,sizeof(buffer));
			}
			MD5Final(&md5, (unsigned char*)decrypt);
			memset(buffer, 0, MD5_READ_BUFFER_LEN);
			for(i = 0; i < 16; i++)  
			{  
				sprintf((char*)(buffer + i * 2), "%02x",decrypt[i]);  
			}
			LYVERBLOG("[+MD5]:md5:%s\n", buffer);
			LYVERBLOG("[+MD5]:md5:%s\n", file_md5);
			
			ret = strncmp((const char*)buffer, (const char*)file_md5,32);
			LYVERBLOG("[+MD5]:ret:%d\n", ret);
		}
		close(handle);
	}
	return ret;
}
//xf.li@20230822 add for ab recover start
#define MD5_VERFY_ERROR 5
int lynq_md5_file_verfy_ab(char* filePath, char* file_md5)
{
	int ret = -1;
	int handle;

	RLOGD("[+MD5]:calc file md5: %s\n", filePath);
	handle = open(filePath, O_RDONLY);	
	RLOGD("[+MD5]:handle:%d\n",handle);
	if(handle == -1)
	{
		RLOGD("[+MD5]: can't open the file, errno is %d\n",errno);
	}
	if(handle >= 0)
	{
		int read_len = 0; 
		unsigned char buffer[MD5_READ_BUFFER_LEN] = {0};
		unsigned char decrypt[16];
		int i;
		MD5_CTX md5;  
		MD5Init(&md5);
		while ((read_len = read(handle,buffer, MD5_READ_BUFFER_LEN)) > 0)
		{   
			MD5Update(&md5, (unsigned char*)buffer, read_len); 				
			memset(buffer,0,sizeof(buffer));
			usleep(1000);
		}
		MD5Final(&md5, (unsigned char*)decrypt);
		memset(buffer, 0, MD5_READ_BUFFER_LEN);
		for(i = 0; i < 16; i++)  
		{  
			sprintf((char*)(buffer + i * 2), "%02x",decrypt[i]);  
		}
		RLOGD("[+MD5]:buffer md5:%s\n", buffer);
		RLOGD("[+MD5]:file_md5 md5:%s\n", file_md5);
		
		ret = strncmp((const char*)buffer, (const char*)file_md5,32);
		RLOGD("[+MD5]:ret:%d\n", ret);
		close(handle);
	}
	if(ret != 0)
	{
		return MD5_VERFY_ERROR;
	}
	return ret;
}
int calculate_file_md5_value(char* filePath, unsigned char buffer_out[])
{
	//int ret = -1;
	int handle;

	RLOGD("[+MD5]:calc file md5: %s\n", filePath);
	handle = open(filePath, O_RDONLY);
	RLOGD("[+MD5]:handle:%d\n",handle);
	if(handle == -1)
	{
		RLOGD("[+MD5]: can't open the file, errno is %d\n",errno);
	}
	if(handle >= 0)
	{
		int read_len = 0; 
		unsigned char buffer[MD5_READ_BUFFER_LEN] = {0};
		unsigned char decrypt[16];
		int i;
		MD5_CTX md5;  
		MD5Init(&md5);
		while ((read_len = read(handle,buffer, MD5_READ_BUFFER_LEN)) > 0)
		{   
			MD5Update(&md5, (unsigned char*)buffer, read_len); 				
			memset(buffer,0,sizeof(buffer));
			usleep(1000);
		}
		MD5Final(&md5, (unsigned char*)decrypt);
		memset(buffer, 0, MD5_READ_BUFFER_LEN);
		for(i = 0; i < 16; i++)  
		{  
			sprintf((char*)(buffer + i * 2), "%02x",decrypt[i]);  
		}
		RLOGD("[+MD5]: md5 of %s : %s\n", filePath, buffer);
		memcpy(buffer_out, buffer, MD5_READ_BUFFER_LEN);
		close(handle);
	}
	else
	{
		return -1;
	}
	return 0;
}

int lynq_md5_two_file_verfy(char* filePath_1, char* filePath_2)
{
	int ret = -1;
	int handle_1, handle_2;
	unsigned char buffer_1[MD5_READ_BUFFER_LEN] = {0};
	unsigned char buffer_2[MD5_READ_BUFFER_LEN] = {0};
	
	ret = calculate_file_md5_value(filePath_1, buffer_1);
	if(ret < 0)
	{
		RLOGD("[+MD5]:calculate file1 md5 value ERROE!!!\n");
		return ret;
	}
	ret = calculate_file_md5_value(filePath_2, buffer_2);
	if(ret < 0)
	{
		RLOGD("[+MD5]:calculate file2 md5 value ERROE!!!\n");
		return ret;
	}
	RLOGD("buffer_1 is %s, buffer_2 is %s\n", buffer_1, buffer_2);
	ret = strncmp((const char*)buffer_1, (const char*)buffer_2, 32);
	RLOGD("[+MD5]:strncmp ret:%d\n", ret);

	if(ret != 0)
	{
		return MD5_VERFY_ERROR;
	}
	return 0;
}
//xf.li@20230822 add for ab recover end
#if 0
int md5_file_verfy_new(char* filePath, char* file_md5,int packe_len)
{
	int ret = -1;
	int handle;
	int tatal_packe_len = 0;

	LYVERBLOG("[+MD5]:calc file md5: %s\n", filePath);
	handle = mtk_device_wrap_open(filePath, O_RDONLY);	
	LYVERBLOG("[+MD5]:handle:%d\n",handle);
	if(handle >= 0){
		{
			int read_len = 0; 
			unsigned char buffer[MD5_READ_BUFFER_LEN] = {0};
			unsigned char decrypt[16];
			int i;
			MD5_CTX md5;  
			MD5Init(&md5);
			//strcpy(buffer,"12345");
			tatal_packe_len = packe_len;
			LYVERBLOG("[+MD5]:tatal_packe_len:%d\n", tatal_packe_len);
			while ((read_len = mtk_device_wrap_read(handle,buffer, MD5_READ_BUFFER_LEN)) > 0)
			{   
				//printf("readlen:%d\n",read_len);
				if(tatal_packe_len >= read_len)
				{
					MD5Update(&md5, (unsigned char*)buffer, read_len); 
					tatal_packe_len -= read_len;
				}
				else if(tatal_packe_len > 0)
				{
					LYVERBLOG("[+MD5]:tatal_packe_len:%d\n", tatal_packe_len);
					MD5Update(&md5, (unsigned char*)buffer, tatal_packe_len); 
					tatal_packe_len -= read_len;
				}
				LYVERBLOG("[+MD5]:tatal_packe_len:%d\n", tatal_packe_len);			
				memset(buffer,0,sizeof(buffer));
			}
			MD5Final(&md5, (unsigned char*)decrypt);
			memset(buffer, 0, MD5_READ_BUFFER_LEN);
			for(i = 0; i < 16; i++)  
			{  
				sprintf((char*)(buffer + i * 2), "%02x",decrypt[i]);  
			}
			LYVERBLOG("[+MD5]:md5:%s\n", buffer);
			LYVERBLOG("[+MD5]:md5:%s\n", file_md5);
			
			ret = strncmp((const char*)buffer, (const char*)file_md5,32);
			LYVERBLOG("[+MD5]:ret:%d\n", ret);
		}
		mtk_device_wrap_close(handle);
	}
	return ret;
}
#endif