#ifndef _IOT_ROCK_H_
#define _IOT_ROCK_H_

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

/* public */

#define E_ROCK_SUCCESS (0)
#define E_ROCK_INVALID_DELTA (-1)
#define E_ROCK_DELTA_MISMATCH (-2)
#define E_ROCK_DELTA_CHUNK_MISMATCH (-3)
#define E_ROCK_READ_DELTA_ERROR (-4)
#define E_ROCK_READ_BLOCK_ERROR (-11)
#define E_ROCK_WRITE_BLOCK_ERROR (-12)
#define E_ROCK_RAM_NOT_ENOUGH (-20)
#define E_ROCK_INVALID_CTX	(-30)
#define E_ROCK_FOTA_ADDR (-50)


#define PATCH_SYSTEM   (1)
#define PATCH_BOOT     (2)
#define PATCH_TEE      (3)
#define PATCH_MD1IMG   (4)
#define PATCH_MD1DSP   (5)
#define PATCH_VBMETA   (6)
#define PATCH_OEMAPP   (7)
#define PATCH_OEMAPP2  (8)
#define PATCH_MEDMCU   (9)
#define PATCH_SPM      (10)
#define PATCH_PROTECT  (11)
#define PATCH_MCF1     (12)
#define PATCH_MCF2     (13)
#define PATCH_MCUPM    (14)
#define PATCH_SSPM     (15)
#define PATCH_DPM      (16)
#define PATCH_PIIMG    (17)
#define PATCH_HSMOS    (18)
#define PATCH_BL2      (19)
#define PATCH_BL33     (20)

#define FULL_SYSTEM    (65)
#define FULL_BOOT      (66)
#define FULL_TEE       (67)
#define FULL_MD1IMG    (68)
#define FULL_MD1DSP    (69) 
#define FULL_VBMETA    (70)
#define FULL_OEMAPP    (71)
#define FULL_OEMAPP2   (72)
#define FULL_MEDMCU    (73)
#define FULL_SPM       (74)
#define FULL_PROTECT   (75)
#define FULL_MCF1      (76)
#define FULL_MCF2      (77)
#define FULL_MCUPM     (78) 
#define FULL_SSPM      (79)
#define FULL_DPM       (80)
#define FULL_PIIMG     (81)
#define FULL_HSMOS     (82)
#define FULL_BL2       (83)
#define FULL_BL33      (84)








#define MAX_OTA_ROLE   (128) 
#define REAL_OTA_ROLE  (20)



#define MODE_NORMAL           0
#define MODE_A2B              1
#define MODE_B2A              2

#define WAIT            0xff
#define PASS             0
#define ERROR           -1

typedef struct {
	void* user_context;
	unsigned int rom_base;	// old rom start
	unsigned char* ram_base;	// ram working buffer start
	unsigned int ram_len; 		// ram working buffer len

	unsigned int backup_base;	// ram backup storage start
	unsigned int backup_len; 		// ram backup storage len

	unsigned int update_nvram;	// nvram update flag

	int read_rom_directly;
	int first_run;
} IOT_UPDATA_CONTEXT;




typedef struct {

    char fota_flag[32];	    //fota 标志保留 
    int  update_result;     //升级结果
	int  ota_run;            //  
	char cid[32];
	char did[32];
} UPDATE_INFO;


typedef struct {
	int  need_update;
    int  check_delta;
    int  check_rom;
	int  update_result;
	
} UPDATE_STATUS;


typedef struct {
	int  ota_run;
    UPDATE_STATUS  update_status[MAX_OTA_ROLE];
	int  update_result;
	int  switch_slot;
	
} OTA_STATUS;





//#define DELTA_HEARD_SIZE	(4*5)

//#define DELTA_HEARD_SIZE	    (4*11 + 4*11)
#define DELTA_HEARD_SIZE	    512
#define DELTA_FULL_HEARD_SIZE   8



int iot_patch(IOT_UPDATA_CONTEXT* update_ctx);
int lynq_read_process(void);
unsigned int iot_hash(unsigned char *buf,unsigned int len, unsigned int* value);
int lynq_md5_file_verfy(char* filePath, char* file_md5);
//xf.li@20230822 add for ab recover start
int lynq_md5_file_verfy_ab(char* filePath, char* file_md5);
int calculate_file_md5_value(char* filePath, unsigned char buffer_out[]);
int lynq_md5_two_file_verfy(char* filePath_1, char* filePath_2);
//xf.li@20230822 add for ab recover end
//int md5_file_verfy_new(char* filePath, char* file_md5,int packe_len);
int lynq_rock_main(int first_run);
int lynq_fota_func(void);
int lynq_nand_open(const char *pathname, int flags);
ssize_t lynq_nand_read(int fd, void *buf, size_t count);
ssize_t lynq_nand_write(int fd, void *buf, size_t count);
int lynq_nand_close(int fd);
int lynq_get_upgrade_status(void);
void lynq_reboot_device(void);
int lynq_fota_nrestart(void);
int lynq_fota_set_addr_value(char *value,int size);
int lynq_fota_get_addr_value(char *tmp);
#endif



