#ifndef LYNQ_AGPS_H
#define LYNQ_AGPS_H

#ifdef __cplusplus
extern "C" {
#endif
/*Copy for agps_interface.h*/
#define agps_bool char

#define MAX_BUFF_SIZE 8192
#define SUPL_PROFILES_NUM 30

#define AGPS_INTF_STRING_LEN 64
#define AGPS_SUPL_ADDR_LEN 128
#define MNL_MCC_STRING_LEN 16
#define EXTERNAL_ADD_LEN 20
#define MLC_NUMBER_LEN 20
#define EPC_MOLR_LPP_PAYLOAD_LEN 300
#define SUPL_PROFILES_NUM 30
#define PROFILING_MESSAGE_LEN 64
#define PROFILING_ELEMENT_NUM 20

typedef enum {
    // Command Enum APP -> AGPSD
    APP_MGR_CMD_CODER_TEST = 0,
    APP_MGR_CMD_VERSION = 1,

    APP_MGR_CMD_GET_CONFIG = 100,    //AgpsConfig
    APP_MGR_CMD_GET_OMA_CP_SUPL_PROFILE = 101,
    APP_MGR_CMD_GET_SYSTEM_PROPERTY = 102,
    APP_MGR_CMD_GET_AGPS_PROFILING = 103,
    APP_MGR_CMD_GET_EMULATOR_MODE = 104,
    APP_MGR_CMD_GET_CONFIG_V2 = 105,
    APP_MGR_CMD_GET_CONFIG_V3 = 106,    // add cert_from_sdcard
    APP_MGR_CMD_GET_CONFIG_V14 = 117,
    APP_MGR_CMD_GET_CONFIG_V20 = 123,
    APP_MGR_CMD_GET_CONFIG_V21 = 124,
    APP_MGR_CMD_GET_CONFIG_V22 = 125,
    APP_MGR_CMD_GET_CONFIG_V23 = 126,
    APP_MGR_CMD_GET_CONFIG_V24 = 127,

    APP_MGR_CMD_SET_AGPS_ENABLE = 200,
    APP_MGR_CMD_SET_PROTOCOL,
    APP_MGR_CMD_SET_CDMA_PREF,
    APP_MGR_CMD_SET_UP_PREF_METHOD,
    APP_MGR_CMD_SET_POS_TECHNOLOGY_MSA,
    APP_MGR_CMD_SET_POS_TECHNOLOGY_MSB,
    APP_MGR_CMD_SET_POS_TECHNOLOGY_ECID,
    APP_MGR_CMD_SET_POS_TECHNOLOGY_OTDOA,
    APP_MGR_CMD_SET_SUPL_VERSION,
    APP_MGR_CMD_SET_SUPL_PROFILE,    //AgpsProfil
    APP_MGR_CMD_SET_QOP = 210,            //AgpsQoP
    APP_MGR_CMD_SET_MOLR_POS_METHDO,
    APP_MGR_CMD_SET_EXTERNAL_ADDR,
    APP_MGR_CMD_SET_MLC_NUMBER,
    APP_MGR_CMD_SET_CP_AUTO_RESET,
    APP_MGR_CMD_SET_ALLOW_NI,
    APP_MGR_CMD_SET_ALLOW_ROAMING,
    APP_MGR_CMD_SET_SUPL_2_FILE,
    APP_MGR_CMD_SET_RESET_TO_DEFAULT,
    APP_MGR_CMD_SET_OMA_CP_SUPL_PROFILE,
    APP_MGR_CMD_SET_NI_REQ = 220,  //un-implemented for test
    APP_MGR_CMD_SET_EPC_MOLR_PDU_ENABLE,
    APP_MGR_CMD_SET_EPC_MOLR_PDU,
    APP_MGR_CMD_SET_TLS_VERSION,
    APP_MGR_CMD_SET_CA_ENABLE,
    APP_MGR_CMD_SET_UDP_ENABLE,
    APP_MGR_CMD_SET_LPP_ENABLE,
    APP_MGR_CMD_SET_CERT_FROM_SDCARD_ENABLE,
    APP_MGR_CMD_SET_AUTO_PROFILE_ENABLE,
    APP_MGR_CMD_SET_UT2,
    APP_MGR_CMD_SET_UT3 = 230,
    APP_MGR_CMD_SET_SUPL_APN_ENABLE,
    APP_MGR_CMD_SET_SYNC_TO_SLP,
    APP_MGR_CMD_SET_UDP_ENABLE_V2,
    APP_MGR_CMD_SET_AUTONOMOUS_ENABLE,
    APP_MGR_CMD_SET_AFLT_ENABLE,
    APP_MGR_CMD_SET_IMSI_ENABLE,
    APP_MGR_CMD_SET_SIB8_16_ENABLE,
    APP_MGR_CMD_SET_GPS_ENABLE,
    APP_MGR_CMD_SET_GLONASS_ENABLE,
    APP_MGR_CMD_SET_BEIDOU_ENABLE = 240,
    APP_MGR_CMD_SET_GALILEO_ENABLE,
    APP_MGR_CMD_SET_SUPL_SHA_VERSION,
    APP_MGR_CMD_SET_SUPL_TLS_VERSION,
    APP_MGR_CMD_SET_SUPL_VER_MINOR,
    APP_MGR_CMD_SET_SUPL_VER_SER_IND,
    APP_MGR_CMD_SET_A_GLONASS_ENABLE,
    APP_MGR_CMD_SET_PDE_PROFILE,
    APP_MGR_CMD_SET_E911_GPS_ICON_ENABLE,
    APP_MGR_CMD_SET_E911_OPEN_GPS_ENABLE,
    APP_MGR_CMD_SET_A_GPS_ENABLE = 250,
    APP_MGR_CMD_SET_A_BEIDOU_ENABLE,
    APP_MGR_CMD_SET_A_GALILEO_ENABLE,
    APP_MGR_CMD_SET_PREF_2G3G_CELL_AGE,
    APP_MGR_CMD_SET_UT1,
    APP_MGR_CMD_SET_NO_SENSITIVE_LOG,
    APP_MGR_CMD_SET_TLS_REUSE_ENABLE,
    APP_MGR_CMD_SET_IMSI_CACHE_ENABLE,
    APP_MGR_CMD_SET_SUPL_RAW_DATA_ENABLE,
    APP_MGR_CMD_SET_TC10_ENABLE,
    APP_MGR_CMD_SET_TC10_USE_APN = 260,
    APP_MGR_CMD_SET_TC10_USE_FW_DNS,
    APP_MGR_CMD_SET_ALLOW_NI_FOR_GPS_OFF,
    APP_MGR_CMD_SET_FORCE_OTDOA_ASSIST_REQ,
    APP_MGR_CMD_SET_REJECT_NON911_NILR_ENABLE,
    APP_MGR_CMD_SET_CP_2G_DISABLE,
    APP_MGR_CMD_SET_CP_3G_DISABLE,
    APP_MGR_CMD_SET_CP_4G_DISABLE,
    APP_MGR_CMD_SET_TC10_IGNORE_FW_CONFIG,
    APP_MGR_CMD_SET_LPPE_HIDE_WIFI_BT_STATUS,
    APP_MGR_CMD_SET_LPPE_NETWORK_LOCATION_DISABLE = 270,
    APP_MGR_CMD_SET_LPPE_CP_ENABLE,
    APP_MGR_CMD_SET_LPPE_UP_ENABLE,
    APP_MGR_CMD_SET_VZW_DEBUG_SCREEN_ENABLE,
    APP_MGR_CMD_SET_AOSP_PROFILE_ENABLE,
    APP_MGR_CMD_SET_BIND_NLP_SETTING_TO_SUPL,
    APP_MGR_CMD_SET_ESUPL_APN_MODE,
    APP_MGR_CMD_SET_TCP_KEEPALIVE,
    APP_MGR_CMD_SET_AGPS_NVRAM_ENABLE,
    APP_MGR_CMD_SET_LBS_LOG_ENABLE,
    APP_MGR_CMD_SET_LPPE_CROWD_SOURCE_CONFIDENT = 280,
    APP_MGR_CMD_SET_IGNORE_SI_FOR_E911,
    APP_MGR_CMD_SET_LPPE_CP_WLAN_ENABLE,
    APP_MGR_CMD_SET_LPPE_CP_SRN_ENABLE,
    APP_MGR_CMD_SET_LPPE_CP_SENSOR_ENABLE,
    APP_MGR_CMD_SET_LPPE_CP_DBH_ENABLE,
    APP_MGR_CMD_SET_LPPE_UP_WLAN_ENABLE,
    APP_MGR_CMD_SET_LPPE_UP_SRN_ENABLE,
    APP_MGR_CMD_SET_LPPE_UP_SENSOR_ENABLE,
    APP_MGR_CMD_SET_LPPE_UP_DBH_ENABLE,
    APP_MGR_CMD_SET_IP_VERSION_PREFER = 290,
    APP_MGR_CMD_SET_UP_LPP_IN_2G3G_DISABLE,
    APP_MGR_CMD_SET_UP_RRLP_IN_4G_DISABLE,
    APP_MGR_CMD_UP_SI_DISABLE,

    // To implement
    APP_MGR_CMD_SET_USE_NI_SLP,
    APP_MGR_CMD_SET_USE_TC10_CONFIG,
    APP_MGR_CMD_SET_LPPE_DEF_NLP_ENABLE,
    APP_MGR_CMD_SET_AOSP_POS_MODE_ENABLE,
    APP_MGR_CMD_SET_PRIVACY_OVERRIDE_MODE,
    APP_MGR_CMD_SET_EMERGENCY_EXT_SECS, // 299


    APP_MGR_CMD_START_PERIODIC = 300,
    APP_MGR_CMD_ABORT_PERIODIC,
    APP_MGR_CMD_START_AREA_EVENT,
    APP_MGR_CMD_ABORT_AREA_EVENT,

    APP_MGR_CMD_START_TEST_CASE = 400,
    APP_MGR_CMD_START_TEST_BUTTON,
    APP_MGR_CMD_START_RESET_AGPSD,
    APP_MGR_CMD_START_EMULATOR_MODE,


    // To implement
    APP_MGR_CMD_SET_TC10_SUPL_SSL_METHOD = 500,
    APP_MGR_CMD_SET_TC10_AUTO_SUPL_VER_FOR_NI,
    APP_MGR_CMD_SET_TC10_SUPL_VER_SKT_NI,
    APP_MGR_CMD_SET_TC10_USE_APN_NI,
    APP_MGR_CMD_SET_TC10_USE_APN_SI,
    APP_MGR_CMD_SET_CP_PRIVACY_OVERRIDE,
    APP_MGR_CMD_SET_SUPL_ADDR_NI,
    APP_MGR_CMD_SET_RRLP_GOOGLE_SUPL,
    APP_MGR_CMD_SET_SUPL2_CAP_EXT_DISABLE,
    APP_MGR_CMD_SET_NI_STATISTIC_ENABLE,
    APP_MGR_CMD_SET_UP_OPERATION_MODE,  // 510
    APP_MGR_CMD_SET_GLONASS_MSA_ENABLE,
    APP_MGR_CMD_SET_GLONASS_MSB_ENABLE,
    APP_MGR_CMD_SET_BEIDOU_MSA_ENABLE,
    APP_MGR_CMD_SET_BEIDOU_MSB_ENABLE,
    APP_MGR_CMD_SET_GALILEO_MSA_ENABLE,
    APP_MGR_CMD_SET_GALILEO_MSB_ENABLE,
    APP_MGR_CMD_SET_TC10_AUTO_SUPL_VER_FOR_ENI,
    APP_MGR_CMD_SET_TC10_CP_LPP_GUARD_TIME_SEC,
    APP_MGR_CMD_SET_TC10_CP_CAPABILITY_VALID_ENABLE,
    APP_MGR_CMD_SET_TC10_CP_CAPABILITY_ENABLE, // 520
    APP_MGR_CMD_SET_IGNORE_EMERGENCY_EXT_SECS_FROM_FRAMEWORK,
    APP_MGR_CMD_GET_AGPSD_VERSION,
    APP_MGR_CMD_GET_IMSI,
} app_mgr_cmd_enum;

typedef enum {
    AGPS_INTF_PDE_IP_TYPE_IPV4 = 0,
    AGPS_INTF_PDE_IP_TYPE_IPV6 = 1,
} agps_intf_pde_ip_type;

typedef enum {
    AGPS_INTF_CDMA_PREFERRED_WCDMA = 0,
    AGPS_INTF_CDMA_PREFERRED_CDMA = 1,
    AGPS_INTF_CDMA_PREFERRED_CDMA_FORCE = 2,
} agps_intf_cdma_preferred;

typedef enum {
    AGPS_INTF_PREF_METHOD_MSA = 0,
    AGPS_INTF_PREF_METHOD_MSB = 1,
    AGPS_INTF_PREF_METHOD_NO_PREF = 2,
} agps_intf_pref_method;

typedef enum {
    AGPS_INTF_AGPS_PROTOCOL_UP = 0,
    AGPS_INTF_AGPS_PROTOCOL_CP = 1,
} agps_intf_agps_protocol;

typedef enum {
    AGPS_INTF_SUPL_VERSION_1 = 1,
    AGPS_INTF_SUPL_VERSION_2 = 2,
} agps_intf_supl_version;

typedef enum {
    AGPS_INTF_TLS_VERSION_1_0 = 0,
    AGPS_INTF_TLS_VERSION_1_1 = 1,
    AGPS_INTF_TLS_VERSION_1_2 = 2,
} agps_intf_tls_version;

typedef enum {
    AGPS_INTF_ESUPL_APN_EIMS_IMS = 0,
    AGPS_INTF_ESUPL_APN_EIMS = 1,
    AGPS_INTF_ESUPL_APN_IMS = 2,
    AGPS_INTF_ESUPL_APN_AS_NORMAL = 3,
} agps_intf_esupl_apn;

typedef enum {
    AGPS_INTF_MOLR_POS_METHOD_LOC_EST = 0,
    AGPS_INTF_MOLR_POS_METHOD_ASSIST_DATA = 1,
} agps_intf_molr_pos_method;

typedef struct {
    char name[AGPS_INTF_STRING_LEN];
    char addr[AGPS_SUPL_ADDR_LEN];
    int port;
    agps_bool tls;
    char mcc_mnc[MNL_MCC_STRING_LEN];
    char app_id[AGPS_INTF_STRING_LEN];
    char provider_id[AGPS_INTF_STRING_LEN];
    char default_apn[AGPS_INTF_STRING_LEN];
    char optional_apn[AGPS_INTF_STRING_LEN];
    char optional_apn_2[AGPS_INTF_STRING_LEN];
    char address_type[AGPS_INTF_STRING_LEN];
} agps_intf_supl_profile;

typedef struct {
    char name[AGPS_INTF_STRING_LEN];
    agps_bool mcp_enable;
    char mcp_addr[AGPS_INTF_STRING_LEN];
    int mcp_port;
    agps_bool pde_addr_valid;
    agps_intf_pde_ip_type pde_ip_type;    //0=IPV4 1=IPV6
    char pde_addr[AGPS_INTF_STRING_LEN];
    int pde_port;
    agps_bool pde_url_valid;
    char pde_url_addr[AGPS_INTF_STRING_LEN];
} agps_intf_cdma_profile;

typedef struct {
    agps_bool agps_enable;
    agps_intf_agps_protocol agps_protocol;
    agps_bool gpevt;
    agps_bool e911_gps_icon_enable;
    agps_bool e911_open_gps;
    agps_bool tc10_ignore_fw_config;
    agps_bool lppe_hide_wifi_bt_status;
    agps_bool lppe_network_location_disable;
    agps_bool agps_nvram_enable;
    agps_bool lbs_log_enable;
    int lppe_crowd_source_confident;
    agps_bool ignore_si_for_e911; // North America operator 'V' asks us to ignore SI triggered by GMS
    agps_bool use_tc10_config;
    agps_bool lppe_def_nlp_enable;
    int emergency_ext_secs;
} agps_intf_agps_setting;

typedef struct {
    agps_intf_molr_pos_method molr_pos_method;
    agps_bool external_addr_enable;
    char external_addr[EXTERNAL_ADD_LEN];
    agps_bool mlc_number_enable;
    char mlc_number[MLC_NUMBER_LEN];
    agps_bool cp_auto_reset;
    agps_bool epc_molr_lpp_payload_enable;
    int epc_molr_lpp_payload_len;
    char epc_molr_lpp_payload[EPC_MOLR_LPP_PAYLOAD_LEN];
    agps_bool cp_lppe_enable;
    agps_bool support_cp_lppe;
    agps_bool reject_non911_nilr_enable;
    agps_bool cp_2g_disable;
    agps_bool cp_3g_disable;
    agps_bool cp_4g_disable;
    agps_bool cp_lppe_wlan_enable;
    agps_bool cp_lppe_srn_enable;
    agps_bool cp_lppe_sensor_enable;
    agps_bool cp_lppe_dbh_enable;
} agps_intf_cp_setting;

typedef struct {
    agps_bool ca_enable;
    agps_bool ni_request;
    agps_bool roaming;
    agps_intf_cdma_preferred cdma_preferred;
    agps_intf_pref_method pref_method;
    agps_intf_supl_version supl_version;
    agps_intf_tls_version tls_version;
    agps_bool supl_log;
    agps_bool msa_enable;
    agps_bool msb_enable;
    agps_bool ecid_enable;
    agps_bool otdoa_enable;
    int qop_hacc;
    int qop_vacc;
    int qop_loc_age;
    int qop_delay;
    agps_bool lpp_enable;
    agps_bool cert_from_sdcard;
    agps_bool auto_profile_enable;
    char ut2;
    char ut3;
    agps_bool apn_enable;
    agps_bool sync_to_slp;
    agps_bool udp_enable;
    agps_bool autonomous_enable;
    agps_bool aflt_enable;
    agps_bool imsi_enable;
    char supl_ver_minor;
    char supl_ver_ser_ind;
    int sha_version;    // 0: SHA1 for SUPL1.0 and SHA256 for SUPL2.0, 1: SHA1 for SUPL1.0 and SUPL2.0, 2: SHA256 for SUPL1.0 and SUPL2.0
    int preferred_2g3g_cell_age;
    char ut1;
    agps_bool no_sensitive_log;
    agps_bool tls_reuse_enable;
    agps_bool imsi_cache_enable;
    agps_bool supl_raw_data_enable;
    agps_bool tc10_enable;
    agps_bool tc10_use_apn;
    agps_bool tc10_use_fw_dns;
    agps_bool allow_ni_for_gps_off;
    agps_bool force_otdoa_assist_req;
    agps_bool up_lppe_enable;
    agps_intf_esupl_apn esupl_apn_mode;
    int tcp_keepalive;
    agps_bool aosp_profile_enable;
    agps_bool bind_nlp_setting_to_supl;
    agps_bool up_lppe_wlan_enable;
    agps_bool up_lppe_srn_enable;
    agps_bool up_lppe_sensor_enable;
    agps_bool up_lppe_dbh_enable;
    int ip_version_prefer;            //0=IPv6 prefer   1=IPv4 prefer
    agps_bool up_lppe_in_2g3g_disable; // For ATT SUPL server
    agps_bool up_rrlp_in_4g_disable;  // For ATT SUPL server
    agps_bool up_si_disable;          // For Sprint
    agps_bool use_ni_slp;             // tc10 (ALPS04423530)
    agps_bool aosp_pos_mode_enable;
    int privacy_override_mode;
} agps_intf_up_setting;

typedef struct {
    agps_bool sib8_sib16_enable;
    agps_bool gps_satellite_enable;
    agps_bool glonass_satellite_enable;
    agps_bool beidou_satellite_enable;
    agps_bool galileo_satellite_enable;
    agps_bool a_glonass_satellite_enable;

    agps_bool gps_satellite_support;
    agps_bool glonass_satellite_support;
    agps_bool beidou_satellite_support;
    agps_bool galileo_satellite_support;

    agps_bool a_gps_satellite_enable;
    agps_bool a_beidou_satellite_enable;
    agps_bool a_galileo_satellite_enable;

    agps_bool mnl_support_lppe;
} agps_intf_gnss_setting;

typedef struct {
    int supl_profiles_num;
    agps_intf_supl_profile supl_profiles[SUPL_PROFILES_NUM];
    agps_intf_supl_profile cur_supl_profile;
    agps_intf_cdma_profile cdma_profile;
    agps_intf_agps_setting agps_setting;
    agps_intf_cp_setting cp_setting;
    agps_intf_up_setting up_setting;
    agps_intf_gnss_setting gnss_setting;
    agps_bool valid;
} agps_intf_agps_config;

#ifdef __cplusplus
}
#endif


#endif