#include<pthread.h>
#include<stdio.h>
#include<unistd.h>
#include<errno.h>
#include<string.h>
#include <sys/time.h>
#include <time.h>
#include <log/log.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <time.h>

#include"lynq_gnsshal.h"
#include"mtk_lbs_utility.h"
#include"lynq_gnss.h"

#define NMEA_ACC "ACCURACY"
#define NMEA_GSA "GSA"
#define NMEA_RMC "RMC"
#define NMEA_GGA "GGA"
#define NMEA_VTG "VTG"
#define NMEA_GSV "GSV"

time_t reopen_start;
extern lynq_gnss_cb* lynq_callbacks;
extern lynq_raw_gnss_cbs *lynq_meas_callbacks;

void lynq_gps_location_callback(GpsLocation_ext* location)
{   
    GpsLocation_ext* loc = (GpsLocation_ext *)location;
    lynq_GpsLocation_ext lynq_loc;
   //lynq_loc.legacyLocation.size = loc->legacyLocation.size;
    lynq_loc.legacyLocation.size = sizeof(lynq_GpsLocation_ext);
    lynq_loc.legacyLocation.flags = loc->legacyLocation.flags;
    lynq_loc.legacyLocation.latitude = loc->legacyLocation.latitude;
    lynq_loc.legacyLocation.longitude = loc->legacyLocation.longitude;
    lynq_loc.legacyLocation.altitude = loc->legacyLocation.altitude;
    lynq_loc.legacyLocation.speed = loc->legacyLocation.speed;
    lynq_loc.legacyLocation.bearing = loc->legacyLocation.bearing;
    lynq_loc.legacyLocation.accuracy = loc->legacyLocation.accuracy;
    lynq_loc.legacyLocation.timestamp = loc->legacyLocation.timestamp;
    lynq_loc.horizontalAccuracyMeters = loc->horizontalAccuracyMeters;
    lynq_loc.verticalAccuracyMeters = loc->speedAccuracyMetersPerSecond;
    lynq_loc.bearingAccuracyDegrees = loc->bearingAccuracyDegrees;
    lynq_callbacks->lynq_location_cb(&lynq_loc);
}

void lynq_gps_status_callback(GpsStatus* status)
{
    lynq_callbacks->lynq_status_cb(status);
}

void lynq_gps_sv_status_callback(GpsSvStatus* sv_info)
{

}
#ifdef GNSS_SYNC_TIME_CFG
extern int g_gnss_sync_enable_flag;
extern int g_gnss_sync_done;
#endif
#ifdef GNSS_ELT_OUTPUT_CFG
extern int g_ttyGS_fd;
extern bool Open_ELT;
#endif

static inline int update_systime_time(GpsUtcTime gpstime)
{
    struct timeval tv;
    int ret = gettimeofday(&tv, NULL);
    if (ret == -1) {
        perror("gettimeofday");
        return -1;
    }
    if (tv.tv_sec == gpstime / 1000)
    {
        return 0;
    }
    printf("Now: %ld.%06ld\n", tv.tv_sec, tv.tv_usec);
    tv.tv_sec = gpstime / 1000;
    tv.tv_usec = (gpstime % 1000) * 1000;
    ret = settimeofday(&tv, NULL);
    if (ret == -1) {
        perror("settimeofday");
        return -1;
    }

    return 0;
}

void lynq_gps_nmea_callback(GpsUtcTime timestamp, const char* nmea, int length)
{
#ifdef GNSS_ELT_OUTPUT_CFG
    int ret;
    time_t reopen_end;
#endif
#ifdef GNSS_SYNC_TIME_CFG
    if (g_gnss_sync_enable_flag == 1 && g_gnss_sync_done == 0)
    {
        if( strncmp(nmea+3,NMEA_RMC,strlen(NMEA_RMC)) == 0 && nmea[18] == 'A')
        {
            if (update_systime_time(timestamp) == 0)
            {
                g_gnss_sync_done = 1;
            }
        }
    }
#endif
#ifdef GNSS_ELT_OUTPUT_CFG
    if(Open_ELT)
    {
        if(g_ttyGS_fd >= 0)
        {
            ret = write(g_ttyGS_fd,nmea,length);
            if(ret<0)
            {
                close(g_ttyGS_fd);
                g_ttyGS_fd = -1;
                reopen_start = time(NULL);
            }
        }

        else
        {
            reopen_end = time(NULL);
            if(difftime(reopen_end,reopen_start) > 3)
            {
                g_ttyGS_fd= open(DEV, O_RDWR | O_NOCTTY | O_NDELAY);
                if(g_ttyGS_fd < 0)
                {
                    reopen_start = time(NULL);
                }
                else
                {
                    RLOGD("Open dev success\n");
                }
            }
        }
    }
#endif
    lynq_callbacks->lynq_nmea_cb(timestamp,nmea,length);

}

void lynq_gps_set_capabilities(uint32_t capabilities)
{

}

void lynq_gps_acquire_wakelock(void)
{

}

void lynq_gps_release_wakelock(void)
{

}

void lynq_gps_request_utc_time(void)
{

}

void lynq_set_system_info_cb(const GnssSystemInfo* info)
{

}

void lynq_gnss_sv_status_cb(GnssSvStatus_ext* sv_info)
{

}

pthread_t lynq_gps_create_thread(const char* name, void (*start)(void *), void* arg)
{
    lynq_callbacks->lynq_create_thread_cb(name,(void *(*)(void *))start,arg);
}

void lynq_gnss_set_name_cb(const char* name, int length)
{

}

void lynq_gnss_request_location_cb(bool independentFromGnss, bool isUserEmergency)
{

}

void lynq_agnss_location_callback(GpsLocation_ext* location) {

}


GpsCallbacks_ext lynq_gps_callbacks_gnss = {
    .size = sizeof(GpsCallbacks_ext),
    .location_cb = lynq_gps_location_callback,
    .status_cb = lynq_gps_status_callback,
    .sv_status_cb = lynq_gps_sv_status_callback,
    .nmea_cb = lynq_gps_nmea_callback,
    .set_capabilities_cb = lynq_gps_set_capabilities,
    .acquire_wakelock_cb = lynq_gps_acquire_wakelock,
    .release_wakelock_cb = lynq_gps_release_wakelock,
    .create_thread_cb = lynq_gps_create_thread,
    .request_utc_time_cb = lynq_gps_request_utc_time,
    .set_system_info_cb = lynq_set_system_info_cb,
    .gnss_sv_status_cb = lynq_gnss_sv_status_cb,
    .set_name_cb = lynq_gnss_set_name_cb,
    .request_location_cb = lynq_gnss_request_location_cb,
    .agps_location_cb = lynq_agnss_location_callback,
};

GpsCallbacks_ext* lynq__get_gps_callbacks(void)
{
    return &lynq_gps_callbacks_gnss;
}

void lynq_measurement_callback(GpsData *data)
{

}

void lynq_gnss_measurement_callback(GnssData_ext* data) 
{   
    lynq_meas_callbacks->lynq_measurement_callback(data);
    return;
}

GpsMeasurementCallbacks_ext lynq_test_raw_callbacks = {
    .size = sizeof(GpsMeasurementCallbacks_ext),
    .measurement_callback = lynq_measurement_callback,
    .gnss_measurement_callback = lynq_gnss_measurement_callback,
};

GpsMeasurementCallbacks_ext* lynq_gnss_get_raw_callbacks(void)
{
    return &lynq_test_raw_callbacks;
}


void lynq_at_gps_location_callback(lynq_GpsLocation_ext* location)
{
    at_gpsinfo_ok = 1;
    sprintf(gpsinfo, "+CGPSINFO: %.10lf,%.10lf,%f,%f,%.10lf,%f,%ld",location->legacyLocation.latitude \
            , location->legacyLocation.longitude, location->horizontalAccuracyMeters,location->legacyLocation.bearing \
            ,location->legacyLocation.altitude, location->legacyLocation.speed\
            ,location->legacyLocation.timestamp/1000);
}

void lynq_at_gps_status_callback(GpsStatus* status)
{

}

void lynq_at_gps_nmea_callback(GpsUtcTime timestamp, const char* nmea, int length)
{
    if (at_gpsnmea_status == 1)
    {
        if(strncmp(nmea+3,NMEA_GSA,strlen(NMEA_GSA))==0 || strncmp(nmea+3,NMEA_RMC,strlen(NMEA_RMC)) == 0 || \
            strncmp(nmea+3,NMEA_GGA,strlen(NMEA_GGA)) == 0 || strncmp(nmea+3,NMEA_VTG,strlen(NMEA_VTG)) == 0|| \
            strncmp(nmea+3,NMEA_GSV,strlen(NMEA_GSV)) == 0)
            {
                atsvc_gnss_outcb(nmea,strlen(nmea),1);
            }
    }
}



pthread_t lynq_at_gps_create_thread(const char* name, void (*start)(void *), void* arg)
{
    pthread_t at_ntid = 0;
    int ret = 0;

    ret = pthread_create(&at_ntid, NULL, (void *(*)(void *))start, arg);

    if(ret != 0)
    {
        printf("thread %s create fail(%s)!\r\n", name, strerror(errno));
        at_ntid = 0;
    }
    else
    {
        printf("tread %s create success!\r\n", name);
    }

    return at_ntid;
}

lynq_gnss_cb lynq_at_gnss_callbacks = {
    .size = sizeof(lynq_gnss_cb),
    .lynq_location_cb =lynq_at_gps_location_callback,
    .lynq_status_cb = lynq_at_gps_status_callback,
    .lynq_nmea_cb = lynq_at_gps_nmea_callback,
    .lynq_create_thread_cb = lynq_at_gps_create_thread,
};

lynq_gnss_cb* lynq_at_get__gnss_callbacks(void)
{
    return &lynq_at_gnss_callbacks;
}
