#include <stdio.h>   
#include <string.h>  
#include <stdlib.h>
#include <sys/time.h>
#include <errno.h>
#include <unistd.h>
#include <log/log.h>
 
#include "lynq_prop.h"

#define PROPBUF_SIZE 512


const char *mnl_prop_path[] = {
    "/etc/gnss/mnl.prop",   /*mainly for target*/
    "/sbin/mnl.prop",   /*mainly for emulator*/
};
 
int write_prop(const char *file_name, char* key, char* val) {
    if(NULL == file_name||NULL == key|| NULL == val)
    {
        RLOGD("incoming char error");
        return -1;
    }
    char linebuffer[PROPBUF_SIZE] = {0};
    char buffer1[PROPBUF_SIZE] = {0};
    char buffer2[PROPBUF_SIZE] = {0};

    int line_len = 0;
    int len = 0;
    int res;
    int changed = 0;
    FILE *fp = NULL;

    if (0 != access(file_name, F_OK)) {    // if file is not exit, create file
         RLOGD("access file error(%s), Try to create file", file_name);

         fp = fopen(file_name, "w");  //Create file
         if (fp == NULL) {
             RLOGD("create file %s fail(%s)", file_name, strerror(errno));
             return -1;
         }
    } else {
        fp = fopen(file_name, "r+");  //Read and write
        if(fp == NULL)
        {
            RLOGD("open error, %s", strerror(errno));
            return -1;
        }
    }

    while(fgets(linebuffer, PROPBUF_SIZE, fp)) {
        line_len = strlen(linebuffer);
        len += line_len;
        sscanf(linebuffer, "%[^=]=%[^=]", buffer1,buffer2);
        RLOGD("buffer1:%s, buffer2:%s", buffer1, buffer2);
        if(!strcmp(key, buffer1)) {
            len -= strlen(linebuffer);
            res = fseek(fp, len, SEEK_SET);
            if(res < 0) {
                RLOGD("fseek fail, %s", strerror(errno));
                fclose(fp);
                return -1;
            }
            RLOGD("Before modify [%s=%s] in file [%s]", buffer1, buffer2, file_name);
            memset(buffer2, 0, PROPBUF_SIZE);
            LYNQ_STRNCPY(buffer2, val, PROPBUF_SIZE);
            strncat(buffer1, "=", PROPBUF_SIZE - strlen(buffer1) - 1);
            strncat(buffer1, buffer2, PROPBUF_SIZE - strlen(buffer1) - 1);
            strncat(buffer1, "\n", PROPBUF_SIZE - strlen(buffer1) - 1);
            RLOGD("After modify [%s] in file [%s]", buffer1, file_name);
            changed = 1;
            fprintf(fp, "%s", buffer1);
            fclose(fp);
            return 0;
        }
    }
    if(changed == 0) {  //Not find key
        memset(linebuffer, 0, PROPBUF_SIZE);
        strncat(linebuffer, "\n", PROPBUF_SIZE - strlen(linebuffer) - 1);
        strncat(linebuffer, key, PROPBUF_SIZE - strlen(linebuffer) - 1);
        strncat(linebuffer, "=", PROPBUF_SIZE - strlen(linebuffer) - 1);
        strncat(linebuffer, val, PROPBUF_SIZE - strlen(linebuffer) - 1);
        strncat(linebuffer, "\n", PROPBUF_SIZE - strlen(buffer1) - 1);
        RLOGD("Add config [%s] to file [%s]", linebuffer, file_name);
        res = fseek(fp, 0, SEEK_END);
        if(res < 0) {
            RLOGD("fseek fail, %s", strerror(errno));
            fclose(fp);
            return -1;
        }
        fprintf(fp, "%s", linebuffer);

        fclose(fp);
    }
    return 0;
}

void mnld_write_cfg(char* key, char* val) {
    int idx;
    int cnt = sizeof(mnl_prop_path)/sizeof(mnl_prop_path[0]);

    for (idx = 0; idx < cnt; idx++) {
        if (!write_prop(mnl_prop_path[idx], key, val))
            break;
    }
}