#ifndef _RTK_FUN_H_
#define _RTK_FUN_H_

#define  RTK_SUPPORT
#define  ENABLE_RTKFUN		 //RTK�ĺ����ӿ�
#define  ENABLE_RTKCHANGEFREQ    //

#include "hardware/gps_mtk.h"
#include "hardware/gps.h"


typedef enum
{
	rtk_log_info,
	rtk_log_warn,
	rtk_log_err
} rtk_log_level;

typedef struct
{
	unsigned char  bPosFlag;   //��ǰ��״̬��0����Ч�� 1�����㣻 2��RTD(SBAS)�� 4��RTK fix�� 5��RTK float�� 6��Dead Reckoing�� 7��Fix pos mode�� 8��Sim mode
	unsigned char  bTrackNo;   //����������
	unsigned char  bSatNo;     //����������

	unsigned char  bRtkFlag;   //RTKԭʼ��״̬(0:ʧ��  1:����   3:����̶�    4:�̶�    5:����    12:����   13:����ƽ��    14:�Ƶ�)
	double	       fDiffAge;   //�������
	unsigned int   uGpsWeek;   //GPSʱ����
	double         fWeekSeconds;//GPSʱ��������
	double         fUTC;       //UTCʱ�������1970-01-01 00:00:00��ʼ����
	double		   fLeapSeconds;//����


	double         fPosX; 	   //X����(m)(WGS84)
	double         fPosY; 	   //Y����(m)(WGS84)
	double         fPosZ;      //Z����(m)(WGS84)
	float	       fPosXDelta; //X����ı�׼���
	float	       fPosYDelta; //Y����ı�׼���
	float	       fPosZDelta; //Z����ı�׼���

	double         fLat;  	   //γ�ȣ���λ�ȣ�
	double         fLong; 	   //���ȣ���λ�ȣ�
	double         fAlt;       //���θߣ���λm��
	double 		   fHeightOfGeoid;//�߳��쳣����λm��
	float          fLatStd;    //γ�ȱ�׼��
	float          fLongStd;   //���ȱ�׼��
	float          fAltStd;    //���θ� ��׼��

	double         fVelX; 	   //X������ٶȣ�m/s��
	double         fVelY;      //Y������ٶ�
	double         fVelZ;      //Z������ٶ�
	float	       fVelXDelta; //X�����ٶȱ�׼��
	float	       fVelYDelta; //Y�����ٶȱ�׼��
	float	       fVelZDelta; //Z�����ٶȱ�׼��

	float          fVelN; 	   //�������ٶȣ�m/s)
	float          fVelE;      //�������ٶȣ�m/s)
	float          fVelU;      //�췽���ٶȣ�m/s)
	float          fVelNDelta; //�������ٶȱ�׼�m/s)
	float          fVelEDelta; //�������ٶȱ�׼�m/s)
	float          fVelUDelta; //�췽���ٶȱ�׼�m/s)

	float	       fHorSpeed;  //�Ե��ٶȣ�m/s)
	float	       fHorSpeedDelta;//�Ե��ٶȱ�׼�m/s)

	float	       fTrueHeading;//���溽��,�켣����ǣ��ȣ����˶�����
	float	       fTrueHeadingDelta;//�켣����Ǳ�׼��ȣ�

	float		   fHeading2Ant; //˫���ߺ����ݲ�֧�֣����켣����Ǹ�ֵ��
	float		   fHeading2AntDelta; //˫���ߺ��򾫶ȣ��ݲ�֧�֣����켣����ǵı�׼�ֵ��

	float	       fRangeRms;  //α�ྫ��
	float	       fPhaseRms;  //�ز�����

	float  	       fHDOP;	   //HDOP
	float 	       fPDOP;      //PDOP
	float          fVDOP;      //VDOP
	float	 	   fCN0;	   //��ǰ���붨λ���ǵľ�ֵCN0(dBHz)

	double		   fClkTime;   //��ӦMTK���ڲ�gps_clock�е�time_ns�ֶ�

	int 		   iBaseStatus;//ͬrtk_base_sdkstatus��������״̬
	//RTK����״̬
	//0x00000001��ʾ�޻�վ����
	//0x00000002��ʾ��Ч���ǵ���10��
	//0x00000004��ʾ��Ч��������Ⱦ�ֵ������ֵ��Ĭ��24��
	//0x00000008��ʾRTK�������ʧ�ܣ�����ʧ�ܰ������ǹ��٣��۲������������ȵͣ���������ȣ�
	//0x00000010��ʾRTKδ������㣨δ�������ԭ������޻�վ���ݡ��л�վ���ݵ��ӳٴ���200��PVT��λʧ�ܡ�ʱ���ж��쳣�ȣ�
	int 		   iRtkStatus;

}rtk_result_info;

typedef void  (*rtk_out_debuginfo)(const char * pBuff, const int length, const int ilevel);
typedef void  (*rtk_out_postdata)(const unsigned char * pBuff, const int length);
typedef void  (*rtk_out_basesdkstatus)(const int status);
typedef void  (*rtk_out_status)(const int status);

typedef void  (*rtk_out_result)(const rtk_result_info * prtk);
typedef void  (*rtk_out_result_nmea)(const char * strnmea, const int length);

#ifdef __cplusplus
extern "C" {
#endif

//rtk��ʼ��
extern void rtk_init();

//ͨ�������û����������½
extern void rtk_set_UserInfo(const char* user, const char* pwd);

//�����豸ID��½
extern void rtk_set_DeviceID(const char* device_id);

//�����ƶ�վMTK��NMEA����(GGA/RMC/VTG/GSA/GSV/GST)
extern void rtk_rove_addnmea(const unsigned char * pBuff, const int iBuffLen);

//�����ƶ�վMTK�Ĺ۲���
extern void rtk_rove_addrawmess(GnssData_ext* data);

//�����ƶ�վMTK��ԭʼ������֡
extern int  rtk_rove_addrawnav(GnssNavigationMessage * msg);

//rtk��������Ϣ
extern void rtk_result_cb(rtk_out_result pRtk);

//rtk��Nmea���Ľ��(GGA/RMC/VTG/GSA/GSV/GST)
extern void rtk_result_nmea_cb(rtk_out_result_nmea pNmea);

//rtk�Ĵ�ӡ��Ϣ,������Ϊ��
extern void rtk_config_log(rtk_out_debuginfo pLog);

//rtk��������,������Ϊ��
extern void rtk_config_post(rtk_out_postdata pOut);

//��վ ��������ݣ�������״̬(�������SDK״̬��)
extern void rtk_base_sdkstatus(rtk_out_basesdkstatus pBaseStatus);

//rtk�����Ƿ�ر�ĳϵͳ
//bSys------1(GPS)  2(GLO)  3(GAL)   4(QZS)   5(BD2)  6(BD3)
//bLock-----l(Lock) 0:(unLock)
extern void rtk_config_lockout(const unsigned char bSys, const unsigned char bLock);

//��ȡRTK�汾�����20�ֽڣ�
extern void rtk_version(char * strVer);

//rtk�Ƿ��������
//0:����������Ĭ��״̬��
//1:�������ߣ�rtk�ӿڲ��ٽ����������룬����sdk���������ͽ������ݣ�ֹͣ������
//2:���뵥�㶨λ״̬��rtk�ӿڽ��������������������sdkֹͣ����
extern void rtk_gotosleep(const unsigned char bMode);

//��ȡ��ǰ���õ�DeviceID�����128�ֽڣ�
extern void rtk_get_DeviceID(char* device_id);

//���÷�����IP��ַ�ӿ�
//server_ip:��������ַ
extern void rtk_setServerIP(const char* server_ip);

//����RTK�Ľ�����Ҫ��͵�����ȣ�Ĭ��24
extern void rtk_setCN0(const unsigned char bCN0);

//����RTK״̬��ӿڣ��������SDK��״̬��+RTK״̬�룬RTK״̬�����¶���)
//���������ԭʼ�۲�����Ƶ�ʸ���RTK״̬�룬״̬��ύ����֣�����ԭʼ����������ÿ�����һ��״̬���������ߺ������
//4001:��ԭʼ��������(����3�뼰����)
//4002:��NMEA��������(����3�뼰����)
//4003:����Ч�����������
//4004:PVTδ��λ
//4005:�����ź���(����Ⱦ�ֵ <30)
//4006:�����ź�һ��(����Ⱦ�ֵ30~35)
//4007:�����źź�(����Ⱦ�ֵ35~40)
//4008:�����ź�ǿ(����Ⱦ�ֵ >40)
extern void rtk_status_update(rtk_out_status pRtkStatus);


#ifdef __cplusplus
}
#endif


#endif /* _RTK_FUN_H_ */
