#ifndef __LYNQ_GET_THERMAL_H__
#define __LYNQ_GET_THERMAL_H__

#define LYNQ_THM_PATH 256

#define TYPE_PATH_PRE "/sys/class/thermal"

#define LYNQ_THM_OK 0
#define LYNQ_THM_OPEN_ERROR -1
#define LYNQ_THM_READ_ERROR -2
#define LYNQ_THM_ACCESS_ERROR -3
#define LYNQ_THM_ZONE_ERROR -4

#define LYNQ_THM_ZONE_KEY "thermal_zone"
#define LYNQ_THM_COOLER_KEY "cooling_device"

typedef enum {
    soc_max=0,
    cpu0,
    cpu1,
    cpu2,
    cpu3,
    gpu0,
    gpu1,
    dramc,
    mmsys,
    md_5g,
    md_4g,
    md_3g,
    soc_dram_ntc,
    pa_5g,
    pa_4g,
    rf_ntc,
    pmic,
    pmic_vcore,
    pmic_vpro,
    pmic_vgpu=19,
} ZONE_NUM;

char* lynq_read_version();
int read_sys_info(char *sys_path, char *out_buf, int out_buf_len);
int lynq_get_zone_tmp(ZONE_NUM num, int *temp);

#endif  //__LYNQ_GET_THERMAL_H__