#!/bin/sh

if [ "$1" == "start" ]; then
        ifconfig wlan0 up
        if [ $? != 0 ]; then
                exit 1
        fi
		ps -eo "%p %a" | grep "dhcpcd wlan0" | grep -v grep
		if [ $? != 0 ];	then
			echo "" > /tmp/wlan0_dhcpcd_router
			mkdir -p /run/wg870/
			hook_script="/run/wg870/wlan0_dhcpcd_run_hooks.sh"
			echo "#!/bin/sh" > $hook_script
			echo "if [ \"\$reason\" == \"BOUND\" -o \"\$reason\" == \"RENEW\" -o \"\$reason\" == \"REBIND\" ]; then" >> $hook_script
			echo "    if [ \"\$new_routers\" != \"\" ]; then" >> $hook_script
			echo "        for x in \$new_routers; do" >> $hook_script
			echo "            echo \"new_router \$x\" > /tmp/wlan0_dhcpcd_router" >> $hook_script
			echo "            ping -c2 \$x &" >> $hook_script
			echo "        done" >> $hook_script
			echo "    fi" >> $hook_script
			echo "fi" >> $hook_script
			chmod +x $hook_script
			dhcpcd wlan0 -t 0 -o domain_name_servers --noipv4ll -4 -B -G -c $hook_script &
		fi
elif [ "$1" == "stop" ]; then
        ps -eo "%p %a" | grep "dhcpcd wlan0" | grep -v grep | awk '{print "kill "$1}' | sh
        ifconfig wlan0 0.0.0.0
        if [ $? != 0 ]; then
                exit 1
        fi
else
        exit 2
fi

exit 0
