#include <stdio.h>
#include <string.h>
#include <pthread.h>
#include <ctype.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <gio/gio.h>
#include <log/log.h>
#include <glib.h>
#include "common.h"
#include "gpio/gpio_test.h"
#define GPIO_SERVICE "gpio.lynq" /*well-known bus name */
#define GPIO_DATA_INTERFACE "gpio.lynq.Data" /*interface name*/
#define GPIO_DATA_PATH "/gpio/lynq/data" /*object name*/
GMainLoop *loop = NULL;
GDBusProxy *proxy = NULL;
#define LOG_TAG "GPIO_CONTROL"
int set_gpio (char * mode,int gpio_numb,int param){
	GDBusConnection *c1;
	GVariant *result;
	GError *error;
	GMainLoop *loop;
	gint32  set_result = -1;
	g_type_init();
	loop = g_main_loop_new(NULL, FALSE);   /** create main loop, but do not start it.*/
	error = NULL;
	c1 = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &error);
	g_assert_no_error (error);
	error = NULL;
	g_assert (c1 != NULL);
	g_assert (!g_dbus_connection_is_closed (c1));
	result = g_dbus_connection_call_sync (c1,
                                        GPIO_SERVICE,  /* bus name */
                                        GPIO_DATA_PATH, /* object path */
                                        GPIO_DATA_INTERFACE,  /* interface name */
                                        "setGpio",                 /* method name */
                                        g_variant_new ("(sii)", mode,gpio_numb,param),  /* parameters */
                                         G_VARIANT_TYPE ("(i)"),                    /* return type */
                                        G_DBUS_CALL_FLAGS_NONE,
                                        -1,
                                        NULL,
                                        &error);
										
	g_assert_no_error (error);
	g_assert (result != NULL);
	g_variant_get(result, "(i)", &(set_result));
	  RLOGD("%s, %s, %d,result:%d", __FILE__, __FUNCTION__, __LINE__,set_result);
	g_variant_unref (result);
	//g_main_loop_run (loop);
	g_main_loop_unref (loop);
    return set_result;
}
int set_gpio143(){
 
  int   result;
  result = set_gpio (GPIO_MODE,WIFI_LED_CONTROL,1);
  return result;
 // sprintf(output, "gpio set stauts %d\n",result);
 // printf("%s",output);
 // emResultNotify(output);
}
void get_gpio (guint gpio_numb,gchar *response){
   	GDBusConnection *c1;
	GError *error;
	GMainLoop *loop;
   //	char output[2048] = {0};
   	//gchar *response;
   	GVariant *get;
	gsize n_elts=0;
	GVariantIter *iter;
	//guchar *response;
	gchar *get_res;
//	const char *p;
	g_type_init();
	loop = g_main_loop_new(NULL, FALSE);   /** create main loop, but do not start it.*/
	error = NULL;
	c1 = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &error);
	g_assert_no_error (error);
	error = NULL;
	g_assert (c1 != NULL);
	g_assert (!g_dbus_connection_is_closed (c1));
	error = NULL;
	get = g_dbus_connection_call_sync (c1,
                                        GPIO_SERVICE,  
                                        GPIO_DATA_PATH, 
                                        GPIO_DATA_INTERFACE,  
                                        "getGpio",                 
                                        g_variant_new ("(i)",gpio_numb), 
                                         G_VARIANT_TYPE ("(s)"),                     
                                        G_DBUS_CALL_FLAGS_NONE,
                                        -1,
                                        NULL,
                                        &error);
	g_assert_no_error (error);
	g_assert (get != NULL);
	g_variant_get (get, "(s)",&get_res);
	strcpy(response, get_res);
	g_variant_unref (get);
	RLOGD("get_gpio,%s",response);
	g_main_loop_unref (loop);
}
void get_gpio143(int command){
  char output[1024] = {0};
  char output1[2048] = {0};
  get_gpio (WIFI_LED_CONTROL,output);
  printf("get_gpio143,%s\n",output);
  sprintf(output1, "Factory_result gpio143 set state:%s\n",output);
  printf("%s",output1);
  emResultNotify(output1,command);
}
void proxy_ready(GObject *source, GAsyncResult *result, gpointer user_data) {
    GError *error;

    error = NULL;
    proxy = g_dbus_proxy_new_for_bus_finish(result, &error);
    if (proxy == NULL) {
        RLOGE("create proxy fail");
        return ;
    }
    RLOGD("proxy is ready");
   // gulong signal_handler_id;

  //  signal_handler_id = g_signal_connect(proxy, "g-signal",
  //          G_CALLBACK (proxy_signals_on_signal), NULL);
   // if (signal_handler_id == 0) {
   //     RLOGE("listen singal fail!");
   // }
}

void* init_data_gdbus_cb(void *param)
{
    /* all the tests rely on a shared main loop */
    loop = g_main_loop_new(NULL, FALSE);

    g_dbus_proxy_new_for_bus(G_BUS_TYPE_SYSTEM,
            G_DBUS_PROXY_FLAGS_NONE,
            NULL, /* GDBusInterfaceInfo */
            GPIO_SERVICE, /* name */
            GPIO_DATA_PATH, /* object path */
            GPIO_DATA_INTERFACE, /* interface */
            NULL, /* GCancellable */
            proxy_ready,
            NULL);

    g_main_loop_run(loop);

    RLOGD("data gdbus main loop run()");
    if(proxy != NULL) {
        g_object_unref (proxy);
    }
    if(loop != NULL) {
        g_main_loop_unref(loop);
    }
}


void startGdbusLoop(void)
{
    pthread_t gpioThread;

    RLOGD("startGdbusLoop()");
   // pthread_mutex_lock(&s_startupMutex);
    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);

    int result = pthread_create(&gpioThread, &attr, init_data_gdbus_cb, NULL);
    if (result != 0) {
        RLOGW("Failed to create gdbus thread: %s", strerror(result));
        //goto done;
    }
//done:
 //   pthread_mutex_unlock(&s_startupMutex);
}
