
/* gets example */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "fota_test.h"
#include "function_common.h"
#include<unistd.h>

#ifdef __cplusplus
extern "C" {
#endif
//#include "liblynq-broadcast/broadcast_send.h"
#include <gio/gio.h>
#include <glib.h>
//#include "liblynq-driver/libdriver.h"

#ifdef __cplusplus
}
#endif

#define BUFFER_SIZE 8192
#define USER_LOG_TAG "FUNCTION_TEST"
#define MAX_ARGS 5
typedef enum {
    API_MENU = 1,
    DEMO_MENU,
}TEST_MAIN_ITEM;
typedef enum{
    API_WIFI=0,
	API_AUDIO,
        API_FOTA,
} API_MOUDLE;



static void getCallback(const char* str_arg, int int_arg )
{
    //printf("SignalCallback,str_arg:%s,int_arg:%d\n", str_arg,int_arg);
    LYVERBLOG("SignalCallback,str_arg:%s,int_arg:%d\n", str_arg,int_arg);

    return;
}

void hold_on(){
    char any[5]={ 0 };
    printf("Press any key to return\n");
    fgets(any, 5, stdin);
}

int parse_param(char *cmd, char *argv[], int max_args){
    char *pos, *pos2;
    int argc = 0;

    pos = cmd;
    while (1) {
        // Trim the space characters.
        while (*pos == ' ') {
            pos++;
        }

        if (*pos == '\0') {
          break;
        }

        // One token may start with '"' or other characters.
        if (*pos == '"' && (pos2 = strchr(pos + 1, '"'))) {
            argv[argc++] = pos + 1;
            *pos2 = '\0';
            pos = pos2 + 1;
            if (*pos == '\n'){
                *pos = '\0';
                pos = pos + 1;
            }
        }
        else {
            argv[argc++] = pos;
            while (*pos != '\0' && *pos != ' '&& *pos != '\n') 
                {
                    if (*pos == '"' && (pos2 = strchr(pos + 1, '"'))) 
                    {
                        pos = pos2 ;
                    }
                    else
                    pos++;
                }
            *pos++ = '\0';
        }

    // Check if the maximum of arguments is reached.
        if (argc == max_args) {
            break;
        }
    }

    return argc;
}
int getRilModule(char *module)
{
    if (module==NULL)
    {
       //printf("[ERROR] Please input module,and try again!");
       // LYVERBLOG("+[command error]:error num = %d\n",MENU_INPUT_ERROR);
        return -1;
    }
    if(!strcmp(module,"WIFI"))
    {
        return API_WIFI;
    }
    else if(!strcmp(module, "fota"))
    {
        return API_FOTA;
    }
/*
    else if(!strcmp(module, "AUDIO"))
    {
        return API_AUDIO;
    }
*/
    else
    {
       LYVERBLOG("+[command error]:error num = %d\n",MENU_INPUT_ERROR);
       // printf("can not find %s API  module ",module);
        return -1;
    }
    return -1;
}

int api_start(int argc, char *argv[]){
    LYDBGLOG("api_start,argc:%d\n",argc);
    char *menu[2] = {0};// menu[0] is the "moudle",menu[1] is the "API"
    char* argvHead=NULL;
    int module = -1;
    argvHead = getMenu(argv[2],menu);//find the "module" and the "API"
    module = getRilModule(menu[0]);
   // if(argvHead == NULL)
   // {
    //     printf("pram api error\n");
    //     return 0;
   // }
    switch(module)
    {
        /* Add the code of the owner modules below*/
        case API_AUDIO:
        {
            //audio_test(menu[1],argvHead);
            break;
        }
	case API_FOTA:
	{
		fota_test(menu[1],argvHead);		
		break;
	}
        case API_WIFI:
            break;
        default:
          //  printf("pram module error\n");
          LYVERBLOG("+[command error]:error num = %d\n",MENU_INPUT_ERROR);

            break;
    }
   // hold_on(); //add by zhouqunchao delete help message
    return 1;
}

int function_start(int argc, char *argv[])
{
	int select_menu = atoi(argv[0]);
	int thread = atoi(argv[1]);
	// printf("select_menu:%d,thread:%d\n",select_menu,thread);
 	switch(select_menu)
	{
		case API_MENU:
		{
			if (thread == 1)//rita add @2021.6.21 for threadhandle test
			{
				LYDBGLOG("[%s-%d] argv[2] = [%s]\n", __FUNCTION__, __LINE__, argv[2]);
				if(strlen(argv[2])){//rita add @2021.6.21 for data error
					LYDBGLOG("[%s-%d] argv[2] = [%s]\n", __FUNCTION__, __LINE__, argv[2]);
					//send_broadcast_by_name("function", strlen(argv[2]), argv[2]);
				}
				else{
					LYVERBLOG("+[thhandle]: error num = %d\n", INVALID_CMD);
					return INVALID_CMD;
				}
			}
			else if(thread ==2){//rita add @2021.6.21 for local test
				api_start(argc,argv);
			}
			else{
				//printf("thread 1,local 2\n");
				LYDBGLOG("thread 1,local 2\n");
			}
			break;
		}
		case DEMO_MENU:
		{
			//printf("DEMO_MENU\n");
			LYDBGLOG("DEMO_MENU\n");
			break;
		}
		default:
        break;
    }
    return 0; 
}


void help_display(){
    printf("\n");
    printf("*****************************************************************************\n");
    printf("0:help ------- help\n");
    printf("*****************************************************************************\n");
    printf("1:API TEST\n" );
    printf("          1-1:Async api-\n" );
    printf("                        --MQTT\n" );
    printf("\n");
    printf("                        --HTTP\n" );
    printf("          1-2:Sync api-\n" );
    printf("                        --GPIO\n" );
    printf("\n");
    printf("                        --RIL\n" );
    printf("\n");
    printf("                        --WIFI\n" );
    printf("\n");
    printf("                        --GNSS\n" );
    printf("\n");
    printf("                        --SERVICE\n" );
    printf("*****************************************************************************\n");
    printf("2:DEMO TEST:Subsequent updates\n" );
    printf("*****************************************************************************\n");
    printf("\n");
    printf("1:API TEST The format is as follows :\n" );
    printf("{menu}-{mode selection} moudle=\"{moudle}\"&API=\"{api interface}\"&session=\"{session id}\"\"&parameterA=\"{parameter A}\"\n" );
    /*
    printf("The main parameters are as follows:\n");
    printf("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    printf("menu:1--API TEST,2--DEMO TEST\n" );
    printf("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    printf("mode selection:1--async api,2--sync api\n" );
    printf("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    printf("moudle:Test module--includes the following modules\n" );
    printf("RIL, GPIO,MQTT,HTTP,WIFI,GNSS\n" );
    printf("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    printf("api interface:--Interface corresponding to module\n" );
    printf("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    printf("session id:--Used to distinguish different session groups of the same module\n" );
    printf("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    printf("parameter A:--API parameter,Add format {\"&parameter_name=\"{parameter}\"} \n" );
    printf("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    */
    printf("Select menu:\n");
}
void menu_display(){
    printf("\n");
    printf("**********************\n");
    printf("0:help menu\n");
    printf("1:API TEST\n");
    printf("2:DEMO TEST\n");
    printf("**********************\n");
    printf("\n");
    printf("Select menu:\n");
}
int main()
{   
    LYLOGEINIT(USER_LOG_TAG);
   // LYLOGSET(4);

    /*Check whether the modem works correctly and start the corresponding service*/  //add by liulei
    char buf[1024]={0};

    while (1) {
        char *argv[MAX_ARGS];
        char str[BUFFER_SIZE]={ 0 };
        menu_display();
        fgets(str, BUFFER_SIZE, stdin);
        LYDBGLOG("[%s-%d] str= [%s]\n", __FUNCTION__, __LINE__, str);
        str[strlen(str)-1]='\0';
        if(!strcmp(str, "0")){
           help_display();
           //hold_on(); //add by zhouqunchao delete help message
           continue;
        }
        if(!strcmp(str,"quit"))
        {   
            //system("killall lynq-framework-service");
           break;
        }
        if ((strncmp(str,"1-",2) == 0)||
           (strncmp(str,"2-",2)== 0))
        {
         char* at_cmd = strstr(str, "-");
         strncpy(at_cmd, " ", 1);
        LYDBGLOG("[%s-%d] at_cmd = [%s]\n", __FUNCTION__, __LINE__, at_cmd);

	
         int argc = parse_param(str, argv, MAX_ARGS);
   //add by zqc  Format error judgment start
        if(argv[2] == NULL)
        {
        LYVERBLOG("+[command error]:error num = %d\n",MENU_INPUT_ERROR);
        continue;
        }
        //add by zqc  Format error judgment end
         function_start(argc,argv);
         continue;
        }
        else{
        // printf("pram error\n");
         LYVERBLOG("+[command error]:error num = %d\n",MENU_INPUT_ERROR);
         continue;
        }
   }
return 0;
}

