
#include "includes.h"

#include "common.h"
#include "../common/ieee802_11_defs.h"
#include "../common/ieee802_11_common.h"
#include "hostapd.h"
#include "../drivers/driver_nl80211.h"

#include "../../wapilib_softap/include/wai_utils_s.h"
#include "wpa_supplicant_i.h"
#include "ap/ap_drv_ops.h"
#include "sta_info.h"

void wapiap_lib_handshakepkt_from_sta(u8 *sta_addr, void *buf, int len, char *ifname);

struct hostapd_data *hostapd;


int brcm_wapiap_startassoc(const u8 *ie, int ielen, const u8 *sta_mac, char *ifname)
{
	int ret = 0;

	wpa_printf(MSG_INFO, "%s :Entered\n", __FUNCTION__);

	ret = wapiap_lib_startassoc(sta_mac, ie, ielen, ifname);

	if (ret != 0)
		wpa_printf(MSG_ERROR, "%s: Failed\n", __FUNCTION__);

	return ret;
}

void brcm_wapiap_handshakepkt_from_sta(u8 *sta_mac, void *buf, int len, char *ifname)
{
	wapiap_lib_handshakepkt_from_sta(sta_mac, buf, len, ifname);
}

void brcm_wapiap_inithostapd(struct hostapd_data *hapd, char *ifname)
{
	wpa_printf(MSG_INFO, "%s :Entered\n", __FUNCTION__);
	hostapd = hapd;
	wapiap_set_hapd(hostapd, ifname);
}

void brcm_wapiap_initialize(void *ctx, int wapiap_tx_sock,
		struct i802_bss *bss, struct wpa_ssid *ssid)
{
	wpa_printf(MSG_INFO, "%s :Entered\n", __FUNCTION__);

	wpa_printf(MSG_INFO, "%s : wapiap_tx_sock=%d bss->ifname=%s bss->ifindex=%d "
			"bss->addr=" MACSTR "ssid->ssid=%s ssid->ssid_len=%d ssid->passphrase=%s\n",
			__FUNCTION__, wapiap_tx_sock, bss->ifname, bss->ifindex, MAC2STR(bss->addr),
			ssid->ssid, ssid->ssid_len, ssid->passphrase);
	wapiap_lib_initialize(ctx, wapiap_tx_sock, bss->ifname,
				bss->ifindex, bss->addr, ssid->ssid,
				ssid->ssid_len, ssid->passphrase);
}

int brcm_wapiap_set_key(const char *ifname, const u8 *addr,
		int key_idx, int set_tx, const u8 *seq,
		size_t seq_len, const u8 *key, size_t key_len)
{
	wpa_printf(MSG_INFO, "%s :Entered\n", __FUNCTION__);

	if (hostapd == NULL){
		wpa_printf(MSG_ERROR, "%s :hostapd is null\n", __FUNCTION__);
		return -1;
	}
	else
		wpa_printf(MSG_INFO, "%s :hostapd is not null\n", __FUNCTION__);

	return hostapd_drv_set_key(ifname, hostapd, WAPI_ALG_SMS4,
		addr, key_idx, set_tx, seq, seq_len, key, key_len);
}

void brcm_wapiap_set_port_authorized(void *hapd_ctx, const u8 *addr, int authorized)
{
	struct hostapd_data *hostapd_ctx = (struct hostapd_data *) hapd_ctx;
	struct sta_info *sta = ap_get_sta(hapd_ctx, addr);

	wpa_printf(MSG_INFO, "%s: sta="MACSTR" authorized=%d\n", __FUNCTION__, MAC2STR(addr), authorized);
	ieee802_1x_set_port_authorized(hapd_ctx, sta, authorized);
}

void brcm_wapiap_unset_hostapd(void)
{
	wpa_printf(MSG_INFO, "%s : unsetting hostapd\n", __FUNCTION__);
	hostapd = NULL;
}
