#
# Copyright (C) 2008 The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
LOCAL_PATH := $(call my-dir)

ifeq ($(WPA_SUPPLICANT_VERSION),VER_0_8_X)

ifneq ($(BOARD_WPA_SUPPLICANT_DRIVER),)
  CONFIG_DRIVER_$(BOARD_WPA_SUPPLICANT_DRIVER) := y
endif

WPA_SUPPL_DIR = $(LOCAL_PATH)/..
WPA_SRC_FILE :=

include $(WPA_SUPPL_DIR)/wpa_supplicant/android.config

L_CFLAGS := -Wno-unused-variable -Wno-typedef-redefinition -Wno-macro-redefined
# Disable unused parameter warnings
L_CFLAGS += -Wno-unused-parameter -Wno-unused-function -Wno-format

ifeq ($(filter 12 13, $(PLATFORM_VERSION)),)
L_CFLAGS += -Wno-error-sometimes-uninitialized
endif

L_CFLAGS += -Wno-incompatible-pointer-types
L_CFLAGS += -Wno-incompatible-pointer-types-discards-qualifiers
L_CFLAGS += -Wno-sign-compare
L_CFLAGS += -Wno-unused-function
L_CFLAGS += -Wno-unused-parameter

L_CFLAGS += -Wno-implicit-function-declaration

WPA_SUPPL_DIR_INCLUDE = $(WPA_SUPPL_DIR)/src \
	$(WPA_SUPPL_DIR)/src/common \
	$(WPA_SUPPL_DIR)/src/drivers \
	$(WPA_SUPPL_DIR)/src/l2_packet \
	$(WPA_SUPPL_DIR)/src/utils \
	$(WPA_SUPPL_DIR)/src/wps \
	$(WPA_SUPPL_DIR)/wpa_supplicant
ifdef CONFIG_DRIVER_NL80211
WPA_SUPPL_DIR_INCLUDE += bionic/libc/arch-$(TARGET_ARCH)/include
WPA_SUPPL_DIR_INCLUDE += bionic/libc/include
WPA_SUPPL_DIR_INCLUDE += bionic/libc/kernel/common
WPA_SUPPL_DIR_INCLUDE += external/libnl_2/include
WPA_SUPPL_DIR_INCLUDE += external/libnl_2/include/linux
WPA_SUPPL_DIR_INCLUDE += external/libnl-headers
WPA_SUPPL_DIR_INCLUDE += external/libnl/include
WPA_SRC_FILE += driver_cmd_nl80211.c
endif

ifdef CONFIG_DRIVER_NL80211_IFX
L_CFLAGS += -DCONFIG_DRIVER_NL80211_IFX

# Broadcom merges
L_CFLAGS += -DCONFIG_BRCM_MERGES

# Retain old code to avoid some crash
L_CFLAGS += -DCONFIG_AP_VHT
endif

ifdef CONFIG_CTRL_IFACE_HIDL
WPA_SUPPLICANT_USE_HIDL=y
L_CFLAGS += -DCONFIG_HIDL -DCONFIG_CTRL_IFACE_HIDL
endif

ifdef CONFIG_CTRL_IFACE_AIDL
L_CFLAGS += -DCONFIG_AIDL -DCONFIG_CTRL_IFACE_AIDL
endif

ifdef CONFIG_BRCM_NAN
L_CFLAGS += -DBCM_GENL
endif

#ifdef CONFIG_BRCM_BT_WIFI_HO
#L_CFLAGS += -DCONFIG_BRCM_BT_WIFI_HO
#endif

ifdef CONFIG_P2P
L_CFLAGS += -DCONFIG_P2P
endif

ifdef CONFIG_BRCM_64BIT
L_CFLAGS += -DCONFIG_BRCM_64BIT
endif

ifdef CONFIG_WAPI
WPA_SUPPL_DIR_INCLUDE += $(WPA_SUPPL_DIR)/src/wapi
endif

#ifdef CONFIG_DRIVER_WEXT
#WPA_SRC_FILE += driver_cmd_wext.c
#endif

# To force sizeof(enum) = 4
ifeq ($(TARGET_ARCH),arm)
L_CFLAGS += -mabi=aapcs-linux
HOSTAPD_CFLAGS += -mabi=aapcs-linux
endif

# To make P2P working in existing Android framework (below KLP)
# with kernels below linux-3.8
ifdef CONFIG_P2P_HACK_PRE38
L_CFLAGS += -DCONFIG_P2P_HACK_PRE38
endif

# To make P2P working in existing Android framework (below KLP)
# with kernels linux-3.8 and above
ifdef CONFIG_P2P_HACK_POST38
ifdef CONFIG_P2P_HACK_PRE38
$(error "CONFIG_P2P_HACK_PRE38 and CONFIG_P2P_HACK_POST38 are mutually exclusive")
endif
L_CFLAGS += -DCONFIG_P2P_HACK_POST38
endif

# To Support SD offload
ifdef CONFIG_BRCM_SDO
SUPP_CFLAGS += -DBCM_SDO -DANDROID_P2P -DBCM_GENL
# Enable BCM_MAP_SDCMDS_2_SDOCMDS to map old wpa_cli commands to SD offloaded Commands
#SUPP_CFLAGS += -DBCM_MAP_SDCMDS_2_SDOCMDS
endif
HOSTAPD_CFLAGS += -DHOSTAPD

ifdef CONFIG_ANDROID_LOG
L_CFLAGS += -DCONFIG_ANDROID_LOG
HOSTAPD_CFLAGS += -DCONFIG_ANDROID_LOG
endif

#Enable and configure firmware for driver based roaming
ifdef CONFIG_BRCM_DRV_ROAM
L_CFLAGS += -DBRCM_DRV_ROAM
endif

ifdef CONFIG_IEEE80211R
L_CFLAGS += -DCONFIG_IEEE80211R
HOSTAPD_CFLAGS += -DCONFIG_IEEE80211R
endif

ifdef CONFIG_BRCM_VE
L_CFLAGS += -DBRCM_VE
endif

ifdef CONFIG_WAPI
L_CFLAGS += -DWAPI
endif

ifdef CONFIG_CTRL_IFACE_DBUS
L_CFLAGS += -DCONFIG_CTRL_IFACE_DBUS
endif

ifdef CONFIG_AP
L_CFLAGS += -DCONFIG_AP
HOSTAPD_CFLAGS += -DCONFIG_AP
endif

ifdef CONFIG_BRCM_GENL
L_CFLAGS += -DBCM_GENL
endif

ifdef CONFIG_BRCM_AUTOMOTIVE
L_CFLAGS += -DCONFIG_BRCM_AUTOMOTIVE
endif

#If you are using Android Oreo Master branch then you will get PLATFORM_VERSION as alphanbet (e.g P,Q)
#If you are using perticulat tag from android AOSP then you will get PLATFORM_VERSION as a NUMBER (e.g 9 - for Android P)
#this you can confirm after setting the evnsetup for target device during "lunch" command.
ifneq ($(filter O P 8.0.0 8.1.0 9 10 11 12 13,$(PLATFORM_VERSION)),)
L_CFLAGS += -DABOVE_8_1
ABOVE_8_1=y
endif

ifndef ABOVE_8_1
WPA_SUPPL_DIR_INCLUDE += bionic/libc/include
endif

ifndef CONFIG_DRIVER_WEXT
########################
include $(CLEAR_VARS)
LOCAL_MODULE := lib_driver_cmd_bcmdhd_supplicant
ifdef ABOVE_8_1
LOCAL_PROPRIETARY_MODULE := true
endif
LOCAL_SHARED_LIBRARIES := libc libcutils
LOCAL_CFLAGS := $(L_CFLAGS) $(SUPP_CFLAGS)
LOCAL_SRC_FILES := $(WPA_SRC_FILE)
LOCAL_C_INCLUDES := $(WPA_SUPPL_DIR_INCLUDE)
include $(BUILD_STATIC_LIBRARY)
########################
include $(CLEAR_VARS)
LOCAL_MODULE := lib_driver_cmd_bcmdhd_hostapd
ifdef ABOVE_8_1
LOCAL_PROPRIETARY_MODULE := true
endif
LOCAL_SHARED_LIBRARIES := libc libcutils
LOCAL_CFLAGS := $(L_CFLAGS) $(HOSTAPD_CFLAGS)
LOCAL_SRC_FILES := $(WPA_SRC_FILE)
LOCAL_C_INCLUDES := $(WPA_SUPPL_DIR_INCLUDE)
include $(BUILD_STATIC_LIBRARY)
########################
endif
endif
