#!/bin/bash
#Copyright (c) 2016, MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction, 
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.

echo "start DTMF message"

if [ $# -lt 1 ]
then
	echo "paramter is invaild!"
	return 1
fi

CallNum="$1"

pattern='[[:digit:]\*#]'
if [[ $1 == $pattern ]]
then
    CallNum="$1"
    echo "msg key is ${CallNum}"
else
    echo "invalid paramter $1, need a single character with one of 12 values: 0-9,*,#"
    exit 1
fi

#open a socket, communicated with Service.
exec 9<>/dev/udp/127.0.0.1/8000

#start dtmf
echo "RIL_REQUEST_DTMF_START ${CallNum}"  >&9

#close socket R/W
exec 9>&-
exec 9<&-
exit 0