#!/bin/bash
#Copyright (c) 2016, MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction, 
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.


#********************************************************************************************
#if the parameters cann't find and replace it with null. 
#USAGE: sh enable_data.sh apn apntype user password authType normalprotocol roamingprotocol
#				or sh enable_data.sh
#apn: 运营商提供的配置信息，必须有
#apntype
#user：运营商提供的配置信息，如果没有填写null
#password：运营商提供的配置信息, ，如果没有填写null
#authType：运营商提供的配置信息，如果没有填写null
#roamingprotocol：运营商提供的配置信息，为这些值中的一个IPV4,IPV6,IPV4V6，如果没有填写null
#normalprotocol：运营商提供的配置信息，为这些值中的一个IPV4,IPV6,IPV4V6，如果没有填写null
#
#一般选的APN包含default这个type, 如下面这个APN type就包含default
# 例如
# <apn carrier="Cosmote Wireless Internet"
#      mcc="202"
#      mnc="01"
#      apn="internet"
#      type="default,supl"
#  />
# command is : sh enable_data.sh internet default null null null null null or
#              sh enable_data.sh
#***********************************************************************************************

upper2lower(){
    value="$(echo $1 | tr '[:upper:]' '[:lower:]')"
    echo $value
}

lower2upper(){
    value="$(echo $1 | tr '[:lower:]' '[:upper:]')"
    echo $value
}

#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

if [ $# -gt 0 ]; then
#enable internet data PDN, this command cann't modify
echo "the internet pdn parameters numbers is: $#"
if [ -z $1 ]
then
echo -n "please input apn: "
read apn
else
apn=$1
fi

if [ -z $2 ]
then
echo -n "please input apntype(maybe is default): "
read apntype
else
apntype=$2
fi

if [ -z $3 ]
then
echo -n "please input user(if no exsit, input "null"): "
read user
else
user=$3
fi

if [ -z $4 ]
then
echo -n "please input password(if no exsit, input "null"): "
read password
else
password=$4
fi

if [ -z $5 ]
then
echo -n "please input authType(if no exsit, input "null"): "
read authType
else
authType=$5
fi

if [ -z $6 ]
then
echo -n "please input normalprotocol(if no exsit, input "null"): "
read normalprotocol
else
normalprotocol=$6

fi
if [ -z $7 ]
then
echo -n "please input roamingprotocol(if no exsit, input "null"): "
read roamingprotocol
else
roamingprotocol=$7
fi

apntype=$(upper2lower $apntype)

normalprotocol=$(lower2upper $normalprotocol)

roamingprotocol=$(lower2upper $roamingprotocol)

#send Terminal response CMD
echo "RIL_REQUEST_DATA_REGISTRATION_STATE" >&9

echo "apn: $apn, apntype: $apntype, usr: $user, password: $password, authType: $authType, normalprotocol: $normalprotocol, roamingprotocol: $roamingprotocol"
echo "RIL_REQUEST_SETUP_DATA_CALL $apn $apntype $user $password $authType $normalprotocol $roamingprotocol" >&9

else
echo "RIL_REQUEST_DATA_REGISTRATION_STATE" >&9
echo "RIL_REQUEST_SETUP_DATA_CALL" >&9
fi

#close socket R/W
exec 9>&-
exec 9<&-
exit 0