#include <log/log.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
extern "C" {
#include <gio/gio.h>
#include "liblog/lynq_deflog.h"
#include <glib.h>
}
#include "driver/driver_service.h"
#define LOG_TAG "DRIVER_SERVICE"
#define GPIO_SERVICE "gpio.lynq" /*well-known bus name */
#define GPIO_DATA_INTERFACE "gpio.lynq.Data" /*interface name*/
#define GPIO_DATA_PATH "/gpio/lynq/data" /*object name*/
static constexpr guint READPARAM = -1;
static const char* GPIO_READ_MODE    = "gpio";
static GDBusNodeInfo *introspection_data = NULL;
static const gchar introspection_xml[] =
        "<node>"
        "  <interface name='gpio.lynq.Data'>"
        "    <method name='setGpio'>"
        "      <arg name='mode' type='s' direction='in'/>"
        "      <arg name='gpio_numb' type='i' direction='in'/>"
        "      <arg name='param' type='i' direction='in'/>"
        "      <arg name='gpioresponse' type='i' direction='out'/>"
        "    </method>"
        "    <method name='getGpio'>"
        "      <arg name='gpio_numb' type='i' direction='in'/>"
        "      <arg name='gpioresponse' type='s' direction='out'/>"
        "    </method>"
        "    <method name='get_trigger_status'>"
        "      <arg name='gpio_id' type='i' direction='in'/>"
        "      <arg name='gpioresponse' type='i' direction='out'/>"
        "    </method>"
        "    <signal name='WakeupKeyChange'>"
        "      <arg name='datacallresponse' type='i'/>"
        "    </signal>"
        "  </interface>"
        "</node>";

/*
static const gchar introspection_test_xml[] =
        "<node>"
        "  <interface name='test.lynq.Data'>"
        "    <method name='add'>"
        "      <arg name='a' type='as' direction='in'/>"
        "      <arg name='datacallresponse' type='i' direction='out'/>"
        "    </method>"
        "  </interface>"
        "</node>";
	*/	
static GMutex g_mutex;
static GHashTable *hashTable = NULL;
static GAsyncQueue *queue;	
void param_process(const gchar *mode, guint gpio_numb, guint param,gchar *result){
    gchar str1[50];  
    gchar indexStr[5] = { 0 };
    gchar indexStr2[5] = { 0 };
    strcpy(str1, mode);
    sprintf(indexStr, " %d", gpio_numb);
    strcat(str1, indexStr);
    if(param != -1){
        sprintf(indexStr2, " %d", param);
        strcat(str1, indexStr2);
    }
    strcpy(result, str1);
	
}
guint write_gpio_file(const gchar *mode,guint gpio_numb,guint param){
	int err = -1;
	gchar argv[50];
	char *s;
	param_process(mode,gpio_numb,param,argv);
	s = argv;
	LYDBGLOG("s:%s",s);
	int fp = open("/proc/n5600", O_RDWR);
	if (fp < 0) {
	  LYDBGLOG("open /proc/n5600 error\n");
	  return -1;
	}
	else { 
	  LYDBGLOG("open /proc/n5600 success!\n");
	}	
	err = write(fp, s, sizeof(argv));
	close(fp);
	if(err == -1)	{
	  RLOGE("read faild!!!\n");
	  return -1;
	}else{
      return 1;
	}
	
}


guint read_gpio_file(guint gpio_numb,guchar *strv){
    int err_w = -1;
    int err_r =-1;
    gchar argv[50];
    gchar *sw;
    guchar str[100]= {0};
    guint valid_data[100];
    sw = argv;
    param_process(GPIO_READ_MODE,gpio_numb,READPARAM,argv);
    int fp = open("/proc/n5600", O_RDWR);
    if (fp < 0) {	
        LYDBGLOG(("open /proc/n5600 error\n"));
        return -1;
    }
    else { 
        LYDBGLOG(("open /proc/n5600 success!\n"));
    }	
    LYDBGLOG("s:%s",sw);
    err_w = write(fp, sw, sizeof(argv));
    if(err_w == -1)	{
		LYDBGLOG("write faild!!!\n");
        close(fp);
        return -1;
    }
    err_r = read(fp,str,sizeof(str));
    if(err_r == -1)	{
        LYDBGLOG("write faild!!!\n");
        close(fp);
        return -1;
    }
    memcpy (valid_data, str, sizeof str);
    strv = str;
    LYDBGLOG("%s, %s, %d,%s", __FILE__, __FUNCTION__, __LINE__,strv);

    //for (int i = 0; i < 10; i++)
    //{
    //	RLOGD("%s, %s, %d,valid_data[%d]:%d", __FILE__, __FUNCTION__, __LINE__,i,valid_data[i]);
    //}
    close(fp);
    return 1;
}

void init_trigger_file(){
    int error;	
    int fp;
    unsigned char str[100]= {0};
    pthread_attr_t attr;
    char  a [ ] = "1 8";
    char *s =a;
    fp = open("/proc/eint_gpio_debug", O_RDWR);
    if (fp < 0) {
        LYDBGLOG("open /proc/eint_gpio_debug error\n");

    } else {
        LYDBGLOG("open /proc/eint_gpio_debug success!\n");
    }
    error = write(fp, s, sizeof(a));
    if(error == -1){
        LYDBGLOG("error,read faild!!!\n");
    }
}

static void
gpio_contorl (GDBusConnection       *connection,
                    const gchar           *sender,
                    const gchar           *object_path,
                    const gchar           *interface_name,
                    const gchar           *method_name,
                    GVariant              *parameters,
                    GDBusMethodInvocation *invocation,
                    gpointer               user_data)
{

    if (g_strcmp0 (method_name, "setGpio") == 0){ 
        GVariant *result = NULL;
        gint32 getResult1 = -1;
        g_mutex_lock(&g_mutex);
        guint gpio_numb;
        guint param;
        const gchar *mode;
        g_variant_get (parameters, "(sii)", &mode, &gpio_numb, &param);
        LYDBGLOG("setGpio parameters is mode: %s, %d %d", mode,gpio_numb,param );

        // sleep(5); 
        getResult1 = write_gpio_file(mode,gpio_numb,param);
        g_dbus_method_invocation_return_value (invocation,
                                         g_variant_new ("(i)", getResult1));
        //g_object_unref (invocation);
        //   g_free(getResult);
        g_mutex_unlock(&g_mutex);
    }
    else if(g_strcmp0 (method_name, "getGpio") == 0){	
        GVariant *result = NULL;	
        //guchar *response;
        guchar response[100];
        guint gpio_numb;
        guint error;
        GVariantBuilder builder;
        g_mutex_lock(&g_mutex);	
        gchar *output;
        g_variant_get (parameters, "(i)", &gpio_numb);
        read_gpio_file(gpio_numb,response);
        if (error == -1){
            g_dbus_method_invocation_return_error (invocation,
                                                   G_DBUS_ERROR, G_DBUS_ERROR_FAILED,
                                                  "File open error");
        }
        //	sprintf(output, "%s",response);
        output = g_strdup_printf ("%s", response);
        g_dbus_method_invocation_return_value (invocation,
                                          g_variant_new ("(s)", output));
        g_free (output);
        g_mutex_unlock(&g_mutex);
		/*
		GVariant *result = NULL;
		guint gpio_numb;
		//gchar *response;
		guchar outbuf[8192] = {0};
		guchar test[] = "143: 1001-04-11-11 [0 1]";
		guint error;
		//gchar *orig = "blargh";
		GVariantBuilder builder;
		 g_mutex_lock(&g_mutex);
		g_variant_builder_init (&builder, G_VARIANT_TYPE ("(as)"));
		 g_variant_builder_open (&builder, G_VARIANT_TYPE ("as"));
		for(int i=0;i<10;i++)
		g_variant_builder_add (&builder, "s", "def");
		g_variant_builder_close (&builder);
		result =  g_variant_builder_end (&builder);
		error = read_gpio_file(gpio_numb,outbuf);
		if (error == -1){
		  g_dbus_method_invocation_return_error (invocation,
		    G_DBUS_ERROR, G_DBUS_ERROR_FAILED,
		    "File open error");
		  }

		g_dbus_method_invocation_return_value (invocation,
                                          result);


		RLOGD("%s, %s, %d", __FILE__, __FUNCTION__, __LINE__);
		//g_free (test);
			RLOGD("%s, %s, %d", __FILE__, __FUNCTION__, __LINE__);
		//g_free (outbuf);
		//g_free (response);
		g_mutex_unlock(&g_mutex);*/
    }else if(g_strcmp0 (method_name, "get_trigger_status") == 0){ 
        GVariant *result = NULL;
        gint32 getResult1 = -1;
        guint tigger_numb;
        g_variant_get (parameters, "(i)", &tigger_numb);
        LYDBGLOG("setGpio parameters is mode: %d ",tigger_numb );

        // sleep(5);
        g_dbus_method_invocation_return_value (invocation,
                                         g_variant_new ("(i)", tigger_numb+1));
    }else{
        LYDBGLOG("Places that can't be reached");
        g_assert_not_reached ();
    }
}

static const GDBusInterfaceVTable interface_vtable =
{
  gpio_contorl,
  NULL,
  NULL
};	

static void
on_bus_acquired (GDBusConnection *connection,
                                      const gchar     *name,
                                      gpointer         user_data)
{

    LYDBGLOG("Acquired a message bus connection");
    guint registration_id;

    registration_id = g_dbus_connection_register_object (connection,
                                                         GPIO_DATA_PATH,
                                                         introspection_data->interfaces[0],
                                                         &interface_vtable,
                                                         NULL,  /* user_data */
                                                         NULL,  /* user_data_free_func */
                                                         NULL); /* GError** */
    g_assert (registration_id > 0);
}

static void
on_name_acquired (GDBusConnection *connection,
                                          const gchar     *name,
                                          gpointer         user_data)
{
    LYDBGLOG("Acquired the name %s", name);
    init_trigger_file();
}

static void
on_name_lost(GDBusConnection *connection,
                                         const gchar     *name,
                                         gpointer user_data)
{
    LYDBGLOG("Lost the name %s", name);

}

static void
on_name_appeared (GDBusConnection *connection,
                  const gchar     *name,
                  const gchar     *name_owner,
                  gpointer         user_data)
{
    LYDBGLOG("Name %s on %s is owned by %s\n",name,"the system bus",name_owner);

}

static gpointer
gpio_dbus_service_cb (gpointer data){
    GMainLoop *loop;
    guint id;
    guint watcher_id;
  // sleep(1);
  //   printf("%s, %s, %d", __FILE__, __FUNCTION__, __LINE__);
    introspection_data = g_dbus_node_info_new_for_xml (introspection_xml, NULL);
    g_assert (introspection_data != NULL);
    hashTable = g_hash_table_new_full(g_int_hash, g_int_equal, NULL, g_free);
    queue = g_async_queue_new();
    loop = g_main_loop_new(NULL, FALSE);
    id = g_bus_own_name(G_BUS_TYPE_SYSTEM,
                           GPIO_SERVICE,
                          GBusNameOwnerFlags(G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT |
                           G_BUS_NAME_OWNER_FLAGS_REPLACE),
                           on_bus_acquired,
                           on_name_acquired,
                           on_name_lost,
                           loop,
                           NULL);
    g_main_loop_run(loop);

    g_bus_unown_name(id);
    g_main_loop_unref(loop);
    g_async_queue_unref(queue);
    g_dbus_node_info_unref (introspection_data);
    return NULL;
}

void register_driver_service(){
    GError *error = NULL;
    GThread *thead = g_thread_try_new("gpio_dbus_service", gpio_dbus_service_cb, NULL, &error);
    g_assert_no_error(error);
    if(error!=NULL)
    {
        LYDBGLOG("initGDbus free error pointer %P", error);
        g_error_free(error);
    }

}
int set_trigger_write(){
    char  a [ ] = "1 8 4";
    char *s =a;
    int error;
    int fp;		
    fp = open("/dev/buttons1", O_RDWR);
    if (fp < 0) {
        LYDBGLOG("open /proc/buttons1 error\n");
        return 0;
    } else {
        LYDBGLOG("open /proc/buttons1 success!\n");

    }
    error = write(fp, s, sizeof(a));
    if(error == -1)
    {
        LYDBGLOG("error,read faild!!!\n");
        close(fp);
        return 0;
    }
       close(fp);
  	 return 1;
}

void trigger_interrupt(int gpio_numb, int prower){
    char* trigger_name = NULL;
    GDBusConnection *connection;
    GError *error = NULL;
    GVariant *value;
    if(gpio_numb == WAKEUP_KEY){
      trigger_name ="WakeupKeyChange";
    }
    value = g_variant_new("(i)",prower);
    if (value == NULL) {
      LYDBGLOG("value is NULL");
      return;
    }
    LYDBGLOG("get sync connection begin");
    connection = g_bus_get_sync(G_BUS_TYPE_SYSTEM, NULL, &error);
    if (error) {
      LYDBGLOG("can't get connection, reason: %s", error->message);
      g_error_free(error);
      g_object_unref(connection);
      connection = NULL;
    }
    error = NULL;
    g_dbus_connection_emit_signal(connection,
                                      NULL,
                                      GPIO_DATA_PATH,
                                      GPIO_DATA_INTERFACE,
                                      trigger_name,
                                      value,
                                      &error);
    if (error) {
      LYDBGLOG("can't emit %d signal, reason: %s", gpio_numb, error->message);
      g_error_free(error);
    }
    g_object_unref(connection);
    connection = NULL;
}



