#include <sys/msg.h>
#include <sys/ipc.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "http/lynq_msgq.h"


int lynq_msgq_init(char *pathname,  int create)
{
	key_t key = ftok(pathname, 66);
	int queueId = msgget(key, IPC_CREAT | create);
	if(queueId == -1)
	{
			//LYDBGLOG("[%s %d] create msg error \n", __FUNCTION__, __LINE__);
			LYVERBLOG("+[http]: error num = %d\n", ERR_MSG);
			return ERR_MSG;
	}
	
	return queueId ;
}

int lynq_msgq_send(int queueId, struct mymesg *ckxmsg)
{
        if(msgsnd(queueId, ckxmsg, 512, 0) < 0)
        {
                //LYDBGLOG("[%s %d] send msg error \n", __FUNCTION__, __LINE__);
		  		LYVERBLOG("+[http]: error num = %d\n", ERR_MSG);
                return ERR_MSG;
        }

        return 0;
}
