#include<stdio.h>
#include<stdlib.h>
#include<errno.h>
#include<string.h>
#include<sys/types.h>
#include<netinet/in.h>
#include<sys/socket.h>
#include <arpa/inet.h>
#include<sys/wait.h>
#include <pthread.h>
#include <unistd.h>
#include <log/log.h>
#include <string.h>
#include <binder/Parcel.h>
#define SERVER_PORT 8088
#define BUFFER_SIZE 8192
#define LOG_TAG "PLUGIN_MAIN"
using::android::Parcel;
int server_socket_fd;
struct sockaddr_in client_addr;

static int s_started =0;
static pthread_mutex_t s_startupMutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t s_startupCond = PTHREAD_COND_INITIALIZER;
static pthread_t s_tid_dispatch;

int plugin_StartSerSocket()
{
    struct sockaddr_in server_addr;
    bool count = true;
    int ret = 0;
    int dataSize = 0; 
    bzero(&server_addr, sizeof(server_addr));
    Parcel parcel;
    int32_t type= 0;
    int32_t request = 0;
    int32_t error = 0;
    server_addr.sin_family = AF_INET;
    server_addr.sin_addr.s_addr = htonl(INADDR_ANY);
    server_addr.sin_port = htons(SERVER_PORT);
    /* create socket */
    //int server_socket_fd = socket(AF_INET, SOCK_DGRAM, 0);
    server_socket_fd = socket(AF_INET, SOCK_DGRAM, 0);
    if(server_socket_fd == -1)
    {
         RLOGE("Create Socket Failed:");
         exit(1);
    }

    /* bind socket port*/
    if(-1 == (bind(server_socket_fd,(struct sockaddr*)&server_addr,sizeof(server_addr))))
    {
         RLOGE("Server Bind Failed:");
         exit(1);
    }

    /* tranlate data */
    while(true)
    {
         /* define address to catch the client addreess*/
        //struct sockaddr_in client_addr;
        socklen_t client_addr_length = sizeof(client_addr);
        printf("read socket 8088!!\n");
        /* receive the data */
        char buffer[BUFFER_SIZE];
        bzero(buffer, BUFFER_SIZE);
        ret = recvfrom(server_socket_fd, buffer, BUFFER_SIZE,0,(struct sockaddr*)&client_addr, &client_addr_length);
        if(ret == -1)
        {
            RLOGE("Receive Data Failed:");
            continue;
        }
        if(count)
        {
            //uint8_t datalength[]=
            uint8_t *datalength = (uint8_t *)buffer;
            printf("PLUGIN:%s, receve: datalength[0] %x,datalength length = %d\n", inet_ntoa(client_addr.sin_addr),(datalength[0]<<8),ret);
            if(ret==4)
            {
                if(((datalength[0]<<8)==0x5500)&&(datalength[1]==0xAA))
                {
                    RLOGD("PLUGIN:%s, receve: dataSize1= %x,dataSize2= %x", inet_ntoa(client_addr.sin_addr), (datalength[2]<<8),datalength[3]);
                    printf("PLUGIN:%s, receve: dataSize1= %d,dataSize2= %d,dataSize = %d\n", inet_ntoa(client_addr.sin_addr), (datalength[2]<<8),datalength[3],((datalength[2]<<8)+datalength[3]));
                    dataSize = datalength[2]+datalength[3];
                    count=false;
                }
            }
        }
        else
        {
            count=true;
            int32_t type= 0;
            int32_t request = 0;
            int32_t error = 0;
            //parcel = (Parcel)buffer;
            parcel.setData((unsigned char *)buffer, sizeof(buffer));
            parcel.setDataPosition(0);
            parcel.readInt32(&type);
            parcel.readInt32(&request);
            parcel.readInt32(&error);
            RLOGD("PLUGIN:%s, receve: type= %d,request= %d,error = %d", inet_ntoa(client_addr.sin_addr), type,request,error);
            printf("PLUGIN:%s, receve: type= %d,request= %d,error = %d\n", inet_ntoa(client_addr.sin_addr), type,request,error);
        }
     }

     RLOGD("close socket fd");
     close(server_socket_fd);
     return 1;
}
void *eventLoop(void *param) {
    pthread_mutex_lock(&s_startupMutex);
    s_started = 1;
    pthread_cond_broadcast(&s_startupCond);
    pthread_mutex_unlock(&s_startupMutex);
    //#ifdef ECALL_SUPPORT
    //init_ecall_timer_all();
    //#endif /**/ECALL_SUPPORT
    plugin_StartSerSocket();
    RLOGD("error in event_loop_base errno:%d", errno);
    // kill self to restart on error
    kill(0, SIGKILL);
    return NULL;
}
void plugin_startEventLoop()
{
    RLOGD("RIL_startEventLoop()");
    /* spin up eventLoop thread and wait for it to get started */
    s_started = 0;
    pthread_mutex_lock(&s_startupMutex);

    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);

    int result = pthread_create(&s_tid_dispatch, &attr, eventLoop, NULL);
    if (result != 0) {
        RLOGW("Failed to create dispatch thread: %s", strerror(result));
        goto done;
    }
    while (s_started == 0) {
        pthread_cond_wait(&s_startupCond, &s_startupMutex);
    }
    done:
    pthread_mutex_unlock(&s_startupMutex);
}
int onRequest()
{
    printf("this is callback function\n");
    return 0;
}
int main(int argc, char **argv)
{
    plugin_startEventLoop();
    while(1)
    {
        sleep(1);
    }
    return 0;
}