
#include "syn_primitive.h"
#define SEM_VALUE_MAX 32767 

int init_condition_handle(condition_handle *cond) {
	return pthread_cond_init(cond, NULL);
}


int destroy_condition_handle(condition_handle *cond) {
	return pthread_cond_destroy(cond);
}


int wait_condition(condition_handle *cond, mutex_handle *mutex, unsigned int wait) {
	struct timespec wait_time;
	if (wait == TIME_WAIT_INFINITE)
		wait_time.tv_sec = TIME_WAIT_INFINITE;
	else
		wait_time.tv_sec = wait + time(0);
	wait_time.tv_nsec = 0;
	
	return pthread_cond_timedwait(cond, mutex, &wait_time);
}


int post_condition_signal(condition_handle *cond) {
	return pthread_cond_signal(cond);
}


int init_mutex_handle(mutex_handle *mutex) {
	return pthread_mutex_init(mutex, NULL);
}

int mutex_lock(mutex_handle *mutex) {
	return pthread_mutex_lock(mutex);
}

int mutex_unlock(mutex_handle *mutex) {
	return pthread_mutex_unlock(mutex);
}

int mutex_destroy(mutex_handle *mutex) {
	return pthread_mutex_destroy(mutex);
}


int create_sem(sem_handle *sem, int init_count) {	
	return sem_init(sem, 0, init_count>SEM_VALUE_MAX ? SEM_VALUE_MAX:init_count );
}


int wait_sem(sem_handle *sem) {
	return sem_wait(sem);
}

int post_sem(sem_handle *sem) {
	return sem_post(sem);
}

int destroy_sem(sem_handle *sem) {
	return sem_destroy(sem);
}

