#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <linux/i2c-dev.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include "lynq_codec.h"
#include <syslog.h>
#include <log/log.h>

#define LOG_TAG "CODEC_API"

static void write_codec_reg(const char * val)
{
    if (val == NULL)
    {
        RLOGE("Invalid input\n");
        return;
    }

    FILE* fp=fopen("/sys/kernel/debug/regmap/0-0018/registers", "w");
    if (fp == NULL)
    {
        RLOGE("Failed to open file\n");
        return;
    }
    fwrite(val, strlen(val), 1, fp);
    fclose(fp);
}

void set_zk_3104_codec(int open)
{
    RLOGD("set_codec %d",open);

    if(open==0)
    {
        system("echo out 201 0 >/sys/devices/platform/10005000.pinctrl/mt_gpio");
        system("echo out 113 0 >/sys/devices/platform/10005000.pinctrl/mt_gpio");
        system("echo out 29 0 >/sys/devices/platform/10005000.pinctrl/mt_gpio");
        /*dongyu@2023.7.12 ZK ADC/DAC power supply default off state, turn on during call, turn off after hang up start*/
        write_codec_reg("0x13 0x00");
        write_codec_reg("0x16 0x00");
        write_codec_reg("0x25 0x00");
        /*dongyu@2023.7.12 ZK ADC/DAC power supply default off state, turn on during call, turn off after hang up end*/
    }
    else
    {
        system("echo out 201 1 >/sys/devices/platform/10005000.pinctrl/mt_gpio");
        usleep(10);//just open need usleep 10us
        system("echo out 113 1 >/sys/devices/platform/10005000.pinctrl/mt_gpio");
        usleep(10);//just open need usleep 10us
        system("echo out 29 1 >/sys/devices/platform/10005000.pinctrl/mt_gpio");
        write_codec_reg("0x00 0x00");
        write_codec_reg("0x01 0x00");
        write_codec_reg("0x02 0x00");
        write_codec_reg("0x03 0x80");
        write_codec_reg("0x04 0x04");
        write_codec_reg("0x05 0x00");
        write_codec_reg("0x06 0x00");
        write_codec_reg("0x07 0xa0");
        write_codec_reg("0x08 0x20");
        write_codec_reg("0x09 0x00");
        write_codec_reg("0x0a 0x00");
        write_codec_reg("0x0b 0x32");
        write_codec_reg("0x0c 0x00");
        write_codec_reg("0x0d 0x00");
        write_codec_reg("0x0f 0x10");
        write_codec_reg("0x10 0x20");
        write_codec_reg("0x11 0xf8");
        write_codec_reg("0x12 0xff");
        /*dongyu@2023.7.12 ZK ADC/DAC 0x13 power supply default off state, turn on during call, turn off after hang up*/
        write_codec_reg("0x13 0x7a");
        write_codec_reg("0x14 0x78");
        write_codec_reg("0x15 0x00");
        /*dongyu@2023.7.12 ZK ADC/DAC 0x16 power supply default off state, turn on during call, turn off after hang up*/
        write_codec_reg("0x16 0x78");
        write_codec_reg("0x17 0x78");
        write_codec_reg("0x18 0x78");
        write_codec_reg("0x19 0x80");
        write_codec_reg("0x1a 0x00");
        write_codec_reg("0x1b 0xfe");
        write_codec_reg("0x1c 0x00");
        write_codec_reg("0x1d 0x00");
        write_codec_reg("0x1e 0xfe");
        write_codec_reg("0x1f 0x00");
        write_codec_reg("0x20 0x18");
        write_codec_reg("0x21 0x18");
        write_codec_reg("0x22 0x00");
        write_codec_reg("0x23 0x00");
        write_codec_reg("0x24 0xc0");
        /*dongyu@2023.7.12 ZK ADC/DAC 0x25 power supply default off state, turn on during call, turn off after hang up*/
        write_codec_reg("0x25 0xc0");
        write_codec_reg("0x26 0x00");
        write_codec_reg("0x27 0x00");
        write_codec_reg("0x28 0x00");
        write_codec_reg("0x29 0x00");
        write_codec_reg("0x2a 0x00");
        write_codec_reg("0x2b 0x02");
        write_codec_reg("0x2c 0x02");
        write_codec_reg("0x2d 0x00");
        write_codec_reg("0x2e 0x02");
        write_codec_reg("0x2f 0x85");
        write_codec_reg("0x30 0x00");
        write_codec_reg("0x31 0x80");
        write_codec_reg("0x32 0x85");
        write_codec_reg("0x33 0x9f");
        write_codec_reg("0x34 0x00");
        write_codec_reg("0x35 0x80");
        write_codec_reg("0x36 0x82");
        write_codec_reg("0x37 0x00");
        write_codec_reg("0x38 0x00");
        write_codec_reg("0x39 0x82");
        write_codec_reg("0x3a 0x9f");
        write_codec_reg("0x3b 0x00");
        write_codec_reg("0x3c 0x00");
        write_codec_reg("0x3d 0x00");
        write_codec_reg("0x3e 0x00");
        write_codec_reg("0x3f 0x80");
        write_codec_reg("0x40 0xaf");
        write_codec_reg("0x41 0x0d");
        write_codec_reg("0x42 0x00");
        write_codec_reg("0x43 0x80");
        write_codec_reg("0x44 0x00");
        write_codec_reg("0x45 0x00");
        write_codec_reg("0x46 0x02");
        write_codec_reg("0x47 0xaf");
        write_codec_reg("0x48 0x0d");
        write_codec_reg("0x49 0x00");
        write_codec_reg("0x4a 0x00");
        write_codec_reg("0x4b 0x00");
        write_codec_reg("0x4c 0x00");
        write_codec_reg("0x4d 0x00");
        write_codec_reg("0x4e 0x00");
        write_codec_reg("0x4f 0x00");
        write_codec_reg("0x50 0x00");
        write_codec_reg("0x51 0x00");
        write_codec_reg("0x52 0x00");
        write_codec_reg("0x53 0x00");
        write_codec_reg("0x54 0x02");
        write_codec_reg("0x55 0xbf");
        write_codec_reg("0x56 0x9b");
        write_codec_reg("0x57 0x00");
        write_codec_reg("0x58 0x02");
        write_codec_reg("0x59 0xbf");
        write_codec_reg("0x5a 0x00");
        write_codec_reg("0x5b 0x00");
        write_codec_reg("0x5c 0xbf");
        write_codec_reg("0x5d 0x08");
        write_codec_reg("0x5e 0xde");
        write_codec_reg("0x5f 0x0c");
        write_codec_reg("0x60 0x00");
        write_codec_reg("0x61 0x00");
        write_codec_reg("0x62 0x00");
        write_codec_reg("0x63 0x00");
        write_codec_reg("0x64 0x00");
        write_codec_reg("0x65 0x01");
        write_codec_reg("0x66 0xa2");
        write_codec_reg("0x67 0x00");
        write_codec_reg("0x68 0x00");
        write_codec_reg("0x69 0x00");
        write_codec_reg("0x6a 0x00");
        write_codec_reg("0x6b 0x00");
        write_codec_reg("0x6c 0x40");
        write_codec_reg("0x6d 0x00");
    }
}

/*hqing add for Geely demand on 11/07/2022, after playing audio, codec should sleep*/
static void set_gsw_3104_codec(codec_op open)
{
    if(open==0)
    {
        system("echo out 201 0 >/sys/devices/platform/10005000.pinctrl/mt_gpio");    
        system("echo out 181 0 >/sys/devices/platform/10005000.pinctrl/mt_gpio");
    }
    else
    {
        system("echo out 181 1 >/sys/devices/platform/10005000.pinctrl/mt_gpio");
        usleep(10);//just open need usleep 10us

        write_codec_reg("0x00 0x00");
        write_codec_reg("0x01 0x00");
        write_codec_reg("0x02 0x00");
        write_codec_reg("0x03 0x80");
        write_codec_reg("0x04 0x04");
        write_codec_reg("0x05 0x00");
        write_codec_reg("0x06 0x00");
        write_codec_reg("0x07 0xa0");
        write_codec_reg("0x08 0x20");
        write_codec_reg("0x09 0x00");
        write_codec_reg("0x0a 0x00");
        write_codec_reg("0x0b 0x32");
        write_codec_reg("0x0c 0x00");
        write_codec_reg("0x0d 0x00");
        write_codec_reg("0x0f 0x10");
        write_codec_reg("0x10 0x20");
        write_codec_reg("0x11 0xf8");
        write_codec_reg("0x12 0xff");
        write_codec_reg("0x13 0x04");
        write_codec_reg("0x14 0x78");
        write_codec_reg("0x15 0x78");
        write_codec_reg("0x16 0x04");
        write_codec_reg("0x17 0x78");
        write_codec_reg("0x18 0x78");
        write_codec_reg("0x19 0x80");
        write_codec_reg("0x1a 0x00");
        write_codec_reg("0x1b 0xfe");
        write_codec_reg("0x1c 0x00");
        write_codec_reg("0x1d 0x00");
        write_codec_reg("0x1e 0xfe");
        write_codec_reg("0x1f 0x00");
        write_codec_reg("0x20 0x18");
        write_codec_reg("0x21 0x18");
        write_codec_reg("0x22 0x00");
        write_codec_reg("0x23 0x00");
        write_codec_reg("0x24 0xc0");
        write_codec_reg("0x25 0xc0");
        write_codec_reg("0x26 0x00");
        write_codec_reg("0x27 0x00");
        write_codec_reg("0x28 0x00");
        write_codec_reg("0x29 0x00");
        write_codec_reg("0x2a 0x00");
        write_codec_reg("0x2b 0x02");
        write_codec_reg("0x2c 0x02");
        write_codec_reg("0x2d 0x00");
        write_codec_reg("0x2e 0x02");
        write_codec_reg("0x2f 0x85");
        write_codec_reg("0x30 0x00");
        write_codec_reg("0x31 0x80");
        write_codec_reg("0x32 0x85");
        write_codec_reg("0x33 0x00"); //dongyu@2023.9.18 Disables CODEC lineout output by default
        write_codec_reg("0x34 0x00");
        write_codec_reg("0x35 0x80");
        write_codec_reg("0x36 0x82");
        write_codec_reg("0x37 0x00");
        write_codec_reg("0x38 0x00");
        write_codec_reg("0x39 0x82");
        write_codec_reg("0x3a 0x00"); //dongyu@2023.9.18 Disables CODEC lineout output by default
        write_codec_reg("0x3b 0x00");
        write_codec_reg("0x3c 0x00");
        write_codec_reg("0x3d 0x00");
        write_codec_reg("0x3e 0x00");
        write_codec_reg("0x3f 0x80");
        write_codec_reg("0x40 0xaf");
        write_codec_reg("0x41 0x00"); //dongyu@2023.9.18 Disables CODEC lineout output by default
        write_codec_reg("0x42 0x00");
        write_codec_reg("0x43 0x80");
        write_codec_reg("0x44 0x00");
        write_codec_reg("0x45 0x00");
        write_codec_reg("0x46 0x02");
        write_codec_reg("0x47 0xaf");
        write_codec_reg("0x48 0x00"); //dongyu@2023.9.18 Disables CODEC lineout output by default
        write_codec_reg("0x49 0x00");
        write_codec_reg("0x4a 0x00");
        write_codec_reg("0x4b 0x00");
        write_codec_reg("0x4c 0x00");
        write_codec_reg("0x4d 0x00");
        write_codec_reg("0x4e 0x00");
        write_codec_reg("0x4f 0x00");
        write_codec_reg("0x50 0x00");
        write_codec_reg("0x51 0x02");
        write_codec_reg("0x52 0xbf");
        write_codec_reg("0x53 0x00");
        write_codec_reg("0x54 0x00");
        write_codec_reg("0x55 0x00");
        write_codec_reg("0x56 0x9b");
        write_codec_reg("0x57 0x00");
        write_codec_reg("0x58 0x00");
        write_codec_reg("0x59 0x00");
        write_codec_reg("0x5a 0x00");
        write_codec_reg("0x5b 0x02");
        write_codec_reg("0x5c 0xbf");
        write_codec_reg("0x5d 0x08");
        write_codec_reg("0x5e 0xde");
        write_codec_reg("0x5f 0x0c");
        write_codec_reg("0x60 0x00");
        write_codec_reg("0x61 0x00");
        write_codec_reg("0x62 0x00");
        write_codec_reg("0x63 0x00");
        write_codec_reg("0x64 0x00");
        write_codec_reg("0x65 0x01");
        write_codec_reg("0x66 0xa2");
        write_codec_reg("0x67 0x00");
        write_codec_reg("0x68 0x00");
        write_codec_reg("0x69 0x00");
        write_codec_reg("0x6a 0x00");
        write_codec_reg("0x6b 0x00");
        write_codec_reg("0x6c 0x40");
        write_codec_reg("0x6d 0x00");
    }
}


#ifdef ZK_CODEC_CFG

/*dongyu@2023.5.31 Add ZK set codec tlv320aic3x API register start*/

void set_codec(media_src_t src, codec_op open_close)
{
    RLOGD("set_zk_3104_codec src=[%d] op=[%d]", src, open_close);
    set_zk_3104_codec(open_close);
}

const char * get_customer_tone_path()
{
    return "/tmp/tone.wav";
}

int get_customer_tone_sample_rate()
{
    return 44100;
}

int customer_set_pa_volume(const int volume)
{
    int file;
    char *filename = "/dev/i2c-0";
    int addr = 0x6c;
    char buf[2];

    if (volume < 1 || volume > 4)
    {
        RLOGE("Invalid volume specified\n");
        return -1;
    }

    if ((file = open(filename, O_RDWR)) < 0)
    {
        RLOGE("Failed to open i2c bus\n");
        return -1;
    }

    if (ioctl(file, I2C_SLAVE, addr) < 0)
    {
        RLOGE("Failed to acquire bus access and/or talk to slave\n");
        close(file);
        return -1;
    }

    switch (volume) {
        case 1:
            buf[0] = 0x03;
            buf[1] = 0x00;  //Gain set to 20 dB
            break;
        case 2:
            buf[0] = 0x03;
            buf[1] = 0x78;  //Gain set to 26 dB
            break;
        case 3:
            buf[0] = 0x03;
            buf[1] = 0x80;  //Gain set to 32 dB
            break;
        case 4:
            buf[0] = 0x03;
            buf[1] = 0xc0;  //Gain set to 36 dB
            break;
    }

    if (write(file, buf, 2) != 2)
    {
        RLOGE("Failed to write to the i2c bus\n");
        close(file);
        return -1;
    }

    RLOGE("Set the 0x%02x register value to 0x%02x\n", buf[0], buf[1]);

    close(file);

    return 0;
}

int customer_get_pa_volume(int* volume)
{
int file;
    char *filename = "/dev/i2c-0";
    int addr = 0x6c;
    char buf[2];

    if(volume == NULL)
    {
        RLOGE("lynq_get_pa_volume Invalid pointer to volume\n");
        return -1;
    }

    if ((file = open(filename, O_RDWR)) < 0)
    {
        RLOGE("Failed to open i2c bus\n");
        return -1;
    }

    if (ioctl(file, I2C_SLAVE, addr) < 0)
    {
        RLOGE("Failed to acquire bus access and/or talk to slave\n");
        close(file);
        return -1;
    }

    buf[0] = 0x03;

    if (write(file, buf, 1) != 1)
    {
        RLOGE("Failed to write to the i2c bus\n");
        close(file);
        return -1;
    }

    if (read(file, buf, 1) != 1)
    {
        RLOGE("Failed to read from the i2c bus\n");
        close(file);
        return -1;
    }

    close(file);

    *volume = (buf[0] >> 6) + 1;

    return 0;

}

#elif defined(GSW_CODEC_CFG)

void set_codec(media_src_t src, codec_op open_close)
{
    RLOGD("set_gsw_3104_codec src=[%d] op=[%d]", src, open_close);
    set_gsw_3104_codec(open_close);
}

const char * get_customer_tone_path()
{
    return "/tmp/tone.wav";
}

int get_customer_tone_sample_rate()
{
    return 44100;
}

int customer_set_pa_volume(const int volume)
{
    RLOGE("not implement\n");
    return -1;
}

int customer_get_pa_volume(int* volume)
{
    RLOGE("not implement\n");
    return -1;
}

#else
const char * get_customer_tone_path()
{
    return "/tmp/tone.wav";
}

int get_customer_tone_sample_rate()
{
    return 44100;
}

int customer_set_pa_volume(const int volume)
{
    RLOGE("not implement\n");
    return -1;
}

int customer_get_pa_volume(int* volume)
{
    RLOGE("not implement\n");
    return -1;
}

void set_codec(media_src_t src, codec_op open_close)
{
    RLOGE("not implement\n");
}

#endif
