#include <stdarg.h>
#include <stdio.h>
#include <stdarg.h>
#include <unistd.h>
#include <sys/time.h>
#include <time.h>
#include <signal.h>
#include <string.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <arpa/inet.h>
#include <dlfcn.h>
#include <stdlib.h>
#include <semaphore.h>
#include <pthread.h>
#include <log/log.h>
#include <stdlib.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/stat.h>

#include "lynq_gnss.h"
#include "gpshal.h"
#include "hal2mnl_interface.h"
#include "lynq_gnsshal.h"
#include "mtk_lbs_utility.h"
#include "lynq_prop.h"
#include "mnldinf_utility.h"
#include "include/lynq_uci.h"

#define LOG_TAG "LYNQ_GNSS"


lynq_gnss_cb* lynq_callbacks =NULL ;
lynq_raw_gnss_cbs* lynq_meas_callbacks = NULL;

GpsCallbacks_ext* turn_cbs = NULL;
GpsMeasurementCallbacks_ext* raw_cbs = NULL;

lynq_gnss_cb* lynq_at_callbacks = NULL ;
/**
 * @brief mark gnss initialization state
 * 0: deinit state
 * 1: init state
 */
static int g_lynq_gnss_init_flag = 0;

static int g_lynq_gnss_calback_flag = 0;
#ifdef GNSS_SYNC_TIME_CFG
int g_gnss_sync_enable_flag = 0;
int g_gnss_sync_done = 0;
#endif

enum
{
    Gnss_ok = 0,
    Not_open = 1,
    Not_located = 10,
    Gnss_unknow = 100
};

/**
 * @brief mark gnss raw meas state
 * 0: deinit state
 * 1: init state
 */
static int g_lynq_gnss_raw_meas_flag = 0;
int at_gps_status = 0;
int at_gpsnmea_status = 0;
#ifdef GNSS_ELT_OUTPUT_CFG
int g_ttyGS_fd= -1;
bool Open_ELT = true;
#endif
int at_gpsinfo_ok = 0;
char gpsinfo[512] = {0};

int lynq_gnss_init(void)
{
    if (g_lynq_gnss_init_flag == 1)
    {
        RLOGD("init twice is not allowed");
        return -1;
    }
    if (g_lynq_gnss_calback_flag == 0)
    {
        RLOGD("Plz Reg callback before init");
        return -1;
    }
    g_lynq_gnss_init_flag = 1;
    gpshal_set_gps_state_intent(GPSHAL_STATE_INIT);
    gpshal2mnl_gps_init();
    g_gpshal_ctx.mnl_retry_timer = mnldinf_init_timer(gpshal_mnl_retry_routine);
#ifdef GNSS_ELT_OUTPUT_CFG
    if(Open_ELT)
    {
        g_ttyGS_fd= open(DEV, O_RDWR | O_NOCTTY | O_NDELAY);
        if(g_ttyGS_fd < 0)
        {
            RLOGD("Open dev fail");
        }
    }
#endif
    return 0;
}

int lynq_gnss_callback_reg(lynq_gnss_cb* callbacks)
{   
    int i=0;
    if (NULL == callbacks)
    {
        RLOGD("illegal callbacks!!!");
        return -1;
    }
    mnldinf_wake_lock_init();
    lynq_callbacks = callbacks;
    turn_cbs = lynq__get_gps_callbacks();
    if(turn_cbs == NULL)
    {
        RLOGD("callbacks error");
        return -1;
    }
    for(i=0;i<5;i++)
    {
        RLOGD("The callback_gps_state:%s",gpshal_state_to_string(g_gpshal_ctx.gps_state));
        if(gpshal_gpscbs_save(turn_cbs) != 0)
        {
            RLOGD("For cbs save error\r\n");
        }
        RLOGD("The callback_gps_state:%s",gpshal_state_to_string(g_gpshal_ctx.gps_state));
        if(g_gpshal_ctx.gps_state != GPSHAL_STATE_UNKNOWN)
        {
            break;
        }
        sleep(1);
    }
    if(i>=5)
    {
        RLOGD("For cbs save error2\r\n");
        return -1;
    }
    g_lynq_gnss_calback_flag = 1;
    return 0;
}

int lynq_gnss_deinit(void)
{
    if (g_lynq_gnss_init_flag == 0)
    {
        RLOGD("deinit twice is not allowed");
        return -1;
    }
    timer_t retry_timer;
    gpshal_set_gps_state_intent(GPSHAL_STATE_CLEANUP);
    gpshal2mnl_gps_cleanup();
    RLOGD("WAKE_LOCK_Begin");
    mnldinf_wake_lock_deinit();
    RLOGD("WAKE_LOCK_END");
    retry_timer = g_gpshal_ctx.mnl_retry_timer;
    g_gpshal_ctx.mnl_retry_timer = INVALID_TIMERID;
    RLOGD("timer deinit start");
    if(mnldinf_deinit_timer(retry_timer) == -1) {
        RLOGD("retry_timer deinit fail:%s", strerror(errno));
        return -1;
    }
    RLOGD("timer de init end");
    g_lynq_gnss_calback_flag = 0;
    g_lynq_gnss_init_flag = 0;
    at_gpsinfo_ok = 0;
#ifdef GNSS_ELT_OUTPUT_CFG
    if(g_ttyGS_fd >= 0)
    {
        close(g_ttyGS_fd);
        g_ttyGS_fd = -1;
    }
#endif
    return 0;
}

int lynq_gnss_start(void)
{
    if (g_lynq_gnss_init_flag == 0)
    {
        RLOGD("start is not allowed");
        return -1;
    }
#ifdef GNSS_SYNC_TIME_CFG
    char gnss_sync_enable[24] = "";
    lynq_get_value("lynq_uci", "lynq_sync_time", "lynq_gnss_sync_time_enable" , gnss_sync_enable);
    g_gnss_sync_enable_flag = atoi(gnss_sync_enable);
    g_gnss_sync_done = 0;
#endif
    //memset(&lynq_debug_data, 0, sizeof(DebugData));
    gpshal_set_gps_state_intent(GPSHAL_STATE_START);
    gpshal2mnl_gps_start();
    return 0;
}

int lynq_gnss_stop(void)
{
    if (g_lynq_gnss_init_flag == 0)
    {
        RLOGD("stop is not allowed");
        return -1;
    }
    gpshal_set_gps_state_intent(GPSHAL_STATE_STOP);
    gpshal2mnl_gps_stop();
    return 0;
}

int lynq_gnss_inject_time(GpsUtcTime time, int64_t timeReference, int uncertainty)
{
    if (hal2mnl_gps_inject_time(time, timeReference, uncertainty) == -1) {
        RLOGD("hal2mnl_gps_inject_time failed because of safe_sendto fail ,strerror:%s \n", strerror(errno));
        return -1;
    }
    return 0;
}

int lynq_gnss_inject_location(
        double latitude,
        double longitude,
        float  accuracy) {
    if (hal2mnl_gps_inject_location(latitude, longitude, accuracy) == -1) {
        RLOGD("hal2mnl_gps_inject_location failed because of safe_sendto fail ,strerror:%s \n", strerror(errno));
        return -1;
    }
    return 0;
}

int lynq_gnss_delete_aiding_data(GpsAidingData flags) {
    if (hal2mnl_gps_delete_aiding_data(flags) == -1) {
        RLOGD("hal2mnl_gps_delete_aiding_data failed because of safe_sendto fail ,strerror:%s \n", strerror(errno));
        return -1;
    }
    return 0;
}

int lynq_gnss_inject_fused_location(
        double latitude,
        double longitude,
        float  accuracy) {
    // TODO:  hal2mnl_gps_inject_fused_location(latitude, longitude, accuracy);
    UNUSED(latitude);
    UNUSED(longitude);
    UNUSED(accuracy);
    return 0;  // 0:ok,   non-zero: error; but GPS JNI will ignore it
}
/*get extension*/
int lynq_gnss_start_raw_meas_mode(lynq_raw_gnss_cbs* raw_gnss_cbs)
{
    if (g_lynq_gnss_raw_meas_flag == 1)
    {
        RLOGD("start twice is not allowed");
        return -1;
    }
    g_lynq_gnss_raw_meas_flag = 1;

    lynq_meas_callbacks = raw_gnss_cbs;
    raw_cbs = lynq_gnss_get_raw_callbacks();
    if (NULL == raw_cbs)
    {
        RLOGD("callbacks error");
        return -2;
    }
    g_gpshal_ctx.meas_cbs = raw_cbs;
    RLOGD("liblynq-gnss:Test for adress %p",g_gpshal_ctx.meas_cbs);
    int ret = hal2mnl_set_gps_measurement(true, true);
    return (ret > 0)?
            GPS_GEOFENCE_OPERATION_SUCCESS :
            GPS_GEOFENCE_ERROR_GENERIC;
}

int lynq_gnss_stop_raw_meas_mode()
{
    if (g_lynq_gnss_raw_meas_flag == 0)
    {
        RLOGD("must start raw meas first");
        return -1;
    }
    if (hal2mnl_set_gps_measurement(false, false) == -1) {
        LOGE("hal2mnl_set_gps_measurement failed because of safe_sendto fail ,strerror:%s \n", strerror(errno));
    }
    RLOGD("typethree test: stop gps raw measurement");
    return 0;
}

int lynq_gnss_set_start_mode(LYNQ_GNSS_MODE_CONFIGURATION start_mode)
{
    int ret = 0;
    switch (start_mode)
    {
        case LYNQ_MODE_GPS_GLONASS:
            mnld_write_cfg(LYNQ_GNSS_MODE , LYNQ_CONF_GPS_GLONASS);
            break;

        case LYNQ_MODE_GPS_BEIDOU:
            mnld_write_cfg(LYNQ_GNSS_MODE , LYNQ_CONF_GPS_BEIDOU);
            break;

        case LYNQ_MODE_GPS_GLONASS_BEIDOU:
            mnld_write_cfg(LYNQ_GNSS_MODE , LYNQ_CONF_GPS_GLONASS_BEIDOU);
            break;

        case LYNQ_MODE_GPS:
            mnld_write_cfg(LYNQ_GNSS_MODE , LYNQ_CONF_GPS);
            break;

        case LYNQ_MODE_BEIDOU:
            mnld_write_cfg(LYNQ_GNSS_MODE , LYNQ_CONF_BEIDOU);
            break;

        case LYNQ_MODE_GLONASS:
            mnld_write_cfg(LYNQ_GNSS_MODE , LYNQ_CONF_GLONASS);
            break;

        case LYNQ_MODE_GPS_GLONASS_BEIDOU_GALILEO:
            mnld_write_cfg(LYNQ_GNSS_MODE , LYNQ_CONF_GPS_GLONASS_BEIDOU_GALILEO);

            break;

        case LYNQ_MODE_GPS_GALILEO:
            mnld_write_cfg(LYNQ_GNSS_MODE , LYNQ_CONF_GPS_GALILEO);

            break;  

        case LYNQ_MODE_GPS_GLONASS_GALILEO:
            mnld_write_cfg(LYNQ_GNSS_MODE , LYNQ_CONF_GPS_GLONASS_GALILEO);

            break;

        case LYNQ_MODE_GPS_GALILEO_ONLY:
            mnld_write_cfg(LYNQ_GNSS_MODE , LYNQ_CONF_GPS_GALILEO_ONLY);

            break;

        case LYNQ_MODE_GPS_GLONASS_BEIDOU_GALILEO_NAVIC:
            mnld_write_cfg(LYNQ_GNSS_MODE , LYNQ_CONF_GPS_GLONASS_BEIDOU_GALILEO_NAVIC);

            break; 
        default:
            RLOGD("unknown type of GNSS MODE");
            ret = -1;
            break;
    }
    
    return ret;
}

int lynq_gnss_debug_switch(LYNQ_CONF_SWITCH switch_op)
{
    int ret = 0;
    switch (switch_op)
    {
        case LYNQ_SWITCH_DISABLE:
            mnld_write_cfg(LYNQ_DEBUG_STATUS,LYNQ_CONFIG_DISABLE);
            break;
        case LYNQ_SWITCH_ENABLE:
            mnld_write_cfg(LYNQ_DEBUG_STATUS,LYNQ_CONFIG_ENABLE);
            break;
        default:
            RLOGD("unknown op");
            ret = -1;
            break;
    }
    return ret;
}

int lynq_gnss_epo_switch(LYNQ_CONF_SWITCH switch_op)
{
    int ret = 0;
    switch (switch_op)
    {
        case LYNQ_SWITCH_DISABLE:
            mnld_write_cfg(LYNQ_EPO_STATUS,LYNQ_CONFIG_DISABLE);
            break;
        case LYNQ_SWITCH_ENABLE:
            mnld_write_cfg(LYNQ_EPO_STATUS,LYNQ_CONFIG_ENABLE);
            break;
        default:
            RLOGD("unknown op");
            ret = -1;
            break;
    }
    return ret;
}

int lynq_gnss_output_frequency_set(int frequency)
{
    int frequency_turn = frequency;

    int freq_num = 1000/frequency_turn;
    char freq[LYNQ_MAX_FRREQUENCY];
    sprintf(freq, "%d", freq_num);
    mnld_write_cfg(LYNQ_OUTPUT_FREQUENCY,freq);
    return 0;
}

lynq_atsvc_outcb atsvc_gnss_outcb;
void atsvc_incb_entity(const char *input,const int length);
int lynq_at_cgps(int at_type,char *at_paramter);
int lynq_at_cgpsnmea(int at_type,char *at_paramter);
int lynq_at_cgpsinfo(void);
void lynq_display_res(int res);

int strUpper(char * str)
{
    int i=0;
    while(1)
    {
        if(str[i]=='\0')
        {
            break;
        }
        if(str[i]>='a'&&str[i]<='z')
        {
             str[i]=str[i]-32;
        }
        i++;
    }
    return 0;      
}

int gnss_at_cmd_parse(char *cmd,char *parse_cmd[],int* at_type)
{
    if (NULL == cmd || NULL == parse_cmd || NULL == at_type)
    {
        return -1;
    }
    int ret = 0;
    int at_type_jug = 0;
    int cmd_size;
    char cmd_buf[128] = {0};
    char buffer1[128] = {0};
    char buffer2[128] = {0};
    bzero(cmd_buf,128);
    bzero(buffer1,128);
    bzero(buffer2,128);
    cmd_size = strlen(cmd);
    memcpy(cmd_buf,cmd,cmd_size);
    strUpper(cmd_buf);
    ret = sscanf(cmd_buf, "%[^=]=%[^=]", buffer1,buffer2);
    if (ret == 1)
    {
        *at_type = 1;
        sscanf(buffer1, "%[^?]", buffer2);
        strcpy(parse_cmd[0],buffer2);
        return 0;
    }
    else if (ret == 2)
    {
        at_type_jug = strcmp(buffer2,"?");
        RLOGD("at_type_jug :%d",at_type_jug);
        if (at_type_jug == 0)
        {
            *at_type = 0;
            strcpy(parse_cmd[0],buffer1);
            return 0;
        }
        else 
        {
            *at_type = 2;
            RLOGD("Buffertest1:buffer1 :%s  buffer2 :%s",buffer1,buffer2);
            strcpy(parse_cmd[0],buffer1);
            strcpy(parse_cmd[1],buffer2);
            RLOGD("buffer1 :%s  buffer2 :%s",parse_cmd[0],parse_cmd[1]);
            return 0;
        }
    }
    else
    {
        RLOGD("unknown paramters");
        return -1;
    }
}

lynq_atsvc_incb lynq_register_gnss(lynq_atsvc_outcb out_cb)
{
    char reg_return[100] = {0};
    if(NULL == out_cb)
    {
        RLOGD("out cb is null");
        return NULL;
    }
    atsvc_gnss_outcb=out_cb;
    memcpy(reg_return,"gnss register success\r\n",24);
    atsvc_gnss_outcb(reg_return,24,0);
    return atsvc_incb_entity;
}


void atsvc_incb_entity(const char *input,const int length)
{
    int res = 0;
    int income_at_type = 0;
    char at_cmd[512]={0};
    char gnss_at_cmd[100] = {0};
    char *parse_atcmd[128]; //argv[0]:at cmd,argv[2]:at paramter
    if(NULL == input)
    {
        RLOGD("input is null");
        memcpy(gnss_at_cmd,"+CME ERROR: 100\r\n",strlen("+CME ERROR: 100\r\n"));
        atsvc_gnss_outcb(gnss_at_cmd,strlen("+CME ERROR: 100\r\n"),0);
        return -1;
    }
    if (strlen(input) >= 128)
    {
        RLOGD("input size more than 128");
        memcpy(gnss_at_cmd,"+CME ERROR: 100\r\n",strlen("+CME ERROR: 100\r\n"));
        atsvc_gnss_outcb(gnss_at_cmd,strlen("+CME ERROR: 100\r\n"),0);
        return -1;
    }
    bzero(at_cmd,512);
    memcpy(at_cmd,input,strlen(input));
    res = gnss_at_cmd_parse(at_cmd,parse_atcmd,&income_at_type);
    if (res != 0)
    {
        RLOGD("parse at cmd error");
        return -1;
    }

    if (!strcmp(parse_atcmd[0], "AT+CGPS"))
    {
        res = lynq_at_cgps(income_at_type,parse_atcmd[1]);
        if (res != 0)
        {
            RLOGD("cgps unknown error");
        }
    }
    else if (!strcmp(parse_atcmd[0], "AT+CGPSNMEA"))
    {
        res = lynq_at_cgpsnmea(income_at_type,parse_atcmd[1]);
    }
    else if (!strcmp(parse_atcmd[0], "AT+CGPSINFO"))
    {
        res = lynq_at_cgpsinfo();
    }
    lynq_display_res(res);
}


int lynq_at_cgps(int at_type,char *at_paramter)
{
    int ret = 0;
    char cgps_at_res[512]={};

    if (at_type == LYNQ_ATCMD_TEST)
    {
        bzero(cgps_at_res,512);
        memcpy(cgps_at_res,"+CGPS:(0,1)\r\n",strlen("+CGPS:(0,1)"));
        atsvc_gnss_outcb(cgps_at_res,strlen("+CGPS:(0,1)\r\n"),0);
        return 0;
    }
    else if(at_type == LYNQ_ATCMD_READ)
    {
        bzero(cgps_at_res,512);
        sprintf(cgps_at_res,"+CGPS:<%d>",at_gps_status);
        atsvc_gnss_outcb(cgps_at_res,strlen(cgps_at_res),0);
        return 0;
    }
    else if(at_type == LYNQ_ATCMD_WRITE)
    {
        if (at_gps_status != atoi(at_paramter))
        {
            at_gps_status = atoi(at_paramter);
        }
        else
        {
            bzero(cgps_at_res,512);
            memcpy(cgps_at_res,"+CGPS ERROR: same status\r\n",strlen("+CGPS ERROR: same status\r\n"));
            atsvc_gnss_outcb(cgps_at_res,strlen(cgps_at_res),0);
            return -1;
        }
        if (at_gps_status == 0)
        {
#ifdef GNSS_ELT_OUTPUT_CFG
            Open_ELT = true;
#endif
            ret = lynq_gnss_stop();
            if (ret != 0)
            {
                RLOGD("lynq gnss stop fail");
                return -1;
            }
            ret = lynq_gnss_deinit();
            if (ret != 0)
            {
                RLOGD("lynq gnss deinit fail");
                return -1;
            }
            bzero(cgps_at_res,512);
            memcpy(cgps_at_res,"+CGPS OK\r\n",strlen("+CGPS OK\r\n"));
            atsvc_gnss_outcb(cgps_at_res,strlen(cgps_at_res),0);
        }
        else if(at_gps_status == 1)
        {
#ifdef GNSS_ELT_OUTPUT_CFG
            Open_ELT = false;
#endif
            lynq_at_callbacks = lynq_at_get__gnss_callbacks();
            ret = lynq_gnss_callback_reg(lynq_at_callbacks);
            if (ret != 0)
            {
                RLOGD("lynq gnss callback reg fail");
                return -1;
            }
            ret = lynq_gnss_init();
            if (ret != 0)
            {
                RLOGD("lynq gnss init fail");
                return -1;
            }
            ret = lynq_gnss_start();
            if (ret != 0)
            {
                RLOGD("lynq gnss init fail");
                return -1;
            }
            bzero(cgps_at_res,512);
            memcpy(cgps_at_res,"+CGPS OK\r\n",strlen("+CGPS OK\r\n"));
            atsvc_gnss_outcb(cgps_at_res,strlen(cgps_at_res),0);
        }
        else
        {
            RLOGD("unknown at paramters");
            bzero(cgps_at_res,512);
            memcpy(cgps_at_res,"+CGPS ERROR: 100\r\n",strlen("+CGPS ERROR: 100\r\n"));
            atsvc_gnss_outcb(cgps_at_res,strlen("+CGPS ERROR: 100\r\n"),0);
        }
        return 0;
    }
}


int lynq_at_cgpsnmea(int at_type,char *at_paramter)
{
    int ret = 0;
    char cgpsnmea_at_res[512]={};

    if (at_type == LYNQ_ATCMD_TEST)
    {
        bzero(cgpsnmea_at_res,512);
        memcpy(cgpsnmea_at_res,"+CGPSNMEA:(0,1)\r\n",strlen("+CGPSNMEA:(0,1)"));
        atsvc_gnss_outcb(cgpsnmea_at_res,strlen(cgpsnmea_at_res),0);
        return 0;
    }
    else if(at_type == LYNQ_ATCMD_READ)
    {
        bzero(cgpsnmea_at_res,512);
        sprintf(cgpsnmea_at_res,"+CGPSNMEA:<%d>",at_gpsnmea_status);
        atsvc_gnss_outcb(cgpsnmea_at_res,strlen(cgpsnmea_at_res),0);
        return 0;
    }
    else if(at_type == LYNQ_ATCMD_WRITE)
    {
        if (at_gpsnmea_status != atoi(at_paramter))
        {
            at_gpsnmea_status = atoi(at_paramter);
            bzero(cgpsnmea_at_res,512);
            memcpy(cgpsnmea_at_res,"+CGPSNMEA OK\r\n",strlen("+CGPSNMEA OK\r\n"));
            atsvc_gnss_outcb(cgpsnmea_at_res,strlen(cgpsnmea_at_res),0);
        }
        else
        {
            RLOGD("unknown at paramters");
            bzero(cgpsnmea_at_res,512);
            memcpy(cgpsnmea_at_res,"+CGPSNMEA ERROR: 100\r\n",strlen("+CGPSNMEA ERROR: 100\r\n"));
            atsvc_gnss_outcb(cgpsnmea_at_res,strlen(cgpsnmea_at_res),0);
        }
        return 0;
    }
}

int lynq_at_cgpsinfo()
{
    if(at_gps_status == 0)//not open gps
    {
        return Not_open;
    }
    if(at_gpsinfo_ok == 0)//means not valid location
    {
        return Not_located;
    }
    else
    {
        atsvc_gnss_outcb(gpsinfo, strlen(gpsinfo), 1);
        return 0;
    }
}

void lynq_display_res(int res)
{
    char res_buf[128] = {0};
    switch (res)
    {
    case Gnss_ok:
        sprintf(res_buf,"OK\r\n",4);
        break;
    case Not_open:
        sprintf(res_buf, "+CME ERROR: %d\r\n", Not_open);
        break;
    case Not_located:
        sprintf(res_buf, "+CME ERROR: %d\r\n", Not_located);
        break;
    default:
        sprintf(res_buf,"+CME ERROR: %d\r\n", Gnss_unknow);
        break;
    }
    atsvc_gnss_outcb(res_buf,strlen(res_buf),0);
}

