#include <stdio.h>
#include <string.h>
#include <liblog/lynq_deflog.h>
#include "rtk_fun.h"
#include "liblynq-rtk.h"


lynq_rtk_out_result lib_result_cb = NULL;
lynq_rtk_out_result_nmea lib_nmea_cb = NULL;
lynq_rtk_out_debuginfo lib_debuginfo = NULL;
lynq_rtk_out_postdata lib_postdata = NULL;
lynq_rtk_out_basesdkstatus lib_basesdkstatus = NULL;
lynq_rtk_out_status lib_status = NULL;


void librtk_out_result(const rtk_result_info * prtk)
{
    /*change rtk_result_info into lynq_result_info*/
    if (NULL == prtk)
    {
        LYERRLOG("result info is NULL return : error");
        return ;
    }
    lynq_rtk_result_info result_info;
    memset(&result_info,0,sizeof(result_info));
    memcpy(&result_info,prtk,sizeof(result_info));
    lib_result_cb(&result_info);
    return ;
}

void librtk_out_result_nmea(const char * strnmea, const int length)
{
    lib_nmea_cb(strnmea,length);
    return ;
}

void librtk_out_debuginfo(const char * pBuff, const int length, const int ilevel)
{
    lib_debuginfo(pBuff,length,ilevel);
    return ;
}

void librtk_out_postdata(const unsigned char * pBuff, const int length)
{
    lib_postdata(pBuff,length);
    return ;
}

void librtk_out_basesdkstatus(const int status)
{
    lib_basesdkstatus(status);
    return ;
}

void librtk_out_status(const int status)
{
    lib_status(status);
    return;
}



void lynq_rtk_lib_version(char * version)
{
    if (NULL == version)
    {
        LYERRLOG("incoming version is NULL, error");
        return ;
    }
    rtk_version(version);
    return ;
}

void lynq_rtk_init()
{
    LYINFLOG("lib rtk init");
    rtk_init();
    return ;
}

void lynq_rtk_set_userinfo(const char *username,const char *pwd)
{
    if (NULL == username || NULL == pwd)
    {
        LYERRLOG("invalid username or pwd incoming ,error");
        return ;
    }
    rtk_set_UserInfo(username,pwd);
    return ;
}

void lynq_rtk_set_deviceID(const char* device_id)
{
    if (NULL == device_id)
    {
        LYERRLOG("invalid device_id incoming ,error");
        return ;
    }
    rtk_set_DeviceID(device_id);
    return ;
}

void lynq_rtk_result_cb_reg(lynq_rtk_out_result result_cb)
{
    if (NULL == result_cb)
    {
        LYERRLOG("invalid lynq_rtk_out_result incoming ,error");
        return ;
    }
    lib_result_cb = result_cb;
    rtk_result_cb(librtk_out_result);
    return ;
}

void lynq_rtk_result_nmea_cb_reg(lynq_rtk_out_result_nmea nmea_cb)
{
    if (NULL == nmea_cb)
    {
        LYERRLOG("invalid lynq_rtk_out_result_nmea incoming ,error");
        return ;
    }
    lib_nmea_cb = nmea_cb;
    rtk_result_nmea_cb(librtk_out_result_nmea);
    return ;
}

void lynq_rtk_config_log_reg(lynq_rtk_out_debuginfo pdebuginfo)
{
    if (NULL == pdebuginfo)
    {
        LYERRLOG("invalid lynq_rtk_out_debuginfo incoming ,error");
        return ;
    }
    lib_debuginfo = pdebuginfo;
    rtk_config_log(librtk_out_debuginfo);
    return ;
}

void lynq_rtk_config_post_reg(lynq_rtk_out_postdata ppostdata)
{
    if (NULL == ppostdata)
    {
        LYERRLOG("invalid lynq_rtk_out_postdata incoming ,error");
        return ;
    }
    lib_debuginfo = ppostdata;
    rtk_config_post(librtk_out_debuginfo);
    return ;
}

void lynq_rtk_base_sdkstatus(lynq_rtk_out_basesdkstatus psdkstatus)
{
    if (NULL == psdkstatus)
    {
        LYERRLOG("invalid lynq_rtk_out_basesdkstatus incoming ,error");
        return ;
    }
    lib_basesdkstatus = psdkstatus;
    rtk_base_sdkstatus(librtk_out_basesdkstatus);
    return ;
}

void lynq_rtk_base_status(lynq_rtk_out_status pstatus)
{
    if (NULL == pstatus)
    {
        LYERRLOG("invalid lynq_rtk_out_status incoming ,error");
        return ;
    }
    lib_status = pstatus;
    rtk_status_update(librtk_out_status);
    return ;
}

void lynq_rtk_rove_addnmea(const unsigned char * pBuff, const int iBuffLen)
{
    rtk_rove_addnmea(pBuff,iBuffLen);
    return ;
}

void lynq_rtk_rove_addrawmess(GnssData_ext* data)
{
    rtk_rove_addrawmess(data);
    return ;
}

void lynq_rtk_setserverIP(const char* server_ip)
{
    rtk_setServerIP(server_ip);
    return ;
}

