/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */


#include <stdlib.h>
#include <stdio.h>
#include <cutils/jstring.h>
#include <log/log.h>
#include <unistd.h>
#include <math.h>
#include <sys/prctl.h>
#include <signal.h>
#include <factory_main.h>
#include <factoryManual.h>
#include <string.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include "common.h"
#include "autoFactoryTest.h"
#include "libtel/lib_tele.h"

#include "ril/ril_test.h"
#ifdef __cplusplus
extern "C" {
#endif
#include "libdriver/libdriver.h"
#ifdef __cplusplus
}
#endif
#include "menu/api_menu.h"
#include "menu/factory_menu.h"
#include "menu/demo_menu.h"
/*
#ifdef __cplusplus
extern "C" {
#endif
#include <gps/gps_test.h>
#ifdef __cplusplus
}
#endif
*/
//#include <lynq_call.h>
#undef LOG_TAG
#define LOG_TAG "FACTORY_ENTRY"
int server_socket_fd;
struct sockaddr_in client_addr;
static pthread_t s_tid_dispatch;
static pthread_t s_tid_automatic;

static const char *factoryCmd ="FACTORY";
static const char *factorySingelCmd ="FACTORY_SINGLE";
factory_arry_t factory_menu[] = {
  {"Config",NUM_ITEMS(config),config,0,0},
  {"Automatic testing",0,NULL,0,0},
  {"Manual test",NUM_ITEMS(manual_menu),manual_menu,0,0},
};

factory_arry_t testmain[] = {
  {"Factory test",NUM_ITEMS(factory_menu),factory_menu,0,0},
};
factory_arry_t fac = {"DEMO TEST",NUM_ITEMS(testmain),testmain,0,0};

int emResultNotify(const char *str,int command)
{
//printf("[EVENT][MT_CALL] phone number is %s\n",p_cur->number);
   // printf("Factory test result:%s",str);
   if (command == FACTORY_SH){
      int len_s = sendto(server_socket_fd,str,strlen(str),0,(struct sockaddr *)&client_addr,sizeof(client_addr));
      sendto(server_socket_fd,"stopemdone",strlen("stopemdone"),0,(struct sockaddr *)&client_addr,sizeof(client_addr));
	   return len_s;
	}else if (command == FACTORY_SINGLE_SH){
	
      printf("%s\n",str);
	  return 0;
	}
	
}
bool handle_show_default(char *menuName,int command){
  char output[2048] = {0};
  RLOGD("menuName:%s, config[INDEX_PHONENUMB].name:%s ",menuName,config[INDEX_PHONENUMB].name);
  if (strcmp(menuName, config[INDEX_PHONENUMB].name) == 0
){
      char property_value[PHONE_SIZE] = { 0 };
    int i = property_get(PHONE_NUMBER, property_value, "18964376469");
    RLOGD("property_Get phone,i:%d",i);
    sprintf(output, "The current test dial number is %s\n",property_value);
    emResultNotify(output,command);
  }
  else if(strcmp(menuName, config[INDEX_SMS_MESSAGE].name) == 0
){
    char property_value[BUFFER_SIZE] = { 0 };
    int i = property_get(SMS_MESSAGE, property_value, "Hello word");
    RLOGD("property_Get sms,i:%d",i);
    sprintf(output, "The current test sms message is %s\n",property_value);
    emResultNotify(output,command);
  }
  else{
    RLOGD("input error ");
    sprintf(output, "input error\n");
    emResultNotify(output,command);
    return false;
  }
  return true;

}

bool handle_para(int len, char *menuName,char *value,int command) {
        char output[2048] = {0};

    RLOGD("handle_para,len: %d, menuName: %s, value: %s", len,menuName ,value); 
   if (strcmp(menuName, config[INDEX_PHONENUMB].name) == 0
){
       int i;
      i = property_set(PHONE_NUMBER, value);
      RLOGD("property_set phone,i:%d",i);
       sprintf(output, "set dial number is %s\ndone\n",value);
       emResultNotify(output,command);
   }
    else if(strcmp(menuName, config[INDEX_SMS_MESSAGE].name) == 0
){
      int i;
       i = property_set(SMS_MESSAGE, value);
       RLOGD("property_set sms,i:%d",i);
       sprintf(output, "set sms message %s\ndone\n",value);
       emResultNotify(output,command);
    }
    else{
    RLOGD("input error ");
    sprintf(output, "input error\n");
    emResultNotify(output,command);
    return false;
    }
    return true; 
}

int config_parm(int len, int *item, int multilen, char *value,int command){
    int propertyid = item[1];
    int operatorid = item[2];
    int select = item[3];
    for (int i = 0;i<10;i++){
      RLOGD("item%d: %d", i,item[i]);
  }
  
    factory_arry_t *subarry = &(factory_menu[propertyid].subarray[operatorid]);
    RLOGD("rfdesense property , propertyid: %d,operatorid:%d", propertyid,operatorid);
    RLOGD("rfdesense len: %d, multilen: %d,subarry->name:%s",len, multilen,subarry->name);
    switch (select) {
    case 0:{
      if(!handle_show_default(subarry->name,command)) return -1;
        break;
    }
      case 1:{
      if(!handle_para(len,subarry->name,value,command)) return -1;
        break;
    }
      default:
            RLOGD(LOG_TAG, "logic eror ");
            return -1;
  }
  
    RLOGD("config_parm called,len:%d,item:%d,multilen:%d,value:%s",len,*item,multilen,value);
    return 0;

}


const char *
  failCauseToString(RIL_Errcode e) {
    switch(e) {
        case SUCCESS: return "E_SUCCESS";
        case ERROR: return "ERROR";
        default: return "<unknown error>";
    }
  }

static void responseCallback(int32_t token,RIL_Errcode e,char *response) {
  char output[2048] = {0};
  // if(token == requestId)
//  {
  sprintf(output, "RIL_Errcode :%s,response:%s\n",failCauseToString(e),response);
  RLOGD("responseCallback,output:%s,token:%d",output,token); 
  if(m_RfDesense){
    if(0==manu_reqId){
      RLOGD("responseCallback,handle_request"); 
      m_RfDesense->handle_request("", 0, token,e);
    }
    else{
      RLOGE("maybe you are test automatic so you can't go to manual test");
    }
  }else if(token == manu_reqId){
     manu_reqId = 0;
     emResultNotify(output,1);
     }
}
int factory_main(int len, int *item, int multilen,  char *value,char *data,int command) {
    int testclass = item[1];
    switch (testclass) {
      case CONFIG:
        config_parm(len - 1, &item[0], multilen, value,command);
        break;
      case AUTO_TESTING:
  //     requestId = lynq_get_sim_status();
        factory_auto_test();
         //sleep(2);
        if(m_RfDesense){
          m_RfDesense->handle_request("", 0, 0, ERROR);
        }
        break;
      case MANUAL_TEST:
        manu_reqId = factory_manual(len - 1, multilen, &item[0],command);
      default:
          break;
        }
    return 0;
}

int driver_test(int *item, char *value,char *data,int command) {
 	int driver_api_choice = item[2];
 	char *argv[2]={0};
	int num=0;
	char output[1024] = {0};
	RLOGD("driver_test start,value:%s,data:%s,driver_api_choice:%d\n",value,data,driver_api_choice);	 
    switch (driver_api_choice) {
        case SET_GPIO:{
            int  result;
            if(num = parseParam(3, value,argv)){
               result = lynq_set_gpio(argv[1], atoi(&argv[2][0]),atoi(&argv[3][0]));
     		   RLOGD("Factory_result gpio %s set state :%d,command:%d\n",argv[2],result,command);	   
               sprintf(output, "Factory_result set gpio %s set state :%d\ndone\n",argv[2],result);
               emResultNotify(output,command);
            }
            else{
				RLOGD("please input get avaliable param and try again");	
                sprintf(output, "please input get avaliable param and try again!\ndone\n");
                emResultNotify(output,command);
            }
            break;
        }   
		case GET_GPIO:{
			if(num = parseParam(1, value,argv)){
			 char output1[1024] = {0};
              lynq_get_gpio (atoi(&argv[1][0]),output1);
              RLOGD("Factory_result get %d gpio:%s \n",argv[1],output1);	   
              sprintf(output, "Factory_result %s gpio get:%s \ndone\n",argv[1],output1);
              emResultNotify(output,command);
			} else{
                sprintf(output, "please input get avaliable param and try again\ndone\n");
                emResultNotify(output,command);
            }
			
			break;
		}
        default:
            break;
    }
 return 0;

}

int test_api(int len, int *item, int multilen,  char *value,char *data,int command)
{
    int testapi = item[1];
    switch (testapi) {
        case WIFI_API:
            //wifi_test(&item[0],value);
            break;
        case RIL_API:{
            RLOGD("test_api,RIL_API");
            ril_test(&item[0],value,data,command);
			break;
        	}
		 case GPIO_API:{
            RLOGD("test_api,driver_test");
            driver_test(&item[0],value,data,command);
            break;
		 	}
        case GPS_API:
            break;
        case MQTT_API:
            break;
        default:
            break;
    }
    return 0;
}

int test_demo(int len, int *item, int multilen,  char *value,char *data,int command)
{
/*
    int testapi = item[1];
    for (int i = 0;i<10;i++){
      RLOGD("test_api,item%d: %d", i,item[i]);
    }
    switch (testapi) {
        case WIFI_API:
            //wifi_test(&item[0],value);     
            break;
        case RIL_API:
            RLOGD("test_api,RIL_API");
            ril_test(&item[0],value);     
            break;
        case GPS_API:
            break;
        case MQTT_API:
            break;
        default:
            break;
    }
    */
    return 0;
}

int demo_test(int len, int *item, int multilen,  char *value,char *data)
{
    int testapi = item[1];
    for (int i = 0;i<10;i++){
      RLOGD("test_api,item%d: %d", i,item[i]);
    }
    switch (testapi) {
        case DEMO_TEST1:
            RLOGD("demo_test,DEMO_TEST1");    
            break;
        case DEMO_TEST2:
            RLOGD("demo_test,DEMO_TEST2");    
            break;
        case DEMO_TEST3:
            RLOGD("demo_test,DEMO_TEST3");    
            break;
        case DEMO_TEST4:
            RLOGD("demo_test,DEMO_TEST4");    
            break;
        default:
            break;
    }
    return 0;
}
int test_main(int len, int *item, int multilen, char *value[],char *data[],int command) {
  int testclass = item[0];
  int i;
  RLOGD("test_main testclase %d", testclass);
  switch (testclass) {
    case FACTORY_TEST:{
     factory_main(len,&item[0],multilen,(value != NULL ? value[0] : NULL),(data != NULL ? data[0] : NULL),command);
     break;
	 }
    case API_TEST:{
     test_api(len,&item[0],multilen,(value != NULL ? value[0] : NULL),(data != NULL ? data[0] : NULL),command);
     break;
	 }
    case DEMO_TEST:{
     test_demo(len,&item[0],multilen,(value != NULL ? value[0] : NULL),(data != NULL ? data[0] : NULL),command);
     break;
    }
    default:
     break;
    }
    return 0;
}

int factory_start(int argc, char *argv[],int  command){
    RLOGD("factory_start called");
    int i = 0;
    factory_arry_t *factory_test = &fac;
    factory_arry_t *factory_sub = NULL;
    RLOGD("Welcome to factory test %s,command:%d",factory_test->name,command);
    char output[2048] = {0};
    int len = 0;
	for(i=0;i<10;i++){
		RLOGD("argv[%d]: %s",i,argv[i]);
	}
    if(argc < 2){
        for(i = 0; i < factory_test->subcnt; i++){
            sprintf(output+len,"%d:%s\n",i+1,factory_test->subarray[i].name);
            len = strlen(output);
        }
        RLOGD("%s",output);
        emResultNotify(output,command);
        return 0;
    }
    int itemlevel = 0;
    int select_argvi[32] = {0};
    int current_argvi = -1;
    int fun_api = 0;
    for(itemlevel = 1; itemlevel < argc; itemlevel++){
        select_argvi[itemlevel-1] = atoi(argv[itemlevel]) - 1;
        current_argvi = select_argvi[itemlevel-1];
        RLOGD("current_argvi:%d,itemlevel:%d,fun_api:%d",current_argvi,itemlevel,fun_api);
        if (factory_test->subcnt < current_argvi + 1) {
            sprintf(output, "the select index %d is out of bounds, please reselect.\nfail\n",current_argvi + 1);
            emResultNotify(output,command);
            return -1;
        }
        if(factory_test->subarray[current_argvi].subarray == NULL){
          for(i = 0 ; i < (argc - itemlevel - 1); i++){
            select_argvi[itemlevel + i] = atoi(argv[itemlevel+1+i]) - 1;
          }
		  	RLOGD("goto thread,param,%d,go_thread%d",factory_test->subarray[current_argvi].param,
				factory_test->subarray[current_argvi].go_thread);
          if(factory_test->subarray[current_argvi].go_thread == 1){
			RLOGD("goto thread");
		  }else if((factory_test->subarray[current_argvi].param == 1)||
    		  	(factory_test->subarray[current_argvi].param == 2)){
    		  	if(argv[itemlevel+1] != NULL){
					RLOGD("one data");
    		      test_main(itemlevel,&select_argvi[0],(argc - itemlevel - 1),&argv[itemlevel+1],NULL,command);
    		  	}
				 else{
    			  sprintf(output, "no parameter,api:%s\n",factory_test->subarray[current_argvi].name);
                  emResultNotify(output,command);
                  return -1;
    			}
		  } else if(factory_test->subarray[current_argvi].param == 3){
				RLOGD("two data");
                  test_main(itemlevel,&select_argvi[0],(argc - itemlevel - 1),&argv[itemlevel+1],&argv[itemlevel+2],command);
    	   }
    	  
		 else {
			RLOGD("no data");
		  	test_main(itemlevel,&select_argvi[0],(argc - itemlevel - 1),NULL,NULL,command);
		 }
		 break;
		}else{
          RLOGD("em_sub[%d].name: %s, itemlevel: %d, argc: %d ",current_argvi, (factory_test->subarray[current_argvi].name), itemlevel, argc);
          factory_sub = &factory_test->subarray[current_argvi];
          if(itemlevel == (argc - 1)){
              memset(output,0,2048);
              len = 0;
     
              for(i = 0; i < factory_sub->subcnt; i++){
                //RLOGD("%d:%s",i+1,em_sub->subarray[i].name);
                sprintf(output+len,"%d:%s\n",i+1,factory_sub->subarray[i].name);
                len = strlen(output);
              }
              RLOGD("%s",output);
              emResultNotify(output,command);
          }
          factory_test = factory_sub;
      }
    }
    return 0;
}

int parse_param(char *cmd, char *argv[], int max_args){
    char *pos, *pos2;
    int argc = 0;
    int flag = 0;
    pos = cmd;
    while (1) {
        flag = 0;//the flag equal 1,it means this posttion is the end of this string.
        // Trim the space characters.
        while (*pos == ' ') {
            pos++;
        }
        if (*pos == '\0') {
            break;
        }
        // One token may start with '"' or other characters.
        if (*pos == '"' && (pos2 = strrchr(pos+1, '"'))) {
            argv[argc++] = pos + 1;
            *pos2 = '\0';
            pos = pos2 + 1;
            if(*pos == '\n'){
                *pos = '\0';
                pos = pos + 1;
            }

        } else {
            argv[argc++] = pos;
            while (*pos != ' '&& *pos != '\n' && *pos != '-') {
                pos++;
                if (*pos == '\0')
                {
                    flag = 1;
                    break;
                }
            }
            if (flag != 1)
            {
                *pos++ = '\0';
            }
        }

        // Check if the maximum of arguments is reached.
        if (argc == max_args) {
            break;
        }
    }
    return argc;
}


void *
eventLoop(void *param) {
    RLOGD("RIL_StartRevSocket start\n");
    char *argv[MAX_ARGS];
    int  argc = 0;

    prctl(PR_SET_NAME,(unsigned long)"UDP_Thread");

  /*listen UPD SOCKET port */
    struct sockaddr_in server_addr;
    bzero(&server_addr, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_addr.s_addr = htonl(INADDR_ANY);
    server_addr.sin_port = htons(SERVER_PORT);
  /* create socket */
  //int server_socket_fd = socket(AF_INET, SOCK_DGRAM, 0);
   server_socket_fd = socket(AF_INET, SOCK_DGRAM, 0);
    if(server_socket_fd == -1)
  {
   RLOGE("Create Socket Failed:");
   exit(1);
  }
    /* bind socket port*/
    if(-1 == (bind(server_socket_fd,(struct sockaddr*)&server_addr,sizeof(server_addr))))
    {
     RLOGE("Server Bind Failed");
     exit(1);
    }

    /* tranlate data */
    while(true)
    {
         /* define address to catch the client addreess*/
        //struct sockaddr_in client_addr;
        socklen_t client_addr_length = sizeof(client_addr);

        /* receive the data */
        char buffer[BUFFER_SIZE];
        bzero(buffer, BUFFER_SIZE);
        if(recvfrom(server_socket_fd, buffer, BUFFER_SIZE,0,(struct sockaddr*)&client_addr, &client_addr_length) == -1)
        {
            RLOGE("Receive Data Failed:");
            continue;
        }
        RLOGD("Factory test:%s, receive: %s", inet_ntoa(client_addr.sin_addr), buffer);
        int argc = parse_param(buffer, argv, MAX_ARGS);
        //printf("=====parse_param=====> argc = %d\n",argc);
        if(argc < 1)
        {
            RLOGE("%s: error input.", buffer);
            continue;
        }
        if (strcmp (argv[0], factoryCmd) == 0){
          factory_start(argc,argv,FACTORY_SH);
		   RLOGD("FACTORY_SH");
		}else if(strcmp (argv[0], factorySingelCmd) == 0)
		{
          factory_start(argc,argv,FACTORY_SINGLE_SH);
		   RLOGD("close socket fd");
        }
      else {
            RLOGE("%s: No such command for factoryTest", argv[0]);
        }
       

     }
     RLOGD("close socket fd");
     close(server_socket_fd);

    RLOGD("error in event_loop_base errno:%d", errno);
    // kill self to restart on error
    kill(0, SIGKILL);

    return NULL;
}

static void gps_status_cb(int state){
  RIL_Errcode e;
  char property_value[5] = { 0 };
  if(1 == state){
    e = ERROR;
  }else if(0 == state){
      e = SUCCESS;
    
  }else{
    RLOGW("Failed to get gps state: %d", state);
  }
   property_set(GPS_STATUS, failCauseToString(e));  
   property_get(GPS_STATUS, property_value, "0");
   RLOGD("gps_status_cb: %s\n", property_value);
   if(m_RfDesense){
    RLOGD("gps_status_cb,handle_request"); 
    m_RfDesense->handle_request("", 0, 0, e);
   }else{
   char output[2048] = {0};
   sprintf(output, "gps open :%s\n",failCauseToString(e));
   emResultNotify(output,1);
 }
 
  
}
void lynqStartEventLoop(void){
    RLOGD("RIL_startEventLoop()");
    //lynqRegisterRequestResponse(responseCallback);
   // register_gps_callback(gps_status_cb);
    /* spin up eventLoop thread and wait for it to get started */
    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
    int result = pthread_create(&s_tid_dispatch, &attr, eventLoop, NULL);
    if (result != 0) {
        RLOGW("Failed to create dispatch thread: %s", strerror(result));
    }
}

