/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef RFAUTOMATICTEST_H_
#define RFAUTOMATICTEST_H_

#include <string>
#include <vector>
#include <memory>
#include <mutex>
#include <thread>
#include <condition_variable>
#include <vendor-ril/telephony/ril.h>
#include <utils/Looper.h>
#include <utils/Thread.h>
#include <utils/RefBase.h>
#include "libtel/lib_tele.h"
using namespace std;
using ::android::Looper;
using ::android::Thread;
using ::android::MessageHandler;
using ::android::Message;
using ::android::sp;
using ::android::RefBase;

static  int mFactoryResult[3] = { 0, 0, 0 };

class RfAutomaticTest: public android::RefBase {
public:
    RfAutomaticTest();
    virtual ~RfAutomaticTest();
    static RfAutomaticTest* getInstance();
    int AutoFactoryStart();
    class RequestHandleThread: public Thread {
    public:
        RequestHandleThread(RfAutomaticTest* tx);
        virtual ~RequestHandleThread();
        sp<Looper> getLooper();

    protected:
        RfAutomaticTest* mTx;
        virtual bool threadLoop();
    private:
        sp<Looper> m_looper;
    };

    class RfRequestMessage: public RefBase {
    public:
        RfRequestMessage(RfAutomaticTest* tx);
        virtual ~RfRequestMessage();
    //    void sendMessage(int delayms);
    public:
        int mMsgType;
        string response;
        int responselen;
        int slot;
        RIL_Errcode e;
    private:
        RfAutomaticTest* mTx;
    };

    class RfRequestHandler: public MessageHandler {
    public:
        RfRequestHandler(RfAutomaticTest* tx): mTx(tx){}
        virtual ~RfRequestHandler();

    public:
 //       void sendMessage(sp<RfRequestMessage> msg, int delayms);
        void handleMessage(const Message& message);
        sp<RfRequestMessage> mMsg;
        // dummy message that makes handler happy
        Message m_dummyMsg;
    private:
        RfAutomaticTest* mTx;
    };  
public:
    static const int MSG_NULL;
    static const int MSG_TELE;
    static const int MSG_SIM;
    static const int MSG_GPS;
    int mCurrentFlag;
    sp<RequestHandleThread> mRequestHandleThread;
    sp<RfRequestHandler> mRfRequestHandler;

	sp<RfRequestHandler> sendMessage(sp<RfRequestMessage> msg, int delayms);
	void handle_request(string response,int responselen,int slot, RIL_Errcode e);
    void factory_test_onebyone(sp<RfRequestMessage> msg);
	int  factory_test_go();
	//int factory_auto_test();

private:
    static RfAutomaticTest* m_instance;
	static std::mutex mMutex;
private:
    void init();

};

#endif /* RFDESENSETXTEST_H_ */
