#include<pthread.h>
#include<stdio.h>
#include<unistd.h>
#include<errno.h>
#include<string.h>
#include <time.h>

#include"lynq_gnss.h"
#include"lynq-gnss-test.h"
#include"include/lynq_systime.h"
#include"include/lynq_uci.h"

/*extern struct timespec lynq_gnss_open_tm;
extern int lynq_ttff_time;
extern int lynq_test_session_end;*/
lynq_test_gnss_result lynq_test_result;
char gnss_ttyCmd[512];

void lynq_test_gps_location_callback(lynq_GpsLocation_ext* location)
{
    if(location->legacyLocation.size == sizeof(lynq_GpsLocation_ext))
    {
        // printf("===============Update Location Info==================\r\n");
        // printf("flags:0x%x\r\n", location->legacyLocation.flags);
        // printf("latitude:%.10lf\r\n", location->legacyLocation.latitude);
        // printf("longitude:%.10lf\r\n", location->legacyLocation.longitude);
        // printf("altitude:%.10lf\r\n", location->legacyLocation.altitude);
        // printf("speed:%f\r\n", location->legacyLocation.speed);
        // printf("bearing:%f\r\n", location->legacyLocation.bearing);
        // printf("timestamp:%ld\r\n", location->legacyLocation.timestamp);
        // printf("horizontalAccuracyMeters:%f\r\n", location->horizontalAccuracyMeters);
        // printf("verticalAccuracyMeters:%f\r\n", location->verticalAccuracyMeters);
        // printf("speedAccuracyMetersPerSecond:%f\r\n", location->speedAccuracyMetersPerSecond);
        // printf("bearingAccuracyDegrees:%f\r\n", location->bearingAccuracyDegrees);
        memset(&(lynq_test_result.location), 0, sizeof(lynq_GpsLocation_ext));
        memcpy(&(lynq_test_result.location), location, sizeof(lynq_GpsLocation_ext));
    }
    else
    {

    }
}

void lynq_test_gps_status_callback(GpsStatus* status)
{
    if(status->size == sizeof(GpsStatus))
    {
        if(status->status == GPS_STATUS_SESSION_BEGIN)
        {
            
        }
        if(status->status == GPS_STATUS_SESSION_END)
        {

        }
    }
    else
    {
        printf("status error\r\n");
    }
}

#define NMEA_ACC "ACCURACY"
#define NMEA_GSA "GSA"
#define NMEA_RMC "RMC"
#define NMEA_GGA "GGA"
#define NMEA_VTG "VTG"
#define NMEA_GSV "GSV"

#if 0
int gnss_set_time_flag=0;
int update_gnss_time(GpsUtcTime sec) 
{
    time_t t;
    t = sec/1000;
    stime(&t);
    return 0;
} 
#endif

void lynq_test_gps_nmea_callback(GpsUtcTime timestamp, const char* nmea, int length)
{
#if 0
    char gnss_sync_enable[24] = "";
    //printf("NMEA report at %ld========\n",timestamp);
    lynq_get_value("lynq_uci", "lynq_sync_time", "lynq_gnss_sync_time_enable" , gnss_sync_enable);
    if (1 == atoi(gnss_sync_enable)) {
        if ((lynq_test_result.fix_type == 3)  && (gnss_set_time_flag == 0)) {
            update_gnss_time(timestamp);
            gnss_set_time_flag = 1;
        }
    }
#endif	
    if(strncmp(nmea+3,NMEA_GSA,strlen(NMEA_GSA))==0)
    {
        lynq_test_result.fix_type = *(nmea+9) - '0';
    }
    else
    {
        
    }
    
    if(strncmp(nmea+3,NMEA_ACC,strlen(NMEA_ACC)) == 0)
    {
        lynq_test_result.location.legacyLocation.timestamp= timestamp;
        //lynq_show_gnss_test_result(&lynq_test_result);
    }
    if(strncmp(nmea+3,NMEA_GSA,strlen(NMEA_GSA))==0 || strncmp(nmea+3,NMEA_RMC,strlen(NMEA_RMC)) == 0 || \
        strncmp(nmea+3,NMEA_GGA,strlen(NMEA_GGA)) == 0 || strncmp(nmea+3,NMEA_VTG,strlen(NMEA_VTG)) == 0|| \
        strncmp(nmea+3,NMEA_GSV,strlen(NMEA_GSV)) == 0)
        {
            printf("%s\r\n",nmea);
            //sprintf(gnss_ttyCmd,"echo -e \"\\%s\\r\\n\" > /dev/ttyGS0",nmea);
            //system(gnss_ttyCmd);
        }
}



pthread_t lynq_test_gps_create_thread(const char* name, void (*start)(void *), void* arg)
{
    pthread_t ntid = 0;
    int ret = 0;

    ret = pthread_create(&ntid, NULL, (void *(*)(void *))start, arg);

    if(ret != 0)
    {
        printf("thread %s create fail(%s)!\r\n", name, strerror(errno));
        ntid = 0;
    }
    else
    {
        printf("tread %s create success!\r\n", name);
    }

    return ntid;
}

lynq_gnss_cb lynq_gnss_callbacks = {
    .size = sizeof(lynq_gnss_cb),
    .lynq_location_cb =lynq_test_gps_location_callback,
    .lynq_status_cb = lynq_test_gps_status_callback,
    .lynq_nmea_cb = lynq_test_gps_nmea_callback,
    .lynq_create_thread_cb = lynq_test_gps_create_thread,
};

lynq_gnss_cb* lynq_test_get__gnss_callbacks(void)
{
    return &lynq_gnss_callbacks;
}


void lynq_gnss__measurement_callback(GnssData_ext* data) 
{
    int i;
    int meas_cnt;
    GnssMeasurement_ext* raw_meas;
    GnssClock_ext* clk;
    ElapsedRealtime* elap_realtime;

    if (data == NULL) {
        printf("param error");
        return;
    }

    meas_cnt = data->measurement_count;
    printf("==================== print_gnss_measurement ====================");
    printf("measurement count is: %d", meas_cnt);
    for (i = 0; i < meas_cnt; i++) {
        raw_meas = &(data->measurements[i]);
        printf("********* measurement message %d *********\r\n", i+1);
        printf("flags=0x%x\r\n", raw_meas->legacyMeasurement.flags);
        printf("svid=%d\r\n", raw_meas->legacyMeasurement.svid);
        printf("constellation=0x%x\r\n", raw_meas->legacyMeasurement.constellation);
        printf("time_offset_ns=%f\r\n", raw_meas->legacyMeasurement.time_offset_ns);
        printf("state=0x%x\r\n", raw_meas->legacyMeasurement.state);
        printf("c_n0_dbhz=%f\r\n", raw_meas->legacyMeasurement.c_n0_dbhz);
        printf("pseudorange_rate_mps=%f\r\n", raw_meas->legacyMeasurement.pseudorange_rate_mps);
        printf("pseudorange_rate_uncertainty_mps=%f\r\n", raw_meas->legacyMeasurement.pseudorange_rate_uncertainty_mps);
        printf("accumulated_delta_range_state=0x%x\r\n", raw_meas->legacyMeasurement.accumulated_delta_range_state);
        printf("accumulated_delta_range_m=%f\r\n", raw_meas->legacyMeasurement.accumulated_delta_range_m);
        printf("accumulated_delta_range_uncertainty_m=%f\r\n", raw_meas->legacyMeasurement.accumulated_delta_range_uncertainty_m);
        printf("carrier_frequency_hz=%f\r\n", raw_meas->legacyMeasurement.carrier_frequency_hz);
        printf("carrier_phase=%f\r\n", raw_meas->legacyMeasurement.carrier_phase);
        printf("carrier_phase_uncertainty=%f\r\n", raw_meas->legacyMeasurement.carrier_phase_uncertainty);
        printf("multipath_indicator=%d\r\n", raw_meas->legacyMeasurement.multipath_indicator);
        printf("snr_db=%f\r\n", raw_meas->legacyMeasurement.snr_db);

        printf("agc_level_db=%f\r\n", raw_meas->agc_level_db);
        printf("codeType=%s\r\n", raw_meas->codeType);
        printf("fullInterSignalBiasNs=%f\r\n", raw_meas->fullInterSignalBiasNs);
        printf("fullInterSignalBiasUncertaintyNs=%f\r\n", raw_meas->fullInterSignalBiasUncertaintyNs);
        printf("satelliteInterSignalBiasNs=%f\r\n", raw_meas->satelliteInterSignalBiasNs);
        printf("satelliteInterSignalBiasUncertaintyNs=%f\r\n", raw_meas->satelliteInterSignalBiasUncertaintyNs);
        printf("basebandCN0DbHz=%f\r\n", raw_meas->basebandCN0DbHz);
    }

    clk = &(data->clock);
    printf("======================= print_gnss_clock =======================");
    printf("flags=0x%x\r\n", clk->legacyClock.flags);
    printf("leap_second=%d\r\n", clk->legacyClock.leap_second);
    printf("time_uncertainty_ns=%f\r\n", clk->legacyClock.time_uncertainty_ns);

    printf("bias_ns=%f\r\n", clk->legacyClock.bias_ns);
    printf("bias_uncertainty_ns=%f\r\n", clk->legacyClock.bias_uncertainty_ns);
    printf("drift_nsps=%f\r\n", clk->legacyClock.drift_nsps);
    printf("drift_uncertainty_nsps=%f\r\n", clk->legacyClock.drift_uncertainty_nsps);
    printf("hw_clock_discontinuity_count=%d\r\n", clk->legacyClock.hw_clock_discontinuity_count);
    printf("constellation=%d\r\n", clk->referenceSignalTypeForIsb.constellation);
    printf("carrierFrequencyHz=%f\r\n", clk->referenceSignalTypeForIsb.carrierFrequencyHz);
    printf("codeType=%s\r\n", clk->referenceSignalTypeForIsb.codeType);

    elap_realtime = &(data->elapsedRealtime);
    printf("================= print_gnss_elapsed_real_time =================");
    printf("flags=0x%x\r\n", elap_realtime->flags);
    printf("timestampNs=%lld\r\n", elap_realtime->timestampNs);
    printf("timeUncertaintyNs=%lld\r\n", elap_realtime->timeUncertaintyNs);

    return;
}

lynq_raw_gnss_cbs lynq_gnss_raw_callbacks = 
{
    .size = sizeof(lynq_raw_gnss_cbs),
    .lynq_measurement_callback = lynq_gnss__measurement_callback,
};

lynq_raw_gnss_cbs* lynq_get__raw_callbacks(void)
{
    return &lynq_gnss_raw_callbacks;
}
