#include <stdarg.h>
#include <stdio.h>
#include <stdarg.h>
#include <unistd.h>
#include <sys/time.h>
#include <time.h>
#include <signal.h>
#include <string.h>
#include <errno.h>
#include <sys/un.h>
#include <arpa/inet.h>
#include <dlfcn.h>
#include <stdlib.h>
#include <semaphore.h>

#include "lynq_gnss.h"
#include "liblog/lynq_deflog.h"
#include "liblog/liblog.h"
#include "lynq-gnss-test.h"

#define USER_LOG_TAG "LYNQ_GNSS"

lynq_gnss_cb* cbs =NULL;
lynq_raw_gnss_cbs* raw_cbs = NULL;

sem_t g_lynq_test_exit_sem;

extern lynq_test_gnss_result lynq_test_result;

void lynq_show_gnss_test_result(lynq_test_gnss_result* result)
{
    if(NULL != result)
    {
        LYVERBLOG("------------------------------------------------------------");
        LYVERBLOG("fix type: %d",result->fix_type);
        LYVERBLOG("Flags: 0x%x",result->location.legacyLocation.flags);
        LYVERBLOG("latitude: %.10lf",result->location.legacyLocation.latitude);
        LYVERBLOG("longitude: %.10lf",result->location.legacyLocation.longitude);
        LYVERBLOG("altitude: %.10lf",result->location.legacyLocation.altitude);
        LYVERBLOG("speed: %fm/s",result->location.legacyLocation.speed);
        LYVERBLOG("bearing: %f",result->location.legacyLocation.bearing);
        LYVERBLOG("accuracy: %fm",result->location.horizontalAccuracyMeters);
        LYVERBLOG("timestamp: %ld",result->location.legacyLocation.timestamp);
        LYVERBLOG("------------------------------------------------------------");
    }
}

// -1 means failure
int lynq_test_block_here() {
    if (sem_init(&g_lynq_test_exit_sem, 0, 0) == -1) 
    {
        LYVERBLOG("lynq_test_block_here() sem_init failure reason=%s\n", strerror(errno));
        return -1;
    }
    sem_wait(&g_lynq_test_exit_sem);
    if (sem_destroy(&g_lynq_test_exit_sem) == -1) 
    {
        LYVERBLOG("lynq_test_block_here() sem_destroy reason=%s\n", strerror(errno));
    }
    LYVERBLOG("lynq_test exit blocking...");
    return 0;
}

int main(int argc,char **argv)
{
    LYLOGEINIT(USER_LOG_TAG);
    //registerTriggerCallback(getCallback);
    //register_key_info();
    //register_broadcast_send();
    LYVERBLOG("Log init");
    int index = 0;
    int ret_test = 0;
    unsigned int delete_flags = 0;
    if (argc == 1)
    {
        LYVERBLOG("LYNQ GNSS START");
        delete_flags = GPS_DELETE_RTI;
    }
    else
    {
        for (index=0; index<argc; index++)
        {
            LYVERBLOG("%s",argv[index]);
        }
        if (!strncmp(argv[1],LYNQ_TEST_HOT_START,sizeof(LYNQ_TEST_HOT_START)))
        {
            LYVERBLOG("LYNQ GNSS HOT START");
            delete_flags = GPS_DELETE_RTI;
        }
        else if (!strncmp(argv[1],LYNQ_TEST_WARM_START,sizeof(LYNQ_TEST_WARM_START)))
        {
            LYVERBLOG("LYNQ GNSS WARM START");
            delete_flags = GPS_DELETE_EPHEMERIS;
        }
        else if (!strncmp(argv[1],LYNQ_TEST_COLD_START,sizeof(LYNQ_TEST_COLD_START)))
        {
            LYVERBLOG("LYNQ GNSS COLD START");
            delete_flags = GPS_DELETE_EPHEMERIS |
                    GPS_DELETE_POSITION | GPS_DELETE_TIME | GPS_DELETE_IONO |
                    GPS_DELETE_UTC | GPS_DELETE_HEALTH;
        }
        else if (!strncmp(argv[1],LYNQ_TEST_FULL_START,sizeof(LYNQ_TEST_FULL_START)))
        {
            LYVERBLOG("LYNQ GNSS FULL START");
            delete_flags = GPS_DELETE_ALL;
        }
        else if (!strncmp(argv[1],LYNQ_TEST_RAW_START,sizeof(LYNQ_TEST_RAW_START)))
        {
            LYVERBLOG("LYNQ GNSS MEAS MODE START");
            cbs = lynq_test_get__gnss_callbacks();
            if(NULL != cbs)
            {
                LYVERBLOG("get cbs successful");
            }
            else
            {
                LYVERBLOG("cbs get error");
            }
            raw_cbs = lynq_get__raw_callbacks();
            if(NULL == raw_cbs)
            {
                LYVERBLOG("raw_cbs get error");
            }
            //open GNSS
            ret_test = lynq_gnss_callback_reg(cbs);  
            LYVERBLOG("cbs reg ret=%d",ret_test);
            
            int init_state = lynq_gnss_init();
            if(init_state == 0)
            {
                LYVERBLOG("gnss init ret_test =%d",init_state);
            }
            else
            {
                LYVERBLOG("error");
            }
            ret_test = lynq_gnss_start_raw_meas_mode(raw_cbs);
            LYVERBLOG("typethree:start raw meas address %p",raw_cbs);

            LYVERBLOG("raw mode start");

            lynq_test_block_here();

            return 0;
        }
        else
        {
            LYVERBLOG("invalid in comming start type");
            return -1;
        }
    }

    //pre set
    // lynq_gnss_set_start_mode(LYNQ_MODE_GPS_GLONASS_BEIDOU);

    // lynq_gnss_debug_switch(LYNQ_SWITCH_ENABLE);

    // lynq_gnss_epo_switch(LYNQ_SWITCH_ENABLE);

    //init
    LYVERBLOG("pre set successful,%d",ret_test);
    cbs = lynq_test_get__gnss_callbacks();
    if(NULL != cbs)
    {
        LYVERBLOG("get cbs successful");
    }
    else
    {
        LYVERBLOG("cbs get error");
    }
    //open GNSS
    ret_test = lynq_gnss_callback_reg(cbs);  
    LYVERBLOG("cbs reg ret=%d",ret_test);
    int init_state = lynq_gnss_init();
    if(init_state == 0)
    {
        LYVERBLOG("gnss init ret_test =%d",init_state);
    }
    else
    {
        LYVERBLOG("error");
    }
    
    lynq_gnss_delete_aiding_data(delete_flags);
    int start_state = lynq_gnss_start();
    if(start_state == 0)
    {
        LYVERBLOG("gnss init successful,ret_test =%d",start_state);
    }
    else
    {
        LYVERBLOG("error");
    }
    LYVERBLOG("delete_flags:%d",delete_flags);

    lynq_test_block_here();

    return 0;
}