#!/bin/bash
#set -x
#set -e

ERROR_PARAM=1
ERROR_FTP_SERVER_PING_NOT_OK=2
ERROR_FTP_TRANSFER_FAIL=3
ERROR_INNER_ERROR=4


ERROR_IS_IN_TRANSFER_LOG=20

ERROR_IS_IN_TRANSFER_SYS_LOG=$((ERROR_IS_IN_TRANSFER_LOG+0))
ERROR_IS_IN_TRANSFER_REMAIN_SYS_LOG=$((ERROR_IS_IN_TRANSFER_LOG+1))
ERROR_IS_IN_WAIT_TRRANSFER_REMAIN_SYS_LOG=$((ERROR_IS_IN_TRANSFER_LOG+2))

ERROR_IS_IN_TRANSFER_MTK_LOG=$((ERROR_IS_IN_TRANSFER_LOG+5))
ERROR_IS_IN_TRANSFER_REMAIN_MTK_LOG=$((ERROR_IS_IN_TRANSFER_LOG+6))
ERROR_IS_IN_WAIT_TRRANSFER_REMAIN_MTK_LOG=$((ERROR_IS_IN_TRANSFER_LOG+7))


ERROR_IS_IN_TRANSFER_DBG_LOG=$((ERROR_IS_IN_TRANSFER_LOG+10))
ERROR_IS_IN_TRANSFER_REMAIN_DBG_LOG=$((ERROR_IS_IN_TRANSFER_LOG+11))
ERROR_IS_IN_WAIT_TRRANSFER_REMAIN_DBG_LOG=$((ERROR_IS_IN_TRANSFER_LOG+12))


DEBUG_FILE_PATH=/var/log/
DEBUG_FILE_NAME=syslog.log
DEBUG_FILE_BACKUP_NAME=log_transfer_debug_0.log
DEBUG_FILE="${DEBUG_FILE_PATH}${DEBUG_FILE_NAME}"
DEBUG_FILE_BACKUP="${DEBUG_FILE_PATH}${DEBUG_FILE_BACKUP_NAME}"

if [ ! -d ${DEBUG_FILE_PATH} ]; then                    
	mkdir -p ${DEBUG_FILE_PATH}
fi    

SYS_LOG_PATH="/var/log/"
MTK_LOG_PATH="/var/log/mtklog/"
TMP_LOG_PATH="/tmp/log_transfer_tmp/"
MTK_LOG_BUFF_PATH="${TMP_LOG_PATH}mtklog_buffer/"
MTK_LOG_MOUNT_PATH="${TMP_LOG_PATH}mtklog"
CONTROL_FILE_PATH="${TMP_LOG_PATH}control/"
LOG_IS_IN_TRANSFER=(
     "${CONTROL_FILE_PATH}is_in_transfer_sys_log"
     "${CONTROL_FILE_PATH}is_in_transfer_mtk_log"
     "${CONTROL_FILE_PATH}is_in_transfer_dbg_log"
    )
WAIT_TRANSFER_REMAIN_LOG=(      
      "${CONTROL_FILE_PATH}is_in_transfer_remain_sys_log"
      "${CONTROL_FILE_PATH}is_in_transfer_remain_mtk_log"
      "${CONTROL_FILE_PATH}is_in_transfer_remain_dbg_log"
    )
	
TARGET_DIR=(      
      "lynq/log/lynq_log_1"
      "lynq/log/lynq_log_2"
      "None"
    )
	
target_dir=""

	
function is_in_debug()
{
    if [ -e "${LOG_IS_IN_TRANSFER[2]}" ] || [ -e "${WAIT_TRANSFER_REMAIN_LOG[2]}" ] 
	then 
        return 1
    else
        return 0
    fi
}


log_print=(
    "sys log"
    "mtk log"
    "dbg log"
)

loop_time=(
    5
    1
    10
)

transfer_log_tag=(
    0
    0
    0
)

LOG_PREFIX=(
    "archive_log"
    "MDLog"
    ""
)
log_prefix=""

#unit 0.1M
SINGLE_FILE_SIZE=(
    21
    100
    0
)
single_file_size=10

#unit M
INIT_LOG_MAX_SIZE=(
    1000
    2700
    0
)
log_num_max=0
LOG_DEL=$(($log_num_max/2))


Q_CUR_NUM_UCI=(
    "lynq_uci.lynq_log.log_1_cur_trf_num"
    "lynq_uci.lynq_log.log_2_cur_trf_num"
    ""
)
q_cur_num_uci=""

Q_MAX_SIZE_UCI=(
    "lynq_uci.lynq_log.log_1_max_size"
    "lynq_uci.lynq_log.log_2_max_size"
    ""
)
q_max_size_uci=""



TAR_CMD="gzip"
TAR_ARG=" -f"
TAR_EXT="gz"

UP_LOAD_POSTFIX=(
    $TAR_EXT
    "muxz"
    ""
)
q_max_size_uci=""


if [ ! -d ${CONTROL_FILE_PATH} ]; then                    
    mkdir -p ${CONTROL_FILE_PATH}
fi

function clear_relative_tag()
{      
    length=${#transfer_log_tag[@]}
   
    for ((i=0;i<$length;i++))
    do
        if [ ${transfer_log_tag[$i]} -eq 1 ]; then                       
            if [ $i -eq 0 ]; then              
                rm -rf $SYS_LOG_PATH$log_prefix*                    
            elif [ $i -eq 1 ]; then
                echo 7 | emdlogger_ctrl        
                rm -rf $MTK_LOG_PATH*
                if [ -d ${MTK_LOG_BUFF_PATH} ]; then                    
                    rm -rf ${MTK_LOG_BUFF_PATH}
                fi   
            fi
        
            if [ -e ${LOG_IS_IN_TRANSFER[$i]} ]; then        
                rm -rf ${LOG_IS_IN_TRANSFER[$i]}
            fi
        
            if [ -e ${WAIT_TRANSFER_REMAIN_LOG[$i]} ]; then
                rm -rf ${WAIT_TRANSFER_REMAIN_LOG[$i]}         
            fi                  
        fi            
    done     
}

function clear_relative_tag_when_exit()
{
    if [ $1 -eq $ERROR_FTP_TRANSFER_FAIL ]; then               
       clear_relative_tag
    fi          
}

function show_relative_tag()
{    
    length=${#LOG_IS_IN_TRANSFER[@]}
   
    for ((i=0;i<$length;i++))
    do
        if [ -e ${LOG_IS_IN_TRANSFER[$i]} ]; then                
            echo_debug_info "now in transfer ${log_print[$i]}"        
        else
            echo_debug_info "now not in transfer ${log_print[$i]}"        
        fi
        
        if [ -e ${WAIT_TRANSFER_REMAIN_LOG[$i]} ]; then                
            echo_debug_info "now in transfer reamain ${log_print[$i]}"     
        else
            echo_debug_info "now not in transfer remain ${log_print[$i]}"         
        fi    
    done
        
    
    if [ -d ${MTK_LOG_PATH} ]; then                
        echo_debug_info "$MTK_LOG_PATH exists"        
    else
        echo_debug_info "$MTK_LOG_PATH not exists"        
    fi    
}

function rotate_debug_file()
{
    filesize=`ls -l $DEBUG_FILE | awk '{ print $5 }'`
    maxsize=1000000
    if [ $filesize -gt $maxsize ]; then
        mv $DEBUG_FILE $DEBUG_FILE_BACKUP
        echo ""> $DEBUG_FILE
    fi
}

currentTime=`date "+%Y%m%d_%H%M%S"`
add_time_info=""
function add_time_to_info()     
{
    currentTime=`date "+%Y%m%d_%H%M%S"`
    add_time_info="${currentTime}$1"    
}

add_time_and_prefix_info=""
function add_time_and_prefix_to_info()
{
    add_time_to_info "$1"
    add_time_and_prefix_info="${2}${add_time_info}"
}


DBG_INFO_PREFIX="lynq_log_transfer "
function echo_debug_info()
{
    echo $1
    is_in_debug 	
    if [ $? -eq 1 ]; then
        add_time_and_prefix_to_info " $1" $DBG_INFO_PREFIX
        echo $add_time_and_prefix_info >> $DEBUG_FILE        
#       rotate_debug_file        
    fi    
}

function print_usage()
{   
    echo "Usage : lynq-log-transfer 0 | 1 | 2 | 3 | 101 | 102 | 103 " >&2
	echo "0 : Init, param like this: 0 config_id" >&2
    echo "1 : Start Transfer syslog, param like this: 1 192.168.10.10 21 username passwword" >&2
    echo "2 : Start Transfer mtklog,  param like this: 2 192.168.10.10 21 username passwword" >&2
    echo "3 : Start debug and Transfer debug log,  param like this: 3" >&2
    echo "101 : Stop transfer sys log, param like this: 101" >&2
    echo "102 : Stop transfer mtk log, param like this: 102" >&2
    echo "103 : Stop debug and stop transfer debug log, param like this: 103" >&2    
    echo " ">&2
    echo " ">&2
}

function print_exit_info()
{
    case "$1" in
      0)
        echo_debug_info "normal exit" 
      ;;
      $ERROR_PARAM)
	    print_usage
        echo_debug_info "param error"
        ;;
      $ERROR_FTP_SERVER_PING_NOT_OK)
        echo_debug_info "ftp server ping not ok"
        ;;  
      $ERROR_FTP_TRANSFER_FAIL)
        echo_debug_info "ftp transfer error"      
        ;; 
      $ERROR_INNER_ERROR)
        echo_debug_info "inner error"
        ;;
      $ERROR_IS_IN_TRANSFER_SYS_LOG)
        echo_debug_info "is still in transfering sys log"
        ;;    
      $ERROR_IS_IN_TRANSFER_REMAIN_SYS_LOG)  
        echo_debug_info "is still in transfering remain sys log"
        ;;  
      $ERROR_IS_IN_WAIT_TRRANSFER_REMAIN_SYS_LOG)
        echo_debug_info "is still waitting transfer remain sys log"
        ;;       
      $ERROR_IS_IN_TRANSFER_MTK_LOG)
        echo_debug_info "is still in transfering mtk log"
        ;;    
      $ERROR_IS_IN_TRANSFER_REMAIN_MTK_LOG)  
        echo_debug_info "is still in transfering remain mtk log"
        ;;  
      $ERROR_IS_IN_WAIT_TRRANSFER_REMAIN_MTK_LOG)
        echo_debug_info "is still waitting transfer remain mtk log"
        ;;           
       $ERROR_IS_IN_TRANSFER_DBG_LOG)
        echo_debug_info "is still in transfering dbg log"
        ;;    
      $ERROR_IS_IN_TRANSFER_REMAIN_DBG_LOG)  
        echo_debug_info "is still in transfering remain dbg log"
        ;;  
      $ERROR_IS_IN_WAIT_TRRANSFER_REMAIN_DBG_LOG)
        echo_debug_info "is still waitting transfer remain dbg log"
        ;;           
      *)
        echo_debug_info "other error"
        ;;
    esac       
}

ftp_server="192.168.125.111/"
ftp_user_name="abc"
ftp_password="abc"
ftp_port="21"

function ftp_transfer_file_then_delete()
{
    new_file_name=$1
    if [ $2 -eq 1 ]; then
      ${TAR_CMD} ${TAR_ARG} $new_file_name
      new_file_name=$new_file_name.$TAR_EXT
    fi        
       
    curl ftp://$ftp_server:$ftp_port/$target_dir/ -u "${ftp_user_name}:${ftp_password}" -T $new_file_name 1>/dev/null
    ret=$?
    rm -rf $new_file_name
    return $ret
}

function ftp_cp_file_after_add_tag()
{    
    if [ -e ${1} ]; then
        add_time_and_prefix_to_info $1 $2    
        cp $1 $add_time_and_prefix_info    
        ftp_transfer_file_then_delete $add_time_and_prefix_info 1    
        return $?
    fi
}

CUR_LOG_NUM=0
function save_cur_log_num_to_uci()
{
    if [ ! -z $q_cur_num_uci ]; then    
        uci set ${q_cur_num_uci}=${CUR_LOG_NUM}
    fi
}

function exit_process()
{    
    print_exit_info $1 
    clear_relative_tag_when_exit  $1 
    save_cur_log_num_to_uci
    exit $1
}


SYS_LOG_FILES=(
    "syslog.log.9"
    "syslog.log.8"
    "syslog.log.7"
    "syslog.log.6"
    "syslog.log.5"
    "syslog.log.4"
    "syslog.log.3"
    "syslog.log.2"
    "syslog.log.1"
    "syslog.log.0"
)

SYSLOG_INDEX=(0 1 2 3 4 5 6 7 8 9)

#SYS_LOG_FILE_COMMON_PREFIX="archive_log"

function do_cur_log_num_plus()
{
    ((CUR_LOG_NUM++))
    if [ $CUR_LOG_NUM -gt $log_index_max ]; then
        CUR_LOG_NUM=0
    fi
}

function ftp_delete_file()
{
   q_cmd="DELE $target_dir/$1"
   curl -u $ftp_user_name:$ftp_password ftp://$ftp_server:$ftp_port  -Q "$q_cmd" 1>/dev/null

}

function get_del_num()
{	
    if [ $1 -lt $((${2}/2)) ]; then
        LOG_DEL=$((${1}+${2}/2))
    else
	LOG_DEL=$((${1}-${2}/2))
    fi
}

function do_sys_log_transfer()
{
    cd ${SYS_LOG_PATH}     
    EXIST_SYS_LONG_NUM=0
    for SYS_LOG_FILE in ${SYS_LOG_FILES[@]} $1; do        
        if [ -e "${SYS_LOG_PATH}/${SYS_LOG_FILE}" ]; then            
            mv ${SYS_LOG_FILE} ${log_prefix}_${CUR_LOG_NUM}
            SYSLOG_INDEX[$EXIST_SYS_LONG_NUM]=${CUR_LOG_NUM}
            ((EXIST_SYS_LONG_NUM++))        
            do_cur_log_num_plus                            
        fi
    done    
    
    for j in `seq 0 $(($EXIST_SYS_LONG_NUM-1))`
    do          
         ${TAR_CMD} ${TAR_ARG} ${log_prefix}_${SYSLOG_INDEX[$j]}         
    done
        
    for j in `seq 0 $(($EXIST_SYS_LONG_NUM-1))`
    do  
        get_del_num ${SYSLOG_INDEX[$j]} $log_num_max
        ftp_delete_file ${log_prefix}_${LOG_DEL}.$TAR_EXT
        ftp_transfer_file_then_delete ${log_prefix}_${SYSLOG_INDEX[$j]}.$TAR_EXT    0    
        if [ $? -ne 0 ]; then
             echo_debug_info "ftp error code is $?"
             exit_process $ERROR_FTP_TRANSFER_FAIL        
        fi              
    done
}    

function do_backup_mtk_log()
{
    cd $MTK_LOG_BUFF_PATH
    for muxzfile in *."$1"; do       
        get_del_num $CUR_LOG_NUM $log_num_max
        ftp_delete_file ${log_prefix}_${LOG_DEL}.muxz	
        ftp_transfer_file_then_delete $muxzfile 0
        if [ $? -ne 0 ]; then
            exit_process $ERROR_FTP_TRANSFER_FAIL        
        fi                   
    done 
    cd -
}

function do_mtk_log_transfer()
{        
    cd $MTK_LOG_PATH
    while true
    do
        file_name=$(find -name \*"$1" | xargs ls -lthr | head -1 | awk '{print $9}')        
        if [ -n "$file_name" ]; then        		   
            mv $file_name $MTK_LOG_BUFF_PATH${log_prefix}_${CUR_LOG_NUM}.muxz             
            do_backup_mtk_log "muxz"   
            do_cur_log_num_plus
        else
            break;
        fi    
    done
}

function do_dbg_log_transfer()
{   
    if [ $ftp_server = "127.0.0.1" ]; then
        return 
    fi       
    
    cd $DEBUG_FILE_PATH
    
    ftp_cp_file_after_add_tag $1 "debug_" 
    if [ $? -eq 0 ]; then
        rm -rf $1
    fi   
}

function send_remain_log()
{
    if [ $1 -eq 0 ]; then        
        do_sys_log_transfer "syslog.log"
        echo "" > ${SYS_LOG_PATH}/syslog.log 
    elif [ $1 -eq 1 ]; 
    then
        do_mtk_log_transfer "muxz"
        do_mtk_log_transfer "muxz.tmp"   
    elif [ $1 -eq 2 ]; 
    then        
        do_dbg_log_transfer $DEBUG_FILE_BACKUP_NAME
        do_dbg_log_transfer $DEBUG_FILE_NAME
    fi    
}



function do_log_transfer()
{
    if [ $1 -eq 0 ]; then        
        do_sys_log_transfer
    elif [ $1 -eq 1 ]; 
    then
        do_mtk_log_transfer "muxz"
    elif [ $1 -eq 2 ]; 
    then
        do_dbg_log_transfer $DEBUG_FILE_BACKUP_NAME
    fi
}

function do_loop()
{     
    echo_debug_info "start transfer ${log_print[$1]}"        

    while [ -e "${LOG_IS_IN_TRANSFER[$1]}" ]
    do             
        do_log_transfer $1
        sleep $2      
    done
    echo_debug_info "start remain ${log_print[$1]} transfer"
    send_remain_log $1 
    echo_debug_info "stop ${log_print[$1]} transfer"
    if [ -e ${WAIT_TRANSFER_REMAIN_LOG[$1]} ]; then
        rm ${WAIT_TRANSFER_REMAIN_LOG[$1]}
    fi      
    clear_relative_tag
}



function wait_transfer_remain_log()
{
    second=0
    while [ -e "${WAIT_TRANSFER_REMAIN_LOG[$1]}"  -a $second -lt 60 ]
    do    
        sleep 1
        ((second=second+1))
    done
}

function stop_log_transfer()
{
    if [ -e ${LOG_IS_IN_TRANSFER[$1]} ]; then
        touch ${WAIT_TRANSFER_REMAIN_LOG[$1]}                    
        rm ${LOG_IS_IN_TRANSFER[$1]}   
        echo_debug_info "${log_print[$1]} transfer stoping "
        wait_transfer_remain_log $1
        if [ -e ${WAIT_TRANSFER_REMAIN_LOG[$1]} ]; then
            rm ${WAIT_TRANSFER_REMAIN_LOG[$1]}         
        fi      
    fi
}

function sever_should_ok()
{
  ping -c 2 $1

  if [ $? -ne 0 ]; then 
      exit_process $ERROR_FTP_SERVER_PING_NOT_OK
  fi  
}

function get_ftp_param()
{
    if [ $1 -gt 4 ]; then
        ftp_server=$2
        sever_should_ok $ftp_server        
        ftp_port=$3
        ftp_user_name=$4
        ftp_password=$5                            
    else
        echo_debug_info "para num $1 error"
        exit_process $ERROR_PARAM
    fi      
}

function delete_beyond_log()
{
	post_fix=${UP_LOAD_POSTFIX[$1]}	 
	
	for j in `seq $2 $3`
	do 
		ftp_delete_file ${log_prefix}_${j}.${post_fix}
	done
}

function get_init_cur_log_num()
{
    q_cur_num_uci=${Q_CUR_NUM_UCI[$1]}	
        
    if [ ! -z $q_cur_num_uci ]; then
        q_uci_value=`uci get $q_cur_num_uci`
        if [ -z $q_uci_value ];
        then
            uci set ${q_cur_num_uci}=${CUR_LOG_NUM}
        else
            CUR_LOG_NUM=$(($q_uci_value))
        fi	
        if [ $CUR_LOG_NUM -gt $log_index_max ]; then
		    delete_beyond_log $1 $log_index_max  $(($CUR_LOG_NUM-1))
            CUR_LOG_NUM=$log_index_max
            uci set ${q_cur_num_uci}=${CUR_LOG_NUM}
        fi
    fi	
}

function get_single_file_size()
{
    single_file_size=${SINGLE_FILE_SIZE[$1]}  		
	 
    if [ $1 -eq 1 ]; then
		q_uci_value=`uci get mdlog.property.md_log_size`
		if [ ! -z $q_uci_value ];
		then
		    single_file_size=$(($(($q_uci_value))*10))			
		fi
    fi			
}

function get_init_max_log_num()
{
    init_log_max_size=${INIT_LOG_MAX_SIZE[$1]}    		
    q_max_size_uci=${Q_MAX_SIZE_UCI[$1]}	
	
	get_single_file_size $1
        
    if [ ! -z $q_max_size_uci ]; then
        q_uci_value=`uci get $q_max_size_uci`
        if [ -z $q_uci_value ];
        then
            uci set ${q_max_size_uci}=$init_log_max_size
            log_num_max=$(($init_log_max_size*20/single_file_size))
        else
            log_num_max=$(($(($q_uci_value))*20/single_file_size))
        fi	
    fi
    log_index_max=$(($log_num_max-1)) 	
}

function loop_prepare()
{
    if [ $1 -eq 1 ]; then
        echo 6 | emdlogger_ctrl
        if [ $? -ne 0 ]; then 
            echo_debug_info "start mtk log fail"
            exit_process $ERROR_INNER_ERROR              
        fi
        if [ ! -d ${MTK_LOG_BUFF_PATH} ]; then                    
            mkdir -p ${MTK_LOG_BUFF_PATH}
        fi      
    fi     
    target_dir=${TARGET_DIR[$1]}	
    log_prefix=${LOG_PREFIX[$1]}   

	
    get_init_max_log_num $1
    get_init_cur_log_num $1
	
    if [ ! -z $target_dir ]; then
        # 3 times for guarrantee
        curl -u $ftp_user_name:$ftp_password -XPWD -p -e ftp://$ftp_server:$ftp_port/$target_dir --ftp-create-dirs ftp://$ftp_server:$ftp_port/$target_dir/ 1>/dev/null
        curl -u $ftp_user_name:$ftp_password -XPWD -p -e ftp://$ftp_server:$ftp_port/$target_dir --ftp-create-dirs ftp://$ftp_server:$ftp_port/$target_dir/ 1>/dev/null	
        curl -u $ftp_user_name:$ftp_password -XPWD -p -e ftp://$ftp_server:$ftp_port/$target_dir --ftp-create-dirs ftp://$ftp_server:$ftp_port/$target_dir/ 1>/dev/null
    fi
}


function trigger_log_transfer()
{
    index=$((${1}-1))
    if [ -e ${LOG_IS_IN_TRANSFER[$index]} ]; then                
        exit_process $((ERROR_IS_IN_TRANSFER_LOG+${index}*5 ))
    fi
    if [ -e ${WAIT_TRANSFER_REMAIN_LOG[$index]} ]; then                
        exit_process $((ERROR_IS_IN_TRANSFER_LOG+${index}*5+1))    
    fi
    
    if [ $index -ne 2 ]; then
	    get_ftp_param $# $2 $3 $4 $5        
        transfer_log_tag[$index]=1
        loop_prepare $index
    fi		

    
    
    touch ${LOG_IS_IN_TRANSFER[${index}]}
    
    echo_debug_info "transfer ${log_print[$index]}"     
    
    if [ $index -eq 2 ]; then    
        echo_debug_info "log transfer param_num $# param $* start"    
        show_relative_tag
        return 
    fi    

    do_loop ${index} ${loop_time[$index]}           
}

function stop_log_transfer_ui()
{
    index=$((${1}-101))
    if [ -e ${WAIT_TRANSFER_REMAIN_LOG[$index]} ]; then                
        exit_process $((ERROR_IS_IN_TRANSFER_LOG+${index}*5+2 ))
    fi          
    
    if [ $index -eq 1 ]; then
        echo 7 | emdlogger_ctrl
    elif [ $index -eq 2 ]; then
        show_relative_tag
        echo_debug_info "log transfer param_num $# param $* complete" 
        rm ${LOG_IS_IN_TRANSFER[$index]}   
        return 
    fi
    
    stop_log_transfer  $index
}

function init_md_log()
{
    if [ ! -d $MTK_LOG_MOUNT_PATH ];
    then 
        echo_debug_info "init md log start"
        mkdir -p $MTK_LOG_MOUNT_PATH
        echo 7 | emdlogger_ctrl
        rm -rf $MTK_LOG_PATH*
        mount -o bind $MTK_LOG_MOUNT_PATH $MTK_LOG_PATH
        rm -rf $MTK_LOG_PATH*
        uci set mdlog.property.md_cyclic_size='36'
        uci set mdlog.property.md_log_size=$((${SINGLE_FILE_SIZE[1]}/10))
        uci commit
        killall emdlogger1	
        echo_debug_info "init md log end"
    fi		
}

function init_log_transfer_ui()
{
    index=$2
    if [ $index -eq 1 ]; then
        #debug
        trigger_log_transfer 3  
        init_md_log
    fi	
}

echo_debug_info "log transfer param_num $# param $* start"

case "$1" in  
  [1-3])  
    trigger_log_transfer "$@"
    ;;
  101|102|103)     
    stop_log_transfer_ui "$@"
    ;;    
  0)
    init_log_transfer_ui "$@"
	;;
  *)    
    exit_process $ERROR_PARAM
    ;;
esac

echo_debug_info "log transfer param_num $# param $* complete"
exit_process 0      
            
           