#include <stdio.h>
#include "include/iot_rock.h"
#include "fcntl.h"

#include "liblog/lynq_deflog.h"

//lynq_ftp_socker_info ftp_log_info;

#define USER_LOG_TAG "UA_UP"


#define UPDATA_ADDR "/tmp/fota.delta"
#define READ_BLOCK_SIZE 0x40000
#if 0
#define FLASH_DEV_DELTA       "/dev/disk/by-partlabel/delta"
#else
#define FLASH_DEV_DELTA       "/dev/mtd41"	
#endif

#define EMMC_DEV_DELTA      "/dev/mmcblk0"

int main(int argc,char argv[])
{
    
    int lynq_upgrade_state = 0;
    int first_run = 1; 
    int ret = 0;
    int fd_down,size,fd_target;
    char input_md5_data[64];
    char delta_data[READ_BLOCK_SIZE];
    char lynq_fota_data[64] = {0};
	
   LYLOGEINIT(USER_LOG_TAG);
   LYLOGSET(4);
/*
   ftp_log_info.portnum = 6521;


   sprintf(ftp_log_info.sevname,"58.246.1.50");
   sprintf(ftp_log_info.username,"VEH_USER_SWAP");
   sprintf(ftp_log_info.pw,"user_swap_file_0129");
   sprintf(ftp_log_info.getfilename,"fota.delta");
   sprintf(ftp_log_info.getfilename_path,"/FOTA/UpFile/");

   sprintf(ftp_log_info.is_pasv_mode,"pasv");
   sprintf(ftp_log_info.file_type,"A");
   sprintf(ftp_log_info.put_opt,"APPE");

   LYVERBLOG("[+UP]: Download the FTP data\n");
   lynq_ftp_login(&ftp_log_info);
   lynq_ftp_download(&ftp_log_info);
   LYVERBLOG("[+UP]: Download the FTP data success\n");
*/

    lynq_upgrade_state = lynq_get_upgrade_status();
    LYVERBLOG("[+UP]:Upgrade state:%d",lynq_upgrade_state);

    LYVERBLOG("[+UP]: input MD5 data:");	
    while(fgets(input_md5_data,64,stdin) != NULL)
    {
        LYVERBLOG("[+UP]: receive MD5 data:%s\n",input_md5_data);
        ret = lynq_md5_file_verfy(UPDATA_ADDR, input_md5_data);
        break;
    }

    fd_down = open(UPDATA_ADDR,O_RDONLY);
    if (fd_down < 0)
    {
        LYVERBLOG("[+UP]: open source  error\n");
        return 1;
    }

    fd_target = lynq_nand_open(EMMC_DEV_DELTA,O_RDWR);

    if (fd_target < 0) 
    {
        lynq_nand_close(fd_target);
        close(fd_down);
        LYERRLOG("+[UA]: open target  error\n");
        return 1;
    } 

    LYVERBLOG("[+UP]: Write data to flash\n");
    while(( size = read(fd_down,delta_data,READ_BLOCK_SIZE))>0) {
    	   lynq_nand_write(fd_target,delta_data,READ_BLOCK_SIZE);
    }
    LYVERBLOG("[+UP]: Write data to flash success\n");

    lynq_nand_close(fd_target);
    close(fd_down);

    if(0 == lynq_fota_set_addr_value(EMMC_DEV_DELTA,13))
    {
        lynq_fota_get_addr_value(lynq_fota_data);
        LYVERBLOG("+[UA]: get fota addr:%s\n",lynq_fota_data);
    }
    else
    {
        LYVERBLOG("+[UA]: get fota addr error\n");
        return -1;
    }

    sleep(10);

    LYVERBLOG("+[UA]: Upgrade to start ret:%d\n",ret);
    if(ret == 0)
    {
    	lynq_rock_main(first_run);
    }
    LYVERBLOG("+[UA]: Upgrade to end\n");

    return 0;

}

