#!/bin/bash
#Copyright (c) [Year], MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction,
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.
help()
{
    echo -e "\033[34m"
    echo "Usage:$0 <sessionid> <cla> <instruction> <p1> <p2> <p3>"
    echo "     :$0 <sessionid> <cla> <instruction> <p1> <p2> <p3> <data>"
    echo "int sessionid;  /* "sessionid" from TS 27.007 +CGLA command. Should be ignored for +CSIM command. */"

    echo "/* Following fields are used to derive the APDU ("command" and "length"
       values in TS 27.007 +CSIM and +CGLA commands). */"
    echo "int cla;"
    echo "int instruction;"
    echo "int p1;"
    echo "int p2;"
    echo "int p3;         /* A negative P3 implies a 4 byte APDU. */"
    echo "char *data;     /* May be NULL. In hex string format. */"
    echo -e "\033[0m"
}

fail_tip()
{
    echo -e "\033[31m"
    echo -E "parameter is invaild!"
    echo -e "\033[0m"
    help
}
is_num()
{
    re='^[+-]?[0-9]+$'
    if ! [[ $1 =~ $re ]]
    then
        return 0
    else
        return 1
    fi
}


if [ "$1" == "-h" ]
then
    help
    exit 0
fi

if [ "$#" gt 7 ]
then
    fail_tip
    exit 0
fi

for var in "$1" "$2" "$3" "$4" "$5" "$6"
do
    if is_num $var
    then
        fail_tip
        exit 0
    fi
done

echo -E "Exchange APDUs with a UICC over a previously opened logical channel: $1 $2 $3 $4 $5 $6 $7"


#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

#send Terminal response CMD
echo "RIL_REQUEST_SIM_TRANSMIT_APDU_CHANNEL $1 $2 $3 $4 $5 $6 $7" >&9

#close socket R/W
exec 9>&-
exec 9<&-
exit 0
