// SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include "em/em.h"

#include <vendor-ril/telephony/ril.h>
#include <stdlib.h>
#include <stdio.h>
#include <cutils/jstring.h>
#include <log/log.h>
#include <unistd.h>
#include <math.h>
#include  "common.h"

#if EM_MODE_SUPPORT

#undef LOG_TAG
#define LOG_TAG "EM_ENTRY"

#define NUM_ITEMS(a)     (sizeof (a) / sizeof (a)[0])
em_arry_t lte_info[] = {
    //{"4G ERRC Misc Info",0,NULL,1,1},
    //{"4G LTE Support Band",0,NULL,1,1},
    //{"4G Active Intra-RAT Meas (LTE)",0,NULL,1,1},
    //{"4G Active Inter-RAT Meas (UMTS)",0,NULL,1,1},
    //{"4G Active Inter-RAT Meas (GSM)",0,NULL,1,1},
    //{"4G SIB Receive Status",0,NULL,1,1},
    //{"4G CSG Autonomous Search",0,NULL,1,1},
    //{"4G Config Info",0,NULL,1,1},
    //{"ESM",0,NULL,1,1},
    //{"EMM",0,NULL,1,1},
    //{"MMDC",0,NULL,1,1},
#ifdef C2K_SUPPORT
    {"EL1",0,NULL,1,1},
#endif
#ifdef TARGET_PLATFORM_MT2735
    {"NR L1 Info",0,NULL,1,1},
#endif
    //{"Timer Information",0,NULL,1,1},
    //{"TDD TAS",0,NULL,1,1},
    //{"GSM TAS",0,NULL,1,1},
    //{"WCDMA TAS",0,NULL,1,1},
    //{"LTE TAS",0,NULL,1,1},
};
em_arry_t ims_setting[] = {
    {"get",0,NULL,0,0},
    {"set",0,NULL,0,0},
};
em_arry_t ims_common[] = {
    {"operator_code",2,ims_setting,0,0},
#ifndef TARGET_PLATFORM_MT2735
    {"sms_support",2,ims_setting,0,0},
    {"voice_support",2,ims_setting,0,0}
#endif
};
em_arry_t ims_call[] = {
    {"UA_call_codec_order1",2,ims_setting,0,0},
    {"UA_call_codec_order2",2,ims_setting,0,0},
    {"UA_call_codec_order3",2,ims_setting,0,0},
    {"silence_dropcall_threshold",2,ims_setting,0,0},
    {"jbm_load_params_enable",2,ims_setting,0,0},
    {"jbm_prebuf_len",2,ims_setting,0,0},
};
em_arry_t ims_registration[] = {
    {"emergency_reg_retain_timer",2,ims_setting,0,0},
    {"UA_reg_auth_password",2,ims_setting,0,0},
    {"UA_reg_auth_name",2,ims_setting,0,0},
    {"VoLTE_Setting_SIP_TCP_On_Demand",2,ims_setting,0,0},
};
em_arry_t ims[] = {
    {"Common",NUM_ITEMS(ims_common),ims_common,1,1},
    {"Call",NUM_ITEMS(ims_call),ims_call,1,1},
    {"Registration",NUM_ITEMS(ims_registration),ims_registration,1,1},
};
em_arry_t gprs[] = {
    {"ATTACH",0,NULL,1,1},
    {"DETACH",0,NULL,1,1},
    {"ATTACH_CONTINUE",0,NULL,1,1},
    {"DETACH_CONTINUE",0,NULL,1,1},
    {"SELECT_ATTACH_TYPE_1",0,NULL,1,1},
    {"SELECT_ATTACH_TYPE_0",0,NULL,1,1},
};
em_arry_t networkselection[] = {
    {"GSM/WCDMA (WCDMA preferred)",0,NULL,1,1},
    {"GSM only",0,NULL,1,1},
    {"WCDMA only",0,NULL,1,1},
    {"GSM/WCDMA (auto)",0,NULL,1,1},
    {"LTE only",0,NULL,1,1},
    {"4G/3G/2G(auto)",0,NULL,1,1},
    {"4G/3G",0,NULL,1,1},
};
em_arry_t modem_cta[] = {
    {"Integrity Check",0,NULL,1,1},
    {"RLC TL1",0,NULL,1,1},
    {"K1297",0,NULL,1,1},
    {"SN Conflict",0,NULL,1,1},
    {"CF query",0,NULL,1,1},
    {"DLMN lock",0,NULL,1,1},
    {"Measurement open",0,NULL,1,1},
    {"Disable DPA",0,NULL,1,1},
    {"Intra CMR",0,NULL,1,1},
};

em_arry_t modem_fta[] = {
    {"ANITE",0,NULL,1,1},
    {"CRTUG",0,NULL,1,1},
    {"CRTUW",0,NULL,1,1},
    {"ANRITSU",0,NULL,1,1},
    {"CMW500",0,NULL,1,1},
};

em_arry_t modem_iot[] = {
    {"General",0,NULL,1,1},
    {"NSN",0,NULL,1,1},
    {"DCM CB",0,NULL,1,1},
    {"ERICSSON",0,NULL,1,1},
};

em_arry_t modem_operator[] = {
    {"MS_USIM_COMPATIPLE",0,NULL,1,1},
    {"ATNT",0,NULL,1,1},
    {"TMOBILE",0,NULL,1,1},
    {"ORANGE",0,NULL,1,1},
    {"VODAFONE",0,NULL,1,1},
    {"O2",0,NULL,1,1},
    {"TELEFONICA",0,NULL,1,1},
    {"DOCOMO",0,NULL,1,1},
    {"SOFTBANK",0,NULL,1,1},
    {"VIVO",0,NULL,1,1},
    {"CLARO",0,NULL,1,1},
    {"TIM",0,NULL,1,1},
    {"CU",0,NULL,1,1},
    {"KDDI",0,NULL,1,1},
    {"CT IR LAB TEST",0,NULL,1,1},
};

em_arry_t modem_C2K_Test_MODEM[] = {
    { "NONE", 0, NULL, 1, 1 },
    { "SPIRENT", 0,NULL, 1, 1 },
};
em_arry_t modemtest[] = {
    {"NONE",0,NULL,1,1},
#ifdef TARGET_PLATFORM_MT2735
    {"Integrity OFF",0,NULL,1,1},
    {"FTA",NUM_ITEMS(modem_fta),modem_fta,1,1},
    {"IOT",NUM_ITEMS(modem_iot),modem_iot,1,1},
    {"OPERATOR",NUM_ITEMS(modem_operator),modem_operator,1,1},
#else
    {"CTA",NUM_ITEMS(modem_cta),modem_cta,1,1},
    {"FTA",NUM_ITEMS(modem_fta),modem_fta,1,1},
    {"IOT",0,NULL,1,1},
    {"OPERATOR",0,NULL,1,1},
#endif
    {"FACTORY",0,NULL,1,1},
#ifdef C2K_SUPPORT
    {"CDMA Test Mode", NUM_ITEMS(modem_C2K_Test_MODEM),modem_C2K_Test_MODEM,1,1},
#endif
};
em_arry_t hspa[] = {
    {"QUERY",0,NULL,1,1},
#ifdef TARGET_PLATFORM_MT2735
    {"QUERY_CAINFO",0,NULL,1,1},
#endif
};
em_arry_t cfu[] = {
    {"Default",0,NULL,1,1},
    {"Always query",0,NULL,1,1},
    {"Always not query",0,NULL,1,1},
};
em_arry_t bandmode[] = {
    {"getcurrentband",0,NULL,1,1},
    {"setBand(eg: 1.1=1 add band, 1.1=0 remove band) or getGSMSupportBand",0,NULL,1,1},
#ifdef TARGET_PLATFORM_MT2735
    {"getcurrentNRband",0,NULL,1,1},
#endif
//    {"[NR]setBand(eg: 1.1=1 add band, 1.1=0 remove band) or getGSMSupportBand",0,NULL,1,1},
};
em_arry_t networkinfo[] = {
    {"RR Cell Sel",0,NULL,1,1},
    {"RR Ch Dscr",0,NULL,1,1},
    {"RR Ctrl chan",0,NULL,1,1},
    {"RR RACH Ctrl",0,NULL,1,1},
    {"RR LAI Info",0,NULL,1,1},
    {"RR Radio Link",0,NULL,1,1},
    {"RR Meas Rep",0,NULL,1,1},
    {"RR Ca List",0,NULL,1,1},
    {"RR Control Msg",0,NULL,1,1},
    {"RR SI2Q Info",0,NULL,1,1},
    {"RR MI Info",0,NULL,1,1},
    {"RR BLK Info",0,NULL,1,1},
    {"RR TBF Info",0,NULL,1,1},
    {"RR GPRS Gen",0,NULL,1,1},
    {"SMEmInfo",0,NULL,1,1},
    {"3GMmEmInfo",0,NULL,1,1},
    {"GmmEmInfo",0,NULL,1,1},
#if 1
    {"3GTcmMmiEmInfo",0,NULL,1,1},
    {"3GGeneralStatusInd",0,NULL,1,1},
    {"xGCsceEMNeighCellSStatusInd",0,NULL,1,1},
    {"3GCsceEMServCellSStatusInd",0,NULL,1,1},
    {"3GCsceEmInfoMultiPlmn",0,NULL,1,1},
    {"3GMemeEmPeriodicBlerReportInd",0,NULL,1,1},
    {"3GUrrUmtsSrncId",0,NULL,1,1},
    {"3GMemeEmInfoHServCellInd",0,NULL,1,1},
#endif
#if 1//fdd
    {"3GMemeEmInfoUmtsCellStatus",0,NULL,1,1},
    {"3GSlceEmPsDataRateStatusInd",0,NULL,1,1},
#endif
#if 0//tdd
    {"3GHandoverSequenceIndStuct",0,NULL,1,1},
    {"3GUl2EmAdmPoolStatusIndStruct",0,NULL,1,1},
    {"3GUl2EmPsDataRateStatusIndStruct",0,NULL,1,1},
    {"3GUl2EmHsdschReconfigStatusIndStruct",0,NULL,1,1},
    {"3GUl2EmUrlcEventStatusIndStruct",0,NULL,1,1},
    {"3G Ul2EmPeriodicBlerReportInd",0,NULL,1,1},
#endif
#if 0 //lte
    {"3G speech codec",0,NULL,1,1},//lte
    {"Security Configuration",0,NULL,1,1},//lte
#endif
};

em_arry_t antenna_setmodes_4g[] {
    {"RX1&RX2", 0, NULL, 1, 1},
    {"RX1", 0, NULL, 1, 1},
    {"RX2", 0, NULL, 1, 1},
};

em_arry_t antenna_setmodes_3g[] {
    {"RX1", 0, NULL, 1, 1},
    {"RX2", 0, NULL, 1, 1},
    {"RX1&RX2", 0, NULL, 1, 1},
    {"Resume default setting", 0, NULL, 1, 1},
};

em_arry_t antenna_setmodes_c2k[] {
    {"Resume default setting", 0, NULL, 1, 1},
    {"RX1", 0, NULL, 1, 1},
    {"RX2", 0, NULL, 1, 1},
    {"RX1&RX2", 0, NULL, 1, 1},
};

em_arry_t antenna_4Gmode[] = {
    {"getmode",0,NULL,1,1},
#ifdef TARGET_PLATFORM_MT2735
    {"setmode",0,NULL,1,1},
#else
    {"setmode",NUM_ITEMS(antenna_setmodes_4g),antenna_setmodes_4g,1,1},
#endif
};

em_arry_t antenna_3Gmode[] = {
    {"getmode",0,NULL,1,1},
    {"setmode",NUM_ITEMS(antenna_setmodes_3g),antenna_setmodes_3g,1,1},
};

em_arry_t antenna_c2kmode[] = {
    {"getmode",0,NULL,1,1},
    {"setmode",NUM_ITEMS(antenna_setmodes_c2k),antenna_setmodes_c2k,1,1},
};

em_arry_t antenna_NRmode[] = {
    {"getmode",0,NULL,1,1},
    {"setmode",0,NULL,1,1},
};

em_arry_t antennatest[] = {
    {"4G",NUM_ITEMS(antenna_4Gmode),antenna_4Gmode,1,1},
#ifdef C2K_SUPPORT
    {"3G",NUM_ITEMS(antenna_3Gmode),antenna_3Gmode,1,1},
    {"CDMA",NUM_ITEMS(antenna_c2kmode),antenna_c2kmode,1,1},
#endif
#ifdef TARGET_PLATFORM_MT2735
    {"NR",NUM_ITEMS(antenna_NRmode),antenna_NRmode,1,1},
#endif
};

em_arry_t time_reg[] = {
    { "disable", 0,NULL, 1, 1 },
    { "enable", 0, NULL, 1, 1 },
};

em_arry_t c2k_modem_setting[] {
        {"TIME REG",NUM_ITEMS(time_reg),time_reg,1,1},
};

em_arry_t rfdesense_setting[] = {
    {"start",0,NULL,0,0},
    {"set",0,NULL,0,0},
//    {"set_check_Limit",0,NULL,0,0},
//    {"get_check_Limit",0,NULL,0,0},
};

em_arry_t set_get[] = {
        {"get",0,NULL,0,0},
        {"set",0,NULL,0,0},
};

em_arry_t rfdesense_gsm_band[] = {
        {"GSM 850",0,NULL,0,0},
        {"P-GSM 900",0,NULL,0,0},
        {"E-GSM 900",0,NULL,0,0},
        {"R-GSM 900",0,NULL,0,0},
        {"DCS 1800",0,NULL,0,0},
        {"PCS 1900",0,NULL,0,0},
};

em_arry_t rfdesense_gsm_pattern[] = {
        {"RFTOOL_NB_TX_RANDOM_WITH_TSC",0,NULL,0,0},
        {"RFTOOL_NB_TX_ALL_ONES_WITHOUT_TSC",0,NULL,0,0},
        {"RFTOOL_AB_TX_RANDOM_WITH_SYNC_SEQ",0,NULL,0,0},
        {"RFTOOL_CONT_TX_ALL_ZEROS",0,NULL,0,0},
        {"RFTOOL_CONT_TX_ALL_ONES",0,NULL,0,0},
        {"RFTOOL_CONT_TX_ALTERNATE_BITS",0,NULL,0,0},
        {"RFTOOL_CONT_TX_PSEUDO_RANDOM",0,NULL,0,0},
};

em_arry_t rfdesense_gsm_sub[] = {
        {"Band",NUM_ITEMS(rfdesense_gsm_band),rfdesense_gsm_band,0,0},
        {"Channel(ARFCN)",NUM_ITEMS(set_get),set_get,0,0},
        {"Power Level",NUM_ITEMS(set_get),set_get,0,0},
        {"AFC",NUM_ITEMS(set_get),set_get,0,0},
        {"TSC",NUM_ITEMS(set_get),set_get,0,0},
        {"PATTERN",NUM_ITEMS(rfdesense_gsm_pattern),rfdesense_gsm_pattern,0,0},
};

em_arry_t rfdesense_gsm[] = {
        {"start",0,NULL,0,0},
        {"Parameters_set",NUM_ITEMS(rfdesense_gsm_sub),rfdesense_gsm_sub,0,0},
        {"show default",0,NULL,0,0},
};

em_arry_t rfdesense_tdscdma_band[] = {
        {"Band A",0,NULL,0,0},
        {"Band F",0,NULL,0,0},
};

em_arry_t rfdesense_tdscdma_sub[] = {
        {"Band",NUM_ITEMS(rfdesense_tdscdma_band),rfdesense_tdscdma_band,0,0},
        {"Channel(ARFCN)",NUM_ITEMS(set_get),set_get,0,0},
        {"Power Level(dBm)",NUM_ITEMS(set_get),set_get,0,0},
};

em_arry_t rfdesense_tdscdma[] = {
        {"start",0,NULL,0,0},
        {"Parameters_set",NUM_ITEMS(rfdesense_tdscdma_sub),rfdesense_tdscdma_sub,0,0},
        {"show default",0,NULL,0,0},
};

em_arry_t rfdesense_wcdma_band[] = {
        {"Band 1",0,NULL,0,0},
        {"Band 2",0,NULL,0,0},
        {"Band 3",0,NULL,0,0},
        {"Band 4",0,NULL,0,0},
        {"Band 5",0,NULL,0,0},
        {"Band 6",0,NULL,0,0},
        {"Band 7",0,NULL,0,0},
        {"Band 8",0,NULL,0,0},
        {"Band 9",0,NULL,0,0},
        {"Band 10",0,NULL,0,0},
        {"Band 11",0,NULL,0,0},
        {"Band 12",0,NULL,0,0},
        {"Band 13",0,NULL,0,0},
        {"Band 14",0,NULL,0,0},
        {"Band 19",0,NULL,0,0},
        {"Band 20",0,NULL,0,0},
        {"Band 21",0,NULL,0,0},
        {"Band 22",0,NULL,0,0},
};

em_arry_t rfdesense_wcdma_sub[] = {
        {"Band",NUM_ITEMS(rfdesense_wcdma_band),rfdesense_wcdma_band,0,0},
        {"Channel(ARFCN)",NUM_ITEMS(set_get),set_get,0,0},
        {"Power Level(dBm)",NUM_ITEMS(set_get),set_get,0,0},
};

em_arry_t rfdesense_wcdma[] {
        {"start",0,NULL,0,0},
        {"Parameters_set",NUM_ITEMS(rfdesense_wcdma_sub),rfdesense_wcdma_sub,0,0},
        {"show default",0,NULL,0,0},
};

em_arry_t rfdesense_lte_mode[] = {
        {"single tone",0,NULL,0,0},
        {"modulation signal",0,NULL,0,0},
};

em_arry_t rfdesense_fdd_band[] = {
        {"1",0,NULL,0,0},
        {"2",0,NULL,0,0},
        {"3",0,NULL,0,0},
        {"4",0,NULL,0,0},
        {"5",0,NULL,0,0},
        {"6",0,NULL,0,0},
        {"7",0,NULL,0,0},
        {"8",0,NULL,0,0},
        {"9",0,NULL,0,0},
        {"10",0,NULL,0,0},
        {"11",0,NULL,0,0},
        {"12",0,NULL,0,0},
        {"13",0,NULL,0,0},
        {"14",0,NULL,0,0},
        {"15",0,NULL,0,0},
        {"16",0,NULL,0,0},
        {"17",0,NULL,0,0},
        {"18",0,NULL,0,0},
        {"19",0,NULL,0,0},
        {"20",0,NULL,0,0},
        {"21",0,NULL,0,0},
        {"22",0,NULL,0,0},
        {"23",0,NULL,0,0},
        {"24",0,NULL,0,0},
        {"25",0,NULL,0,0},
        {"26",0,NULL,0,0},
        {"27",0,NULL,0,0},
        {"28",0,NULL,0,0},
        {"29",0,NULL,0,0},
        {"30",0,NULL,0,0},
        {"31",0,NULL,0,0},
        {"66",0,NULL,0,0},
};

em_arry_t rfdesense_lte_bandwidth[] = {
        {"1.4M",0,NULL,0,0},
        {"3M",0,NULL,0,0},
        {"5M",0,NULL,0,0},
        {"10M",0,NULL,0,0},
        {"15M",0,NULL,0,0},
        {"20M",0,NULL,0,0},
};

em_arry_t  rfdesense_lte_mcs[] = {
        {"QPSK",0,NULL,0,0},
        {"16QAM",0,NULL,0,0},
        {"64QAM",0,NULL,0,0},
};

em_arry_t rfdesense_fdd_sub[] = {
        {"mode",NUM_ITEMS(rfdesense_lte_mode),rfdesense_lte_mode,0,0},
        {"band",NUM_ITEMS(rfdesense_fdd_band),rfdesense_fdd_band,0,0},
        {"UL Bandwidth",NUM_ITEMS(rfdesense_lte_bandwidth),rfdesense_lte_bandwidth,0,0},
        {"UL Freq(100kHz)",NUM_ITEMS(set_get),set_get,0,0},
        {"VRB Start(0-99)",NUM_ITEMS(set_get),set_get,0,0},
        {"VRB Length(1-100)",NUM_ITEMS(set_get),set_get,0,0},
        {"MCS",NUM_ITEMS(rfdesense_lte_mcs),rfdesense_lte_mcs,0,0},
        {"Power Level(dbm)(-50_23)",NUM_ITEMS(set_get),set_get,0,0},
};

em_arry_t rfdesense_lte_fdd[] = {
        {"start",0,NULL,0,0},
        {"Parameters_set",NUM_ITEMS(rfdesense_fdd_sub),rfdesense_fdd_sub,0,0},
        {"show default",0,NULL,0,0},
};

em_arry_t rfdesense_tdd_band[] = {
        {"33",0,NULL,0,0},
        {"34",0,NULL,0,0},
        {"35",0,NULL,0,0},
        {"36",0,NULL,0,0},
        {"37",0,NULL,0,0},
        {"38",0,NULL,0,0},
        {"39",0,NULL,0,0},
        {"40",0,NULL,0,0},
        {"41",0,NULL,0,0},
        {"42",0,NULL,0,0},
        {"43",0,NULL,0,0},
        {"44",0,NULL,0,0},
};

em_arry_t rfdesense_tdd_config[] = {
        {"0",0,NULL,0,0},
        {"1",0,NULL,0,0},
        {"2",0,NULL,0,0},
        {"3",0,NULL,0,0},
        {"4",0,NULL,0,0},
        {"5",0,NULL,0,0},
        {"6",0,NULL,0,0},
};

em_arry_t rfdesense_tdd_special[] = {
        {"0",0,NULL,0,0},
        {"1",0,NULL,0,0},
        {"2",0,NULL,0,0},
        {"3",0,NULL,0,0},
        {"4",0,NULL,0,0},
        {"5",0,NULL,0,0},
        {"6",0,NULL,0,0},
        {"7",0,NULL,0,0},
        {"8",0,NULL,0,0},
        {"9",0,NULL,0,0},
};

em_arry_t rfdesense_tdd_sub[] = {
        {"mode",NUM_ITEMS(rfdesense_lte_mode),rfdesense_lte_mode,0,0},
        {"band",NUM_ITEMS(rfdesense_tdd_band),rfdesense_tdd_band,0,0},
        {"UL Bandwidth",NUM_ITEMS(rfdesense_lte_bandwidth),rfdesense_lte_bandwidth,0,0},
        {"UL Freq(100kHz)",NUM_ITEMS(set_get),set_get,0,0},
        {"TDD Config Index",NUM_ITEMS(rfdesense_tdd_config),rfdesense_tdd_config,0,0},
        {"TDD Special SF Config Index",NUM_ITEMS(rfdesense_tdd_special),rfdesense_tdd_special,0,0},
        {"VRB Start(0-99)",NUM_ITEMS(set_get),set_get,0,0},
        {"VRB Length(1-100)",NUM_ITEMS(set_get),set_get,0,0},
        {"MCS",NUM_ITEMS(rfdesense_lte_mcs),rfdesense_lte_mcs,0,0},
        {"Power Level(dbm)(-50_23)",NUM_ITEMS(set_get),set_get,0,0},
};

em_arry_t rfdesense_lte_tdd[] = {
        {"start",0,NULL,0,0},
        {"Parameters_set",NUM_ITEMS(rfdesense_tdd_sub),rfdesense_tdd_sub,0,0},
        {"show default",0,NULL,0,0},
};

em_arry_t rfdesense_cdma_band[] = {
        {"Band 0",0,NULL,0,0},
        {"Band 1",0,NULL,0,0},
        {"Band 2",0,NULL,0,0},
        {"Band 3",0,NULL,0,0},
        {"Band 4",0,NULL,0,0},
        {"Band 5",0,NULL,0,0},
        {"Band 6",0,NULL,0,0},
        {"Band 7",0,NULL,0,0},
        {"Band 8",0,NULL,0,0},
        {"Band 9",0,NULL,0,0},
        {"Band 10",0,NULL,0,0},
        {"Band 11",0,NULL,0,0},
        {"Band 12",0,NULL,0,0},
        {"Band 13",0,NULL,0,0},
        {"Band 14",0,NULL,0,0},
        {"Band 15",0,NULL,0,0},
};

em_arry_t rfdesense_cdma_modulation[] = {
        {"1X",0,NULL,0,0},
        {"EVDO",0,NULL,0,0},
};

em_arry_t rfdesense_cdma_sub[] = {
        {"Band",NUM_ITEMS(rfdesense_cdma_band),rfdesense_cdma_band,0,0},
        {"modulation",NUM_ITEMS(rfdesense_cdma_modulation),rfdesense_cdma_modulation,0,0},
        {"Channel(ARFCN)",NUM_ITEMS(set_get),set_get,0,0},
        {"Power Level(dBm)",NUM_ITEMS(set_get),set_get,0,0},
};

em_arry_t rfdesense_cdma[] = {
        {"start",0,NULL,0,0},
        {"Parameters_set",NUM_ITEMS(rfdesense_cdma_sub),rfdesense_cdma_sub,0,0},
        {"show default",0,NULL,0,0},
};

em_arry_t rfdesense_nr_tx_mode[] = {
        {"Tone",0,NULL,0,0},
        {"PUSCH",0,NULL,0,0},
};

em_arry_t rfdesense_nr_band[] = {
        {"1",0,NULL,0,0},
        {"3",0,NULL,0,0},
        {"7",0,NULL,0,0},
        {"8",0,NULL,0,0},
        {"20",0,NULL,0,0},
        {"28",0,NULL,0,0},
        {"38",0,NULL,0,0},
        {"41",0,NULL,0,0},
        {"77",0,NULL,0,0},
        {"78",0,NULL,0,0},
        {"79",0,NULL,0,0},
};

em_arry_t rfdesense_nr_bandwidth[] = {
        {"5M",0,NULL,0,0},
        {"10M",0,NULL,0,0},
        {"15M",0,NULL,0,0},
        {"20M",0,NULL,0,0},
        {"25M",0,NULL,0,0},
        {"30M",0,NULL,0,0},
        {"35M",0,NULL,0,0},
        {"40M",0,NULL,0,0},
        {"45M",0,NULL,0,0},
        {"50M",0,NULL,0,0},
        {"55M",0,NULL,0,0},
        {"60M",0,NULL,0,0},
        {"65M",0,NULL,0,0},
        {"70M",0,NULL,0,0},
        {"75M",0,NULL,0,0},
        {"82M",0,NULL,0,0},
        {"85M",0,NULL,0,0},
        {"90M",0,NULL,0,0},
        {"95M",0,NULL,0,0},
        {"100M",0,NULL,0,0},
};

em_arry_t  rfdesense_nr_mcs[] = {
        {"DFT-S BPSK",0,NULL,0,0},
        {"CP QPSK",0,NULL,0,0},
        {"DFT-S QPSK",0,NULL,0,0},
        {"CP 16QAM",0,NULL,0,0},
        {"DFT-S 16QAM",0,NULL,0,0},
        {"CP 64QAM",0,NULL,0,0},
        {"DFT-S 64QAM",0,NULL,0,0},
        {"CP 256QAM",0,NULL,0,0},
        {"DFT-S 256QAM",0,NULL,0,0},
};

em_arry_t  rfdesense_nr_scs[] = {
        {"15KHZ(0)",0,NULL,0,0},
        {"30KHZ(1)",0,NULL,0,0},
        {"60KHZ(2)",0,NULL,0,0},
        {"120KHZ(3)",0,NULL,0,0},
        {"240KHZ(4)",0,NULL,0,0},
};

em_arry_t rfdesense_nr_sub[] = {
        {"Tx mode",NUM_ITEMS(rfdesense_nr_tx_mode),rfdesense_nr_tx_mode,0,0},
        {"Band",NUM_ITEMS(rfdesense_nr_band),rfdesense_nr_band,0,0},
        {"UL bandwidth",NUM_ITEMS(rfdesense_nr_bandwidth),rfdesense_nr_bandwidth,0,0},
        {"UL freq(1kHz)",NUM_ITEMS(set_get),set_get,0,0},
        {"VRB start(0-272)",NUM_ITEMS(set_get),set_get,0,0},
        {"VRB length(1-273)",NUM_ITEMS(set_get),set_get,0,0},
        {"MCS",NUM_ITEMS(rfdesense_nr_mcs),rfdesense_nr_mcs,0,0},
        {"SCS",NUM_ITEMS(rfdesense_nr_scs),rfdesense_nr_scs,0,0},
        {"Power level(dbm)(-50-23)",NUM_ITEMS(set_get),set_get,0,0},
        {"Tdd slot config(1-44)",NUM_ITEMS(set_get),set_get,0,0},
};

em_arry_t rfdesense_nr[] = {
        {"start",0,NULL,0,0},
        {"Parameters_set",NUM_ITEMS(rfdesense_nr_sub),rfdesense_nr_sub,0,0},
        {"show default",0,NULL,0,0},
};

em_arry_t sub_tx_test[] = {
    { "GSM", NUM_ITEMS(rfdesense_gsm),rfdesense_gsm, 1, 1 },
#ifndef TARGET_PLATFORM_MT2735
    { "TDSCDMA", NUM_ITEMS(rfdesense_tdscdma), rfdesense_tdscdma, 1, 1 },
#endif
    { "WCDMA", NUM_ITEMS(rfdesense_wcdma), rfdesense_wcdma, 1, 1 },
    { "LTE(FDD)", NUM_ITEMS(rfdesense_lte_fdd), rfdesense_lte_fdd, 1, 1 },
    { "LTE(TDD)", NUM_ITEMS(rfdesense_lte_tdd), rfdesense_lte_tdd, 1, 1 },
#ifdef TARGET_PLATFORM_MT2735
    { "NR", NUM_ITEMS(rfdesense_nr), rfdesense_nr, 1, 1 },
#endif
#ifdef C2K_SUPPORT
    { "CDMA(EVDO)", NUM_ITEMS(rfdesense_cdma), rfdesense_cdma, 1, 1 },
    { "CDMA(1x)", NUM_ITEMS(rfdesense_cdma), rfdesense_cdma, 1, 1 },
#endif/*C2K_SUPPORT*/
};

em_arry_t desense_test[] {
        {"Tx Test",NUM_ITEMS(sub_tx_test),sub_tx_test,1,1},
};

em_arry_t no_support[] {
        {"NO SUPPORT",0,NULL,0,0},
};

em_arry_t emmain[] = {
#ifdef C2K_SUPPORT
    {"CDMA modem setting",NUM_ITEMS(c2k_modem_setting),c2k_modem_setting,0,0},
#endif
    {"RF Desense Test ",NUM_ITEMS(desense_test),desense_test,0,0},
    {"Modem Test",NUM_ITEMS(modemtest),modemtest,0,0},
    {"HSPA",NUM_ITEMS(hspa),hspa,0,0},
#ifndef TARGET_PLATFORM_MT2735
    {"CFU",NUM_ITEMS(cfu),cfu,0,0},
#endif
    {"Antenna Test",NUM_ITEMS(antennatest),antennatest,0,0},
    {"Band Mode",NUM_ITEMS(bandmode),bandmode,0,0},
    {"IMS",NUM_ITEMS(ims),ims,0,0},
#ifndef TARGET_PLATFORM_MT2735
    {"Network Info",NUM_ITEMS(no_support),no_support,0,0},
#endif
    {"LTE",NUM_ITEMS(lte_info),lte_info,0,0},
};
typedef enum {
#ifdef C2K_SUPPORT
    C2K_MODEM_SETTING = 0,
    RF_DESENSE_TEST,
#else
    RF_DESENSE_TEST = 0,
#endif
    MODEM_TEST_ITEM,
    HSPA_ITEM,
#ifndef TARGET_PLATFORM_MT2735
    CFU_ITEM,
#endif
    ANTENNATEST_ITEM,
    BANDMODE_ITEM,
    IMS_ITEM,
#ifndef TARGET_PLATFORM_MT2735
    NO_SUPPORT,
#endif
    LTE_ITEM,
}EM_MAIN_ITEM;
em_arry_t em = {"Telephony",NUM_ITEMS(emmain),emmain,0,0};
int em_main(int len, int *item, int multilen, char *value[]) {
    int testclass = item[0];
    RLOGD("em_main testclase %d", testclass);
    switch (testclass) {
#ifndef TARGET_PLATFORM_MT2735
    case C2K_MODEM_SETTING:
        emC2kModemSettingStart(len - 1, multilen, &item[1]);
        break;
    case CFU_ITEM:
        emCfuStart(len - 1, &item[1]);
        break;
#endif
    case RF_DESENSE_TEST:
        emRfDesenseStart(len - 1, &item[1], multilen, value);
        break;
    case MODEM_TEST_ITEM:
        emModemtestStart(len - 1, multilen, &item[1]);
        break;
    case HSPA_ITEM:
        emHspaStart(len - 1, &item[1]);
        break;
    case ANTENNATEST_ITEM:
        emAntennaTestStart(len - 1, &item[1], multilen, value);
        break;
    case BANDMODE_ITEM:
        emBandmodeStart(len - 1, &item[1], multilen, value);
        break;
    case IMS_ITEM:
        emImsStart(len - 1, &item[1], (value != NULL ? value[0] : NULL));
        break;
    case LTE_ITEM:
        em_el1_start(len - 1, multilen, &item[1]);
        break;
#ifndef TARGET_PLATFORM_MT2735
    case NO_SUPPORT:
        android::emResultNotify("don't support\n");
        break;
#endif
    default:
        break;
    }
    return 0;
}

int em_start(int argc, char *argv[], RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    RLOGD("em_start called");
    int i = 0;
    em_arry_t *em_test = &em;
    em_arry_t *em_sub = NULL;
    RLOGD("Welcome to EM %s",em_test->name);
    char output[2048] = {0};
    int len = 0;

    if(argc < 2){
        for(i = 0; i < em_test->subcnt; i++){
            sprintf(output+len,"%d:%s\n",i+1,em_test->subarray[i].name);
            len = strlen(output);
        }
        RLOGD("%s",output);
        android::emResultNotify(output);
        return 0;
    }
    int itemlevel = 0;
    int select_argvi[32] = {0};
    int current_argvi = -1;
    for(itemlevel = 1; itemlevel < argc; itemlevel++){
        select_argvi[itemlevel-1] = atoi(argv[itemlevel]) - 1;
        current_argvi = select_argvi[itemlevel-1];
        if (em_test->subcnt < current_argvi + 1) {
            sprintf(output, "the select index %d is out of bounds, please reselect.\nfail\n",current_argvi + 1);
            android::emResultNotify(output);
            return -1;
        }
        if(em_test->subarray[current_argvi].subarray == NULL){
            for(i = 0 ; i < (argc - itemlevel - 1); i++){
                select_argvi[itemlevel + i] = atoi(argv[itemlevel+1+i]) - 1;
            }
            RLOGD("em_test->subarray[%d].name: %s",current_argvi, em_test->subarray[current_argvi].name);
            if(strncmp(em_test->subarray[current_argvi].name,"set",3) == 0){
                em_main(itemlevel,&select_argvi[0],(argc - itemlevel - 1),&argv[itemlevel+1]);
            }
            else{
                RLOGD("item level %d",itemlevel);
                em_main(itemlevel,&select_argvi[0],(argc - itemlevel - 1),NULL);
            }
            //android::emResultNotify("done\n");
            break;
        }else{
            RLOGD("em_sub[%d].name: %s, itemlevel: %d, argc: %d ",current_argvi, (em_test->subarray[current_argvi].name), itemlevel, argc);
            em_sub = &em_test->subarray[current_argvi];
            if(itemlevel == (argc - 1)){
                memset(output,0,2048);
                len = 0;

                for(i = 0; i < em_sub->subcnt; i++){
                    //RLOGD("%d:%s",i+1,em_sub->subarray[i].name);
                    sprintf(output+len,"%d:%s\n",i+1,em_sub->subarray[i].name);
                    len = strlen(output);
                }
                RLOGD("%s",output);
                android::emResultNotify(output);
            }
            em_test = em_sub;
        }
    }
    return 0;
}

extern void ARspRequestWithArg(int request, const char* arg, RIL_SOCKET_ID soc_id);

void emSendATCommand(const char *cmd, int soc_id)
{
    ARspRequestWithArg(RIL_REQUEST_OEM_HOOK_RAW, cmd, (RIL_SOCKET_ID)soc_id);
}

void emEnableRadio(bool isEnable, int soc_id) {
    //check main phone
    ARspRequestWithArg(RIL_REQUEST_RADIO_POWER, (isEnable ? "1" : "0"), (RIL_SOCKET_ID)soc_id);
}

std::vector<std::string> getCdmaCmdArr(std::vector<std::string> cmdArray) {
#ifndef MD_93_SUPPORT
    return cmdArray;
#else
    std::vector<std::string> cmdArrayNew(2);
    cmdArrayNew[0] = cmdArray[0];
    cmdArrayNew[1] = cmdArray[1];
    return cmdArrayNew;
#endif /*MD_93_SUPPORT*/
}

int emResultNotifyWithDone(std::string str) {
    std::string tmp = str + std::string("\ndone\n");
    android::emResultNotify(tmp.c_str());
    return 0;
}

int emResultNotifyEx(std::string str) {
    std::string tmp = str + std::string("\n");
    android::emResultNotify(tmp.c_str());
    return 0;
}

int em_result_only_msg(std::string str) {
    std::string tmp = str + std::string("\nonly_em_message\n");
    android::emResultNotify(tmp.c_str());
    return 0;
}

int em_result_notify_fail(std::string str) {
    std::string tmp = "fail, " + str;
    emResultNotifyWithDone(tmp);
    return 0;
}

int em_result_notify_ok(std::string str) {
    std::string tmp = "OK, " + str;
    emResultNotifyWithDone(tmp);
    return 0;
}

int em_result_notify_error(std::string str) {
    std::string tmp = "error, " + str;
    emResultNotifyWithDone(tmp);
    return 0;
}
#endif

