/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <string>
#include <iostream>
using namespace std;

#include <log/log.h>
#include "UserData.h"
#include "HexDump.h"

constexpr int UserData::ASCII_NL_INDEX;
constexpr int UserData::ASCII_CR_INDEX;
const char UserData::ASCII_MAP[] = { ' ', '!', '"', '#', '$', '%', '&', '\'',
    '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6',
    '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E',
    'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T',
    'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c',
    'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r',
    's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~' };

const int UserData::ASCII_MAP_MAX_INDEX = ASCII_MAP_BASE_INDEX
    + sizeof(ASCII_MAP) / sizeof(char) - 1;

std::map<char, uint8_t> UserData::charToAscii = UserData::init();

std::map<char, uint8_t> UserData::init() {
  std::map<char, uint8_t> temp;
  for (uint32_t i = 0; i < sizeof(ASCII_MAP) / sizeof(char); i++) {
    temp.insert(
        pair<char, uint8_t>(ASCII_MAP[i], PRINTABLE_ASCII_MIN_INDEX + i));
  }
  temp.insert(pair<char, uint8_t>('\n', ASCII_NL_INDEX));
  temp.insert(pair<char, uint8_t>('\r', ASCII_CR_INDEX));
  return temp;
}

//uint8_t* UserData::stringToAscii(string msg, int* length) {
std::vector<uint8_t> UserData::stringToAscii(std::string msg) {
  int len = msg.length();
  //uint8_t* result = new uint8_t[len];
  std::vector<uint8_t> result;
  for (int i = 0; i < len; i++) {
    uint8_t charCode;
    try {
      charCode = charToAscii.at(msg[i]);
    } catch (const out_of_range &e) {
      //TBD log.
      return result;
    }
    result.push_back(charCode);
    //result[i] = charCode;

  }
  return result;
}

UserData::UserData() {

}

UserData::~UserData() {

}

std::string UserData::toString() {
  string builder;
  builder.append("UserData ");
  builder.append("{ msgEncoding=");
  builder.append(msgEncodingSet ? std::to_string(msgEncoding) : "unset");
  builder.append(", msgType=" + std::to_string(msgType));
  builder.append(", paddingBits=" + std::to_string(paddingBits));
  builder.append(", numFields=" + std::to_string(numFields));
  builder.append(
      ", userDataHeader="
          + string(userDataHeader ? userDataHeader->toString() : "unset"));
  builder.append(", payload='" + HexDump::toHexString(payload) + string("'"));
  builder.append(", payloadStr='" + payloadStr + "'");
  std::cout << "message content: " << payloadStr << std::endl;
  RLOGD("[MT_CDMA_SMS]Message conetent: %s", payloadStr.c_str());
  builder.append(" }");
  return builder;
}
