/*============================================================================= 
#     FileName: lynq_sms_manager.cpp
#     Desc: about SMS API
#     Author: Warren
#     Version: V1.0
#     LastChange: 2021-08-27 
#     History: 
=============================================================================*/
#ifndef __LYNQ_SMS_MANAGER__
#define __LYNQ_SMS_MANAGER__
#include <sqlite3.h>
#ifdef __cplusplus
extern "C" {
#endif
#define LYNQ_MAX_SMS_LIST 255
#define LYNQ_SMS_MAX_SCA_NUMBER_LEN   22
#define LYNQ_SMS_MAX_PDU_NUMBER_LEN 2504
#define LYNQ_SMS_MAX_TEXT_NUMBER_LEN 512
#define LYNQ_TELEPHONE_NUM_LEN 64
#define SMS_DB_PATH "/system/etc/tele/sms.db"
#define SMS_DB_READED 0
#define SMS_DB_ERR 1
#define SMS_DB_CREATE 2

typedef enum {
    LYNQ_SMS_GSM=0,
    LYNQ_SMS_CDMA
}lynq_sms_technology_t;
typedef enum{
    LYNQ_SMS_ALL=0,
    LYNQ_SMS_UREA,
    LYNQ_SMS_READ,
    LYNQ_SMS_UNSENT,
    LYNQ_SMS_SENT
}lynq_sms_status_t;

typedef struct
{
    int index;//Maximum number of SMS that can be storaged.
    int slot_id;
    int charset;
    char address[LYNQ_TELEPHONE_NUM_LEN];
    int addrLen;
    char smsc[LYNQ_SMS_MAX_SCA_NUMBER_LEN];
    int smscLen;
    char pdu[LYNQ_SMS_MAX_PDU_NUMBER_LEN];
    int pduLen;
    char sms_text[LYNQ_SMS_MAX_TEXT_NUMBER_LEN];
    int sms_text_len;
    lynq_sms_technology_t lynq_sms_technology;
    lynq_sms_status_t lynq_sms_status;
    /*lei add for gsw 2022/5/12*/
    int current;
    int total;
    /*lei add for gsw 2022/5/12*/
}lynq_sms_t;

typedef struct{
    int index[LYNQ_MAX_SMS_LIST];
    int num_of_indexs;
}lynq_sms_list_t;
class sms_manager
{
    public:
        sms_manager(void );
        virtual ~ sms_manager();
        int initSmsManager();
        int lynq_write_sms_to_memory(const char* data,const char *num,const char *smsc,const char *msg,const int charset,const int slot_id,int current, int total);
        int lynq_delete_sms_from_memory(const int index);
        int lynq_read_sms_from_memory(const int index, lynq_sms_t *sms);
        int lynq_list_sms_from_memory(const int status,lynq_sms_list_t * sms_list);
        int get_sms_total()
        {
            return sms_total;
        }
        int set_sms_total(int smsTotal)
        {
            sms_total = smsTotal;
            return 0;
        }
        bool get_sms_full()
        {
            return sms_full;
        }
        int set_sms_full(bool status)
        {
            sms_full = status;
            return 0;
        }
        int get_sms_usable_id()
        {
            return sms_usable_id;
        }
        int set_sms_usable_id(int index)
        {
             sms_usable_id = index;
             return 0;
        }
    private:
        int create_sms_db(char *path);
        int create_sms_table(char*path);
        int create_sms_number_table(char * path);
        int lynq_write_sms_to_sms_db(int id,int slot_id,int status,const char *smsc,int charset,const char *pdu,const char *content,char *path,const char*address,int current,int total);
        int find_unuse_sms_index(char *path);
        int lynq_check_index(int total);
        int sms_total;
        int sms_usable_id;
        bool sms_full;
        sqlite3* smsDb;
};
extern sms_manager *g_smsManagement;
int lynq_init_sms_manager();
#ifdef __cplusplus
}
#endif

#endif


