

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <log/log.h>
#include "include/libat_common/lynq_at_common.h"
#include "atci_at_util.h"

#undef LOG_TAG
#define LOG_TAG "AT_COMMON"

int g_mnetcall_mode = 0;
int g_gtarndis_mode = 0;
int g_version_mode = 0;

lynq_atsvc_outcb handle_output;

typedef struct
{
    char *cmd;
    void (*func)(char *input,int mode);
}Command;

enum
{
    Response = 0,
    Urc
};

void lynq_response_ok()
{
    char *str = "\r\nOK\r\n";
    handle_output(str, strlen(str), Response);
}

void lynq_response_error()
{
    char *str = "\r\n+CME ERROR:100\r\n";
    handle_output(str, strlen(str), Response);
}

static void lynq_get_poepn_buf(char *cmd)
{
    FILE *fp;
    char buf[128] = {0};
    fp = popen(cmd,"r");
    while(fgets(buf, sizeof(buf), fp) != NULL){}
    pclose(fp);
    RLOGD("buf is %s size %d\n", buf, sizeof(buf));
    handle_output(buf, strlen(buf), Response);
    return;
}

void lynq_handle_rndis(char *input,int type)
{
    RLOGD("lynq_handle_rndis type %d\n", type);
    char buf[128] = {0}; 
    if(type == AT_SET_MODE)//set
    {
        int mode;
        if (SYS_FAIL == atci_at_to_equal(&input))
        {
            lynq_response_error();
            return SYS_FAIL;
        }
        if (SYS_FAIL == atci_at_get_nexthexint(&input, &mode))
        {
            lynq_response_error();
            return SYS_FAIL;
        }
        if(mode == 1)
        {
            g_mnetcall_mode = mode;
            system("connmanctl enable gadget");
            system("connmanctl tether gadget on");
            lynq_response_ok();
        }
        else if (mode == 0)
        {
            g_mnetcall_mode = mode;
            system("connmanctl disable gadget");
            lynq_response_ok();
        }
        else
        {
            lynq_response_error();
        }
    }
    else if(type == AT_TEST_MODE)//list
    {
        sprintf(buf,"+MNETCALL:(0-1)");
        handle_output(buf, strlen(buf), Response);
        lynq_response_ok();
    }
    else if(type == AT_READ_MODE)//get
    {
        sprintf(buf,"+MNETCALL:%d", g_mnetcall_mode);
        handle_output(buf, strlen(buf), Response);
        lynq_response_ok();
    }
    else
    {
        lynq_response_error();
    }
    return;
}

void lynq_handle_rndis_configure(char *input,int type)
{
    RLOGD("lynq_handle_rndis_configure type %d\n", type);
    char buf[128] = {0}; 
    if(type == AT_SET_MODE)//set
    {
        int mode;
        if (SYS_FAIL == atci_at_to_equal(&input))
        {
            lynq_response_error();
            return SYS_FAIL;
        }
        if (SYS_FAIL == atci_at_get_nexthexint(&input, &mode))
        {
            lynq_response_error();
            return SYS_FAIL;
        }
        if(mode == 1)
        {
            g_gtarndis_mode = mode;
            system("uci set lynq_uci.rndis=lynq_rndis");
            system("uci set lynq_uci.rndis.status='1'");
            system("uci commit");
            lynq_response_ok();
        }
        else if (mode == 0)
        {
            g_gtarndis_mode = mode;
            system("uci set lynq_uci.rndis=lynq_rndis");
            system("uci set lynq_uci.rndis.status='0'");
            system("uci commit");
            lynq_response_ok();
        }
        else
        {
            lynq_response_error();
        }
    }
    else if(type == AT_TEST_MODE)//list
    {
        sprintf(buf,"+GTARNDIS:(0-1)");
        handle_output(buf, strlen(buf), Response);
        lynq_response_ok();
    }
    else if(type == AT_READ_MODE)//get
    {
        sprintf(buf,"+GTARNDIS:%d", g_gtarndis_mode);
        handle_output(buf, strlen(buf), Response);
        lynq_response_ok();
    }
    else
    {
        lynq_response_error();
    }
    return;
}

void lynq_handle_version(char *input,int type)
{
    RLOGD("lynq_handle_version type %d\n", type);
    char buf[128] = {0}; 
    if(type == AT_SET_MODE)//set
    {
        int mode;
        if (SYS_FAIL == atci_at_to_equal(&input))
        {
            lynq_response_error();
            return SYS_FAIL;
        }
        if (SYS_FAIL == atci_at_get_nexthexint(&input, &mode))
        {
            lynq_response_error();
            return SYS_FAIL;
        }
        if(mode == 1)
        {
            g_version_mode = mode;
            lynq_get_poepn_buf("uci get lynq_uci_ro.lynq_version.LYNQ_SW_INSIDE_VERSION");
            //handle_output(buf, strlen(buf), Response);
            lynq_response_ok();
        }
        else if (mode == 0)
        {
            g_version_mode = mode;
            lynq_get_poepn_buf("uci get lynq_uci_ro.lynq_version.LYNQ_SW_VERSION");
            //handle_output(buf, strlen(buf), Response);
            lynq_response_ok();
        }
        else
        {
            lynq_response_error();
        }
    }
    else if(type == AT_TEST_MODE)//list
    {
        sprintf(buf,"+CGIR:(0-1)");
        handle_output(buf, strlen(buf), Response);
        lynq_response_ok();
    }
    else if(type == AT_READ_MODE)//get
    {
        sprintf(buf,"+CGIR:%d", g_version_mode);
        handle_output(buf, strlen(buf), Response);
        lynq_response_ok();
    }
    else if(type == AT_ACTIVE_MODE)//active
    {
        if(g_version_mode == 0)
        {
            lynq_get_poepn_buf("uci get lynq_uci_ro.lynq_version.LYNQ_SW_VERSION");
            //handle_output(buf, strlen(buf), Response);
            lynq_response_ok();
        }
        else if(g_version_mode == 1)
        {
            lynq_get_poepn_buf("uci get lynq_uci_ro.lynq_version.LYNQ_SW_INSIDE_VERSION");
            //handle_output(buf, strlen(buf), Response);
            lynq_response_ok();
        }
    }
    return;
}

void lynq_display_modem_mode(const char *cmd)
{
    FILE *fp;
    char buf[128] = {0};
    fp = popen(cmd,"r");
    while(fgets(buf, sizeof(buf), fp) != NULL){}
    pclose(fp);
    RLOGD("buf is %s size %d\n", buf, sizeof(buf));
    char tmp[16] = {0};
    sprintf(tmp, "+LGMDS: %c", buf[4]);
    handle_output(tmp, strlen(tmp), Response);
    return;
}

void lynq_handle_modem_status(char *input,int type)
{
    RLOGD("lynq_handle_modem_status type %d\n", type); 
    if(type == AT_ACTIVE_MODE)//active
    {
        lynq_display_modem_mode("cat /sys/kernel/ccci/boot");
        lynq_response_ok();
    }
    return;
}

void lynq_tmp_handle_rndis(char *input,int type)
{
     RLOGD("lynq_tmp_handle_rndis type %d\n", type);
    char *connman_cmd1 = NULL;
    char *connman_cmd2 = NULL;
    if(type == AT_SET_MODE)//set
    {
        if (SYS_FAIL == atci_at_to_equal(&input))
        {
            lynq_response_error();
            return ;
        }
        if (SYS_FAIL == atci_at_get_next_key(&input, &connman_cmd1))
        {
            lynq_response_error();
            return ;
        }
         if (SYS_FAIL == atci_at_get_next_key(&input, &connman_cmd2))
        {
            //lynq_response_error();
            //return SYS_FAIL;
        }
        if((connman_cmd1 != NULL) && (connman_cmd2 != NULL))
        {
            if(!strcmp(connman_cmd1, "connmanctl enable gadget"))
            {
                system("connmanctl enable gadget");
            }
            else
            {
                lynq_response_error();
                return;
            }
            if(!strcmp(connman_cmd2, "connmanctl tether gadget on"))
            {
                system("connmanctl tether gadget on");
            }
            else
            {
                lynq_response_error();
                return;
            }
            lynq_response_ok();
        }
        if(connman_cmd2 == NULL)
        {
            if(!strcmp(connman_cmd1, "connmanctl disable gadget"))
            {
                system("connmanctl disable gadget");
            }
            else
            {
                lynq_response_error();
                return;
            }
            lynq_response_ok();
        }
    }
    // else if(type == AT_TEST_MODE)//list
    // {
    //     sprintf(buf,"+MNETCALL:(0-1)");
    //     handle_output(buf, strlen(buf), Response);
    //     lynq_response_ok();
    // }
    // else if(type == AT_READ_MODE)//get
    // {
    //     sprintf(buf,"+MNETCALL:%d", g_mnetcall_mode);
    //     handle_output(buf, strlen(buf), Response);
    //     lynq_response_ok();
    // }
    else
    {
        lynq_response_error();
    }
    return;
}

static Command commands[] = 
{
{"at+mnetcall",lynq_handle_rndis},
{"at+gtarndis",lynq_handle_rndis_configure},
{"at+cgir",lynq_handle_version},
{"at+lgmds",lynq_handle_modem_status},
{"at+lrndishandle",lynq_tmp_handle_rndis},//tmp plan
{NULL, NULL}
};

Command* find_command (char *input)
{
    RLOGD("function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
    int i;
    int ret = -1;
    for (i = 0; commands[i].cmd; i++)
    {
        ret = strcmp(input, commands[i].cmd);
        if(ret == 0)
        {
            RLOGD("function %s line %d find input %s commands[i].cmd %s  strlen %d ret %d\n", __FUNCTION__, __LINE__, input, commands[i].cmd, strlen(commands[i].cmd), ret);
            return (&commands[i]);
        }
    }
    RLOGD("function %s line %d not find ret %d \n", __FUNCTION__, __LINE__, ret);
    return ((Command *)NULL);
}

void lynq_at_common_cb(char *input, int input_max_size)
{
    if(handle_output != NULL)
    {
        RLOGD("function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
        if(input != NULL)
        {
            char *prefix = NULL;
            prefix = atci_get_cmd_prefix(input);
            if (NULL == prefix) {
                RLOGD("atci_cut_cmd_prefix error");
                return;
            }
            RLOGD("find prefix [%s]", prefix);
            Command *cmd = find_command(prefix);
            if(cmd != NULL)
            {
                int cmd_mode = atci_get_cmd_mode(input);
                RLOGD("function %s line %d\n", __FUNCTION__, __LINE__);
                (*(cmd->func))(input,cmd_mode);
                free(prefix);
                return;
            }
            else
            {
                RLOGD("not find prefix in list");
            }
            free(prefix);
        }
    }
}

lynq_atsvc_incb lynq_register_at_common(lynq_atsvc_outcb out_cb)
{
    if(out_cb != NULL)
    {
        handle_output = out_cb;
        RLOGD("function %s line %d\n", __FUNCTION__, __LINE__);
        return lynq_at_common_cb;
    }
}
