#include <stdio.h>
#include <string.h>
#include <stdbool.h>
#include <stdlib.h>
#include "dhcp/lynq_dhcp.h"

bool isVaildIp(const char *ip)
{
	int dots = 0; /*number of char*/
	int setions = 0; /*part of ip（0-255）*/ 

	if (NULL == ip || *ip == '.') { /*排除输入参数为NULL, 或者一个字符为'.'的字符串*/ 
		return false;
	}   

	while (*ip) {

		if (*ip == '.') {
			dots ++; 
			if (setions >= 0 && setions <= 255) { /*judge ip is vaild*/
				setions = 0;
				ip++;
				continue;
			}   
			return false;
		}   
		else if (*ip >= '0' && *ip <= '9') { /*judge is number*/
			setions = setions * 10 + (*ip - '0'); /*求每一段总和*/
		} else 
			return false;
		ip++;   
	}   

	if (setions >= 0 && setions <= 255) {		/*判断IP最后一段是否合法*/ 
		if (dots == 3) {
			return true;
		}   
	}   

	return false;
}

void Restart_Dhcp(char* if_name)
{
	char gyCmd[128] = {0};
	sprintf(gyCmd,"ifconfig %s down",if_name);
	system(gyCmd);
		//printf("gyCmd=%s\n",gyCmd);
	sprintf(gyCmd,"ifconfig %s up",if_name);
	system(gyCmd);
		//printf("gyCmd=%s\n",gyCmd);
}

void lynq_dhcp_get_interfacelist(char* interface_name)
{
	char ifname[IFNAME_CNT][IFNAME] = {0};

	char buf[IFNAME]={0};
	int i=0;
	FILE * fp = NULL;
	char gyCmd[128] = {0};
	//1.Start from the second row and loop to get the first column of data;2.Remove the space from start of line;3.Remove the ":" from end of line;
	sprintf (gyCmd, "cat /proc/net/dev | awk '{i++; if(i>2){print $1}}' | sed 's/^[\t]*//g' | sed 's/[:]*$//g'");

	//ifconfig | grep encap |grep -v lo | cut -d ' ' -f1
	//sprintf (gyCmd, "ifconfig | grep flags |grep -v lo | cut -d ':' -f1");
	fp = popen (gyCmd, "r");
	
	while(fgets(buf, sizeof(buf), fp)!=NULL){
        strtok(buf, "\n");
		strcat(interface_name,buf);
		strcat(interface_name,";");
	}

	pclose(fp);
}

void lynq_dhcp_get_address(char* inet_addr,int type)
{
	char ifname[IFNAME_CNT][IFNAME] = {0};
	int i=0;
	char buf[32]={0};
	char interface_name[IFNAME] = {0};
	char gyCmd[128] = {0};
	FILE * fp = NULL;

	lynq_dhcp_get_interfacelist(interface_name);
	char delims[] = ";";  
    char *result = NULL;  
    result = strtok( interface_name, delims );  
    while( result != NULL ) {  
	   strcpy(ifname[i++],result);	   
       result = strtok( NULL, delims );  
    }          
	for(i=0;i<IFNAME_CNT;i++){
		if(strlen(ifname[i])){
			//printf("[%s][%d]ifname[%s]\n",__FUNCTION__,__LINE__,ifname[i]);
			switch (type) {
				case DHCP_IPADDR:
					sprintf(gyCmd,"ifconfig %s | grep \"inet addr:\" | awk '{print $2}' | awk 'NR==1'",ifname[i]);
					break;
				case DHCP_NETMASK:
					sprintf(gyCmd,"ifconfig %s | grep \"inet addr:\" | awk '{print $4}' | awk 'NR==1'",ifname[i]);
					break;
				case DHCP_GATEWAY:
					sprintf(gyCmd,"route -n | grep %s | awk 'NR==1' | awk '{print $2}'",ifname[i]);
					break;
				case DHCP_BROADCAST:
					sprintf(gyCmd,"ifconfig %s | grep \"inet addr:\" | awk '{print $6}' | awk 'NR==1'",ifname[i]);
					break;
				default:
					break;
			}
			//printf("[%s][%d]gyCmd[%s]\n",__FUNCTION__,__LINE__,gyCmd);
				fp = popen (gyCmd, "r");
				if(fgets(buf, sizeof(buf), fp)!=NULL){
					buf[strlen(buf)-1]='\0';
					//printf("[%s][%d]strlen(buf)[%d][%s]\n",__FUNCTION__,__LINE__,strlen(buf),buf);
					if(strlen(buf)>1){
						if(strstr(buf, "Device not found") != NULL ){
							strcat(inet_addr,ifname[i]);
							strcat(inet_addr,":Not Found!;");
						}else{
							strcat(inet_addr,ifname[i]);
							strcat(inet_addr,":");
							strcat(inet_addr,buf);
							strcat(inet_addr,";");
						}

						//printf("[%s][%d]addr[%s][%d]\n",__FUNCTION__,__LINE__,addr[i],i);
					}else if(!strlen(buf)){
						strcat(inet_addr,ifname[i]);
						strcat(inet_addr,":Not Found!;");	
						//printf("[%s][%d]addr[%s][%d]\n",__FUNCTION__,__LINE__,addr[i],i);
					}
				}else{
					strcat(inet_addr,ifname[i]);
					strcat(inet_addr,":Not Found!;");	
					
				}
				pclose(fp);
		}
	}
	//printf("[%s][%d]addr[%s][%d]\n",__FUNCTION__,__LINE__,addr[i],i);

}

#if 0
//ifconfig eth1 | grep "inet addr:" | awk '{print $2}' | cut -c 6-
char* Get_Dhcp_Ip(char addr[16][64])
{
	char ifname[IFNAME_CNT][IFNAME] = {0};
	int i=0;
	char buf[IFNAME]={0};

	char gyCmd[128] = {0};
	FILE * fp = NULL;
	Search_Interface(ifname);
	for(i=0;i<IFNAME_CNT;i++){
		if(strlen(ifname[i])){
			printf("[%s][%d]ifname[%s]\n",__FUNCTION__,__LINE__,ifname[i]);
			sprintf(gyCmd,"ifconfig %s | grep \"inet\" | awk '{print $2}' | awk 'NR==1'",ifname[i]);
				fp = popen (gyCmd, "r");
				while(fgets(buf, sizeof(buf), fp)!=NULL){
					if(strstr(buf, "Device not found") != NULL ){
						strcpy(addr[i],ifname[i]);
						strcat(addr[i],":Not Found!");
					}else{
						if(strlen(buf)>1){
							strtok(buf, "\n");
							
							strcpy(addr[i],ifname[i]);
							strcat(addr[i],":");
							strcat(addr[i],buf);
							//printf("[%s][%d]addr[%s][%d]\n",__FUNCTION__,__LINE__,addr[i],i);
						}
					}
				}
				pclose(fp);
		}
	}

	return addr;
}

char* Get_Dhcp_NetMask(char addr[16][64])
{
	char ifname[IFNAME_CNT][IFNAME] = {0};
	int i=0;
	char buf[IFNAME]={0};

	char gyCmd[128] = {0};
	FILE * fp = NULL;
	Search_Interface(ifname);
	for(i=0;i<IFNAME_CNT;i++){
		if(strlen(ifname[i])){
			printf("[%s][%d]ifname[%s]\n",__FUNCTION__,__LINE__,ifname[i]);
			sprintf(gyCmd,"ifconfig %s | grep \"inet\" | awk '{print $4}' | awk 'NR==1'",ifname[i]);
				fp = popen (gyCmd, "r");
				while(fgets(buf, sizeof(buf), fp)!=NULL){
					if(strstr(buf, "Device not found") != NULL ){
						strcpy(addr[i],ifname[i]);
						strcat(addr[i],":Not Found!");
					}else{
						if(strlen(buf)>1){
							strtok(buf, "\n");
							
							strcpy(addr[i],ifname[i]);
							strcat(addr[i],":");
							strcat(addr[i],buf);
							//printf("[%s][%d]addr[%s][%d]\n",__FUNCTION__,__LINE__,addr[i],i);
						}
					}
				}
				pclose(fp);
		}
	}

	return addr;
}
#endif

int lynq_dhcp_set_address(char *inet_addr,char *interface_name ,int type)
{
	char ifname[IFNAME_CNT][IFNAME] = {0};
	int i=0;
	int find=0;
	char gyCmd[128] = {0};
	char ifn[IFNAME] = {0};
	char delims[] = ";";  
    char *result = NULL;  
    if (!isVaildIp(inet_addr)) {
		return DHCP_FAIL_INVALID_IP;
    }   
	lynq_dhcp_get_interfacelist(ifn);

    result = strtok( ifn, delims );  
    while( result != NULL ) {  
	   strcpy(ifname[i++],result);	   
       result = strtok( NULL, delims );  
    }     
	if(interface_name==NULL)
		return DHCP_FAIL_INVALID_IFNAME;	
	for(i=0;i<IFNAME_CNT;i++){
		if(strlen(ifname[i]))
			if(!strcmp(ifname[i],interface_name))
				find=1;
	}

	switch (type) {
		case DHCP_IPADDR:
			sprintf(gyCmd,"ifconfig %s %s",interface_name,inet_addr);
			system(gyCmd);
			//printf("gyCmd=%s\n",gyCmd);
			break;
		case DHCP_NETMASK:
			sprintf(gyCmd,"ifconfig %s netmask %s",interface_name,inet_addr);
			system(gyCmd);
			break;
		case DHCP_GATEWAY:
			sprintf(gyCmd,"route add %s gw %s ",interface_name,inet_addr);
			system(gyCmd);
			break;
		case DHCP_BROADCAST:
			sprintf(gyCmd,"ifconfig %s broadcast %s",interface_name,inet_addr);
			system(gyCmd);
			break;
		default:
			break;
	}

	Restart_Dhcp(interface_name);
	if(find)
		return DHCP_SUCCESS;
	else
		return DHCP_FAIL_NO_DEV;
}

int lynq_dhcp_enable(char* interface_name,int enable)
{
	char ifname[IFNAME_CNT][IFNAME] = {0};
	int i=0;
	char gyCmd[128] = {0};
	int find=0;
	char ifn[IFNAME] = {0};
	char delims[] = ";";  
    char *result = NULL;  
	if(interface_name==NULL)
		return DHCP_FAIL_INVALID_IFNAME;	
	lynq_dhcp_get_interfacelist(ifn);
    result = strtok( ifn, delims );  
    while( result != NULL ) {  
	   strcpy(ifname[i++],result);	   
       result = strtok( NULL, delims );  
    }   	
	for(i=0;i<IFNAME_CNT;i++){
		if(strlen(ifname[i]))
			if(!strcmp(ifname[i],interface_name))
				find=1;
	}
	switch (enable) {
		case DHCP_ON:
			sprintf(gyCmd,"ifconfig %s up",interface_name);
			break;
		case DHCP_OFF:
			sprintf(gyCmd,"ifconfig %s  down",interface_name);
			break;
		default:
			break;
	}

	if(find)
		return DHCP_SUCCESS;
	else
		return DHCP_FAIL_NO_DEV;
}
#if 0
//my_test1 0 192.168.125.55 eth1 0
int main(int argc,  char *argv[])
{
	char ip_addr[16][64] = {0};
	int i;
	char* buf=NULL;
	//Get_Dhcp_Ip(ip_addr);
	printf("%d\n",atoi(argv[1]));
	Get_Dhcp(ip_addr,atoi(argv[1]));
	for(i=0;i<IFNAME_CNT;i++){
		printf("[%s][%d]out[%s][%d]\n",__FUNCTION__,__LINE__,ip_addr[i],i);
	}
	buf=Set_Dhcp(argv[2],argv[3],argv[4]);
	printf("buf=%s\n",buf);
	return 0;
}
#endif