/*============================================================================= 
#     FileName: lynq_sms.h
#         Desc: about sms api
#       Author: zhouqunchao 
#      Version:  
#   LastChange: 2020-07-29 
#      History: 
 
=============================================================================*/

#ifndef YLNQ_SMS_H
#define YLNQ_SMS_H 1
#include <sys/types.h>
#include "lib_tele.h"
#ifdef __cplusplus
extern "C" {
#endif
#define MIN_MSM_PARAM_NUM 4
#define MIN_IMS_MSM_PARAM_NUM 6
#define MIN_WRITE_MSM_PARAM_NUM 5
#define MSG_MAX_LEN 256
typedef struct {
    char *telephonyNumber;
    char *charset;
    char *msg;
    char *smsc;
} SmsSendData;
typedef struct{
lynqBase base;
RIL_SMS_Response smsResp;
}smsResponse;
typedef struct {
    char *telephonyNumber;
    char *charset;
    char *msg;
    char *retryNum;
    char *messageRef;
    char *smsc;    
} SmsImsSendData;

typedef struct {
    int  smsStatus; //UnRead\Read\UnSent\Sent
    char *recPhonNum;
    char *charset;
    char *msg;
    char *smsc;    
} SmsInfo;

typedef struct{
lynqBase base;
int msgStoreIndex;
}messageStoreInfo;

typedef struct{
lynqBase base;
char *smsc;
}smscCbInfo;
typedef struct
{
    int index;// the index of sms in memory,0-100.
    int status;//read:0,unread:1
    int smslen;//the length of sms,the maximum length shall not exceed the length specified in 3GGP protocol(160/70)
    char message[MSG_MAX_LEN];//sms content
    RIL_SOCKET_ID soc_id;
    char teleNum[50];//telephony number
    int numLen;
}storeMessageInfo;
int lynq_send_sms(const char *telephonyNumber, const int charset,const char *msg, const char *smsc, smsResponse* smsResp);
int lynq_Ims_send_sms(const char *telephonyNumber, const int charset,const char *msg, const char*retryNum,const char *messageRef, const char *smsc,smsResponse *smsResp);
int lynq_write_sms_to_sim(const int smsStatus,const char *recPhonNum,const int charset,const char *msg,const char *smsc,messageStoreInfo *msgstroeInfo);
int lynq_report_sms_memory_status(const int status,lynqBase *base);
int lynq_delet_sms_on_sim(const int index,lynqBase *base);
int lynq_get_smsc_address(smscCbInfo *smscInfo);
int lynq_set_smsc_address(const char* serviceNumber,lynqBase *base);
void lynq_recive_new_sms_cb(RIL_SOCKET_ID soc_id,char * num, char * smsc, char * msg, int charset);
int lynq_store_sms_to_memory(RIL_SOCKET_ID soc_id,const int status,char * num,const char* sms,lynqBase *base);
int lynq_get_sms_from_memory(const int index, storeMessageInfo* sms,lynqBase *base);
int lynq_delete_message_from_memory(const int index,lynqBase *base);

#ifdef __cplusplus
}
#endif
#endif
