/*============================================================================= 
#     FileName: lynq_sms.cpp
#         Desc: about sms api
#         Author: MoblieTek 
#         Version:
#   LastChange: 2021-01-06  
#      History: 
 
=============================================================================*/
#include <dlfcn.h>
#include <string.h>
#include <stdint.h>
#include <unistd.h>
#include <fcntl.h>
#include <cutils/jstring.h>
#include <cutils/properties.h>
#include "lynq_sms.h"
#include "lynq_common.h"
#include <liblog/lynq_deflog.h>
#define KERNAL 19
#define SMS_INDEX_VALUE "persist.sms.memory.index"
#define SMS_INDEX_FLAG_VALUE "persist.sms.memory.flag"
#undef LOG_TAG
#define LOG_TAG "LYNQ_SMS"

int lynq_send_sms(const char *telephonyNumber, const int charset,const char *msg, const char *smsc,smsResponse* smsResp)
{
    int lenth = MIN_MSM_PARAM_NUM;
    char *argv[MAX_LEN];
    int32_t token=0;
    RIL_Errno err=-1;
    lynqQueue *node =NULL;
    int num = 0;
    int res = 0;
    char requestStr[MAX_QUEST_LEN] = {0};
    sprintf(requestStr, "%d", charset);
    argv[0] = "RIL_REQUEST_SEND_SMS";
    argv[1] = telephonyNumber;
    argv[2] = requestStr;
    argv[3] = msg;
    argv[4] = smsc;
    if(smsc ==NULL)
    {
        token = android::getRequestData(argv,4);
        //RLOGD("token is %d",token);
        LYDBGLOG("[%s][%d][%s]token:%d\n",__FUNCTION__, __LINE__,__FILE__,token);
    }
    else
    {
        token = android::getRequestData(argv,5);
        //RLOGD("token is %d",token);
        LYDBGLOG("[%s][%d][%s]token:%d\n",__FUNCTION__, __LINE__,__FILE__,token);
    }
    smsResp->base.request = RIL_REQUEST_SEND_SMS;
    smsResp->base.token=token;
    smsResp->smsResp.messageRef = 0;
    smsResp->smsResp.errorCode = 0;
    if(token<0)
    {
        smsResp->base.e=err;
        return -1;
    }
    node = commonFindParcelmsg(token, 500, err);
    smsResp->base.e=err;
    if (node !=NULL)
    {
        node->parcel.readInt32(&num);
        if(num ==0)
        {
            LYDBGLOG("[%s][%d][%s]the call back message is null!\n",__FUNCTION__, __LINE__,__FILE__);
            if(err==RIL_E_SUCCESS)
            {
                smsResp->base.e=-1;
            }
            lynqDeQueue(token);
            return token;
        }
        node->parcel.readInt32(&smsResp->smsResp.messageRef);
        smsResp->smsResp.ackPDU= lynqStrdupReadString(node->parcel);
        node->parcel.readInt32(&smsResp->smsResp.errorCode);
    }
    lynqDeQueue(token);
    return token;
}
int lynq_Ims_send_sms(const char *telephonyNumber, const int charset,const char *msg, const char* retryNum,const char *messageRef, const char *smsc,smsResponse *smsResp)
{
    int lenth = MIN_IMS_MSM_PARAM_NUM;
    char *argv[MAX_LEN];
    char requestStr[MAX_QUEST_LEN] = {0};
    int32_t token=0 ;
    RIL_Errno err=-1;
    lynqQueue *node =NULL;
    int num = 0;
    int res = 0;
    sprintf(requestStr, "%d", charset);
    argv[0] = "RIL_REQUEST_IMS_SEND_SMS";
    argv[1] = telephonyNumber;
    argv[2] = requestStr;
    argv[3] = msg;
    argv[4] = retryNum;
    argv[5] = messageRef;
    argv[6] = smsc;
    if(smsc==NULL)
    {
        token = android::getRequestData(argv, 5);
        //RLOGD("token is %d",token);
        LYDBGLOG("%s,%d,%s,token:%d\n",__FUNCTION__, __LINE__,__FILE__,token);
    }
    else
    {
        token = android::getRequestData(argv, 6);
        //RLOGD("token is %d",token);
        LYDBGLOG("%s,%d,%s,token:%d\n",__FUNCTION__, __LINE__,__FILE__,token);
    }
    smsResp->base.request = RIL_REQUEST_SEND_SMS;
    smsResp->base.token=token;
    smsResp->smsResp.messageRef = 0;
    smsResp->smsResp.errorCode = 0;
    if(token<0)
    {
        smsResp->base.e=err;
        return -1;
    }
    node = commonFindParcelmsg(token, 500, err);
    smsResp->base.e=err;
    if (node !=NULL)
    {
        node->parcel.readInt32(&num);
        if(num ==0)
        {
            //RLOGD("[%s]the call back message is null!",__FUNCTION__);
            LYDBGLOG("[%s][%d][%s]the call back message is null!\n",__FUNCTION__, __LINE__,__FILE__);
            if(err==RIL_E_SUCCESS)
            {
                smsResp->base.e=-1;
            }
            lynqDeQueue(token);
            return token;
        }
        node->parcel.readInt32(&smsResp->smsResp.messageRef);
        smsResp->smsResp.ackPDU= lynqStrdupReadString(node->parcel);
        node->parcel.readInt32(&smsResp->smsResp.errorCode);
    }
    lynqDeQueue(token);
    return token;
}
int lynq_write_sms_to_sim(const int smsStatus,const char *recPhonNum,const int charset,const char *msg,const char *smsc,messageStoreInfo *msgstroeInfo)
{
    char *argv[MAX_LEN];
    char smsStatusStr[MAX_QUEST_LEN] = {0};
    char charsetStr[MAX_QUEST_LEN] = {0};
    int32_t token=0 ;
    RIL_Errno err=-1;
    lynqQueue *node =NULL;
    int num = 0;
    int res = 0;
    sprintf(smsStatusStr, "%d", smsStatus);
    sprintf(charsetStr, "%d", charset);
    argv[0] = "RIL_REQUEST_WRITE_SMS_TO_SIM";
    argv[1] = smsStatusStr;
    argv[2] = recPhonNum;
    argv[3] = charsetStr;
    argv[4] = msg;
    argv[5] = smsc;
    if(smsc==NULL)
    {
        token = android::getRequestData(argv, 5);
        //RLOGD("token is %d",token);
        LYDBGLOG("%s,%d,%s,token:%d\n",__FUNCTION__, __LINE__,__FILE__,token);
    }
    else
    {
        token = android::getRequestData(argv, 6);
        //RLOGD("token is %d",token);
        LYDBGLOG("%s,%d,%s,token:%d\n",__FUNCTION__, __LINE__,__FILE__,token);
    }
    msgstroeInfo->base.request = RIL_REQUEST_WRITE_SMS_TO_SIM;
    msgstroeInfo->base.token=token;
    msgstroeInfo->msgStoreIndex = 0;
    if(token<0)
    {
        msgstroeInfo->base.e=err;
        return -1;
    }
    node = commonFindParcelmsg(token, 500, err);
    msgstroeInfo->base.e=err;
    if (node !=NULL)
    {
        node->parcel.readInt32(&num);
        if(num ==0)
        {
            //RLOGD("[%s]the call back message is null!",__FUNCTION__);
            LYDBGLOG("[%s][%d][%s]the call back message is null!\n",__FUNCTION__, __LINE__,__FILE__);
            if(err==RIL_E_SUCCESS)
            {
                msgstroeInfo->base.e=-1;
            }
            lynqDeQueue(token);
            return token;
        }
        node->parcel.readInt32(&msgstroeInfo->msgStoreIndex);
    }
    lynqDeQueue(token);
    return token;
}

/**
RIL_REQUEST_REPORT_SMS_MEMORY_STATUS
index is Unavailable or Available
*/
int lynq_report_sms_memory_status(const int status,lynqBase *base)
{
    int32_t token=0 ;
    RIL_Errno err=-1;
    lynqQueue *node =NULL;
    int state = 0;
    int res = 0;
    const char requestStr[MAX_LEN] = {"RIL_REQUEST_REPORT_SMS_MEMORY_STATUS"};
    token = lynqIntParame(requestStr,status);
    base->request = RIL_REQUEST_REPORT_SMS_MEMORY_STATUS;
    base->token=token;
    if(token<0)
    {
        base->e=err;
        return -1;
    }
    node = commonFindParcelmsg(token, 500, err);
    base->e=err;
    if (node !=NULL)
    {
        node->parcel.readInt32(&state);
        if(state ==0)
        {
            //RLOGD("[%s]the call back message is null!",__FUNCTION__);
            LYDBGLOG("[%s][%d][%s]the call back message is null!\n",__FUNCTION__, __LINE__,__FILE__);
            if(err==RIL_E_SUCCESS)
            {
                base->e=-1;
            }
            lynqDeQueue(token);
            return token;
        }
    }
    lynqDeQueue(token);
    return token;
}

/**
RIL_REQUEST_REPORT_SMS_MEMORY_STATUS
index is lynqWriteSMSToSim get index
*/
int lynq_delet_sms_on_sim(const int index,lynqBase *base)
{
    int32_t token=0 ;
    RIL_Errno err=-1;
    lynqQueue *node =NULL;
    int status = 0;
    int res = 0;
    const char requestStr[MAX_LEN] = {"RIL_REQUEST_DELETE_SMS_ON_SIM"};
    token = lynqIntParame(requestStr,index);
    base->request = RIL_REQUEST_DELETE_SMS_ON_SIM;
    base->token=token;
    if(token<0)
    {
        base->e=err;
        return -1;
    }
    node = commonFindParcelmsg(token, 500, err);
    base->e=err;
    if (node !=NULL)
    {
        node->parcel.readInt32(&status);
        if(status ==0)
        {
            //RLOGD("[%s]the call back message is null!",__FUNCTION__);
            LYDBGLOG("[%s][%d][%s]the call back message is null!\n",__FUNCTION__, __LINE__,__FILE__);
            if(err==RIL_E_SUCCESS)
            {
                base->e=-1;
            }
            lynqDeQueue(token);
            return token;
        }
    }
    lynqDeQueue(token);
    return token;
}

int lynq_get_smsc_address(smscCbInfo *smscInfo)
{
    int32_t token=0 ;
    RIL_Errno err=-1;
    lynqQueue *node =NULL;
    int num = 0;
    int res = 0;
    const char requestStr[MAX_LEN] = {"RIL_REQUEST_GET_SMSC_ADDRESS"};
    token = lynqNoneParame(requestStr);
    smscInfo->base.request = RIL_REQUEST_GET_SMSC_ADDRESS;
    smscInfo->base.token = token;
    smscInfo->smsc = NULL;
    if(token<0)
    {
        smscInfo->base.e=err;
        return -1;
    }
    node = commonFindParcelmsg(token, 500, err);
    smscInfo->base.e=err;
    if (node !=NULL)
    {
        node->parcel.readInt32(&num);
        if(num ==0)
        {
            //RLOGD("[%s]the call back message is null!",__FUNCTION__);
            LYDBGLOG("[%s][%d][%s]the call back message is null!\n",__FUNCTION__, __LINE__,__FILE__);
            if(err==RIL_E_SUCCESS)
            {
                smscInfo->base.e=-1;
            }
            lynqDeQueue(token);
            return token;
        }
        smscInfo->smsc =lynqStrdupReadString(node->parcel);
    }
    lynqDeQueue(token);
    return token;
}

int lynq_set_smsc_address(const char* serviceNumber,lynqBase *base)
{
    int32_t token=0 ;
    RIL_Errno err=-1;
    lynqQueue *node =NULL;
    int status = 0;
    int res = 0;
    const char requestStr[MAX_LEN] = {"RIL_REQUEST_SET_SMSC_ADDRESS"};
    token = lynqStringParame(requestStr,serviceNumber);
    base->request = RIL_REQUEST_SET_SMSC_ADDRESS;
    base->token=token;
    if(token<0)
    {
        base->e=err;
        return -1;
    }
    node = commonFindParcelmsg(token, 500, err);
    base->e=err;
    if (node !=NULL)
    {
        node->parcel.readInt32(&status);
        if(status ==0)
        {
            //RLOGD("[%s]the call back message is null!",__FUNCTION__);
            LYDBGLOG("[%s][%d][%s]the call back message is null!\n",__FUNCTION__, __LINE__,__FILE__);
            if(err==RIL_E_SUCCESS)
            {
                base->e=-1;
            }
            lynqDeQueue(token);
            return token;
        }
    }
    lynqDeQueue(token);
    return token;
}
/*
void lynq_recive_new_sms_cb(RIL_SOCKET_ID soc_id,char * num, char * smsc, char * msg, int charset)
{
    printf("[SIM%d]num is %s,smsc is %s,msg is %s,charset is %d\n",soc_id,num,smsc,msg,charset);
}*/
/*Convert the decimal number into hexadecimal and write it into the buffer
int decToHex(int aa,char *buffer)
{
    itoa(aa, buffer, 16);
    return 0;

}
*/
/*Convert the index into string and write it into the buf*/
int hexToDec(char* s)
{
    int t = 0;         //t记录临时加的数 
    int sum = 0;
    for (int i = 0;s[i];i++)
    {
        if (s[i] >= '0' && s[i] <= '9')
            t = s[i] - '0';       //当字符是0~9时保持原数不变
        if (s[i] >= 'a' && s[i] <= 'z')
            t = s[i] - 'a' + 10;
        if (s[i] >= 'A' && s[i] <= 'Z')
            t = s[i] - 'A' + 10;
        sum = sum * 16 + t;
    }
    //printf("SUM:%d\n", sum);
    return sum;
}

int indexToString(int index,char buf[])
{
    int smslen = 0;
    if (index > 0 && index < 10)
    {
        snprintf(buf, sizeof(buf), "00%d", index);
    }
    else if (index >= 10 && index < 100)
    {
        snprintf(buf, sizeof(buf), "0%d", index);
    }
    else if (index == 100)
    {
        snprintf(buf, sizeof(buf), "%d", index);
    }
    else if (index <= 0 ||index > 100)
    {
        snprintf(buf, sizeof(buf), "%d", 110);
    }
    buf[3] = '\0';
    return 0;
}
/*组装短消息头，并且和短消息实体拼接。
**储存短消息的头信息格式如下
**头部的格式：index|status|soc_id|teleNumLen|smslen|
**index 表示存储索引，占3位
**status 表示短消息的阅读状态，占1位
**smslen 表示短消息实体长度，是16进制数0x0000，占6位
**soc_id 表示卡槽编号，占1位
**teleNumLen 表示电话号码的长度，占2位。
**
*/
int assembleMsgInfo(FILE* fp,int property,int status,int smslen,RIL_SOCKET_ID soc_id,char * num,char element[],char *sms)
{
    char indexString[10] = { 0 };
    char numBuf[50]={0};
    char smsBuffer[MSG_MAX_LEN] = { 0 };
    indexToString(property,indexString);
    snprintf(element, KERNAL+1, "|%s|%d|0x%04x|%d|%02d|", indexString, status, smslen,soc_id,strlen(num));
    element[KERNAL] = '\0';//必须加结束符‘\0’.
    snprintf(numBuf, strlen(num)+1, "%s", num);//加1是因为需要把结束符‘\0’也保存进来。
    snprintf(smsBuffer, strlen(sms)+1, "%s", sms);
    strncat(element, numBuf, strlen(num));
    strncat(element, smsBuffer, smslen);
    //printf("head %s\n", element);
    LYDBGLOG("[%s][%d][%s]element sms%s!\n",__FUNCTION__, __LINE__,__FILE__,element);
    return 0;
}

int parseHeader(const char *message,int number,storeMessageInfo *SMI[])
{
    const char* temp = message;
    const char* nextP = NULL;
    char docker[100] = { 0 };
    char smsbuffer[MSG_MAX_LEN] = {0};
    char indexbuf[10] = { 0 };
    char smslenbuf[10] = { 0 };
    char socIdBuf[10] ={0};
    char numLenBuf[10] = {0};
    char numBuf[50] = {0};
    int count = 0;
    if (temp == NULL)
    {
        LYERRLOG("[%s][%d][%s]input message is null !!\n",__FUNCTION__, __LINE__,__FILE__);
        return LYNQ_E_NULL_ANONALY;
    }
    while (1)
    {
        if (*temp == '\0')
        {
            break;
        }
        nextP = temp + 1;
        for (int i = 0;i < KERNAL; i++)
        {
            docker[i] = *temp;
            temp++;
        }
        if (docker[0] == '|' && docker[4] == '|' && docker[6] == '|' && docker[13] == '|')
        {
            for (int i = 0;i < 3;i++)
            {
                strncat(indexbuf, &docker[i+1], 1);
            }
            indexbuf[3] = '\0';
            for (int i = 0; i < 4; i++)
            {
                strncat(smslenbuf, &docker[i + 9], 1);
            }
            smslenbuf[4] = '\0';
            for(int i=0;i<2;i++)
            {
                strncat(numLenBuf,&docker[i+16],1);
            }
            SMI[count]->index = atoi(indexbuf);
            SMI[count]->status = atoi(&docker[5]);
            SMI[count]->soc_id=atoi(&docker[14]);
            SMI[count]->numLen = atoi(numLenBuf);
            SMI[count]->smslen = hexToDec(smslenbuf);
            int i=0;
            for(i=0;i<SMI[count]->numLen;i++)
            {
                numBuf[i]=*temp;
                temp++;
            }
            numBuf[i + 1]='\0';
            for (i = 0;i < SMI[count]->smslen;i++)
            {
                smsbuffer[i] = *temp;
                temp++;
            }
            smsbuffer[i + 1] = '\0';
            memcpy(SMI[count]->message, smsbuffer, SMI[count]->smslen + 1);
            memcpy(SMI[count]->teleNum, numBuf, SMI[count]->numLen + 1);
            LYDBGLOG("[%s][%d][%s]index:%d,status:%d,smslen:%d,message:%s,soc_id:%d,numberlen:%d,number:%s!!\n",__FUNCTION__,
            __LINE__,__FILE__,SMI[count]->index,SMI[count]->status,SMI[count]->smslen,SMI[count]->message,
            SMI[count]->soc_id,SMI[count]->numLen,SMI[count]->numLen);
            memset(smslenbuf, 0, strlen(smslenbuf));
            memset(indexbuf, 0, strlen(indexbuf));
            memset(docker, 0, strlen(docker));
            memset(smsbuffer, 0, strlen(smsbuffer));
            memset(socIdBuf,0,strlen(socIdBuf));
            memset(numLenBuf,0,strlen(numLenBuf));
            memset(numBuf,0,strlen(numBuf));
            count += 1;
        }
        else
        {
            temp = nextP;
        }
    }
    if (count != number||count ==0)
    {
        return -1;
    }
    return 0;
}
storeMessageInfo **getAllMessage(int &smsNum,int index)
{
    int result = 0;
    int property = 0;
    int flag =0;
    int len = 0;
    char indexBuf[10]={ 0 };
    char flagBuf[10]={0};
    char buff[MSG_MAX_LEN*100] = { 0 };
    char element[MSG_MAX_LEN] = { 0 };
    storeMessageInfo** SMI = NULL;
    property_get(SMS_INDEX_VALUE,indexBuf,NULL);
    property_get(SMS_INDEX_FLAG_VALUE,flagBuf,NULL);
    property = atoi(indexBuf);
    //printf("property:%d\n",property);
    flag = atoi(flagBuf);
    //printf("flag:%d\n",flag);
    if((property==0)&&(flag==1))
    {
        property =100;
    }
    if((property==0)&&(flag==0))
    {
        LYERRLOG("[%s][%d][%s]not have SMS was store in memory!!\n",__FUNCTION__, __LINE__,__FILE__);
        return NULL;
    }
    if(property<index)
    {
        LYERRLOG("[%s][%d][%s]Out of bounds!!\n",__FUNCTION__, __LINE__,__FILE__);
        return NULL;
    }
    FILE* fp = NULL;
    fp = fopen("/usr/bin/demoscript/SMS_API/custerm_message.txt", "r");
    if (fp == 0)
    {
        LYERRLOG("[%s][%d][%s]Can't open log file!!\n",__FUNCTION__, __LINE__,__FILE__);
        return NULL;
    }
    fseek(fp, 0, SEEK_END);    //将文件指针指向文件的结尾；
    len = ftell(fp);           //获取当前文件指针在文件内的位置，单位为byte       ,len为文件的长度。
    fseek(fp, 0, SEEK_SET);
    fread(buff, len + 1, 1, fp);
    if ((SMI = (storeMessageInfo**)malloc(sizeof(storeMessageInfo*) * property)) == NULL)
    {
        LYERRLOG("[%s][%d][%s]Core dump,malloc fail!!\n",__FUNCTION__, __LINE__,__FILE__);
        return NULL;
    }
    for (int i = 0;i < property;i++)
    {
        if (!(SMI[i] = (storeMessageInfo*)malloc(sizeof(storeMessageInfo))))
        {
            LYERRLOG("[%s][%d][%s]Core dump,malloc fail!!\n",__FUNCTION__, __LINE__,__FILE__);
            for (int n = 0;n < i;n++)
            {
                free(SMI[n]);
            }
            free(SMI);
            return NULL;
        }
        memset(SMI[i], 0, sizeof(storeMessageInfo));
    }
    result = parseHeader(buff, property, SMI);
    fclose(fp);
    smsNum=property;
    return SMI;
}
int lynq_store_sms_to_memory(RIL_SOCKET_ID soc_id,const int status,char * num,const char* sms,lynqBase *base)
{
    int index = 0;
    int indexflag = 0;
    int indexlen =0;
    int headlen = 0;
    int smslen = 0;
    int smsNum = 0;
    FILE* fp = NULL;
    char smsBuffer[MSG_MAX_LEN] = {0};
    char enCode[MSG_MAX_LEN] = {0};
    char buffer[MSG_MAX_LEN*100]={0};
    char indexBuf[50] = { 0 };
    char indexflagBuf[50]={0};
    char teleNumBuf[70]={0};
    storeMessageInfo ** SMI =NULL;
    if (sms == NULL)
    {
        LYERRLOG("[%s][%d][%s] Message is null!!\n",__FUNCTION__, __LINE__,__FILE__);
        base->e = LYNQ_E_NULL_ANONALY;
        return -1;
    }
    fp=fopen("/usr/bin/demoscript/SMS_API/custerm_message.txt", "a+");
    if (fp == 0)
    {
        LYERRLOG("[%s][%d][%s] Can't open log file!!\n",__FUNCTION__, __LINE__,__FILE__);
        return 0;
    }
    indexlen = property_get(SMS_INDEX_VALUE,indexBuf,"0");
    index = atoi(indexBuf);
    indexlen = property_get(SMS_INDEX_FLAG_VALUE,indexflagBuf,"0");
    indexflag = atoi(indexflagBuf);
    smslen = strlen(sms);
    if(indexflag==1)
    {
        SMI = getAllMessage(smsNum, -1);
        if(SMI==NULL)
        {
            base->e= LYNQ_E_NULL_ANONALY;
            return -1;
        }
        for (int i = 0;i < smsNum;i++)
        {
            if(index ==0)
            {
                index = 1;
            }
            if (SMI[i]->index == index)
            {
                 memset(indexBuf,0,strlen(indexBuf));
                 indexToString(index+1, indexBuf);
                 property_set(SMS_INDEX_VALUE,indexBuf);
                 assembleMsgInfo(fp,index,status,smslen,soc_id,num,enCode,sms);
                 strncat(buffer, enCode, strlen(enCode));
                 memset(enCode,0, strlen(enCode));
            }
            else
            {
                assembleMsgInfo(fp,SMI[i]->index, SMI[i]->status, SMI[i]->smslen,SMI[i]->soc_id,SMI[i]->teleNum, enCode, SMI[i]->message);
                strncat(buffer, enCode, strlen(enCode));
                memset(enCode,0, strlen(enCode));
            }
        }
        fwrite(buffer, strlen(buffer), 1, fp);//将msg对应的字符串append到文件末尾
        fclose(fp);
        for(int i=0;i<smsNum;i++)
        {
            free(SMI[i]);
        }
        free(SMI);
        base->e= RIL_E_SUCCESS;
        return 0;
    }
    else
    {
        index = index+1;
        if(index==100)
        {
            property_set(SMS_INDEX_VALUE,"0");
            property_set(SMS_INDEX_FLAG_VALUE,"1");
            assembleMsgInfo(fp,index,status,smslen,soc_id,num,enCode,sms);
        }
        else
        {
            memset(indexBuf,0,strlen(indexBuf));
            indexToString(index, indexBuf);
            property_set(SMS_INDEX_VALUE,indexBuf);
            assembleMsgInfo(fp,index,status,smslen,soc_id,num,enCode,sms);
        }
        fseek(fp, 0, SEEK_END);//定位到文件末尾
        fwrite(enCode, strlen(enCode), 1, fp);//将msg对应的字符串append到文件末尾
        fclose(fp);
        base->e= RIL_E_SUCCESS;
        return 0;
    }
    return -1;
}
int lynq_get_sms_from_memory(const int index, storeMessageInfo* sms,lynqBase *base)
{
    int smsNum = 0;
    storeMessageInfo **SMI=NULL;
    SMI = getAllMessage(smsNum,index);
    if(SMI==NULL)
    {
        base->e= LYNQ_E_NULL_ANONALY;
        return -1;
    }
    /*
    printf("test sms--001\n");
    printf("smsNUM%d, index %d\n",smsNum,index-1);
    sms->index= SMI[index-1]->index;
    printf("test sms--002\n");
    sms->numLen= SMI[index-1]->numLen;
    printf("test sms--003\n");
    sms->smslen = SMI[index-1]->smslen;
    printf("test sms--004\n");
    sms->soc_id= (RIL_SOCKET_ID)SMI[index-1]->soc_id;
    printf("test sms--005\n");
    sms->status=SMI[index-1]->status;
    printf("test sms--006\n");
    memcpy(sms->message,SMI[index-1]->message,strlen(SMI[index-1]->message)+1);
    printf("test sms--007\n");
    memcpy(sms->teleNum,SMI[index-1]->teleNum,strlen(SMI[index-1]->teleNum)+1);
    printf("test sms--008\n");
    */
    for(int i=0;i<smsNum;i++)
    {
        if(SMI[i]->index==index)
        {
            sms->index= SMI[i]->index;
            sms->numLen= SMI[i]->numLen;
            sms->smslen = SMI[i]->smslen;
            sms->soc_id= SMI[i]->soc_id;
            sms->status=SMI[i]->status;
            memcpy(sms->message,SMI[i]->message,strlen(SMI[i]->message)+1);
            memcpy(sms->teleNum,SMI[i]->teleNum,strlen(SMI[i]->teleNum)+1);
            for(int i=0;i<smsNum;i++)
            {
                free(SMI[i]);
            }
            free(SMI);
            base->e= RIL_E_SUCCESS;
            return 0;
        }
    }
    for(int i=0;i<smsNum;i++)
    {
        free(SMI[i]);
    }
    free(SMI);
    base->e= RIL_E_SUCCESS;
    return 0;
}
// The value range of index is -1, 1-100.
//-1 means to delete all.
int lynq_delete_message_from_memory(const int index,lynqBase *base)
{
    char buff[MSG_MAX_LEN*100] = { 0 };
    char element[MSG_MAX_LEN] = {0};
    char indexBuf[10]={ 0 };
    char flagBuf[10]={0};
    int smsNum = 0;
    int property_Count =0;
    int property_Flag = 0;
    int removeflag = 0;
    FILE *fpW=NULL;
    storeMessageInfo **SMI=NULL;
    if(index==(-1))
    {
        fpW = fopen("/usr/bin/demoscript/SMS_API/custerm_message.txt", "w+");
        if (fpW == 0)
        {
            LYERRLOG("[%s][%d][%s] Can't open log file!!\n",__FUNCTION__, __LINE__,__FILE__);
            return -1;
        }
        fwrite(buff, strlen(buff), 1, fpW);
        fclose(fpW);
        property_set(SMS_INDEX_VALUE,"0");
        property_set(SMS_INDEX_FLAG_VALUE,"0");
        base->e= RIL_E_SUCCESS;
        return 0;
    }
    property_get(SMS_INDEX_VALUE,indexBuf,NULL);
    property_get(SMS_INDEX_FLAG_VALUE,flagBuf,NULL);
    property_Count = atoi(indexBuf);
    memset(indexBuf,0,strlen(indexBuf));
    property_Flag = atoi(flagBuf);
    SMI = getAllMessage(smsNum,index);
    if(SMI==NULL)
    {
        base->e= LYNQ_E_NULL_ANONALY;
        return -1;
    }
    fpW = fopen("/usr/bin/demoscript/SMS_API/custerm_message.txt", "w+");
    if (fpW == 0)
    {
        LYERRLOG("[%s][%d][%s] Can't open log file!!\n",__FUNCTION__, __LINE__,__FILE__);
        return -1;
    }
    for (int i = 0;i < smsNum;i++)
    {
        if (SMI[i]->index == index)
        {
            removeflag =1;
            continue;
        }
        assembleMsgInfo(fpW,SMI[i]->index, SMI[i]->status, SMI[i]->smslen,SMI[i]->soc_id,SMI[i]->teleNum, element, SMI[i]->message);
        strncat(buff, element, SMI[i]->smslen + KERNAL+SMI[i]->numLen);
            //strncat(buff, SMI[i]->message,SMI[i]->smslen);
    }
    if(removeflag==1)
    {
        if(property_Flag==1)
        {
            snprintf(indexBuf,4, "%03d",99);
            property_set(SMS_INDEX_VALUE,indexBuf);
            property_set(SMS_INDEX_FLAG_VALUE,"0");

        }
        else
        {
            snprintf(indexBuf,4, "%03d", property_Count-1);
            property_set(SMS_INDEX_VALUE,indexBuf);
            property_set(SMS_INDEX_FLAG_VALUE,"0");
        }
    }
    //printf("%s\n",buff);
    fwrite(buff, strlen(buff), 1, fpW);//将msg对应的字符串append到文件末尾
    fclose(fpW);
    for(int i=0;i<smsNum;i++)
    {
        free(SMI[i]);
    }
    free(SMI);
    base->e= RIL_E_SUCCESS;
    return 0;
}

