#include "http_manager.h"
#include <unistd.h>
#include <stdio.h>
#include <string.h>

static struct list_head http_list;
static HTTP_LIST_LINK_S* http_slider;
static lynq_http_client_t http_cmd = {0};


void *http_handler(void * list)
{
	int error_code = 0;
	HTTP_LIST_LINK_S* pos_list  = (HTTP_LIST_LINK_S *)list;
	
	while(1)
	{
		if (pos_list->data.modify_thread != 1 && pos_list->data.add_thread != 1)
			continue;
		
		pos_list->data.add_thread = 0;
		pos_list->data.modify_thread = 0;

		if (!strcmp(pos_list->data.action, "init")) {}
		else if (!strcmp(pos_list->data.action, "send")) {}
		else if (!strcmp(pos_list->data.action, "get")) {
			lynq_http_init();
			lynq_http_client_t * http_data = lynq_http_new();
			
			http_data->session = pos_list->data.session;
			memcpy(http_data->action, pos_list->data.action, sizeof(http_data->action));//rita add @2021.7.19 for action type mismatch
			lynq_http_sync_request(http_data , pos_list->data.url, M_GET, M_CLOSE);	
			
			error_code = lynq_http_get_error_code(http_data);
			if(error_code!=0){
				LYDBGLOG("[%s-%d] get error!!!\n", __FUNCTION__, __LINE__);//rita add @2021.7.19 for debuging error
				LYVERBLOG("+[http][%s][session%d]: error num = %d\n", http_data->action, http_data->session, error_code);
			}
			
			if (pos_list->data.url)
				free(pos_list->data.url);

			if (pos_list->data.post_data)
				free(pos_list->data.post_data);

			list_del((struct list_head* )pos_list);
			return NULL;
		}

		else if (!strcmp(pos_list->data.action, "getfile")) {//rita add @2021.7.19 for http get
			lynq_http_init();
			lynq_http_client_t * http_data = lynq_http_new();
			
			http_data->session = pos_list->data.session;
			memcpy(http_data->action, pos_list->data.action, sizeof(http_data->action));
			lynq_http_sync_download_file(http_data, pos_list->data.url, "",M_GET, M_CLOSE);

			error_code = lynq_http_get_error_code(http_data);
			if(error_code!=0){
				LYDBGLOG("[%s-%d] get file error!!!\n", __FUNCTION__, __LINE__);//rita add @2021.7.19 for debuging error
				LYVERBLOG("[http][%s][session%d]: error num = %d\n", http_data->action, http_data->session, error_code);
			}
			
			if (pos_list->data.url) {
				free(pos_list->data.url);
			}

			if (pos_list->data.post_data) {
				free(pos_list->data.post_data);
			}

			list_del((struct list_head* )pos_list);
			return NULL;
		}
		else if (!strcmp(pos_list->data.action, "post")) {
			lynq_http_init();
			lynq_http_client_t * http_data = lynq_http_new();

			http_data->session = pos_list->data.session;
			memcpy(http_data->action, pos_list->data.action, sizeof(http_data->action));
			lynq_http_sync_post_request(http_data , pos_list->data.url, pos_list->data.post_data, M_POST, M_CLOSE);

			error_code = lynq_http_get_error_code(http_data);
			if(error_code!=0){
				LYDBGLOG("[%s-%d] post error!!!\n", __FUNCTION__, __LINE__);//rita add @2021.7.19 for debuging error
				LYVERBLOG("+[http][%s][session%d]: error num = %d\n", http_data->action, http_data->session, error_code);
			}
			if (pos_list->data.url) {
				free(pos_list->data.url);
			}
			
			if (pos_list->data.post_data) {
				free(pos_list->data.post_data);
			}
			
			list_del((struct list_head* )pos_list);
			return NULL;
		}

		else if (!strcmp(pos_list->data.action, "lpost")) {
			lynq_http_init();
			lynq_http_client_t *http_data = lynq_http_new();
			
			memcpy(http_data->action, pos_list->data.action, sizeof(http_data->action));
			memcpy(http_data->protocol, pos_list->data.protocol, sizeof(http_data->protocol));
			http_data->session = pos_list->data.session;

			if (pos_list->data.index != 1) {
				http_data->index = 1;
				lynq_http_sync_post_request(http_data , pos_list->data.url, pos_list->data.post_data, M_POST, M_KEEP);
			}
			else {
				http_data->fd = pos_list->data.fd;
				http_data->url = pos_list->data.url;
				http_data->post_data = pos_list->data.post_data;
				http_data->post_data_len = pos_list->data.post_data_len;
				http_data->method = M_POST;
				http_data->conn_method= M_KEEP;

				if( http_parser_parse_url(http_data->url, strlen(http_data->url), 0, &http_data->u) != 0 )
				{
					//printf("[%s-%d] \n", __FUNCTION__, __LINE__);
					LYVERBLOG("+[thhandle]: error num = %d\n", ERR_INVOKE);
					return NULL;
				}
				
				lynq_http_write_head_data(http_data);
			}

			error_code = lynq_http_get_error_code(http_data);
			if(error_code != 0) {
				LYVERBLOG("+[http][%s][session%d]: error num = %d\n", http_data->action, http_data->session, error_code);
				if (pos_list->data.url)
					free(pos_list->data.url);
				
				if (pos_list->data.post_data)
					free(pos_list->data.post_data);
				
				list_del((struct list_head* )pos_list);
				return NULL;
			}

			memcpy(&pos_list->data, http_data, sizeof(lynq_http_client_t));
			pos_list->data.index = 1;
		}

		else if (!strcmp(pos_list->data.action, "close")) {
			lynq_http_client_t *http_data = lynq_http_new();

			http_data->session = pos_list->data.session;
			memcpy(http_data->action, pos_list->data.action, sizeof(http_data->action));
			http_data->fd = pos_list->data.fd;
			http_data->url = pos_list->data.url;
			http_data->conn_method = M_CLOSE;
			http_data->post_data = pos_list->data.post_data;


			pos_list->data.index = 0;
			if( http_parser_parse_url(http_data->url, strlen(http_data->url), 0, &http_data->u) != 0 )
			{
				//printf("[%s-%d]\n", __FUNCTION__, __LINE__);
				LYVERBLOG("+[thhandle]: error num = %d\n", ERR_INVOKE);
				return NULL;
			}
				
			lynq_http_write_head_data(http_data);
			error_code = lynq_http_get_error_code(http_data);
			if(error_code!=0)
				LYVERBLOG("+[http][%s][session%d]: error num = %d\n", http_data->action, http_data->session, error_code);
			
			lynq_http_data_send("close");

			if (pos_list->data.url)
				free(pos_list->data.url);
			
			if (pos_list->data.post_data)
				free(pos_list->data.post_data);
			
			list_del((struct list_head* )pos_list);
			return NULL;
		}
	}
}



int http_act_handler(thread_pool_t *pool)
{
	HTTP_LIST_LINK_S* tmp_list = (HTTP_LIST_LINK_S *)http_slider;
	struct list_head* slider = NULL;
	HTTP_LIST_LINK_S* tmp = NULL;
	if(tmp == NULL)
	{
		tmp = (HTTP_LIST_LINK_S*)malloc(sizeof(HTTP_LIST_LINK_S));
		if(tmp == NULL)
		{
			return ERR_MALLOCVALID;
		}
	}
	memset(tmp, 0, sizeof(HTTP_LIST_LINK_S));

	if (tmp_list == NULL ) {
		if(!strcmp(http_cmd.action, "init") || !strcmp(http_cmd.action, "conn") || !strcmp(http_cmd.action, "send") || !strcmp(http_cmd.action, "get") || !strcmp(http_cmd.action, "post") || !strcmp(http_cmd.action, "lpost")  || !strcmp(http_cmd.action, "getfile")) {
			tmp->data = http_cmd;
			if (http_cmd.url != NULL) 
			{
			
				tmp->data.url = (char *)malloc(strlen(http_cmd.url)+1);
				if (tmp->data.url == NULL)
					return ERR_MALLOCVALID;

				memset(tmp->data.url, 0x00, strlen(http_cmd.url)+1);
				memcpy(tmp->data.url, http_cmd.url, strlen(http_cmd.url));
			}

			if (http_cmd.post_data != NULL) 
			{
				tmp->data.post_data = (char *)malloc(strlen(http_cmd.post_data)+1);
				if (tmp->data.post_data == NULL)
					return ERR_MALLOCVALID;

				memset(tmp->data.post_data, 0x00, strlen(http_cmd.post_data)+1);
				memcpy(tmp->data.post_data, http_cmd.post_data, strlen(http_cmd.post_data));
			}

			tmp->data.add_thread = 1;
			list_add_tail(&tmp->list, &http_list);				
			http_list_locate();

			if (!threadpool_add(pool, http_handler, (void *)http_slider)) {
				LYVERBLOG("+[thhandle]: error num = %d\n", ERR_INVOKE);	
				return ERR_INVOKE;
			}
		}
		else	{
			LYDBGLOG("[%s-%d] cmd error \n", __FUNCTION__, __LINE__);
			LYVERBLOG("+[thhandle]: error num = %d\n", ERR_CMDVALID);
			if (tmp != NULL)
				free(tmp);
			return ERR_CMDVALID;
		}
	}
	else {
		if(!strcmp(http_cmd.action, "send") || !strcmp(http_cmd.action, "lpost") || !strcmp(http_cmd.action, "close")) {
			memcpy(tmp_list->data.action, http_cmd.action, sizeof(tmp_list->data.action));
			memcpy(tmp_list->data.post_data, http_cmd.post_data, strlen(http_cmd.post_data));
			tmp_list->data.modify_thread = 1;
		}		
		else	{
			LYDBGLOG("[%s-%d] cmd error \n", __FUNCTION__, __LINE__);
			LYVERBLOG("+[thhandle]: error num = %d\n", ERR_CMDVALID);
			return ERR_CMDVALID;
		}
	}

	tmp = NULL;
	return NO_ERROR;
}



int http_param_verification(char result[][BUF_SIZE] , int line)
{
	if (line < 3) {
		LYDBGLOG("[%s-%d] command error\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[thhandle]: error num = %d\n", ERR_CMDVALID);
		return ERR_CMDVALID;
	}

	http_cmd.url = NULL;
	http_cmd.post_data = NULL;
	memcpy(http_cmd.protocol, result[0], sizeof(http_cmd.protocol));

	if(!atoi(result[2])) { //session
		LYDBGLOG("[%s-%d] session error\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[thhandle]: error num = %d\n", ERR_SESSIONVALID);
		return ERR_SESSIONVALID;
	}
	
	http_cmd.session = atoi(result[2]); 
	memcpy(http_cmd.action, result[1], sizeof(http_cmd.action));

	if (!(strcmp(result[1], "post"))) {
		http_cmd.url = result[3];
		http_cmd.post_data = result[4];
	}

	else if (!(strcmp(result[1], "lpost"))) {
		http_cmd.url = result[3];
		http_cmd.post_data = result[4];
	}

	else if (!(strcmp(result[1], "get"))) {
		strcat(result[3], result[4]);
		http_cmd.url = result[3];
	}

	else if (!(strcmp(result[1], "getfile"))) {
		http_cmd.url = result[3];
		strcat(http_cmd.url, result[4]);//path

	}

	else if (!(strcmp(result[1], "close"))) {
		http_cmd.conn_method = M_CLOSE;
		http_cmd.post_data = "s=close";
	}
	else {
		LYVERBLOG("+[thhandle]: error num = %d\n", ERR_CMDVALID);
		return ERR_CMDVALID;
	}
	
	return NO_ERROR;
}


int http_list_locate()
{
	struct list_head* slider = NULL;
	http_slider = NULL;
	list_for_each(slider, &http_list) 
	{
		http_slider = (HTTP_LIST_LINK_S*)slider;
#if 0
		LYDBGLOG("[%s-%d] =================================== \n", __func__, __LINE__);
		LYDBGLOG("[%s-%d] protocol : %s \n", __FUNCTION__, __LINE__, http_slider->data.protocol);
		LYDBGLOG("[%s-%d] session : %d \n", __FUNCTION__, __LINE__, http_slider->data.session);
		LYDBGLOG("[%s-%d] action : %s \n", __FUNCTION__, __LINE__, http_slider->data.action);
		LYDBGLOG("[%s-%d] index : %d \n", __FUNCTION__, __LINE__, http_slider->data.index);
		LYDBGLOG("[%s-%d] =================================== \n", __func__, __LINE__);
#endif

		if (!strcmp(http_slider->data.protocol, http_cmd.protocol) && http_slider->data.session == http_cmd.session) {
			if (strcmp(http_cmd.action, "close") != 0) {
				if (strcmp(http_slider->data.url, http_cmd.url) != 0) {
					//LYDBGLOG("[%s-%d] URL error\n", __FUNCTION__, __LINE__);
					LYVERBLOG("+[thhandle]: error num = %d\n", ERR_CMDVALID);
					return ERR_CMDVALID;
				}
			}
			return NO_ERROR;
		}
	}
	http_slider = NULL;

	return NO_ERROR;
}


static int http_init = 0;
void http_list_init()
{
	if (http_init == 0) {
		INIT_LIST_HEAD(&http_list);
		http_init = 1;
	}

}

